/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import org.jetbrains.kotlin.com.intellij.lang.jvm.types.JvmType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;

public abstract class PsiType
implements JvmType,
PsiAnnotationOwner,
Cloneable {
    public static final PsiPrimitiveType BYTE = new PsiPrimitiveType(JvmPrimitiveTypeKind.BYTE);
    public static final PsiPrimitiveType CHAR = new PsiPrimitiveType(JvmPrimitiveTypeKind.CHAR);
    public static final PsiPrimitiveType DOUBLE = new PsiPrimitiveType(JvmPrimitiveTypeKind.DOUBLE);
    public static final PsiPrimitiveType FLOAT = new PsiPrimitiveType(JvmPrimitiveTypeKind.FLOAT);
    public static final PsiPrimitiveType INT = new PsiPrimitiveType(JvmPrimitiveTypeKind.INT);
    public static final PsiPrimitiveType LONG = new PsiPrimitiveType(JvmPrimitiveTypeKind.LONG);
    public static final PsiPrimitiveType SHORT = new PsiPrimitiveType(JvmPrimitiveTypeKind.SHORT);
    public static final PsiPrimitiveType BOOLEAN = new PsiPrimitiveType(JvmPrimitiveTypeKind.BOOLEAN);
    public static final PsiPrimitiveType VOID = new PsiPrimitiveType(JvmPrimitiveTypeKind.VOID);
    public static final PsiPrimitiveType NULL = new PsiPrimitiveType(null);
    public static final PsiType[] EMPTY_ARRAY = new PsiType[0];
    public static final ArrayFactory<PsiType> ARRAY_FACTORY = count2 -> count2 == 0 ? EMPTY_ARRAY : new PsiType[count2];
    private TypeAnnotationProvider myAnnotationProvider;

    @NotNull
    public static PsiType[] createArray(int count2) {
        PsiType[] psiTypeArray = ARRAY_FACTORY.create(count2);
        if (psiTypeArray == null) {
            PsiType.$$$reportNull$$$0(0);
        }
        return psiTypeArray;
    }

    protected PsiType(@NotNull PsiAnnotation[] annotations2) {
        if (annotations2 == null) {
            PsiType.$$$reportNull$$$0(1);
        }
        this(TypeAnnotationProvider.Static.create(annotations2));
    }

    protected PsiType(@NotNull TypeAnnotationProvider annotations2) {
        if (annotations2 == null) {
            PsiType.$$$reportNull$$$0(2);
        }
        this.myAnnotationProvider = annotations2;
    }

    @NotNull
    public PsiType annotate(@NotNull TypeAnnotationProvider provider) {
        PsiType psiType2;
        if (provider == null) {
            PsiType.$$$reportNull$$$0(3);
        }
        if (provider == this.myAnnotationProvider) {
            PsiType psiType3 = this;
            if (psiType3 == null) {
                PsiType.$$$reportNull$$$0(4);
            }
            return psiType3;
        }
        try {
            PsiType copy2 = (PsiType)this.clone();
            copy2.myAnnotationProvider = provider;
            psiType2 = copy2;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (psiType2 == null) {
            PsiType.$$$reportNull$$$0(5);
        }
        return psiType2;
    }

    @NotNull
    public PsiArrayType createArrayType() {
        PsiArrayType psiArrayType = new PsiArrayType(this);
        if (psiArrayType == null) {
            PsiType.$$$reportNull$$$0(6);
        }
        return psiArrayType;
    }

    @Deprecated
    @NotNull
    public PsiArrayType createArrayType(PsiAnnotation ... annotations2) {
        if (annotations2 == null) {
            PsiType.$$$reportNull$$$0(7);
        }
        PsiArrayType psiArrayType = new PsiArrayType(this, annotations2);
        if (psiArrayType == null) {
            PsiType.$$$reportNull$$$0(8);
        }
        return psiArrayType;
    }

    @NotNull
    public String getPresentableText(boolean annotated) {
        String string = this.getPresentableText();
        if (string == null) {
            PsiType.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public abstract String getPresentableText();

    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getCanonicalText();
        if (string == null) {
            PsiType.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public abstract String getCanonicalText();

    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getCanonicalText();
        if (string == null) {
            PsiType.$$$reportNull$$$0(11);
        }
        return string;
    }

    public abstract boolean isValid();

    @Contract(pure=true)
    public boolean isAssignableFrom(@NotNull PsiType type2) {
        if (type2 == null) {
            PsiType.$$$reportNull$$$0(12);
        }
        return TypeConversionUtil.isAssignable(this, type2);
    }

    public boolean isConvertibleFrom(@NotNull PsiType type2) {
        if (type2 == null) {
            PsiType.$$$reportNull$$$0(13);
        }
        return TypeConversionUtil.areTypesConvertible(type2, this);
    }

    public abstract boolean equalsToText(@NotNull String var1);

    @NotNull
    public static PsiClassType getTypeByName(@NotNull String qName, @NotNull Project project, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            PsiType.$$$reportNull$$$0(14);
        }
        if (project == null) {
            PsiType.$$$reportNull$$$0(15);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(16);
        }
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(project);
        PsiClassType psiClassType = factory2.createTypeByFQClassName(qName, resolveScope);
        if (psiClassType == null) {
            PsiType.$$$reportNull$$$0(17);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangObject(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(18);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(19);
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.Object", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            PsiType.$$$reportNull$$$0(20);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangClass(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(21);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(22);
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.Class", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            PsiType.$$$reportNull$$$0(23);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangThrowable(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(24);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(25);
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.Throwable", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            PsiType.$$$reportNull$$$0(26);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangString(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(27);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(28);
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.String", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            PsiType.$$$reportNull$$$0(29);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangError(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(30);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(31);
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.Error", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            PsiType.$$$reportNull$$$0(32);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangRuntimeException(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(33);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(34);
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.RuntimeException", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            PsiType.$$$reportNull$$$0(35);
        }
        return psiClassType;
    }

    public abstract <A> A accept(@NotNull PsiTypeVisitor<A> var1);

    public final int getArrayDimensions() {
        PsiType type2 = this;
        int dims = 0;
        while (type2 instanceof PsiArrayType) {
            ++dims;
            type2 = ((PsiArrayType)type2).getComponentType();
        }
        return dims;
    }

    @NotNull
    public final PsiType getDeepComponentType() {
        PsiType type2 = this;
        while (type2 instanceof PsiArrayType) {
            type2 = ((PsiArrayType)type2).getComponentType();
        }
        PsiType psiType2 = type2;
        if (psiType2 == null) {
            PsiType.$$$reportNull$$$0(36);
        }
        return psiType2;
    }

    @Nullable
    public abstract GlobalSearchScope getResolveScope();

    @NotNull
    public abstract PsiType[] getSuperTypes();

    @NotNull
    public final TypeAnnotationProvider getAnnotationProvider() {
        TypeAnnotationProvider typeAnnotationProvider = this.myAnnotationProvider;
        if (typeAnnotationProvider == null) {
            PsiType.$$$reportNull$$$0(37);
        }
        return typeAnnotationProvider;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.myAnnotationProvider.getAnnotations();
        if (psiAnnotationArray == null) {
            PsiType.$$$reportNull$$$0(38);
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiType.$$$reportNull$$$0(39);
        }
        for (PsiAnnotation annotation2 : this.getAnnotations()) {
            if (!qualifiedName.equals(annotation2.getQualifiedName())) continue;
            return annotation2;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiType.$$$reportNull$$$0(40);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            PsiType.$$$reportNull$$$0(41);
        }
        return psiAnnotationArray;
    }

    public String toString() {
        return "PsiType:" + this.getPresentableText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/PsiType";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createArray";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeByName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaLangObject";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaLangClass";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaLangThrowable";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaLangString";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaLangError";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaLangRuntimeException";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeepComponentType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProvider";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createArrayType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableFrom";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isConvertibleFrom";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangObject";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangClass";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangThrowable";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangString";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangError";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangRuntimeException";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class Stub
    extends PsiType {
        protected Stub(@NotNull PsiAnnotation[] annotations2) {
            if (annotations2 == null) {
                Stub.$$$reportNull$$$0(0);
            }
            super(annotations2);
        }

        protected Stub(@NotNull TypeAnnotationProvider annotations2) {
            if (annotations2 == null) {
                Stub.$$$reportNull$$$0(1);
            }
            super(annotations2);
        }

        @Override
        @NotNull
        public final String getPresentableText() {
            String string = this.getPresentableText(false);
            if (string == null) {
                Stub.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public abstract String getPresentableText(boolean var1);

        @Override
        @NotNull
        public final String getCanonicalText() {
            String string = this.getCanonicalText(false);
            if (string == null) {
                Stub.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public abstract String getCanonicalText(boolean var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotations";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/PsiType$Stub";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiType$Stub";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

