/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializationException;

class FieldAccessor
implements MutableAccessor {
    private final Field myField;

    FieldAccessor(@NotNull Field field) {
        if (field == null) {
            FieldAccessor.$$$reportNull$$$0(0);
        }
        this.myField = field;
        field.setAccessible(true);
    }

    @Override
    public Object read(@NotNull Object o) {
        if (o == null) {
            FieldAccessor.$$$reportNull$$$0(1);
        }
        assert (this.myField.getDeclaringClass().isInstance(o)) : "Wrong class: " + o.getClass() + "; should be: " + this.myField.getDeclaringClass();
        try {
            return this.myField.get(o);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Reading " + this.myField, e);
        }
    }

    @Override
    public void set(@NotNull Object host, @Nullable Object value) {
        if (host == null) {
            FieldAccessor.$$$reportNull$$$0(2);
        }
        try {
            this.myField.set(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setBoolean(@NotNull Object host, boolean value) {
        if (host == null) {
            FieldAccessor.$$$reportNull$$$0(3);
        }
        try {
            this.myField.setBoolean(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setInt(@NotNull Object host, int value) {
        if (host == null) {
            FieldAccessor.$$$reportNull$$$0(4);
        }
        try {
            this.myField.setInt(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setShort(@NotNull Object host, short value) {
        if (host == null) {
            FieldAccessor.$$$reportNull$$$0(5);
        }
        try {
            this.myField.setShort(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setLong(@NotNull Object host, long value) {
        if (host == null) {
            FieldAccessor.$$$reportNull$$$0(6);
        }
        try {
            this.myField.setLong(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setFloat(@NotNull Object host, float value) {
        if (host == null) {
            FieldAccessor.$$$reportNull$$$0(7);
        }
        try {
            this.myField.setFloat(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setDouble(@NotNull Object host, double value) {
        if (host == null) {
            FieldAccessor.$$$reportNull$$$0(8);
        }
        try {
            this.myField.setDouble(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(@NotNull Class<T> annotationClass) {
        if (annotationClass == null) {
            FieldAccessor.$$$reportNull$$$0(9);
        }
        return this.myField.getAnnotation(annotationClass);
    }

    @Override
    public String getName() {
        return this.myField.getName();
    }

    @Override
    public Class<?> getValueClass() {
        return this.myField.getType();
    }

    @Override
    public Type getGenericType() {
        return this.myField.getGenericType();
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.myField.getModifiers());
    }

    @NonNls
    public String toString() {
        return "FieldAccessor[" + this.myField.getDeclaringClass() + "." + this.myField.getName() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/xmlb/FieldAccessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setBoolean";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setInt";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setShort";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setLong";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setFloat";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setDouble";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

