/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyGetter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertySetter;
import org.jetbrains.kotlin.fir.declarations.impl.FirMemberPropertyImpl;
import org.jetbrains.kotlin.fir.resolve.calls.SyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.ConeCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeVariableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J4\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0016\u0010\u0016\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\u0004\u0012\u00020\u00110\u0017H\u0002J(\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0016\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\u0004\u0012\u00020\u00110\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/FirSyntheticPropertiesScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "baseScope", "typeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/FirScope;Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "synthetic", "", "Lorg/jetbrains/kotlin/fir/symbols/ConeCallableSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/ConeVariableSymbol;", "getSynthetic", "()Ljava/util/Map;", "checkGetAndCreateSynthetic", "Lorg/jetbrains/kotlin/fir/scopes/ProcessorAction;", "name", "Lorg/jetbrains/kotlin/name/Name;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "processor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "processPropertiesByName", "resolve"})
public final class FirSyntheticPropertiesScope
extends FirScope {
    @NotNull
    private final Map<ConeCallableSymbol, ConeVariableSymbol> synthetic;
    @NotNull
    private final FirSession session;
    private final FirScope baseScope;
    private final ReturnTypeCalculator typeCalculator;

    @NotNull
    public final Map<ConeCallableSymbol, ConeVariableSymbol> getSynthetic() {
        return this.synthetic;
    }

    private final ProcessorAction checkGetAndCreateSynthetic(Name name, FirFunctionSymbol<?> symbol2, Function1<? super FirCallableSymbol<?>, ? extends ProcessorAction> processor2) {
        FirElement firElement = symbol2.getFir();
        if (!(firElement instanceof FirNamedFunction)) {
            firElement = null;
        }
        FirNamedFunction firNamedFunction = (FirNamedFunction)firElement;
        if (firNamedFunction == null) {
            return ProcessorAction.NEXT;
        }
        FirNamedFunction fir = firNamedFunction;
        Collection collection = fir.getTypeParameters();
        boolean bl = false;
        if (!collection.isEmpty()) {
            return ProcessorAction.NEXT;
        }
        collection = fir.getValueParameters();
        bl = false;
        if (!collection.isEmpty()) {
            return ProcessorAction.NEXT;
        }
        SyntheticPropertySymbol synthetic = new SyntheticPropertySymbol(new CallableId(symbol2.getCallableId().getPackageName(), symbol2.getCallableId().getClassName(), name));
        FirResolvedTypeRef returnTypeRef = this.typeCalculator.tryCalculateReturnType(fir);
        new FirMemberPropertyImpl(this.session, null, synthetic, name, fir.getVisibility(), fir.getModality(), false, false, false, false, false, null, returnTypeRef, true, null, new FirDefaultPropertyGetter(this.session, null, returnTypeRef, fir.getVisibility()), new FirDefaultPropertySetter(this.session, null, returnTypeRef, fir.getVisibility()), null);
        return (ProcessorAction)((Object)processor2.invoke((Object)synthetic));
    }

    @Override
    @NotNull
    public ProcessorAction processPropertiesByName(@NotNull Name name, @NotNull Function1<? super FirCallableSymbol<?>, ? extends ProcessorAction> processor2) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        if (name.isSpecial()) {
            return ProcessorAction.NEXT;
        }
        StringBuilder stringBuilder = new StringBuilder().append("get");
        String string = name.getIdentifier();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.identifier");
        Name name2 = Name.guessByFirstCharacter(stringBuilder.append(StringsKt.capitalize((String)string)).toString());
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.guessByFirstCharact\u2026dentifier.capitalize()}\")");
        if (this.baseScope.processFunctionsByName(name2, (Function1)new Function1<FirFunctionSymbol<?>, ProcessorAction>(this, name, processor2){
            final /* synthetic */ FirSyntheticPropertiesScope this$0;
            final /* synthetic */ Name $name;
            final /* synthetic */ Function1 $processor;

            @NotNull
            public final ProcessorAction invoke(@NotNull FirFunctionSymbol<?> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return FirSyntheticPropertiesScope.access$checkGetAndCreateSynthetic(this.this$0, this.$name, it, this.$processor);
            }
            {
                this.this$0 = firSyntheticPropertiesScope;
                this.$name = name;
                this.$processor = function1;
                super(1);
            }
        }).stop()) {
            return ProcessorAction.STOP;
        }
        String string2 = name.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name.asString()");
        if (StringsKt.startsWith$default((String)string2, (String)"is", (boolean)false, (int)2, null) && this.baseScope.processFunctionsByName(name, (Function1)new Function1<FirFunctionSymbol<?>, ProcessorAction>(this, name, processor2){
            final /* synthetic */ FirSyntheticPropertiesScope this$0;
            final /* synthetic */ Name $name;
            final /* synthetic */ Function1 $processor;

            @NotNull
            public final ProcessorAction invoke(@NotNull FirFunctionSymbol<?> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return FirSyntheticPropertiesScope.access$checkGetAndCreateSynthetic(this.this$0, this.$name, it, this.$processor);
            }
            {
                this.this$0 = firSyntheticPropertiesScope;
                this.$name = name;
                this.$processor = function1;
                super(1);
            }
        }).stop()) {
            return ProcessorAction.STOP;
        }
        return super.processPropertiesByName(name, processor2);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    public FirSyntheticPropertiesScope(@NotNull FirSession session, @NotNull FirScope baseScope, @NotNull ReturnTypeCalculator typeCalculator2) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)baseScope, (String)"baseScope");
        Intrinsics.checkParameterIsNotNull((Object)typeCalculator2, (String)"typeCalculator");
        this.session = session;
        this.baseScope = baseScope;
        this.typeCalculator = typeCalculator2;
        FirSyntheticPropertiesScope firSyntheticPropertiesScope = this;
        boolean bl = false;
        firSyntheticPropertiesScope.synthetic = map2 = (Map)new LinkedHashMap();
    }

    public static final /* synthetic */ ProcessorAction access$checkGetAndCreateSynthetic(FirSyntheticPropertiesScope $this, Name name, FirFunctionSymbol symbol2, Function1 processor2) {
        return $this.checkGetAndCreateSynthetic(name, symbol2, processor2);
    }
}

