/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.watch;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.internal.file.FileType;
import org.gradle.internal.vfs.SnapshotHierarchy;

public class WatchRootUtil {
    public static Set<Path> resolveRootsToWatch(Set<String> directories) {
        HashSet<Path> roots = new HashSet<Path>();
        directories.stream().map(x$0 -> Paths.get(x$0, new String[0])).sorted(Comparator.comparingInt(Path::getNameCount)).filter(path -> {
            Path parent = path;
            while ((parent = parent.getParent()) != null) {
                if (!roots.contains(parent)) continue;
                return false;
            }
            return true;
        }).forEach(roots::add);
        return roots;
    }

    public static Set<String> resolveDirectoriesToWatch(SnapshotHierarchy root, Predicate<String> watchFilter, Collection<File> mustWatchDirectories) {
        Set<String> watchedDirectories = mustWatchDirectories.stream().map(File::getAbsolutePath).collect(Collectors.toSet());
        root.visitSnapshots((snapshot, rootOfCompleteHierarchy) -> {
            Path ancestorToWatch;
            if (!watchFilter.test(snapshot.getAbsolutePath())) {
                return;
            }
            if (snapshot.getType() == FileType.Directory) {
                watchedDirectories.add(snapshot.getAbsolutePath());
            }
            if (!rootOfCompleteHierarchy) {
                return;
            }
            Path path = Paths.get(snapshot.getAbsolutePath(), new String[0]);
            switch (snapshot.getType()) {
                case RegularFile: 
                case Directory: {
                    ancestorToWatch = path.getParent();
                    break;
                }
                case Missing: {
                    ancestorToWatch = WatchRootUtil.findFirstExistingAncestor(path);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            watchedDirectories.add(ancestorToWatch.toString());
        });
        return watchedDirectories;
    }

    private static Path findFirstExistingAncestor(Path path) {
        Path candidate = path;
        do {
            if ((candidate = candidate.getParent()) != null) continue;
            throw new IllegalStateException("Couldn't find existing ancestor for " + path);
        } while (!Files.isDirectory(candidate, new LinkOption[0]));
        return candidate;
    }
}

