/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.language.scala.ScalaPlatform;
import org.gradle.language.scala.internal.DefaultScalaPlatform;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.platform.base.internal.PlatformResolver;
import org.gradle.play.internal.DefaultPlayPlatform;
import org.gradle.play.internal.PlayPlatformRequirement;
import org.gradle.play.internal.platform.PlayMajorVersion;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public class PlayPlatformResolver
implements PlatformResolver<PlayPlatform> {
    public static final Map<String, String> LATEST_SCALA_VERSIONS = ImmutableMap.of((Object)"2.10", (Object)"2.10.7", (Object)"2.11", (Object)"2.11.12", (Object)"2.12", (Object)"2.12.9");

    public Class<PlayPlatform> getType() {
        return PlayPlatform.class;
    }

    public PlayPlatform resolve(PlatformRequirement platformRequirement) {
        if (platformRequirement instanceof PlayPlatformRequirement) {
            PlayPlatformRequirement requirement = (PlayPlatformRequirement)platformRequirement;
            return this.resolve(requirement.getPlatformName(), requirement.getPlayVersion(), requirement.getScalaVersion(), requirement.getJavaVersion());
        }
        String playVersion = this.parsePlayVersionFromPlatformName(platformRequirement.getPlatformName());
        return this.resolve(platformRequirement.getPlatformName(), playVersion, null, null);
    }

    private PlayPlatform resolve(String name, String playVersion, String scalaVersion, String javaVersion) {
        PlayMajorVersion playMajorVersion = PlayMajorVersion.forPlayVersion(playVersion);
        JavaPlatform javaPlatform = this.getJavaPlatform(javaVersion);
        ScalaPlatform scalaPlatform = this.getScalaPlatform(playMajorVersion, scalaVersion);
        return new DefaultPlayPlatform(name, playVersion, scalaPlatform, javaPlatform);
    }

    private String parsePlayVersionFromPlatformName(String playPlatformName) {
        if (playPlatformName.startsWith("play-")) {
            return playPlatformName.substring(5);
        }
        throw new InvalidUserDataException(String.format("Not a valid Play platform: %s.", playPlatformName));
    }

    private JavaPlatform getJavaPlatform(String preferredJavaVersion) {
        if (preferredJavaVersion != null) {
            return new DefaultJavaPlatform(JavaVersion.toVersion((Object)preferredJavaVersion));
        }
        return new DefaultJavaPlatform(JavaVersion.current());
    }

    private ScalaPlatform getScalaPlatform(PlayMajorVersion playMajorVersion, String preferredScalaVersion) {
        String scalaVersion = (String)GUtil.elvis((Object)preferredScalaVersion, (Object)playMajorVersion.getDefaultScalaPlatform());
        ScalaPlatform scalaPlatform = this.createScalaPlatform(scalaVersion);
        playMajorVersion.validateCompatible(scalaPlatform);
        return scalaPlatform;
    }

    private ScalaPlatform createScalaPlatform(String compatibilityVersion) {
        String latestVersion = LATEST_SCALA_VERSIONS.get(compatibilityVersion);
        if (latestVersion != null) {
            return new DefaultScalaPlatform(latestVersion);
        }
        throw new InvalidUserDataException(String.format("Not a supported Scala platform identifier %s. Supported values are: [%s].", compatibilityVersion, CollectionUtils.join((String)", ", LATEST_SCALA_VERSIONS.keySet())));
    }
}

