/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.strict;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;

public class StrictVersionConstraints {
    public static final StrictVersionConstraints EMPTY = new StrictVersionConstraints(){

        @Override
        public final StrictVersionConstraints union(StrictVersionConstraints other) {
            return other;
        }

        @Override
        public final StrictVersionConstraints intersect(StrictVersionConstraints other) {
            return EMPTY;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(ModuleIdentifier module) {
            return false;
        }

        @Override
        public String toString() {
            return "no modules";
        }
    };
    private final Set<ModuleIdentifier> modules;

    private StrictVersionConstraints() {
        this.modules = Collections.emptySet();
    }

    private StrictVersionConstraints(Set<ModuleIdentifier> modules) {
        this.modules = modules;
    }

    public static StrictVersionConstraints of(Set<ModuleIdentifier> modules) {
        if (modules.isEmpty()) {
            return EMPTY;
        }
        return new StrictVersionConstraints(modules);
    }

    public Set<ModuleIdentifier> getModules() {
        return this.modules;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean contains(ModuleIdentifier module) {
        return this.modules.contains(module);
    }

    public StrictVersionConstraints union(StrictVersionConstraints other) {
        if (other == EMPTY) {
            return this;
        }
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)(this.modules.size() + other.modules.size()));
        builder.addAll(this.modules);
        builder.addAll(other.modules);
        return StrictVersionConstraints.of((Set<ModuleIdentifier>)builder.build());
    }

    public StrictVersionConstraints intersect(StrictVersionConstraints other) {
        if (other.modules == this.modules) {
            return this;
        }
        if (other == EMPTY) {
            return EMPTY;
        }
        return StrictVersionConstraints.of((Set<ModuleIdentifier>)ImmutableSet.copyOf((Collection)Sets.intersection(this.modules, other.modules)));
    }

    public String toString() {
        return "modules=" + this.modules;
    }
}

