/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import groovy.lang.Script;
import java.io.File;
import org.codehaus.groovy.ast.ClassNode;
import org.gradle.api.Action;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.DefaultScriptCompilationHandler;
import org.gradle.groovy.scripts.internal.ScriptCompilationHandler;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.resource.ResourceLocation;
import org.gradle.internal.scripts.CompileScriptBuildOperationType;

public class BuildOperationBackedScriptCompilationHandler
implements ScriptCompilationHandler {
    public static final String GROOVY_LANGUAGE = "GROOVY";
    private static final CompileScriptBuildOperationType.Result RESULT = new CompileScriptBuildOperationType.Result(){};
    private final DefaultScriptCompilationHandler delegate;
    private final BuildOperationExecutor buildOperationExecutor;

    public BuildOperationBackedScriptCompilationHandler(DefaultScriptCompilationHandler delegate, BuildOperationExecutor buildOperationExecutor) {
        this.delegate = delegate;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public void compileToDir(final ScriptSource source, final ClassLoader classLoader, final File classesDir, final File metadataDir, final CompileOperation<?> transformer, final Class<? extends Script> scriptBaseClass, final Action<? super ClassNode> verifier) {
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                BuildOperationBackedScriptCompilationHandler.this.delegate.compileToDir(source, classLoader, classesDir, metadataDir, transformer, scriptBaseClass, (Action<? super ClassNode>)verifier);
                context.setResult((Object)RESULT);
            }

            public BuildOperationDescriptor.Builder description() {
                ResourceLocation resourceLocation = source.getResource().getLocation();
                File file = resourceLocation.getFile();
                String stage = transformer.getStage();
                String name = "Compile script " + (file != null ? file.getName() : source.getDisplayName()) + " (" + stage + ")";
                return BuildOperationDescriptor.displayName((String)name).name(name).details((Object)new Details(stage));
            }
        });
    }

    @Override
    public <T extends Script, M> CompiledScript<T, M> loadFromDir(ScriptSource source, HashCode sourceHashCode, ClassLoaderScope targetScope, File scriptCacheDir, File metadataCacheDir, CompileOperation<M> transformer, Class<T> scriptBaseClass) {
        return this.delegate.loadFromDir(source, sourceHashCode, targetScope, scriptCacheDir, metadataCacheDir, transformer, scriptBaseClass);
    }

    private static class Details
    implements CompileScriptBuildOperationType.Details {
        private final String stage;

        Details(String stage) {
            this.stage = stage;
        }

        public String getLanguage() {
            return BuildOperationBackedScriptCompilationHandler.GROOVY_LANGUAGE;
        }

        public String getStage() {
            return this.stage;
        }
    }
}

