/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.rubygrapefruit.platform.file.FileWatcherCallback;
import org.gradle.internal.vfs.watch.FileWatcherRegistry;

public interface WatcherEvent {
    public void dispatch(FileWatcherRegistry.ChangeHandler var1);

    public static WatcherEvent createEvent(FileWatcherCallback.Type type, String path) {
        switch (type) {
            case CREATED: {
                return new ChangeEvent(FileWatcherRegistry.Type.CREATED, path);
            }
            case MODIFIED: {
                return new ChangeEvent(FileWatcherRegistry.Type.MODIFIED, path);
            }
            case REMOVED: {
                return new ChangeEvent(FileWatcherRegistry.Type.REMOVED, path);
            }
            case INVALIDATE: {
                return new ChangeEvent(FileWatcherRegistry.Type.INVALIDATE, path);
            }
            case UNKNOWN: {
                return StateLostEvent.INSTANCE;
            }
        }
        throw new AssertionError();
    }

    public static void dispatch(Iterable<WatcherEvent> events, FileWatcherRegistry.ChangeHandler handler) throws IOException {
        try {
            events.forEach(watcherEvent -> watcherEvent.dispatch(handler));
        }
        catch (Exception ex) {
            throw new IOException("Couldn't get watches", ex);
        }
    }

    public static class StateLostEvent
    implements WatcherEvent {
        public static final WatcherEvent INSTANCE = new StateLostEvent();

        @Override
        public void dispatch(FileWatcherRegistry.ChangeHandler handler) {
            handler.handleLostState();
        }
    }

    public static class ChangeEvent
    implements WatcherEvent {
        private final FileWatcherRegistry.Type type;
        private final Path path;

        public ChangeEvent(FileWatcherRegistry.Type type, String path) {
            this.type = type;
            this.path = Paths.get(path, new String[0]);
        }

        @Override
        public void dispatch(FileWatcherRegistry.ChangeHandler handler) {
            handler.handleChange(this.type, this.path);
        }
    }
}

