/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;

public abstract class AbstractProperty<T>
extends AbstractMinimalProvider<T>
implements PropertyInternal<T> {
    private static final DisplayName DEFAULT_DISPLAY_NAME = Describables.of((Object)"this property");
    private static final DisplayName DEFAULT_VALIDATION_DISPLAY_NAME = Describables.of((Object)"a property");
    private State state = State.ImplicitValue;
    private boolean finalizeOnNextGet;
    private boolean disallowChanges;
    private Task producer;
    private DisplayName displayName;

    @Override
    public void attachDisplayName(DisplayName displayName) {
        this.displayName = displayName;
    }

    @Override
    @Nullable
    protected DisplayName getDeclaredDisplayName() {
        return this.displayName;
    }

    @Override
    protected DisplayName getTypedDisplayName() {
        return DEFAULT_DISPLAY_NAME;
    }

    @Override
    protected DisplayName getDisplayName() {
        if (this.displayName == null) {
            return DEFAULT_DISPLAY_NAME;
        }
        return this.displayName;
    }

    protected DisplayName getValidationDisplayName() {
        if (this.displayName == null) {
            return DEFAULT_VALIDATION_DISPLAY_NAME;
        }
        return this.displayName;
    }

    @Override
    public void attachProducer(Task task) {
        if (this.producer != null && this.producer != task) {
            throw new IllegalStateException(String.format("%s already has a producer task associated with it.", this.getDisplayName().getCapitalizedDisplayName()));
        }
        this.producer = task;
    }

    protected abstract ValueSupplier getSupplier();

    protected abstract String describeContents();

    @Override
    public final String toString() {
        if (this.displayName != null) {
            return this.displayName.toString();
        }
        return this.describeContents();
    }

    @Override
    public void visitProducerTasks(Action<? super Task> visitor) {
        if (this.producer != null) {
            visitor.execute((Object)this.producer);
        } else {
            this.getSupplier().visitProducerTasks(visitor);
        }
    }

    @Override
    public boolean isValueProducedByTask() {
        return this.getSupplier().isValueProducedByTask();
    }

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        if (this.producer != null) {
            context.add(this.producer);
            return true;
        }
        return this.getSupplier().maybeVisitBuildDependencies(context);
    }

    public void finalizeValue() {
        if (this.state != State.Final) {
            this.makeFinal();
        }
        this.state = State.Final;
        this.disallowChanges = true;
    }

    public void disallowChanges() {
        this.disallowChanges = true;
    }

    public void finalizeValueOnRead() {
        this.finalizeOnNextGet = true;
    }

    @Override
    public void implicitFinalizeValue() {
        this.disallowChanges = true;
        this.finalizeOnNextGet = true;
    }

    protected abstract void applyDefaultValue();

    protected abstract void makeFinal();

    protected void beforeRead() {
        if (this.state == State.Final) {
            return;
        }
        if (this.finalizeOnNextGet) {
            this.makeFinal();
            this.state = State.Final;
        }
    }

    protected boolean beforeMutate() {
        if (this.canMutate()) {
            if (this.state == State.ImplicitValue) {
                this.applyDefaultValue();
                this.state = State.ExplicitValue;
            }
            return true;
        }
        return false;
    }

    protected boolean beforeReset() {
        if (this.canMutate()) {
            this.state = State.ImplicitValue;
            return true;
        }
        return false;
    }

    protected boolean shouldApplyConvention() {
        if (this.canMutate()) {
            return this.state == State.ImplicitValue;
        }
        return false;
    }

    private boolean canMutate() {
        if (this.state == State.Final) {
            throw new IllegalStateException(String.format("The value for %s is final and cannot be changed any further.", this.getDisplayName().getDisplayName()));
        }
        if (this.disallowChanges) {
            throw new IllegalStateException(String.format("The value for %s cannot be changed any further.", this.getDisplayName().getDisplayName()));
        }
        return true;
    }

    private static enum State {
        ImplicitValue,
        ExplicitValue,
        Final;

    }
}

