/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.resolver;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.kotlin.dsl.concurrent.EventLoop;
import org.gradle.kotlin.dsl.resolver.DefaultResolverEventLogger;
import org.gradle.kotlin.dsl.resolver.ResolverEvent;
import org.gradle.kotlin.dsl.resolver.ResolverEventLogger;
import org.gradle.kotlin.dsl.support.IOKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0018\u0010\u0018\u001a\n \u0019*\u0004\u0018\u00010\b0\b2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\tH\u0016J\b\u0010\u001d\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\n \u0019*\u0004\u0018\u00010\b0\bH\u0002J\b\u0010\u001f\u001a\u00020\fH\u0002J\u001e\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"H\u0002J\u0010\u0010#\u001a\n \u0019*\u0004\u0018\u00010$0$H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/gradle/kotlin/dsl/resolver/DefaultResolverEventLogger;", "Lorg/gradle/kotlin/dsl/resolver/ResolverEventLogger;", "()V", "cleanupAfterDays", "", "eventLoop", "Lorg/gradle/kotlin/dsl/concurrent/EventLoop;", "Lkotlin/Pair;", "Ljava/util/Date;", "Lorg/gradle/kotlin/dsl/resolver/ResolverEvent;", "logFilesExpireAfterDays", "outputFile", "Ljava/io/File;", "getOutputFile", "()Ljava/io/File;", "outputFile$delegate", "Lkotlin/Lazy;", "resolverLogFilenameRegex", "Lkotlin/text/Regex;", "bufferedAppendWriter", "Ljava/io/BufferedWriter;", "cleanupLogDirectory", "", "logDir", "daysAgo", "kotlin.jvm.PlatformType", "days", "log", "event", "logDirForOperatingSystem", "now", "outputDir", "readyForCleanup", "cleanup", "Lkotlin/Function0;", "timestampForFileName", "", "gradle-kotlin-dsl"})
public final class DefaultResolverEventLogger
implements ResolverEventLogger {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final EventLoop<Pair<Date, ResolverEvent>> eventLoop;
    private static final Lazy outputFile$delegate;
    private static final int cleanupAfterDays = 1;
    private static final int logFilesExpireAfterDays = 7;
    private static final Regex resolverLogFilenameRegex;
    public static final DefaultResolverEventLogger INSTANCE;

    static {
        DefaultResolverEventLogger defaultResolverEventLogger;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DefaultResolverEventLogger.class), "outputFile", "getOutputFile()Ljava/io/File;"))};
        INSTANCE = defaultResolverEventLogger = new DefaultResolverEventLogger();
        eventLoop = new EventLoop(null, eventLoop.1.INSTANCE, 1, null);
        outputFile$delegate = LazyKt.lazy((Function0)outputFile.2.INSTANCE);
        resolverLogFilenameRegex = new Regex("resolver-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{3}\\.log");
    }

    @Override
    public void log(@NotNull ResolverEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        eventLoop.accept((Pair<Date, ResolverEvent>)TuplesKt.to((Object)this.now(), (Object)event));
    }

    private final File getOutputFile() {
        Lazy lazy = outputFile$delegate;
        DefaultResolverEventLogger defaultResolverEventLogger = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (File)lazy.getValue();
    }

    private final BufferedWriter bufferedAppendWriter() {
        return new BufferedWriter(new FileWriter(this.getOutputFile(), true));
    }

    private final String timestampForFileName() {
        return new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS").format(this.now());
    }

    private final File outputDir() {
        File file = this.logDirForOperatingSystem();
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        $this$apply.mkdirs();
        return file;
    }

    private final File logDirForOperatingSystem() {
        File file;
        OperatingSystem operatingSystem = OperatingSystem.current();
        boolean bl = false;
        boolean bl2 = false;
        OperatingSystem $this$run = operatingSystem;
        boolean bl3 = false;
        if ($this$run.isMacOsX()) {
            file = FilesKt.resolve((File)IOKt.userHome(), (String)"Library/Logs/gradle-kotlin-dsl");
        } else if ($this$run.isWindows()) {
            String string2 = System.getenv("LOCALAPPDATA");
            if (string2 != null) {
                String string3 = string2;
                boolean bl4 = false;
                boolean bl5 = false;
                String it = string3;
                boolean bl6 = false;
                file = new File(it + "/gradle-kotlin-dsl/log");
            } else {
                file = FilesKt.resolve((File)IOKt.userHome(), (String)"AppData/Local/gradle-kotlin-dsl/log");
            }
        } else {
            file = FilesKt.resolve((File)IOKt.userHome(), (String)".gradle-kotlin-dsl/log");
        }
        return file;
    }

    private final Date now() {
        Calendar calendar = GregorianCalendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"GregorianCalendar.getInstance()");
        return calendar.getTime();
    }

    private final void cleanupLogDirectory(File logDir) {
        this.readyForCleanup(logDir, (Function0<Unit>)((Function0)new Function0<Unit>(logDir){
            final /* synthetic */ File $logDir;

            public final void invoke() {
                Date expiration = DefaultResolverEventLogger.access$daysAgo(DefaultResolverEventLogger.INSTANCE, 7);
                File[] fileArray = this.$logDir.listFiles(new FileFilter(expiration){
                    final /* synthetic */ Date $expiration;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean accept(File file) {
                        File file2 = file;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                        if (!file2.isFile()) return false;
                        String string2 = file.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
                        CharSequence charSequence = string2;
                        Regex regex = DefaultResolverEventLogger.access$getResolverLogFilenameRegex$p(DefaultResolverEventLogger.INSTANCE);
                        boolean bl = false;
                        if (!regex.matches(charSequence)) return false;
                        if (!new Date(file.lastModified()).before(this.$expiration)) return false;
                        return true;
                    }
                    {
                        this.$expiration = date;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"logDir.listFiles { file \u2026expiration)\n            }");
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                File[] fileArray2 = $this$forEach$iv;
                int n = fileArray2.length;
                for (int j = 0; j < n; ++j) {
                    File element$iv;
                    File it = element$iv = fileArray2[j];
                    boolean bl = false;
                    it.delete();
                }
            }
            {
                this.$logDir = file;
                super(0);
            }
        }));
    }

    private final void readyForCleanup(File logDir, Function0<Unit> cleanup) {
        File file = FilesKt.resolve((File)logDir, (String)".cleanup");
        boolean bl = false;
        boolean bl2 = false;
        File $this$run = file;
        boolean bl3 = false;
        if (!$this$run.isFile() || $this$run.isFile() && new Date($this$run.lastModified()).before(INSTANCE.daysAgo(1))) {
            cleanup.invoke();
            FilesKt.writeBytes((File)$this$run, (byte[])new byte[0]);
        }
    }

    private final Date daysAgo(int days) {
        Calendar calendar = GregorianCalendar.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        Calendar $this$apply = calendar;
        boolean bl3 = false;
        $this$apply.add(5, -days);
        Calendar calendar2 = calendar;
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"GregorianCalendar.getIns\u2026ar.DAY_OF_MONTH, -days) }");
        return calendar2.getTime();
    }

    private DefaultResolverEventLogger() {
    }

    public static final /* synthetic */ Date access$daysAgo(DefaultResolverEventLogger $this, int days) {
        return $this.daysAgo(days);
    }

    public static final /* synthetic */ Regex access$getResolverLogFilenameRegex$p(DefaultResolverEventLogger $this) {
        DefaultResolverEventLogger defaultResolverEventLogger = $this;
        return resolverLogFilenameRegex;
    }

    public static final /* synthetic */ BufferedWriter access$bufferedAppendWriter(DefaultResolverEventLogger $this) {
        return $this.bufferedAppendWriter();
    }

    public static final /* synthetic */ File access$outputDir(DefaultResolverEventLogger $this) {
        return $this.outputDir();
    }

    public static final /* synthetic */ void access$cleanupLogDirectory(DefaultResolverEventLogger $this, File logDir) {
        $this.cleanupLogDirectory(logDir);
    }

    public static final /* synthetic */ String access$timestampForFileName(DefaultResolverEventLogger $this) {
        return $this.timestampForFileName();
    }
}

