/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.gwt.dev.js.ThrowExceptionOnErrorReporter;
import org.jetbrains.kotlin.com.google.gwt.dev.js.rhino.ErrorReporter;
import org.jetbrains.kotlin.js.backend.JsToStringGenerationVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.facade.SourceMapBuilderConsumer;
import org.jetbrains.kotlin.js.inline.util.FixForwardNameReferencesKt;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.JSONKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMap;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapError;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapLocationRemapper;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapParser;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSuccess;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.sourceMap.SourceMap3Builder;
import org.jetbrains.kotlin.js.sourceMap.SourceMapMappingConsumer;
import org.jetbrains.kotlin.js.util.TextOutputImpl;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a\u0019\u0010\u0006\u001a\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\n\u001a.\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0002\u00a8\u0006\u0014"}, d2={"collectFiles", "", "rootFile", "Ljava/io/File;", "target", "", "main", "args", "", "", "([Ljava/lang/String;)V", "mergeStdlibParts", "outputFile", "wrapperFile", "baseDir", "inputPaths", "", "createInsertionPlace", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "cli-js"})
@JvmName(name="JSStdlibLinker")
public final class JSStdlibLinker {
    /*
     * WARNING - void declaration
     */
    public static final void main(@NotNull String[] args) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        File outputFile = new File(args[0]);
        File baseDir = new File(args[1]).getCanonicalFile();
        File wrapperFile = new File(args[2]);
        Iterable $this$map$iv = ArraysKt.drop((Object[])args, (int)3);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file2 = new File((String)it);
            collection.add(file2);
        }
        List inputPaths = (List)destination$iv$iv;
        File file3 = baseDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"baseDir");
        JSStdlibLinker.mergeStdlibParts(outputFile, wrapperFile, file3, inputPaths);
    }

    /*
     * WARNING - void declaration
     */
    private static final void mergeStdlibParts(File outputFile, File wrapperFile, File baseDir, List<? extends File> inputPaths) {
        void $this$toTypedArray$iv;
        JsonNode[] jsonNodeArray;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        JsonNode sourceMapJson;
        List list2;
        Object remapper2;
        Object file22;
        JsProgram program = new JsProgram();
        Function1<File, String> $fun$relativizeIfNecessary$1 = new Function1<File, String>(baseDir){
            final /* synthetic */ File $baseDir;

            @NotNull
            public final String invoke(@NotNull File $this$relativizeIfNecessary) {
                Intrinsics.checkParameterIsNotNull((Object)$this$relativizeIfNecessary, (String)"$this$relativizeIfNecessary");
                File file2 = $this$relativizeIfNecessary.getCanonicalFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"canonicalFile");
                return FilesKt.toRelativeString((File)file2, (File)this.$baseDir);
            }
            {
                this.$baseDir = file2;
                super(1);
            }
        };
        String string2 = FilesKt.readText$default((File)wrapperFile, null, (int)1, null);
        ErrorReporter errorReporter = ThrowExceptionOnErrorReporter.INSTANCE;
        JsObjectScope jsObjectScope = program.getScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsObjectScope, (String)"program.scope");
        List<JsStatement> list3 = ParserUtilsKt.parse(string2, errorReporter, jsObjectScope, $fun$relativizeIfNecessary$1.invoke(wrapperFile));
        if (list3 == null) {
            Intrinsics.throwNpe();
        }
        List<JsStatement> wrapper = list3;
        JsBlock insertionPlace = JSStdlibLinker.createInsertionPlace(wrapper);
        boolean bl = false;
        List allFiles = new ArrayList();
        Iterable $this$forEach$iv = inputPaths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl2 = false;
            JSStdlibLinker.collectFiles(it, allFiles);
        }
        for (Object file22 : allFiles) {
            Object sourceMapParse;
            List<JsStatement> statements;
            String string3 = FilesKt.readText$default((File)file22, null, (int)1, null);
            ErrorReporter errorReporter2 = ThrowExceptionOnErrorReporter.INSTANCE;
            JsObjectScope jsObjectScope2 = program.getScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsObjectScope2, (String)"program.scope");
            if (ParserUtilsKt.parse(string3, errorReporter2, jsObjectScope2, $fun$relativizeIfNecessary$1.invoke((File)file22)) == null) {
                Intrinsics.throwNpe();
            }
            JsBlock block = new JsBlock(statements);
            FixForwardNameReferencesKt.fixForwardNameReferences(block);
            File sourceMapFile2 = new File(((File)file22).getParent(), ((File)file22).getName() + ".map");
            if (sourceMapFile2.exists()) {
                sourceMapParse = SourceMapParser.INSTANCE.parse(sourceMapFile2);
                Object object = sourceMapParse;
                if (object instanceof SourceMapError) {
                    System.err.println("Error parsing source map file " + sourceMapFile2 + ": " + ((SourceMapError)sourceMapParse).getMessage());
                    int n = 1;
                    boolean bl3 = false;
                    System.exit(n);
                    throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
                if (object instanceof SourceMapSuccess) {
                    SourceMap sourceMap2 = ((SourceMapSuccess)sourceMapParse).getValue();
                    remapper2 = new SourceMapLocationRemapper(sourceMap2, null, 2, null);
                    ((SourceMapLocationRemapper)remapper2).remap(block);
                }
            }
            sourceMapParse = insertionPlace.getStatements();
            boolean bl4 = false;
            CollectionsKt.addAll((Collection)sourceMapParse, (Iterable)statements);
        }
        JsGlobalBlock jsGlobalBlock = program.getGlobalBlock();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsGlobalBlock, (String)"program.globalBlock");
        file22 = jsGlobalBlock.getStatements();
        $i$f$forEach = false;
        CollectionsKt.addAll((Collection)file22, (Iterable)wrapper);
        File sourceMapFile = new File(outputFile.getParentFile(), outputFile.getName() + ".map");
        TextOutputImpl textOutput = new TextOutputImpl();
        SourceMap3Builder sourceMapBuilder = new SourceMap3Builder(outputFile, textOutput, "");
        SourceMapMappingConsumer sourceMapMappingConsumer = sourceMapBuilder;
        File file3 = new File(".");
        boolean sourceMapFile2 = false;
        List list4 = list2 = (List)new ArrayList();
        boolean bl5 = true;
        boolean bl6 = true;
        SourceFilePathResolver sourceFilePathResolver = new SourceFilePathResolver(list4);
        SourceMapMappingConsumer sourceMapMappingConsumer2 = sourceMapMappingConsumer;
        File file4 = file3;
        SourceMapBuilderConsumer consumer = new SourceMapBuilderConsumer(file4, sourceMapMappingConsumer2, sourceFilePathResolver, bl6, bl5);
        program.getGlobalBlock().accept(new JsToStringGenerationVisitor(textOutput, consumer));
        String sourceMapContent = sourceMapBuilder.build();
        String string4 = textOutput.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"textOutput.toString()");
        String programText = string4;
        FilesKt.writeText$default((File)outputFile, (String)(programText + "\n//# sourceMappingURL=" + sourceMapFile.getName() + '\n'), null, (int)2, null);
        String string5 = sourceMapContent;
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sourceMapContent");
        JsonNode jsonNode = sourceMapJson = JSONKt.parseJson(string5);
        if (jsonNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject");
        }
        JsonNode jsonNode2 = ((JsonObject)jsonNode).getProperties().get("sources");
        if (jsonNode2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray");
        }
        JsonArray sources = (JsonArray)jsonNode2;
        remapper2 = sources.getElements();
        String string6 = "sourcesContent";
        Map<String, JsonNode> map2 = ((JsonObject)sourceMapJson).getProperties();
        boolean $i$f$map = false;
        void var19_42 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void sourcePath;
            JsonNode jsonNode3 = (JsonNode)item$iv$iv;
            jsonNodeArray = destination$iv$iv;
            boolean bl7 = false;
            void v12 = sourcePath;
            if (v12 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.parser.sourcemaps.JsonString");
            }
            File sourceFile = new File(((JsonString)v12).getValue());
            JsonNode jsonNode4 = sourceFile.exists() ? (JsonNode)new JsonString(FilesKt.readText$default((File)sourceFile, null, (int)1, null)) : (JsonNode)JsonNull.INSTANCE;
            jsonNodeArray.add(jsonNode4);
        }
        jsonNodeArray = (List)destination$iv$iv;
        $this$map$iv = (Collection)jsonNodeArray;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        JsonNode[] jsonNodeArray2 = thisCollection$iv.toArray(new JsonNode[0]);
        if (jsonNodeArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        jsonNodeArray = jsonNodeArray2;
        JsonNode[] jsonNodeArray3 = Arrays.copyOf(jsonNodeArray, jsonNodeArray.length);
        map2.put(string6, new JsonArray(jsonNodeArray3));
        FilesKt.writeText$default((File)sourceMapFile, (String)sourceMapJson.toString(), null, (int)2, null);
    }

    private static final JsBlock createInsertionPlace(@NotNull List<? extends JsStatement> $this$createInsertionPlace) {
        JsGlobalBlock block = new JsGlobalBlock();
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(block){
            final /* synthetic */ JsGlobalBlock $block;

            public boolean visit(@NotNull JsExpressionStatement x, @NotNull JsContext<? super JsStatement> ctx2) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx2, (String)"ctx");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"x.expression");
                if (this.isInsertionPlace(jsExpression)) {
                    ctx2.replaceMe((JsNode)this.$block);
                    return false;
                }
                return super.visit(x, ctx2);
            }

            private final boolean isInsertionPlace(JsExpression expression2) {
                if (!(expression2 instanceof JsInvocation) || !((JsInvocation)expression2).getArguments().isEmpty()) {
                    return false;
                }
                JsExpression jsExpression = ((JsInvocation)expression2).getQualifier();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"expression.qualifier");
                JsExpression qualifier = jsExpression;
                if (!(qualifier instanceof JsNameRef) || ((JsNameRef)qualifier).getQualifier() != null) {
                    return false;
                }
                return Intrinsics.areEqual((Object)((JsNameRef)qualifier).getIdent(), (Object)"insertContent");
            }
            {
                this.$block = $captured_local_variable$0;
            }
        };
        for (JsStatement jsStatement : $this$createInsertionPlace) {
            visitor2.accept((JsNode)jsStatement);
        }
        return block;
    }

    private static final void collectFiles(File rootFile, List<File> target) {
        if (rootFile.isDirectory()) {
            File[] fileArray = rootFile.listFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"rootFile.listFiles()");
            Iterator iterator2 = ArraysKt.sorted((Comparable[])fileArray).iterator();
            while (iterator2.hasNext()) {
                File child;
                File file2 = child = (File)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"child");
                JSStdlibLinker.collectFiles(file2, target);
            }
        } else if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)rootFile), (Object)"js")) {
            Collection collection = target;
            boolean bl = false;
            collection.add(rootFile);
        }
    }
}

