/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.diagnostic;

import java.lang.reflect.Constructor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.ControlFlowException;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.DefaultLogger;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.org.apache.log4j.Level;

public abstract class Logger {
    private static Factory ourFactory = new DefaultFactory();
    static final Function<Attachment, String> ATTACHMENT_TO_STRING = attachment -> attachment.getPath() + "\n" + attachment.getDisplayText();

    public static void setFactory(@NotNull Class<? extends Factory> factory2) {
        if (factory2 == null) {
            Logger.$$$reportNull$$$0(0);
        }
        if (Logger.isInitialized()) {
            if (factory2.isInstance(ourFactory)) {
                return;
            }
            System.out.println("Changing log factory\n" + ExceptionUtil.getThrowableText(new Throwable()));
        }
        try {
            Constructor<? extends Factory> constructor = factory2.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            ourFactory = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void setFactory(Factory factory2) {
        if (Logger.isInitialized()) {
            System.out.println("Changing log factory\n" + ExceptionUtil.getThrowableText(new Throwable()));
        }
        ourFactory = factory2;
    }

    public static Factory getFactory() {
        return ourFactory;
    }

    public static boolean isInitialized() {
        return !(ourFactory instanceof DefaultFactory);
    }

    @NotNull
    public static Logger getInstance(@NotNull String category) {
        if (category == null) {
            Logger.$$$reportNull$$$0(1);
        }
        Logger logger = ourFactory.getLoggerInstance(category);
        if (logger == null) {
            Logger.$$$reportNull$$$0(2);
        }
        return logger;
    }

    @NotNull
    public static Logger getInstance(@NotNull Class cl) {
        if (cl == null) {
            Logger.$$$reportNull$$$0(3);
        }
        Logger logger = Logger.getInstance("#" + cl.getName());
        if (logger == null) {
            Logger.$$$reportNull$$$0(4);
        }
        return logger;
    }

    public abstract boolean isDebugEnabled();

    public abstract void debug(String var1);

    public abstract void debug(@Nullable Throwable var1);

    public abstract void debug(String var1, @Nullable Throwable var2);

    public void debug(@NotNull String message2, Object ... details) {
        if (message2 == null) {
            Logger.$$$reportNull$$$0(5);
        }
        if (details == null) {
            Logger.$$$reportNull$$$0(6);
        }
        if (this.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(message2);
            for (Object detail : details) {
                sb.append(detail);
            }
            this.debug(sb.toString());
        }
    }

    public boolean isTraceEnabled() {
        return this.isDebugEnabled();
    }

    public void trace(String message2) {
        this.debug(message2);
    }

    public void trace(@Nullable Throwable t) {
        this.debug(t);
    }

    public void info(@NotNull Throwable t) {
        if (t == null) {
            Logger.$$$reportNull$$$0(7);
        }
        this.info(t.getMessage(), t);
    }

    public abstract void info(String var1);

    public abstract void info(String var1, @Nullable Throwable var2);

    public void warn(String message2) {
        this.warn(message2, null);
    }

    public void warn(@NotNull Throwable t) {
        if (t == null) {
            Logger.$$$reportNull$$$0(8);
        }
        this.warn(t.getMessage(), t);
    }

    public abstract void warn(String var1, @Nullable Throwable var2);

    public void error(String message2) {
        this.error(message2, new Throwable(message2), ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void error(Object message2) {
        this.error(String.valueOf(message2));
    }

    public void error(String message2, Attachment ... attachments) {
        if (attachments == null) {
            Logger.$$$reportNull$$$0(9);
        }
        this.error(message2, (Throwable)null, attachments);
    }

    public void error(String message2, @Nullable Throwable t, Attachment ... attachments) {
        if (attachments == null) {
            Logger.$$$reportNull$$$0(10);
        }
        this.error(message2, t, ContainerUtil.map2Array(attachments, String.class, ATTACHMENT_TO_STRING));
    }

    public void error(String message2, String ... details) {
        if (details == null) {
            Logger.$$$reportNull$$$0(11);
        }
        this.error(message2, new Throwable(message2), details);
    }

    public void error(String message2, @Nullable Throwable t) {
        this.error(message2, t, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void error(@NotNull Throwable t) {
        if (t == null) {
            Logger.$$$reportNull$$$0(12);
        }
        this.error(t.getMessage(), t, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public abstract void error(String var1, @Nullable Throwable var2, String ... var3);

    @Contract(value="false,_->fail")
    public boolean assertTrue(boolean value2, @Nullable Object message2) {
        if (!value2) {
            String resultMessage = "Assertion failed";
            if (message2 != null) {
                resultMessage = resultMessage + ": " + message2;
            }
            this.error(resultMessage, new Throwable(resultMessage));
        }
        return value2;
    }

    @Contract(value="false->fail")
    public boolean assertTrue(boolean value2) {
        return value2 || this.assertTrue(false, null);
    }

    public abstract void setLevel(Level var1);

    protected static Throwable checkException(@Nullable Throwable t) {
        return t instanceof ControlFlowException ? new Throwable("Control-flow exceptions (like " + t.getClass().getSimpleName() + ") should never be logged", t) : t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setFactory";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "info";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "warn";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DefaultFactory
    implements Factory {
        private DefaultFactory() {
        }

        @Override
        @NotNull
        public Logger getLoggerInstance(@NotNull String category) {
            if (category == null) {
                DefaultFactory.$$$reportNull$$$0(0);
            }
            DefaultLogger defaultLogger = new DefaultLogger(category);
            if (defaultLogger == null) {
                DefaultFactory.$$$reportNull$$$0(1);
            }
            return defaultLogger;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "category";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger$DefaultFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger$DefaultFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLoggerInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLoggerInstance";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Factory {
        @NotNull
        public Logger getLoggerInstance(@NotNull String var1);
    }
}

