/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.ResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiSubstitutorImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.ResolveScopeManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsReferenceParameterListImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class ClsJavaCodeReferenceElementImpl
extends ClsElementImpl
implements PsiAnnotatedJavaCodeReferenceElement {
    private final PsiElement myParent;
    private final String myCanonicalText;
    private final String myQualifiedName;
    private final PsiReferenceParameterList myRefParameterList;

    public ClsJavaCodeReferenceElementImpl(PsiElement parent2, @NotNull String canonicalText) {
        String canonical;
        if (canonicalText == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(0);
        }
        this.myParent = parent2;
        this.myCanonicalText = canonical = TypeInfo.internFrequentType(canonicalText);
        String qName = TypeInfo.internFrequentType(PsiNameHelper.getQualifiedClassName(this.myCanonicalText, false));
        this.myQualifiedName = qName.equals(canonical) ? canonical : qName;
        String[] classParameters = PsiNameHelper.getClassParametersText(canonicalText);
        this.myRefParameterList = classParameters.length == 0 ? null : new ClsReferenceParameterListImpl(this, classParameters);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(1);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String getText() {
        return PsiNameHelper.getPresentableText(this);
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string2 = this.myCanonicalText;
        if (string2 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated, @Nullable PsiAnnotation[] annotations2) {
        String text2 = this.getCanonicalText();
        if (!annotated || annotations2 == null) {
            String string2 = text2;
            if (string2 == null) {
                ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(3);
            }
            return string2;
        }
        StringBuilder sb = new StringBuilder();
        String prefix = ClsJavaCodeReferenceElementImpl.getOuterClassRef(text2);
        int tailStart = 0;
        if (!StringUtil.isEmpty(prefix)) {
            sb.append(prefix).append('.');
            tailStart = prefix.length() + 1;
        }
        PsiNameHelper.appendAnnotations(sb, Arrays.asList(annotations2), true);
        sb.append(text2, tailStart, text2.length());
        String string3 = sb.toString();
        if (string3 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(4);
        }
        return string3;
    }

    private JavaResolveResult advancedResolveImpl(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(5);
        }
        PsiTypeElement[] typeElements = this.myRefParameterList == null ? PsiTypeElement.EMPTY_ARRAY : this.myRefParameterList.getTypeParameterElements();
        PsiElement resolve2 = this.resolveElement(containingFile);
        if (resolve2 == null) {
            return null;
        }
        if (resolve2 instanceof PsiClass) {
            HashMap<PsiTypeParameter, PsiType> substitutionMap = new HashMap<PsiTypeParameter, PsiType>();
            int index2 = 0;
            for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiClass)resolve2)) {
                if (index2 >= typeElements.length) {
                    substitutionMap.put(parameter, null);
                } else {
                    substitutionMap.put(parameter, typeElements[index2].getType());
                }
                ++index2;
            }
            this.collectOuterClassTypeArgs((PsiClass)resolve2, this.myCanonicalText, substitutionMap);
            return new CandidateInfo(resolve2, PsiSubstitutorImpl.createSubstitutor(substitutionMap));
        }
        return new CandidateInfo(resolve2, PsiSubstitutor.EMPTY);
    }

    private void collectOuterClassTypeArgs(@NotNull PsiClass psiClass, String canonicalText, Map<PsiTypeParameter, PsiType> substitutionMap) {
        PsiClass containingClass;
        if (psiClass == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(6);
        }
        if ((containingClass = psiClass.getContainingClass()) != null) {
            String outerClassRef = ClsJavaCodeReferenceElementImpl.getOuterClassRef(canonicalText);
            String[] classParameters = PsiNameHelper.getClassParametersText(outerClassRef);
            PsiType[] args = classParameters.length == 0 ? null : new ClsReferenceParameterListImpl(this, classParameters).getTypeArguments();
            PsiTypeParameter[] typeParameters2 = containingClass.getTypeParameters();
            for (int i = 0; i < typeParameters2.length; ++i) {
                if (args != null) {
                    if (i >= args.length) continue;
                    substitutionMap.put(typeParameters2[i], args[i]);
                    continue;
                }
                substitutionMap.put(typeParameters2[i], null);
            }
            if (!containingClass.hasModifierProperty("static")) {
                this.collectOuterClassTypeArgs(containingClass, outerClassRef, substitutionMap);
            }
        }
    }

    @NotNull
    @Contract(pure=true)
    private static String getOuterClassRef(String ref) {
        int stack = 0;
        block5: for (int i = ref.length() - 1; i >= 0; --i) {
            char c = ref.charAt(i);
            switch (c) {
                case '<': {
                    --stack;
                    continue block5;
                }
                case '>': {
                    ++stack;
                    continue block5;
                }
                case '.': {
                    if (stack != 0) continue block5;
                    String string2 = ref.substring(0, i);
                    if (string2 == null) {
                        ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(7);
                    }
                    return string2;
                }
            }
        }
        if ("" == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(8);
        }
        return "";
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            JavaResolveResult javaResolveResult = results[0];
            if (javaResolveResult == null) {
                ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(9);
            }
            return javaResolveResult;
        }
        JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(10);
        }
        return javaResolveResult;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file2 = this.getContainingFile();
        if (file2 == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        ResolveCache resolveCache = ResolveCache.getInstance(file2.getProject());
        ResolveResult[] results = resolveCache.resolveWithCaching(this, Resolver.INSTANCE, true, incompleteCode, file2);
        if (results.length == 0) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(11);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        JavaResolveResult[] javaResolveResultArray = (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(12);
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Nullable
    private PsiElement resolveElement(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(13);
        }
        for (PsiElement element = this.getParent(); element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (element instanceof PsiMethod) {
                for (PsiTypeParameter psiTypeParameter : PsiUtil.typeParametersIterable((PsiMethod)element)) {
                    if (!this.myQualifiedName.equals(psiTypeParameter.getName())) continue;
                    return psiTypeParameter;
                }
                continue;
            }
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) continue;
            PsiClass psiClass = (PsiClass)element;
            if (this.myQualifiedName.equals(psiClass.getQualifiedName())) {
                return element;
            }
            for (PsiTypeParameter parameter3 : PsiUtil.typeParametersIterable(psiClass)) {
                if (!this.myQualifiedName.equals(parameter3.getName())) continue;
                return parameter3;
            }
            for (PsiClass innerClass : psiClass.getInnerClasses()) {
                if (!this.myQualifiedName.equals(innerClass.getQualifiedName())) continue;
                return innerClass;
            }
        }
        Project project = containingFile.getProject();
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getInstance(project).getResolveScope(this);
        return JavaPsiFacade.getInstance(project).findClass(this.myQualifiedName, globalSearchScope);
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor2) {
        if (processor2 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(14);
        }
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return this.myRefParameterList;
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    @Override
    public String getReferenceName() {
        return PsiNameHelper.getShortClassName(this.myCanonicalText);
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(15);
        }
        throw ClsJavaCodeReferenceElementImpl.cannotModifyException(this);
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(16);
        }
        throw ClsJavaCodeReferenceElementImpl.cannotModifyException(this);
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(17);
        }
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass2 = (PsiClass)element;
        return this.myCanonicalText.equals(aClass2.getQualifiedName()) || this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for references to compiled code");
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(18);
        }
        buffer.append(this.getCanonicalText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(19);
        }
        this.setMirrorCheckingType(element, JavaElementType.JAVA_CODE_REFERENCE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(20);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = new TextRange(0, this.getTextLength());
        if (textRange == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(21);
        }
        return textRange;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        ClsJavaCodeReferenceElementImpl clsJavaCodeReferenceElementImpl = this;
        if (clsJavaCodeReferenceElementImpl == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(22);
        }
        return clsJavaCodeReferenceElementImpl;
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        PsiType[] psiTypeArray = this.myRefParameterList == null ? PsiType.EMPTY_ARRAY : this.myRefParameterList.getTypeArguments();
        if (psiTypeArray == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(23);
        }
        return psiTypeArray;
    }

    @Override
    public boolean isQualified() {
        return false;
    }

    @Override
    public PsiElement getQualifier() {
        return null;
    }

    @Override
    public String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 23: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterClassRef";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "advancedResolveImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectOuterClassTypeArgs";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "appendMirrorText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantContextResolver<ClsJavaCodeReferenceElementImpl> {
        public static final Resolver INSTANCE = new Resolver();

        private Resolver() {
        }

        @NotNull
        public JavaResolveResult[] resolve(@NotNull ClsJavaCodeReferenceElementImpl ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            JavaResolveResult[] javaResolveResultArray;
            JavaResolveResult resolveResult;
            if (ref == null) {
                Resolver.$$$reportNull$$$0(0);
            }
            if (containingFile == null) {
                Resolver.$$$reportNull$$$0(1);
            }
            if ((resolveResult = ref.advancedResolveImpl(containingFile)) == null) {
                javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            } else {
                JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                javaResolveResultArray = javaResolveResultArray2;
                javaResolveResultArray2[0] = resolveResult;
            }
            if (javaResolveResultArray == null) {
                Resolver.$$$reportNull$$$0(2);
            }
            return javaResolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

