/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.CommonProcessors;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.Processors;
import org.jetbrains.kotlin.com.intellij.util.Query;
import org.jetbrains.kotlin.com.intellij.util.UnmodifiableIterator;

public abstract class AbstractQuery<Result>
implements Query<Result> {
    private final ThreadLocal<Boolean> myIsProcessing = new ThreadLocal();

    @Override
    @NotNull
    public Collection<Result> findAll() {
        this.assertNotProcessing();
        ArrayList result2 = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.forEach(processor2);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            AbstractQuery.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Iterator<Result> iterator() {
        this.assertNotProcessing();
        UnmodifiableIterator<Result> unmodifiableIterator = new UnmodifiableIterator<Result>(this.findAll().iterator());
        if (unmodifiableIterator == null) {
            AbstractQuery.$$$reportNull$$$0(1);
        }
        return unmodifiableIterator;
    }

    @Override
    @Nullable
    public Result findFirst() {
        this.assertNotProcessing();
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        this.forEach(processor2);
        return (Result)processor2.getFoundValue();
    }

    private void assertNotProcessing() {
        assert (this.myIsProcessing.get() == null) : "Operation is not allowed while query is being processed";
    }

    @NotNull
    private Processor<Result> threadSafeProcessor(@NotNull Processor<? super Result> consumer) {
        if (consumer == null) {
            AbstractQuery.$$$reportNull$$$0(5);
        }
        Object lock = ObjectUtils.sentinel("AbstractQuery lock");
        Processor<Object> processor2 = e -> {
            Object object = lock;
            synchronized (object) {
                return consumer.process((Object)e);
            }
        };
        if (processor2 == null) {
            AbstractQuery.$$$reportNull$$$0(6);
        }
        return processor2;
    }

    @Override
    public boolean forEach(@NotNull Processor<? super Result> consumer) {
        if (consumer == null) {
            AbstractQuery.$$$reportNull$$$0(7);
        }
        return this.doProcessResults(this.threadSafeProcessor(consumer));
    }

    private boolean doProcessResults(Processor<? super Result> consumer) {
        this.assertNotProcessing();
        this.myIsProcessing.set(true);
        try {
            boolean bl = this.processResults(consumer);
            return bl;
        }
        finally {
            this.myIsProcessing.remove();
        }
    }

    protected abstract boolean processResults(@NotNull Processor<? super Result> var1);

    protected static <T> boolean delegateProcessResults(Query<T> query, @NotNull Processor<? super T> consumer) {
        if (consumer == null) {
            AbstractQuery.$$$reportNull$$$0(10);
        }
        if (query instanceof AbstractQuery) {
            return ((AbstractQuery)query).doProcessResults(consumer);
        }
        return query.forEach(consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/AbstractQuery";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/AbstractQuery";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "allowParallelProcessing";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "threadSafeProcessor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "forEachAsync";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInReadAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "threadSafeProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forEachAsync";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "delegateProcessResults";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "wrapInReadAction";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

