/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.CacheCleanupAction;
import org.gradle.cache.internal.CacheCoordinator;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.DefaultCacheAccess;
import org.gradle.cache.internal.DefaultCleanupProgressMonitor;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPersistentDirectoryStore
implements ReferencablePersistentCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPersistentDirectoryStore.class);
    public static final int CLEANUP_INTERVAL_IN_HOURS = 24;
    private final File dir;
    private final CacheBuilder.LockTarget lockTarget;
    private final LockOptions lockOptions;
    private final CleanupAction cleanupAction;
    private final FileLockManager lockManager;
    private final ExecutorFactory executorFactory;
    private final String displayName;
    protected final File propertiesFile;
    private final File gcFile;
    private final ProgressLoggerFactory progressLoggerFactory;
    private CacheCoordinator cacheAccess;

    public DefaultPersistentDirectoryStore(File dir, String displayName, CacheBuilder.LockTarget lockTarget, LockOptions lockOptions, CleanupAction cleanupAction, FileLockManager fileLockManager, ExecutorFactory executorFactory, ProgressLoggerFactory progressLoggerFactory) {
        this.dir = dir;
        this.lockTarget = lockTarget;
        this.lockOptions = lockOptions;
        this.cleanupAction = cleanupAction;
        this.lockManager = fileLockManager;
        this.executorFactory = executorFactory;
        this.propertiesFile = new File(dir, "cache.properties");
        this.gcFile = new File(dir, "gc.properties");
        this.progressLoggerFactory = progressLoggerFactory;
        this.displayName = displayName != null ? displayName + " (" + dir + ")" : "cache directory " + dir.getName() + " (" + dir + ")";
    }

    @Override
    public DefaultPersistentDirectoryStore open() {
        GFileUtils.mkdirs((File)this.dir);
        this.cacheAccess = this.createCacheAccess();
        try {
            this.cacheAccess.open();
        }
        catch (Throwable e) {
            throw new CacheOpenException(String.format("Could not open %s.", this), e);
        }
        return this;
    }

    private CacheCoordinator createCacheAccess() {
        return new DefaultCacheAccess(this.displayName, this.getLockTarget(), this.lockOptions, this.dir, this.lockManager, this.getInitAction(), this.getCleanupAction(), this.executorFactory);
    }

    private File getLockTarget() {
        switch (this.lockTarget) {
            case CacheDirectory: 
            case DefaultTarget: {
                return this.dir;
            }
            case CachePropertiesFile: {
                return this.propertiesFile;
            }
        }
        throw new IllegalArgumentException("Unsupported lock target: " + (Object)((Object)this.lockTarget));
    }

    protected CacheInitializationAction getInitAction() {
        return new CacheInitializationAction(){

            @Override
            public boolean requiresInitialization(FileLock fileLock) {
                return false;
            }

            @Override
            public void initialize(FileLock fileLock) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected CacheCleanupAction getCleanupAction() {
        return new Cleanup();
    }

    @Override
    public void close() {
        if (this.cacheAccess != null) {
            try {
                this.cacheAccess.close();
            }
            finally {
                this.cacheAccess = null;
            }
        }
    }

    @Override
    public File getBaseDir() {
        return this.dir;
    }

    @Override
    public Collection<File> getReservedCacheFiles() {
        return Arrays.asList(this.propertiesFile, this.gcFile, DefaultPersistentDirectoryStore.determineLockTargetFile(this.getLockTarget()));
    }

    static File determineLockTargetFile(File target) {
        if (target.isDirectory()) {
            return new File(target, target.getName() + ".lock");
        }
        return new File(target.getParentFile(), target.getName() + ".lock");
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(PersistentIndexedCacheParameters<K, V> parameters) {
        return this.cacheAccess.newCache(parameters);
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(String name, Class<K> keyType, Serializer<V> valueSerializer) {
        return this.cacheAccess.newCache(PersistentIndexedCacheParameters.of(name, keyType, valueSerializer));
    }

    @Override
    public <K, V> boolean cacheExists(PersistentIndexedCacheParameters<K, V> parameters) {
        return this.cacheAccess.cacheExists(parameters);
    }

    @Override
    public <T> T withFileLock(Factory<? extends T> action) {
        return this.cacheAccess.withFileLock(action);
    }

    @Override
    public void withFileLock(Runnable action) {
        this.cacheAccess.withFileLock(action);
    }

    @Override
    public <T> T useCache(Factory<? extends T> action) {
        return this.cacheAccess.useCache(action);
    }

    @Override
    public void useCache(Runnable action) {
        this.cacheAccess.useCache(action);
    }

    private class Cleanup
    implements CacheCleanupAction {
        private Cleanup() {
        }

        @Override
        public boolean requiresCleanup() {
            if (DefaultPersistentDirectoryStore.this.cleanupAction != null) {
                if (!DefaultPersistentDirectoryStore.this.gcFile.exists()) {
                    GFileUtils.touch((File)DefaultPersistentDirectoryStore.this.gcFile);
                } else {
                    long duration = System.currentTimeMillis() - DefaultPersistentDirectoryStore.this.gcFile.lastModified();
                    long timeInHours = TimeUnit.MILLISECONDS.toHours(duration);
                    LOGGER.debug("{} has last been fully cleaned up {} hours ago", (Object)DefaultPersistentDirectoryStore.this, (Object)timeInHours);
                    return timeInHours >= 24L;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleanup() {
            if (DefaultPersistentDirectoryStore.this.cleanupAction != null) {
                String description = "Cleaning " + DefaultPersistentDirectoryStore.this.getDisplayName();
                ProgressLogger progressLogger = DefaultPersistentDirectoryStore.this.progressLoggerFactory.newOperation(CacheCleanupAction.class).start(description, description);
                Timer timer = Time.startTimer();
                try {
                    DefaultPersistentDirectoryStore.this.cleanupAction.clean(DefaultPersistentDirectoryStore.this, new DefaultCleanupProgressMonitor(progressLogger));
                    GFileUtils.touch((File)DefaultPersistentDirectoryStore.this.gcFile);
                }
                finally {
                    LOGGER.info("{} cleaned up in {}.", (Object)DefaultPersistentDirectoryStore.this, (Object)timer.getElapsed());
                    progressLogger.completed();
                }
            }
        }
    }
}

