/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ExplicitApiMode;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExplicitApiDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkExplicitReturnType", "state", "Lorg/jetbrains/kotlin/config/ExplicitApiMode;", "checkVisibilityModifier", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "excludeForDiagnostic", "", "Companion", "frontend"})
public final class ExplicitApiDeclarationChecker
implements DeclarationChecker {
    public static final Companion Companion = new Companion(null);

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        ExplicitApiMode state = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getExplicitApiMode());
        if (state == ExplicitApiMode.DISABLED) {
            return;
        }
        if (!(descriptor2 instanceof DeclarationDescriptorWithVisibility)) {
            return;
        }
        if (!DescriptorUtilsKt.isEffectivelyPublicApi((DeclarationDescriptorWithVisibility)descriptor2)) {
            return;
        }
        this.checkVisibilityModifier(state, declaration2, (DeclarationDescriptorWithVisibility)descriptor2, context2);
        this.checkExplicitReturnType(state, declaration2, descriptor2, context2);
    }

    private final void checkVisibilityModifier(ExplicitApiMode state, KtDeclaration declaration2, DeclarationDescriptorWithVisibility descriptor2, DeclarationCheckerContext context2) {
        PsiElement modifier = KtPsiUtilKt.visibilityModifier(declaration2);
        if (modifier != null) {
            return;
        }
        if (this.excludeForDiagnostic(descriptor2)) {
            return;
        }
        DiagnosticFactory0<KtDeclaration> diagnostic = state == ExplicitApiMode.STRICT ? Errors.NO_EXPLICIT_VISIBILITY_IN_API_MODE : Errors.NO_EXPLICIT_VISIBILITY_IN_API_MODE_WARNING;
        BindingTrace bindingTrace = context2.getTrace();
        SimpleDiagnostic<KtDeclaration> simpleDiagnostic = diagnostic.on((KtDeclaration)((PsiElement)declaration2));
        Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"diagnostic.on(declaration)");
        DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
    }

    private final void checkExplicitReturnType(ExplicitApiMode state, KtDeclaration declaration2, DeclarationDescriptor descriptor2, DeclarationCheckerContext context2) {
        if (!(declaration2 instanceof KtCallableDeclaration)) {
            return;
        }
        if (!Companion.returnTypeCheckIsApplicable((KtCallableDeclaration)declaration2)) {
            return;
        }
        boolean shouldReport = Companion.returnTypeRequired((KtCallableDeclaration)declaration2, descriptor2, true, false, false);
        if (shouldReport) {
            DiagnosticFactory0<KtNamedDeclaration> diagnostic = state == ExplicitApiMode.STRICT ? Errors.NO_EXPLICIT_RETURN_TYPE_IN_API_MODE : Errors.NO_EXPLICIT_RETURN_TYPE_IN_API_MODE_WARNING;
            BindingTrace bindingTrace = context2.getTrace();
            SimpleDiagnostic<KtNamedDeclaration> simpleDiagnostic = diagnostic.on((KtNamedDeclaration)declaration2);
            Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"diagnostic.on(declaration)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
        }
    }

    private final boolean excludeForDiagnostic(DeclarationDescriptor descriptor2) {
        Object object;
        DeclarationDescriptor declarationDescriptor;
        DeclarationDescriptor declarationDescriptor2 = descriptor2;
        if (!(declarationDescriptor2 instanceof ClassConstructorDescriptor)) {
            declarationDescriptor2 = null;
        }
        ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)declarationDescriptor2;
        if (classConstructorDescriptor != null) {
            if (classConstructorDescriptor.isPrimary()) {
                return true;
            }
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            DeclarationDescriptor declarationDescriptor3 = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
            if (!(declarationDescriptor3 instanceof ClassDescriptor)) {
                declarationDescriptor3 = null;
            }
            ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor3;
            if (classDescriptor2 != null) {
                if (classDescriptor2.isData()) {
                    return true;
                }
            }
        }
        if (!((declarationDescriptor = descriptor2) instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        if ((object = (CallableDescriptor)declarationDescriptor) != null && (object = object.getOverriddenDescriptors()) != null) {
            Object object2 = object;
            boolean bl = false;
            if (!object2.isEmpty()) {
                return true;
            }
        }
        return descriptor2 instanceof PropertyAccessorDescriptor;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J0\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExplicitApiDeclarationChecker$Companion;", "", "()V", "returnTypeCheckIsApplicable", "", "element", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "returnTypeRequired", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkForPublicApi", "checkForInternal", "checkForPrivate", "frontend"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean returnTypeRequired(@NotNull KtCallableDeclaration element, @Nullable DeclarationDescriptor descriptor2, boolean checkForPublicApi, boolean checkForInternal, boolean checkForPrivate) {
            Visibility visibility;
            CallableMemberDescriptor callableMemberDescriptor;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(element);
            if (ktClassOrObject != null) {
                if (ktClassOrObject.isLocal()) {
                    return false;
                }
            }
            if (element instanceof KtFunction && ((KtFunction)element).isLocal()) {
                return false;
            }
            if (element instanceof KtProperty && ((KtProperty)element).isLocal()) {
                return false;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (!(declarationDescriptor instanceof CallableMemberDescriptor)) {
                declarationDescriptor = null;
            }
            Visibility visibility2 = (object = (callableMemberDescriptor = (CallableMemberDescriptor)declarationDescriptor)) != null && (object = EffectiveVisibilityKt.effectiveVisibility$default((DeclarationDescriptorWithVisibility)object, null, false, 3, null)) != null ? ((EffectiveVisibility)object).toVisibility() : (visibility = null);
            if (checkForPublicApi) {
                Visibility visibility3 = visibility;
                if (visibility3 != null) {
                    if (visibility3.isPublicAPI()) return true;
                }
            }
            if (checkForInternal) {
                if (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.INTERNAL)) return true;
            }
            if (!checkForPrivate) return false;
            if (!Intrinsics.areEqual((Object)visibility, (Object)Visibilities.PRIVATE)) return false;
            return true;
        }

        public final boolean returnTypeCheckIsApplicable(@NotNull KtCallableDeclaration element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (element.getContainingFile() instanceof KtCodeFragment) {
                return false;
            }
            if (element instanceof KtFunctionLiteral) {
                return false;
            }
            if (element instanceof KtConstructor) {
                return false;
            }
            if (element.getTypeReference() != null) {
                return false;
            }
            return !(element instanceof KtNamedFunction) || !((KtNamedFunction)element).hasBlockBody();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

