/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.Collector;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;

public class Collectors {

    public static class TypedCollector<T>
    implements ProvidedCollector<T> {
        private final Class<? extends T> type;
        protected final Collector<T> delegate;
        private final ValueCollector<T> valueCollector;

        public TypedCollector(@Nullable Class<? extends T> type, Collector<T> delegate) {
            this.type = type;
            this.delegate = delegate;
            this.valueCollector = ValueSanitizers.collectorFor(type);
        }

        @Nullable
        public Class<? extends T> getType() {
            return this.type;
        }

        @Override
        public boolean isPresent() {
            return this.delegate.isPresent();
        }

        public void collectInto(ImmutableCollection.Builder<T> builder) {
            this.collectEntries(this.valueCollector, builder);
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueCollector<T> collector, ImmutableCollection.Builder<T> dest) {
            return this.delegate.collectEntries(collector, dest);
        }

        @Override
        public boolean isProvidedBy(Provider<?> provider) {
            return this.delegate instanceof ProvidedCollector && ((ProvidedCollector)this.delegate).isProvidedBy(provider);
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            this.delegate.visit(sources);
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return this.delegate.maybeVisitBuildDependencies(context);
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
            this.delegate.visitProducerTasks(visitor);
        }

        @Override
        public boolean isValueProducedByTask() {
            return this.delegate.isValueProducedByTask();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypedCollector that = (TypedCollector)o;
            return Objects.equal(this.type, that.type) && Objects.equal(this.delegate, that.delegate);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.delegate});
        }
    }

    public static class ElementsFromArray<T>
    implements Collector<T> {
        private final T[] value;

        ElementsFromArray(T[] value) {
            this.value = value;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueCollector<T> collector, ImmutableCollection.Builder<T> dest) {
            for (T t : this.value) {
                collector.add(t, dest);
            }
            return ValueSupplier.Value.present();
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            sources.add(Providers.of(ImmutableList.copyOf((Object[])this.value)));
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return false;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
        }

        @Override
        public boolean isValueProducedByTask() {
            return false;
        }

        @Override
        public int size() {
            return this.value.length;
        }
    }

    public static class ElementsFromCollectionProvider<T>
    implements ProvidedCollector<T> {
        private final ProviderInternal<? extends Iterable<? extends T>> provider;

        public ElementsFromCollectionProvider(ProviderInternal<? extends Iterable<? extends T>> provider) {
            this.provider = provider;
        }

        @Override
        public boolean isPresent() {
            return this.provider.isPresent();
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueCollector<T> collector, ImmutableCollection.Builder<T> collection) {
            ValueSupplier.Value<Iterable<T>> value = this.provider.calculateValue();
            if (value.isMissing()) {
                return value.asType();
            }
            collector.addAll(value.get(), collection);
            return ValueSupplier.Value.present();
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            sources.add(this.provider);
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return this.provider.maybeVisitBuildDependencies(context);
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
            this.provider.visitProducerTasks(visitor);
        }

        @Override
        public boolean isValueProducedByTask() {
            return this.provider.isValueProducedByTask();
        }

        @Override
        public boolean isProvidedBy(Provider<?> provider) {
            return Objects.equal(provider, provider);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementsFromCollectionProvider that = (ElementsFromCollectionProvider)o;
            return Objects.equal(this.provider, that.provider);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.provider});
        }

        @Override
        public int size() {
            if (this.provider instanceof CollectionProviderInternal) {
                return ((CollectionProviderInternal)this.provider).size();
            }
            throw new UnsupportedOperationException();
        }
    }

    public static class ElementsFromCollection<T>
    implements Collector<T> {
        private final Iterable<? extends T> value;

        public ElementsFromCollection(Iterable<? extends T> value) {
            this.value = value;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueCollector<T> collector, ImmutableCollection.Builder<T> collection) {
            collector.addAll(this.value, collection);
            return ValueSupplier.Value.present();
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            sources.add(Providers.of(this.value));
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return false;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
        }

        @Override
        public boolean isValueProducedByTask() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementsFromCollection that = (ElementsFromCollection)o;
            return Objects.equal(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.value});
        }

        @Override
        public int size() {
            return Iterables.size(this.value);
        }
    }

    public static class ElementFromProvider<T>
    implements ProvidedCollector<T> {
        private final ProviderInternal<? extends T> providerOfElement;

        public ElementFromProvider(ProviderInternal<? extends T> providerOfElement) {
            this.providerOfElement = providerOfElement;
        }

        @Override
        public boolean isPresent() {
            return this.providerOfElement.isPresent();
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueCollector<T> collector, ImmutableCollection.Builder<T> collection) {
            ValueSupplier.Value<T> value = this.providerOfElement.calculateValue();
            if (value.isMissing()) {
                return value.asType();
            }
            collector.add(value.get(), collection);
            return ValueSupplier.Value.present();
        }

        @Override
        public boolean isProvidedBy(Provider<?> provider) {
            return Objects.equal(provider, this.providerOfElement);
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            sources.add((ProviderInternal<Iterable<T>>)this.providerOfElement.map(e -> ImmutableList.of((Object)e)));
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return this.providerOfElement.maybeVisitBuildDependencies(context);
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
            this.providerOfElement.visitProducerTasks(visitor);
        }

        @Override
        public boolean isValueProducedByTask() {
            return this.providerOfElement.isValueProducedByTask();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementFromProvider that = (ElementFromProvider)o;
            return Objects.equal(this.providerOfElement, that.providerOfElement);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.providerOfElement});
        }

        @Override
        public int size() {
            return 1;
        }
    }

    public static class SingleElement<T>
    implements Collector<T> {
        private final T element;

        public SingleElement(T element) {
            this.element = element;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueCollector<T> collector, ImmutableCollection.Builder<T> collection) {
            collector.add(this.element, collection);
            return ValueSupplier.Value.present();
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            sources.add(Providers.of(ImmutableList.of(this.element)));
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return false;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
        }

        @Override
        public boolean isValueProducedByTask() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleElement that = (SingleElement)o;
            return Objects.equal(this.element, that.element);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.element});
        }

        @Override
        public int size() {
            return 1;
        }
    }

    public static interface ProvidedCollector<T>
    extends Collector<T> {
        public boolean isProvidedBy(Provider<?> var1);
    }
}

