/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Cast;
import org.gradle.internal.DisplayName;

public interface ValueSupplier {
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext var1);

    public void visitProducerTasks(Action<? super Task> var1);

    public boolean isValueProducedByTask();

    public boolean isPresent();

    public static class Missing<T>
    implements Value<T> {
        private final List<DisplayName> path;

        public Missing() {
            this.path = ImmutableList.of();
        }

        public Missing(List<DisplayName> path) {
            this.path = path;
        }

        @Override
        public boolean isMissing() {
            return true;
        }

        @Override
        public T get() throws IllegalStateException {
            throw new IllegalStateException();
        }

        @Override
        public T orNull() {
            return null;
        }

        @Override
        public <S> S orElse(S defaultValue) {
            return defaultValue;
        }

        @Override
        public List<DisplayName> getPathToOrigin() {
            return this.path;
        }

        @Override
        public <S> Value<S> asType() {
            return (Value)Cast.uncheckedCast((Object)this);
        }

        @Override
        public Value<T> pushWhenMissing(@Nullable DisplayName displayName) {
            if (displayName == null) {
                return this;
            }
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.path.size() + 1));
            builder.add((Object)displayName);
            builder.addAll(this.path);
            return new Missing<T>((List<DisplayName>)builder.build());
        }

        @Override
        public Value<T> addPathsFrom(Value<?> rightValue) {
            if (this.path.isEmpty()) {
                return rightValue.asType();
            }
            Missing other = (Missing)rightValue;
            if (other.path.isEmpty()) {
                return this;
            }
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.path.size() + other.path.size()));
            builder.addAll(this.path);
            builder.addAll(other.path);
            return new Missing<T>((List<DisplayName>)builder.build());
        }
    }

    public static class Present<T>
    implements Value<T> {
        private final T result;

        public Present(T result) {
            this.result = result;
        }

        @Override
        public boolean isMissing() {
            return false;
        }

        @Override
        public T get() throws IllegalStateException {
            return this.result;
        }

        @Override
        public T orNull() {
            return this.result;
        }

        @Override
        public <S> S orElse(S defaultValue) {
            return (S)Cast.uncheckedCast(this.result);
        }

        @Override
        public Value<T> pushWhenMissing(@Nullable DisplayName displayName) {
            return this;
        }

        @Override
        public <S> Value<S> asType() {
            throw new IllegalStateException();
        }

        @Override
        public List<DisplayName> getPathToOrigin() {
            throw new IllegalStateException();
        }

        @Override
        public Value<T> addPathsFrom(Value<?> rightValue) {
            throw new IllegalStateException();
        }
    }

    public static interface Value<T> {
        public static final Value<Object> MISSING;
        public static final Value<Void> SUCCESS;

        public static <T> Value<T> ofNullable(@Nullable T value) {
            if (value == null) {
                return MISSING.asType();
            }
            return new Present<T>(value);
        }

        public static <T> Value<T> missing() {
            return MISSING.asType();
        }

        public static <T> Value<T> of(T value) {
            if (!1.$assertionsDisabled && value == null) {
                throw new AssertionError();
            }
            return new Present<T>(value);
        }

        public static Value<Void> present() {
            return SUCCESS;
        }

        public T get() throws IllegalStateException;

        @Nullable
        public T orNull();

        public <S> S orElse(S var1);

        public List<DisplayName> getPathToOrigin();

        public boolean isMissing();

        public <S> Value<S> asType();

        public Value<T> pushWhenMissing(@Nullable DisplayName var1);

        public Value<T> addPathsFrom(Value<?> var1);

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
            MISSING = new Missing<Object>();
            SUCCESS = new Present<Object>(null);
        }
    }
}

