/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.AbstractIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Supplier;
import java.util.zip.ZipFile;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.changedetection.state.JdkZipEntry;
import org.gradle.api.internal.changedetection.state.StreamZipInput;
import org.gradle.api.internal.changedetection.state.ZipEntry;
import org.gradle.api.internal.changedetection.state.ZipInput;

class FileZipInput
implements ZipInput {
    private final ZipFile file;
    private final Enumeration<? extends java.util.zip.ZipEntry> entries;

    public static ZipInput create(File file) {
        if (FileZipInput.isZipFileSafeToUse()) {
            return new FileZipInput(file);
        }
        try {
            return new StreamZipInput(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static boolean isZipFileSafeToUse() {
        return JavaVersion.current().isJava11Compatible();
    }

    private FileZipInput(File file) {
        try {
            this.file = new ZipFile(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.entries = this.file.entries();
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        return new AbstractIterator<ZipEntry>(){

            protected ZipEntry computeNext() {
                if (!FileZipInput.this.entries.hasMoreElements()) {
                    return (ZipEntry)this.endOfData();
                }
                final java.util.zip.ZipEntry zipEntry = (java.util.zip.ZipEntry)FileZipInput.this.entries.nextElement();
                return new JdkZipEntry(zipEntry, new Supplier<InputStream>(){

                    @Override
                    public InputStream get() {
                        try {
                            return FileZipInput.this.file.getInputStream(zipEntry);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                });
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

