/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import groovy.util.CharsetToolkit;
import java.io.File;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.buildinit.plugins.internal.BuildInitException;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateValue;

public class SimpleTemplateOperation
implements TemplateOperation {
    private final URL templateURL;
    private final File target;
    private final Map<String, TemplateValue> bindings;

    public SimpleTemplateOperation(URL templateURL, File target, Map<String, TemplateValue> bindings) {
        if (templateURL == null) {
            throw new BuildInitException("Template URL must not be null");
        }
        if (target == null) {
            throw new BuildInitException("Target file must not be null");
        }
        this.templateURL = templateURL;
        this.bindings = bindings;
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate() {
        try {
            this.target.getParentFile().mkdirs();
            SimpleTemplateEngine templateEngine = new SimpleTemplateEngine();
            String templateText = Resources.asCharSource((URL)this.templateURL, (Charset)CharsetToolkit.getDefaultSystemCharset()).read();
            Template template = templateEngine.createTemplate(templateText);
            try (Writer writer = Files.asCharSink((File)this.target, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).openStream();){
                template.make(this.bindings).writeTo(writer);
            }
        }
        catch (Exception ex) {
            throw new GradleException("Could not generate file " + this.target + ".", (Throwable)ex);
        }
    }
}

