/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NonNullApi;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.internal.catalog.AbstractExternalDependencyFactory;
import org.gradle.api.internal.catalog.AbstractSourceGenerator;
import org.gradle.api.internal.catalog.BundleModel;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.internal.catalog.DependencyModel;
import org.gradle.api.internal.catalog.VersionModel;
import org.gradle.api.internal.catalog.problems.DefaultCatalogProblemBuilder;
import org.gradle.api.internal.catalog.problems.VersionCatalogProblemId;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.util.TextUtil;

public class LibrariesSourceGenerator
extends AbstractSourceGenerator {
    private static final int MAX_ENTRIES = 30000;
    public static final String ERROR_HEADER = "Cannot generate dependency accessors";
    private final DefaultVersionCatalog config;

    public LibrariesSourceGenerator(Writer writer, DefaultVersionCatalog config) {
        super(writer);
        this.config = config;
    }

    public static void generateSource(Writer writer, DefaultVersionCatalog config, String packageName, String className) {
        LibrariesSourceGenerator generator = new LibrariesSourceGenerator(writer, config);
        try {
            generator.generate(packageName, className);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void generate(String packageName, String className) throws IOException {
        this.writeLn("package " + packageName + ";");
        this.writeLn();
        this.addImports();
        this.writeLn();
        String description = TextUtil.normaliseLineSeparators((String)this.config.getDescription());
        this.writeLn("/**");
        for (String descLine : Splitter.on((char)'\n').split((CharSequence)description)) {
            this.writeLn(" * " + descLine);
        }
        List<String> libraries = this.config.getDependencyAliases();
        List<String> bundles = this.config.getBundleAliases();
        List<String> versions = this.config.getVersionAliases();
        this.performValidation(libraries, bundles, versions);
        ClassNode librariesEntryPoint = LibrariesSourceGenerator.toClassNode(libraries, LibrariesSourceGenerator.rootNode(AccessorKind.library));
        ClassNode versionsEntryPoint = LibrariesSourceGenerator.toClassNode(versions, LibrariesSourceGenerator.rootNode(AccessorKind.version, "versions")).parent;
        ClassNode bundlesEntryPoint = LibrariesSourceGenerator.toClassNode(bundles, LibrariesSourceGenerator.rootNode(AccessorKind.bundle, "bundles")).parent;
        this.writeLibraryEntryPoint(className, librariesEntryPoint, versionsEntryPoint, bundlesEntryPoint);
    }

    private void writeLibraryEntryPoint(String className, ClassNode librariesEntryPoint, ClassNode versionsEntryPoint, ClassNode bundlesEntryPoint) throws IOException {
        this.writeLn("*/");
        this.writeLn("@NonNullApi");
        this.writeLn("public class " + className + " extends AbstractExternalDependencyFactory {");
        this.writeLn();
        this.indent(() -> {
            this.writeLn("private final AbstractExternalDependencyFactory owner = this;");
            this.writeSubAccessorFieldsOf(librariesEntryPoint, AccessorKind.library);
            this.writeSubAccessorFieldsOf(versionsEntryPoint, AccessorKind.version);
            this.writeSubAccessorFieldsOf(bundlesEntryPoint, AccessorKind.bundle);
            this.writeLn();
            this.writeLn("@Inject");
            this.writeLn("public " + className + "(DefaultVersionCatalog config, ProviderFactory providers) {");
            this.writeLn("    super(config, providers);");
            this.writeLn("}");
            this.writeLn();
            this.writeLibraryAccessors(librariesEntryPoint);
            this.writeVersionAccessors(versionsEntryPoint);
            this.writeBundleAccessors(bundlesEntryPoint);
            this.writeLibrarySubClasses(librariesEntryPoint);
            this.writeVersionSubClasses(versionsEntryPoint);
            this.writeBundleSubClasses(bundlesEntryPoint);
        });
        this.writeLn("}");
    }

    private void addImports() throws IOException {
        this.addImport(NonNullApi.class);
        this.addImport(MinimalExternalModuleDependency.class);
        this.addImport(ExternalModuleDependencyBundle.class);
        this.addImport(MutableVersionConstraint.class);
        this.addImport(Provider.class);
        this.addImport(ProviderFactory.class);
        this.addImport(AbstractExternalDependencyFactory.class);
        this.addImport(DefaultVersionCatalog.class);
        this.addImport(Map.class);
        this.addImport(Inject.class);
    }

    private void writeLibrarySubClasses(ClassNode classNode) throws IOException {
        for (ClassNode child : classNode.getChildren()) {
            this.writeLibraryAccessorClass(child);
            this.writeLibrarySubClasses(child);
        }
    }

    private void writeVersionSubClasses(ClassNode classNode) throws IOException {
        for (ClassNode child : classNode.getChildren()) {
            this.writeVersionAccessorClass(child);
            this.writeVersionSubClasses(child);
        }
    }

    private void writeBundleSubClasses(ClassNode classNode) throws IOException {
        for (ClassNode child : classNode.getChildren()) {
            this.writeBundleAccessorClass(child);
            this.writeBundleSubClasses(child);
        }
    }

    private void writeBundleAccessorClass(ClassNode classNode) throws IOException {
        classNode.validate();
        String bundleClassName = classNode.getClassName();
        List aliases = classNode.aliases.stream().sorted().collect(Collectors.toList());
        this.writeLn("public static class " + bundleClassName + " extends BundleFactory {");
        this.indent(() -> {
            this.writeSubAccessorFieldsOf(classNode, AccessorKind.bundle);
            this.writeLn();
            this.writeLn("public " + bundleClassName + "(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }");
            this.writeLn();
            for (String alias : aliases) {
                BundleModel bundle = this.config.getBundle(alias);
                List<String> coordinates = bundle.getComponents().stream().map(this.config::getDependencyData).map(this::coordinatesDescriptorFor).collect(Collectors.toList());
                this.writeBundle(alias, coordinates, bundle.getContext());
            }
            for (ClassNode child : classNode.getChildren()) {
                this.writeSubAccessor(child, AccessorKind.bundle);
            }
        });
        this.writeLn("}");
        this.writeLn();
    }

    private void writeLibraryAccessors(ClassNode classNode) throws IOException {
        classNode.validate();
        Set dependencies = classNode.aliases;
        for (String alias : dependencies) {
            DependencyModel model = this.config.getDependencyData(alias);
            String coordinates = this.coordinatesDescriptorFor(model);
            this.writeDependencyAccessor(alias, coordinates, model.getContext());
        }
        for (ClassNode child : classNode.getChildren()) {
            this.writeSubAccessor(child, AccessorKind.library);
        }
    }

    private void writeVersionAccessors(ClassNode classNode) throws IOException {
        classNode.validate();
        Set versionsAliases = classNode.aliases;
        for (String alias : versionsAliases) {
            VersionModel model = this.config.getVersion(alias);
            this.writeSingleVersionAccessor(alias, model.getContext(), model.getVersion().getDisplayName());
        }
        for (ClassNode child : classNode.getChildren()) {
            this.writeSubAccessor(child, AccessorKind.version);
        }
    }

    private void writeBundleAccessors(ClassNode classNode) throws IOException {
        classNode.validate();
        Set versionsAliases = classNode.aliases;
        for (String alias : versionsAliases) {
            BundleModel model = this.config.getBundle(alias);
            List<String> coordinates = model.getComponents().stream().map(this.config::getDependencyData).map(this::coordinatesDescriptorFor).collect(Collectors.toList());
            this.writeBundle(alias, coordinates, model.getContext());
        }
        for (ClassNode child : classNode.getChildren()) {
            this.writeSubAccessor(child, AccessorKind.bundle);
        }
    }

    private void writeSubAccessorFieldFor(ClassNode classNode, AccessorKind kind) throws IOException {
        String className = classNode.getClassName();
        this.writeLn("private final " + className + " " + kind.accessorVariableNameFor(className) + " = new " + className + "(" + kind.getConstructorParams() + ");");
    }

    private void writeSubAccessorFieldsOf(ClassNode classNode, AccessorKind kind) throws IOException {
        for (ClassNode child : classNode.getChildren()) {
            this.writeSubAccessorFieldFor(child, kind);
        }
    }

    private void writeLibraryAccessorClass(ClassNode classNode) throws IOException {
        classNode.validate();
        this.writeLn("public static class " + classNode.getClassName() + " extends SubDependencyFactory {");
        this.indent(() -> {
            this.writeSubAccessorFieldsOf(classNode, AccessorKind.library);
            this.writeLn();
            this.writeLn("public " + classNode.getClassName() + "(AbstractExternalDependencyFactory owner) { super(owner); }");
            this.writeLn();
            for (String alias : classNode.aliases) {
                DependencyModel model = this.config.getDependencyData(alias);
                String coordinates = this.coordinatesDescriptorFor(model);
                this.writeDependencyAccessor(alias, coordinates, model.getContext());
            }
            for (ClassNode child : classNode.getChildren()) {
                this.writeSubAccessor(child, AccessorKind.library);
            }
        });
        this.writeLn("}");
        this.writeLn();
    }

    private void writeVersionAccessorClass(ClassNode classNode) throws IOException {
        classNode.validate();
        String versionsClassName = classNode.getClassName();
        Set<String> versionAliases = classNode.getAliases();
        this.writeLn("public static class " + versionsClassName + " extends VersionFactory {");
        this.writeLn();
        this.indent(() -> {
            this.writeSubAccessorFieldsOf(classNode, AccessorKind.version);
            this.writeLn("public " + versionsClassName + "(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }");
            this.writeLn();
            for (String alias : versionAliases) {
                VersionModel vm = this.config.getVersion(alias);
                String context = vm.getContext();
                this.indent(() -> this.writeSingleVersionAccessor(alias, context, vm.getVersion().getDisplayName()));
            }
            for (ClassNode child : classNode.getChildren()) {
                this.writeSubAccessor(child, AccessorKind.version);
            }
        });
        this.writeLn("}");
        this.writeLn();
    }

    private void writeSingleVersionAccessor(String versionAlias, @Nullable String context, String version) throws IOException {
        this.writeLn("/**");
        this.writeLn(" * Returns the version associated to this alias: " + versionAlias + " (" + version + ")");
        this.writeLn(" * If the version is a rich version and that its not expressible as a");
        this.writeLn(" * single version string, then an empty string is returned.");
        if (context != null) {
            this.writeLn(" * This version was declared in " + context);
        }
        this.writeLn(" */");
        this.writeLn("public Provider<String> get" + LibrariesSourceGenerator.toJavaName(this.leafNodeForAlias(versionAlias)) + "() { return getVersion(\"" + versionAlias + "\"); }");
        this.writeLn();
    }

    private String standardErrorLocation() {
        return "Version catalog " + this.config.getName();
    }

    private void performValidation(List<String> dependencies, List<String> bundles, List<String> versions) {
        this.assertUnique(dependencies, "dependency aliases", "");
        this.assertUnique(bundles, "dependency bundles", "Bundle");
        this.assertUnique(versions, "dependency versions", "Version");
        int size = dependencies.size() + bundles.size() + versions.size();
        if (size > 30000) {
            DefaultCatalogProblemBuilder.maybeThrowError((String)ERROR_HEADER, (List)ImmutableList.of((Object)DefaultCatalogProblemBuilder.buildProblem((VersionCatalogProblemId)VersionCatalogProblemId.TOO_MANY_ENTRIES, spec -> spec.inContext(this::standardErrorLocation).withShortDescription(() -> "Version catalog model contains too many entries (" + size + ")").happensBecause(() -> "The maximum number of aliases in a catalog is 30000").addSolution(() -> "Reduce the number of aliases defined in this catalog").addSolution(() -> "Split the catalog into multiple catalogs").documented())));
        }
    }

    private void assertUnique(List<String> names, String prefix, String suffix) {
        List errors = names.stream().collect(Collectors.groupingBy(AbstractSourceGenerator::toJavaName)).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(e -> DefaultCatalogProblemBuilder.buildProblem((VersionCatalogProblemId)VersionCatalogProblemId.ACCESSOR_NAME_CLASH, spec -> spec.inContext(this::standardErrorLocation).withShortDescription(() -> prefix + " " + ((List)e.getValue()).stream().sorted().collect(Collectors.joining(" and ")) + " are mapped to the same accessor name get" + (String)e.getKey() + suffix + "()").happensBecause("A name clash was detected").addSolution(() -> "Use a different alias for " + ((List)e.getValue()).stream().sorted().collect(Collectors.joining(" and "))).documented())).collect(Collectors.toList());
        DefaultCatalogProblemBuilder.maybeThrowError((String)ERROR_HEADER, errors);
    }

    private String coordinatesDescriptorFor(DependencyModel dependencyData) {
        return dependencyData.getGroup() + ":" + dependencyData.getName();
    }

    private void writeDependencyAccessor(String alias, String coordinates, @Nullable String context) throws IOException {
        String name = this.leafNodeForAlias(alias);
        this.writeLn("    /**");
        this.writeLn("     * Creates a dependency provider for " + name + " (" + coordinates + ")");
        if (context != null) {
            this.writeLn("     * This dependency was declared in " + context);
        }
        this.writeLn("     */");
        this.writeLn("    public Provider<MinimalExternalModuleDependency> get" + LibrariesSourceGenerator.toJavaName(name) + "() { return create(\"" + alias + "\"); }");
        this.writeLn();
    }

    private String leafNodeForAlias(String alias) {
        List splitted = LibrariesSourceGenerator.nameSplitter().splitToList((CharSequence)alias);
        return (String)splitted.get(splitted.size() - 1);
    }

    private void writeSubAccessor(ClassNode classNode, AccessorKind kind) throws IOException {
        String className = classNode.getClassName();
        String getter = classNode.name;
        this.writeLn("/**");
        this.writeLn(" * Returns the group of " + kind.getDescription() + " at " + classNode.getPath());
        this.writeLn(" */");
        this.writeLn("public " + className + " get" + LibrariesSourceGenerator.toJavaName(getter) + "() { return " + kind.accessorVariableNameFor(className) + "; }");
        this.writeLn();
    }

    private void writeBundle(String alias, List<String> coordinates, @Nullable String context) throws IOException {
        this.indent(() -> {
            this.writeLn("/**");
            this.writeLn(" * Creates a dependency bundle provider for " + alias + " which is an aggregate for the following dependencies:");
            this.writeLn(" * <ul>");
            for (String coordinate : coordinates) {
                this.writeLn(" *    <li>" + coordinate + "</li>");
            }
            this.writeLn(" * </ul>");
            if (context != null) {
                this.writeLn(" * This bundle was declared in " + context);
            }
            this.writeLn(" */");
            this.writeLn("public Provider<ExternalModuleDependencyBundle> get" + LibrariesSourceGenerator.toJavaName(this.leafNodeForAlias(alias)) + "() { return createBundle(\"" + alias + "\"); }");
        });
        this.writeLn();
    }

    private static ClassNode rootNode(AccessorKind kind) {
        return new ClassNode(kind, null, null);
    }

    private static ClassNode rootNode(AccessorKind kind, String nest) {
        ClassNode root = LibrariesSourceGenerator.rootNode(kind);
        ClassNode wrappingNode = root.child(nest);
        wrappingNode.wrapping = true;
        return wrappingNode;
    }

    private static ClassNode toClassNode(List<String> aliases, ClassNode root) {
        for (String alias : aliases) {
            ClassNode current = root;
            List dotted = LibrariesSourceGenerator.nameSplitter().splitToList((CharSequence)alias);
            int last = dotted.size() - 1;
            for (int i = 0; i < last; ++i) {
                current = current.child((String)dotted.get(i));
            }
            current.addAlias(alias);
        }
        return root;
    }

    private static enum AccessorKind {
        library("libraries", "owner"),
        version("versions", "providers, config"),
        bundle("bundles", "providers, config");

        private final String description;
        private final String constructorParams;
        private final String variablePrefix;

        private AccessorKind(String description, String constructorParams) {
            this.description = description;
            this.constructorParams = constructorParams;
            this.variablePrefix = this.name().charAt(0) + "acc";
        }

        public String getDescription() {
            return this.description;
        }

        public String getClassNameSuffix() {
            return StringUtils.capitalize((String)this.name()) + "Accessors";
        }

        public String getConstructorParams() {
            return this.constructorParams;
        }

        public String accessorVariableNameFor(String className) {
            return this.variablePrefix + "For" + className;
        }
    }

    private static class ClassNode {
        private final ClassNode parent;
        private final AccessorKind kind;
        private final String name;
        private final Map<String, ClassNode> children = Maps.newLinkedHashMap();
        private final Set<String> aliases = Sets.newLinkedHashSet();
        public boolean wrapping;

        private ClassNode(AccessorKind kind, @Nullable ClassNode parent, @Nullable String name) {
            this.kind = kind;
            this.parent = parent;
            this.name = name;
        }

        private String getSimpleName() {
            if (this.parent == null || this.wrapping) {
                return "";
            }
            return this.parent.getSimpleName() + StringUtils.capitalize((String)this.name);
        }

        private String getClassName() {
            return this.getSimpleName() + this.kind.getClassNameSuffix();
        }

        ClassNode child(String name) {
            return this.children.computeIfAbsent(name, n -> new ClassNode(this.kind, this, (String)n));
        }

        void addAlias(String alias) {
            this.aliases.add(alias);
        }

        public Collection<ClassNode> getChildren() {
            return this.children.values();
        }

        public Set<String> getAliases() {
            return this.aliases;
        }

        String getPath() {
            if (this.parent == null) {
                return "";
            }
            String parentPath = this.parent.getPath();
            return parentPath.isEmpty() ? this.name : parentPath + "." + this.name;
        }

        private static String shortAlias(String fullAlias) {
            List dotted = AbstractSourceGenerator.nameSplitter().splitToList((CharSequence)fullAlias);
            return (String)dotted.get(dotted.size() - 1);
        }

        void validate() {
            Sets.SetView intersection = Sets.intersection(this.aliases.stream().map(ClassNode::shortAlias).collect(Collectors.toSet()), this.children.keySet());
            if (!intersection.isEmpty()) {
                String path = this.getPath();
                path = path.isEmpty() ? "top level accessors" : "accessors for " + path;
                throw new InvalidUserDataException("Cannot generate " + path + " because it contains both aliases and groups of the same name: " + intersection);
            }
        }

        public String toString() {
            return "ClassNode{name='" + this.name + '\'' + ", aliases=" + this.aliases + '}';
        }
    }
}

