/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.definitions;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.api.SourceCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.scripting.resolve.ScriptReportSink;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/definitions/CliScriptReportSink;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptReportSink;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "attachReports", "", "scriptFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "reports", "", "Lkotlin/script/experimental/api/ScriptDiagnostic;", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "Lkotlin/script/experimental/api/SourceCode$Location;", "convertSeverity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "Lkotlin/script/experimental/api/ScriptDiagnostic$Severity;", "kotlin-scripting-compiler"})
public final class CliScriptReportSink
implements ScriptReportSink {
    @NotNull
    private final MessageCollector messageCollector;

    public CliScriptReportSink(@NotNull MessageCollector messageCollector2) {
        Intrinsics.checkParameterIsNotNull((Object)messageCollector2, (String)"messageCollector");
        this.messageCollector = messageCollector2;
    }

    public void attachReports(@NotNull VirtualFile scriptFile, @NotNull List<ScriptDiagnostic> reports) {
        Intrinsics.checkParameterIsNotNull((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkParameterIsNotNull(reports, (String)"reports");
        Iterable $this$forEach$iv = reports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScriptDiagnostic it = (ScriptDiagnostic)element$iv;
            boolean bl = false;
            this.messageCollector.report(this.convertSeverity(it.getSeverity()), it.getMessage(), (CompilerMessageSourceLocation)this.location(scriptFile, it.getLocation()));
        }
    }

    private final CompilerMessageLocation location(VirtualFile scriptFile, SourceCode.Location location) {
        if (location == null) {
            return CompilerMessageLocation.Companion.create(scriptFile.getPath());
        }
        return CompilerMessageLocation.Companion.create(scriptFile.getPath(), location.getStart().getLine(), location.getStart().getCol(), null);
    }

    private final CompilerMessageSeverity convertSeverity(ScriptDiagnostic.Severity $this$convertSeverity) {
        CompilerMessageSeverity compilerMessageSeverity;
        ScriptDiagnostic.Severity severity = $this$convertSeverity;
        int n = WhenMappings.$EnumSwitchMapping$0[severity.ordinal()];
        switch (n) {
            case 1: {
                compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                break;
            }
            case 2: {
                compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                break;
            }
            case 3: {
                compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                break;
            }
            case 4: {
                compilerMessageSeverity = CompilerMessageSeverity.INFO;
                break;
            }
            case 5: {
                compilerMessageSeverity = CompilerMessageSeverity.LOGGING;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return compilerMessageSeverity;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScriptDiagnostic.Severity.values().length];
            nArray[ScriptDiagnostic.Severity.FATAL.ordinal()] = 1;
            nArray[ScriptDiagnostic.Severity.ERROR.ordinal()] = 2;
            nArray[ScriptDiagnostic.Severity.WARNING.ordinal()] = 3;
            nArray[ScriptDiagnostic.Severity.INFO.ordinal()] = 4;
            nArray[ScriptDiagnostic.Severity.DEBUG.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

