/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.lower.DefaultArgumentStubGenerator;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmDefaultArgumentStubGenerator;", "Lorg/jetbrains/kotlin/backend/common/lower/DefaultArgumentStubGenerator;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "defaultArgumentStubVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getOriginForCallToImplementation", "Lorg/jetbrains/kotlin/backend/jvm/JvmLoweredStatementOrigin$DEFAULT_STUB_CALL_TO_IMPLEMENTATION;", "useConstructorMarker", "", "generateSuperCallHandlerCheckIfNeeded", "", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "irFunction", "newIrFunction", "backend.jvm"})
public final class JvmDefaultArgumentStubGenerator
extends DefaultArgumentStubGenerator {
    @NotNull
    private final JvmBackendContext context;

    public JvmDefaultArgumentStubGenerator(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, false, false, false, 8, null);
        this.context = context2;
    }

    @Override
    @NotNull
    public JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    protected DescriptorVisibility defaultArgumentStubVisibility(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return IrUtilsKt.getJvmVisibilityOfDefaultArgumentStub(function2);
    }

    @Override
    protected boolean useConstructorMarker(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return function2 instanceof IrConstructor || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.STATIC_INLINE_CLASS_CONSTRUCTOR.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void generateSuperCallHandlerCheckIfNeeded(@NotNull IrBlockBodyBuilder $this$generateSuperCallHandlerCheckIfNeeded, @NotNull IrFunction irFunction2, @NotNull IrFunction newIrFunction) {
        void $this$generateSuperCallHandlerCheckIfNeeded_u24lambda_u2d0;
        IrElement irElement;
        IrClass irClass2;
        Intrinsics.checkNotNullParameter((Object)$this$generateSuperCallHandlerCheckIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)newIrFunction, (String)"newIrFunction");
        if (!(irFunction2 instanceof IrSimpleFunction) || !this.getContext().getIr().shouldGenerateHandlerParameterForDefaultBodyFun() || AdditionalIrUtilsKt.isTopLevelDeclaration(irFunction2) || Intrinsics.areEqual((Object)((irClass2 = (irElement = irFunction2.getParent()) instanceof IrClass ? (IrClass)irElement : null) == null ? null : Boolean.valueOf(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isFinalClass(irClass2))), (Object)true)) {
            return;
        }
        IrValueParameter handlerDeclaration = (IrValueParameter)CollectionsKt.last(newIrFunction.getValueParameters());
        irElement = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateSuperCallHandlerCheckIfNeeded, this.getContext().getIr().getSymbols().getThrowUnsupportedOperationException());
        boolean bl = false;
        boolean bl2 = false;
        IrElement irElement2 = irElement;
        IrExpression irExpression = LowerUtilsKt.irNot($this$generateSuperCallHandlerCheckIfNeeded, ExpressionHelpersKt.irEqualsNull($this$generateSuperCallHandlerCheckIfNeeded, ExpressionHelpersKt.irGet($this$generateSuperCallHandlerCheckIfNeeded, handlerDeclaration)));
        IrType irType = $this$generateSuperCallHandlerCheckIfNeeded.getContext().getIrBuiltIns().getUnitType();
        IrBuilderWithScope irBuilderWithScope = $this$generateSuperCallHandlerCheckIfNeeded;
        IrBlockBodyBuilder irBlockBodyBuilder = $this$generateSuperCallHandlerCheckIfNeeded;
        boolean bl3 = false;
        $this$generateSuperCallHandlerCheckIfNeeded_u24lambda_u2d0.putValueArgument(0, ExpressionHelpersKt.irString($this$generateSuperCallHandlerCheckIfNeeded, Intrinsics.stringPlus((String)"Super calls with default arguments not supported in this target, function: ", (Object)irFunction2.getName().asString())));
        Unit unit = Unit.INSTANCE;
        irBlockBodyBuilder.unaryPlus(ExpressionHelpersKt.irIfThen$default(irBuilderWithScope, irType, irExpression, (IrExpression)irElement, null, 8, null));
    }

    @Override
    @NotNull
    protected JvmLoweredStatementOrigin.DEFAULT_STUB_CALL_TO_IMPLEMENTATION getOriginForCallToImplementation() {
        return JvmLoweredStatementOrigin.DEFAULT_STUB_CALL_TO_IMPLEMENTATION.INSTANCE;
    }
}

