/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaClassOnCompanionChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
public final class JavaClassOnCompanionChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        ClassDescriptor classDescriptor2;
        Annotated annotated;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (!(descriptor2 instanceof PropertyDescriptor) || !Intrinsics.areEqual((Object)((PropertyDescriptor)descriptor2).getName().asString(), (Object)"javaClass")) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
        DeclarationDescriptor container2 = declarationDescriptor;
        if (!(container2 instanceof PackageFragmentDescriptor) || !Intrinsics.areEqual((Object)((PackageFragmentDescriptor)container2).getFqName().asString(), (Object)"kotlin.jvm")) {
            return;
        }
        KotlinType kotlinType = ((PropertyDescriptor)descriptor2).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
        KotlinType actualType = kotlinType;
        Object object = (TypeProjection)CollectionsKt.singleOrNull(actualType.getArguments());
        Annotated annotated2 = annotated = object == null ? null : object.getType();
        ClassifierDescriptor classifierDescriptor = annotated == null ? null : ((object = ((KotlinType)annotated).getConstructor()) == null ? null : object.getDeclarationDescriptor());
        ClassDescriptor classDescriptor3 = classDescriptor2 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor2 == null) {
            return;
        }
        ClassDescriptor companionObject = classDescriptor2;
        if (companionObject.isCompanionObject()) {
            ClassDescriptor containingClass = (ClassDescriptor)companionObject.getContainingDeclaration();
            object = actualType.getConstructor().getDeclarationDescriptor();
            Annotated annotated3 = annotated = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
            if (annotated == null) {
                return;
            }
            Annotated javaLangClass2 = annotated;
            List arguments2 = CollectionsKt.listOf((Object)new TypeProjectionImpl(containingClass.getDefaultType()));
            Annotations annotations2 = Annotations.Companion.getEMPTY();
            TypeConstructor typeConstructor2 = javaLangClass2.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"javaLangClass.typeConstructor");
            SimpleType expectedType2 = KotlinTypeFactory.simpleType$default(annotations2, typeConstructor2, arguments2, actualType.isMarkedNullable(), null, 16, null);
            context2.getTrace().report(ErrorsJvm.JAVA_CLASS_ON_COMPANION.on(reportOn, actualType, expectedType2));
        }
    }
}

