/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.services;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.mvnsettings.MavenSettingsProvider;
import org.gradle.buildinit.plugins.internal.BasicProjectGenerator;
import org.gradle.buildinit.plugins.internal.BuildContentGenerator;
import org.gradle.buildinit.plugins.internal.BuildInitializer;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.CompositeProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.CppApplicationProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.CppLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.DefaultTemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.GitAttributesGenerator;
import org.gradle.buildinit.plugins.internal.GitIgnoreGenerator;
import org.gradle.buildinit.plugins.internal.GroovyGradlePluginProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.JavaGradlePluginProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.JvmApplicationProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.JvmLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.KotlinGradlePluginProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.LanguageSpecificAdaptor;
import org.gradle.buildinit.plugins.internal.LanguageSpecificProjectGenerator;
import org.gradle.buildinit.plugins.internal.ProjectGenerator;
import org.gradle.buildinit.plugins.internal.ProjectLayoutSetupRegistry;
import org.gradle.buildinit.plugins.internal.ResourceDirsGenerator;
import org.gradle.buildinit.plugins.internal.SimpleGlobalFilesBuildSettingsDescriptor;
import org.gradle.buildinit.plugins.internal.SwiftApplicationProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.SwiftLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.maven.PomProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.model.Description;
import org.gradle.workers.WorkerExecutor;

public class ProjectLayoutSetupRegistryFactory {
    private final DocumentationRegistry documentationRegistry;
    private final MavenSettingsProvider mavenSettingsProvider;
    private final BuildScriptBuilderFactory scriptBuilderFactory;
    private final TemplateOperationFactory templateOperationBuilder;
    private final WorkerExecutor workerExecutor;

    public ProjectLayoutSetupRegistryFactory(MavenSettingsProvider mavenSettingsProvider, DocumentationRegistry documentationRegistry, WorkerExecutor workerExecutor) {
        this.mavenSettingsProvider = mavenSettingsProvider;
        this.documentationRegistry = documentationRegistry;
        this.workerExecutor = workerExecutor;
        this.scriptBuilderFactory = new BuildScriptBuilderFactory();
        this.templateOperationBuilder = new TemplateOperationFactory("/org/gradle/buildinit/tasks/templates", documentationRegistry);
    }

    public ProjectLayoutSetupRegistry createProjectLayoutSetupRegistry() {
        DefaultTemplateLibraryVersionProvider libraryVersionProvider = new DefaultTemplateLibraryVersionProvider();
        TemplateOperationFactory templateOperationBuilder = this.templateOperationBuilder;
        SimpleGlobalFilesBuildSettingsDescriptor settingsDescriptor = new SimpleGlobalFilesBuildSettingsDescriptor(this.scriptBuilderFactory, this.documentationRegistry);
        ResourceDirsGenerator resourcesGenerator = new ResourceDirsGenerator();
        GitIgnoreGenerator gitIgnoreGenerator = new GitIgnoreGenerator();
        GitAttributesGenerator gitAttributesGenerator = new GitAttributesGenerator();
        ImmutableList jvmProjectGenerators = ImmutableList.of((Object)settingsDescriptor, (Object)gitIgnoreGenerator, (Object)gitAttributesGenerator, (Object)resourcesGenerator);
        ImmutableList commonGenerators = ImmutableList.of((Object)settingsDescriptor, (Object)gitIgnoreGenerator, (Object)gitAttributesGenerator);
        BuildInitializer basicType = this.of(new BasicProjectGenerator(this.scriptBuilderFactory, this.documentationRegistry), (List<BuildContentGenerator>)commonGenerators);
        PomProjectInitDescriptor mavenBuildConverter = new PomProjectInitDescriptor(this.mavenSettingsProvider, this.documentationRegistry, this.workerExecutor);
        ProjectLayoutSetupRegistry registry = new ProjectLayoutSetupRegistry(basicType, mavenBuildConverter, templateOperationBuilder);
        registry.add(this.of(new JvmApplicationProjectInitDescriptor(Description.JAVA, libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators, libraryVersionProvider));
        registry.add(this.of(new JvmLibraryProjectInitDescriptor(Description.JAVA, libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators, libraryVersionProvider));
        registry.add(this.of(new JvmApplicationProjectInitDescriptor(Description.GROOVY, libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators, libraryVersionProvider));
        registry.add(this.of(new JvmLibraryProjectInitDescriptor(Description.GROOVY, libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators, libraryVersionProvider));
        registry.add(this.of(new JvmApplicationProjectInitDescriptor(Description.SCALA, libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators, libraryVersionProvider));
        registry.add(this.of(new JvmLibraryProjectInitDescriptor(Description.SCALA, libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators, libraryVersionProvider));
        registry.add(this.of(new JvmApplicationProjectInitDescriptor(Description.KOTLIN, libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators, libraryVersionProvider));
        registry.add(this.of(new JvmLibraryProjectInitDescriptor(Description.KOTLIN, libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators, libraryVersionProvider));
        registry.add(this.of(new CppApplicationProjectInitDescriptor(templateOperationBuilder, this.documentationRegistry), (List<BuildContentGenerator>)commonGenerators, libraryVersionProvider));
        registry.add(this.of(new CppLibraryProjectInitDescriptor(templateOperationBuilder, this.documentationRegistry), (List<BuildContentGenerator>)commonGenerators, libraryVersionProvider));
        registry.add(this.of(new JavaGradlePluginProjectInitDescriptor(libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators, libraryVersionProvider));
        registry.add(this.of(new GroovyGradlePluginProjectInitDescriptor(libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators, libraryVersionProvider));
        registry.add(this.of(new KotlinGradlePluginProjectInitDescriptor(libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators, libraryVersionProvider));
        registry.add(this.of(new SwiftApplicationProjectInitDescriptor(templateOperationBuilder, this.documentationRegistry), (List<BuildContentGenerator>)commonGenerators, libraryVersionProvider));
        registry.add(this.of(new SwiftLibraryProjectInitDescriptor(templateOperationBuilder, this.documentationRegistry), (List<BuildContentGenerator>)commonGenerators, libraryVersionProvider));
        return registry;
    }

    private BuildInitializer of(ProjectGenerator projectGenerator, List<BuildContentGenerator> generators) {
        return new CompositeProjectInitDescriptor(projectGenerator, generators);
    }

    private BuildInitializer of(LanguageSpecificProjectGenerator projectGenerator, List<BuildContentGenerator> generators, TemplateLibraryVersionProvider libraryVersionProvider) {
        return this.of(new LanguageSpecificAdaptor(projectGenerator, this.scriptBuilderFactory, this.templateOperationBuilder, libraryVersionProvider), generators);
    }
}

