/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AbstractAnalyzerWithCompilerReport;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.wasm.CompilerKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmCompilerResult;
import org.jetbrains.kotlin.backend.wasm.WasmLoweringPhasesKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.JsHelpersKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleFragmentGenerator;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.backend.js.IrModuleInfo;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrLinker;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.resolver.KotlinLibraryResolveResult;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi2ir.generators.DeclarationStubGeneratorImplKt;
import org.jetbrains.kotlin.wasm.ir.WasmModule;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToBinary;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToText;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\\\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0018\u00a8\u0006\u0019"}, d2={"compileWasm", "Lorg/jetbrains/kotlin/backend/wasm/WasmCompilerResult;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "mainModule", "Lorg/jetbrains/kotlin/ir/backend/js/MainModule;", "analyzer", "Lorg/jetbrains/kotlin/analyzer/AbstractAnalyzerWithCompilerReport;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "allDependencies", "Lorg/jetbrains/kotlin/library/resolver/KotlinLibraryResolveResult;", "friendDependencies", "", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/name/FqName;", "generateJs", "", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;", "backend.wasm"})
public final class CompilerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final WasmCompilerResult compileWasm(@NotNull Project project, @NotNull MainModule mainModule, @NotNull AbstractAnalyzerWithCompilerReport analyzer2, @NotNull CompilerConfiguration configuration, @NotNull PhaseConfig phaseConfig, @NotNull IrFactory irFactory, @NotNull KotlinLibraryResolveResult allDependencies, @NotNull List<? extends KotlinLibrary> friendDependencies, @NotNull Set<FqName> exportedDeclarations) {
        void $this$flatMapTo$iv$iv2;
        Object element$iv2;
        List list2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
        Intrinsics.checkNotNullParameter((Object)analyzer2, (String)"analyzer");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        Intrinsics.checkNotNullParameter((Object)allDependencies, (String)"allDependencies");
        Intrinsics.checkNotNullParameter(friendDependencies, (String)"friendDependencies");
        Intrinsics.checkNotNullParameter(exportedDeclarations, (String)"exportedDeclarations");
        IrModuleInfo irModuleInfo = KlibKt.loadIr(project, mainModule, analyzer2, configuration, allDependencies, friendDependencies, irFactory);
        IrModuleFragment moduleFragment = irModuleInfo.component1();
        List dependencyModules = irModuleInfo.component2();
        IrBuiltIns irBuiltIns = irModuleInfo.component3();
        SymbolTable symbolTable = irModuleInfo.component4();
        JsIrLinker deserializer = irModuleInfo.component5();
        MainModule mainModule2 = mainModule;
        if (mainModule2 instanceof MainModule.SourceFiles) {
            list2 = CollectionsKt.plus((Collection)dependencyModules, (Iterable)CollectionsKt.listOf((Object)moduleFragment));
        } else if (mainModule2 instanceof MainModule.Klib) {
            list2 = dependencyModules;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List allModules2 = list2;
        ModuleDescriptor moduleDescriptor = moduleFragment.getDescriptor();
        WasmBackendContext context2 = new WasmBackendContext(moduleDescriptor, irBuiltIns, symbolTable, moduleFragment, exportedDeclarations, configuration);
        Iterable $this$forEach$iv = allModules2;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv2;
            boolean bl = false;
            List irProviders = DeclarationStubGeneratorImplKt.generateTypicalIrProviderList$default(it.getDescriptor(), irBuiltIns, symbolTable, deserializer, null, 16, null);
            new ExternalDependenciesGenerator(symbolTable, irProviders).generateUnboundSymbolsAsDependencies();
        }
        Object $this$flatMap$iv = allModules2;
        boolean $i$f$flatMap22 = false;
        element$iv2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            IrModuleFragment it = (IrModuleFragment)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List irFiles2 = (List)destination$iv$iv;
        moduleFragment.getFiles().clear();
        $this$flatMap$iv = moduleFragment;
        Collection $i$f$flatMap22 = ((IrModuleFragment)$this$flatMap$iv).getFiles();
        boolean $this$flatMapTo$iv$iv2 = false;
        CollectionsKt.addAll((Collection)$i$f$flatMap22, (Iterable)irFiles2);
        List irProviders = DeclarationStubGeneratorImplKt.generateTypicalIrProviderList$default(moduleDescriptor, irBuiltIns, symbolTable, deserializer, null, 16, null);
        new ExternalDependenciesGenerator(symbolTable, irProviders).generateUnboundSymbolsAsDependencies();
        PatchDeclarationParentsKt.patchDeclarationParents$default(moduleFragment, null, 1, null);
        CompilerPhaseKt.invokeToplevel((CompilerPhase)WasmLoweringPhasesKt.getWasmPhases(), phaseConfig, (CommonBackendContext)context2, moduleFragment);
        WasmCompiledModuleFragment compiledWasmModule = new WasmCompiledModuleFragment();
        WasmModuleFragmentGenerator codeGenerator = new WasmModuleFragmentGenerator(context2, compiledWasmModule);
        codeGenerator.generateModule(moduleFragment);
        WasmModule linkedModule = compiledWasmModule.linkWasmCompiledFragments();
        WasmIrToText watGenerator = new WasmIrToText();
        watGenerator.appendWasmModule(linkedModule);
        String wat = watGenerator.toString();
        String js = CompilerKt.generateJs(compiledWasmModule);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        new WasmIrToBinary(os, linkedModule).appendWasmModule();
        byte[] byteArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byteArray, (String)"byteArray");
        return new WasmCompilerResult(wat, js, byteArray);
    }

    public static /* synthetic */ WasmCompilerResult compileWasm$default(Project project, MainModule mainModule, AbstractAnalyzerWithCompilerReport abstractAnalyzerWithCompilerReport, CompilerConfiguration compilerConfiguration, PhaseConfig phaseConfig, IrFactory irFactory, KotlinLibraryResolveResult kotlinLibraryResolveResult, List list2, Set set, int n, Object object) {
        if ((n & 0x100) != 0) {
            set = SetsKt.emptySet();
        }
        return CompilerKt.compileWasm(project, mainModule, abstractAnalyzerWithCompilerReport, compilerConfiguration, phaseConfig, irFactory, kotlinLibraryResolveResult, list2, set);
    }

    @NotNull
    public static final String generateJs(@NotNull WasmCompiledModuleFragment $this$generateJs) {
        Intrinsics.checkNotNullParameter((Object)$this$generateJs, (String)"<this>");
        String runtime = "const runtime = {\n    String_getChar(str, index) {\n        return str.charCodeAt(index);\n    },\n\n    String_compareTo(str1, str2) {\n        if (str1 > str2) return 1;\n        if (str1 < str2) return -1;\n        return 0;\n    },\n\n    String_equals(str, other) {\n        return str === other;\n    },\n\n    String_subsequence(str, startIndex, endIndex) {\n        return str.substring(startIndex, endIndex);\n    },\n\n    String_getLiteral(index) {\n        return runtime.stringLiterals[index];\n    },\n\n    coerceToString(value) {\n        return String(value);\n    },\n\n    Char_toString(char) {\n        return String.fromCharCode(char)\n    },\n\n    identity(x) {\n        return x;\n    },\n\n    println(value) {\n        console.log(\">>>  \" + value)\n    }\n};";
        String jsCode2 = "\nconst js_code = {" + CollectionsKt.joinToString$default((Iterable)$this$generateJs.getJsFuns(), (CharSequence)",\n", null, null, (int)0, null, (Function1)generateJs.jsCode.1.INSTANCE, (int)30, null) + "};";
        return runtime + JsHelpersKt.generateStringLiteralsSupport($this$generateJs.getStringLiterals()) + jsCode2;
    }
}

