/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JVMConstructorCallNormalizationMode;
import org.jetbrains.kotlin.config.JvmAbiStability;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmStringConcat;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\u0012\u0010\r\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0011\u001a\u00020\b*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0012\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001c\u0010\u0013\u001a\u00020\u0006*\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000f\u001a4\u0010\u0016\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0002\u001a\u0012\u0010\u001e\u001a\u00020\b*\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010 \u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006!"}, d2={"messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getMessageCollector", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "addModularRootIfNotNull", "", "isModularJava", "", "moduleName", "", "file", "Ljava/io/File;", "configureAdvancedJvmOptions", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "configureExplicitContentRoots", "configureJdkHome", "configureKlibPaths", "configureStandardLibs", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "handleClosureGenerationSchemeArgument", "flag", "value", "key", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "Lorg/jetbrains/kotlin/config/JvmClosureGenerationScheme;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "registerJavacIfNeeded", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "setupJvmSpecificArguments", "cli"})
public final class JvmArgumentsKt {
    public static final void setupJvmSpecificArguments(@NotNull CompilerConfiguration $this$setupJvmSpecificArguments, @NotNull K2JVMCompilerArguments arguments2) {
        String stringConcat;
        Object[] objectArray;
        Object jvmTarget;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$this$setupJvmSpecificArguments, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.INCLUDE_RUNTIME, arguments2.getIncludeRuntime());
        $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.NO_REFLECT, arguments2.getNoReflect());
        Object[] objectArray2 = arguments2.getFriendPaths();
        $this$setupJvmSpecificArguments.putIfNotNull(JVMConfigurationKeys.FRIEND_PATHS, objectArray2 == null ? null : ArraysKt.asList((Object[])objectArray2));
        if (arguments2.getJvmTarget() != null) {
            object = arguments2.getJvmTarget();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if ((jvmTarget = JvmTarget.Companion.fromString((String)object)) != null) {
                $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.JVM_TARGET, jvmTarget);
                if (jvmTarget == JvmTarget.JVM_1_6 && !arguments2.getSuppressDeprecatedJvmTargetWarning()) {
                    MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.STRONG_WARNING, "JVM target 1.6 is deprecated and will be removed in a future release. Please migrate to JVM target 1.8 or above", null, 4, null);
                }
            } else {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "Unknown JVM target version: " + arguments2.getJvmTarget() + "\nSupported versions: " + ArraysKt.joinToString$default((Object[])JvmTarget.values(), null, null, null, (int)0, null, (Function1)setupJvmSpecificArguments.1.INSTANCE, (int)31, null), null, 4, null);
            }
        }
        object = (objectArray = $this$setupJvmSpecificArguments.get(JVMConfigurationKeys.JVM_TARGET)) == null ? JvmTarget.DEFAULT : objectArray;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"get(JVMConfigurationKeys.JVM_TARGET) ?: JvmTarget.DEFAULT");
        jvmTarget = object;
        if (((JvmTarget)jvmTarget).getMajorVersion() < JvmTarget.JVM_1_8.getMajorVersion()) {
            JvmDefaultMode jvmDefaultMode = CommonConfigurationKeysKt.getLanguageVersionSettings($this$setupJvmSpecificArguments).getFlag(JvmAnalysisFlags.INSTANCE.getJvmDefaultMode());
            if (jvmDefaultMode.getForAllMethodsWithBody()) {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "'-Xjvm-default=" + jvmDefaultMode.getDescription() + "' is only supported since JVM target 1.8. Recompile with '-jvm-target 1.8'", null, 4, null);
            }
        }
        if ((stringConcat = arguments2.getStringConcat()) != null) {
            JvmStringConcat runtimeStringConcat = JvmStringConcat.Companion.fromString(stringConcat);
            if (runtimeStringConcat != null) {
                $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.STRING_CONCAT, runtimeStringConcat);
                if (((JvmTarget)jvmTarget).getMajorVersion() < JvmTarget.JVM_9.getMajorVersion() && runtimeStringConcat != JvmStringConcat.INLINE) {
                    MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.WARNING, "`-Xstring-concat=" + stringConcat + "` does nothing with JVM target `" + ((JvmTarget)jvmTarget).getDescription() + "`.", null, 4, null);
                }
            } else {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "Unknown `-Xstring-concat` mode: " + stringConcat + "\nSupported modes: " + ArraysKt.joinToString$default((Object[])JvmStringConcat.values(), null, null, null, (int)0, null, (Function1)setupJvmSpecificArguments.2.INSTANCE, (int)31, null), null, 4, null);
            }
        }
        String string2 = arguments2.getSamConversions();
        objectArray = JVMConfigurationKeys.SAM_CONVERSIONS;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"SAM_CONVERSIONS");
        JvmArgumentsKt.handleClosureGenerationSchemeArgument($this$setupJvmSpecificArguments, "-Xsam-conversions", string2, (CompilerConfigurationKey<JvmClosureGenerationScheme>)objectArray, (JvmTarget)jvmTarget);
        String string3 = arguments2.getLambdas();
        objectArray = JVMConfigurationKeys.LAMBDAS;
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"LAMBDAS");
        JvmArgumentsKt.handleClosureGenerationSchemeArgument($this$setupJvmSpecificArguments, "-Xlambdas", string3, objectArray, (JvmTarget)jvmTarget);
        objectArray = arguments2.getAdditionalJavaModules();
        $this$setupJvmSpecificArguments.addAll(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, objectArray == null ? null : ArraysKt.asList((Object[])objectArray));
    }

    private static final void handleClosureGenerationSchemeArgument(CompilerConfiguration $this$handleClosureGenerationSchemeArgument, String flag, String value2, CompilerConfigurationKey<JvmClosureGenerationScheme> key, JvmTarget jvmTarget) {
        if (value2 != null) {
            JvmClosureGenerationScheme parsedValue = JvmClosureGenerationScheme.Companion.fromString(value2);
            if (parsedValue != null) {
                $this$handleClosureGenerationSchemeArgument.put(key, parsedValue);
                if (jvmTarget.compareTo((Enum)parsedValue.getMinJvmTarget()) < 0) {
                    MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$handleClosureGenerationSchemeArgument), CompilerMessageSeverity.WARNING, '`' + flag + '=' + value2 + "` requires JVM target at least " + parsedValue.getMinJvmTarget().getDescription() + " and is ignored.", null, 4, null);
                }
            } else {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$handleClosureGenerationSchemeArgument), CompilerMessageSeverity.ERROR, "Unknown `" + flag + "` argument: " + value2 + "\n.Supported arguments: " + ArraysKt.joinToString$default((Object[])JvmClosureGenerationScheme.values(), null, null, null, (int)0, null, (Function1)handleClosureGenerationSchemeArgument.1.INSTANCE, (int)31, null), null, 4, null);
            }
        }
    }

    public static final boolean configureJdkHome(@NotNull CompilerConfiguration $this$configureJdkHome, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$configureJdkHome, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        if (arguments2.getNoJdk()) {
            $this$configureJdkHome.put(JVMConfigurationKeys.NO_JDK, true);
            if (arguments2.getJdkHome() != null) {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureJdkHome), CompilerMessageSeverity.STRONG_WARNING, "The '-jdk-home' option is ignored because '-no-jdk' is specified", null, 4, null);
            }
            return true;
        }
        if (arguments2.getJdkHome() != null) {
            File jdkHome;
            String string2 = arguments2.getJdkHome();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if (!(jdkHome = new File(string2)).exists()) {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureJdkHome), CompilerMessageSeverity.ERROR, Intrinsics.stringPlus((String)"JDK home directory does not exist: ", (Object)jdkHome), null, 4, null);
                return false;
            }
            MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureJdkHome), CompilerMessageSeverity.LOGGING, Intrinsics.stringPlus((String)"Using JDK home directory ", (Object)jdkHome), null, 4, null);
            $this$configureJdkHome.put(JVMConfigurationKeys.JDK_HOME, jdkHome);
        }
        return true;
    }

    public static final void configureExplicitContentRoots(@NotNull CompilerConfiguration $this$configureExplicitContentRoots, @NotNull K2JVMCompilerArguments arguments2) {
        List list2;
        String modularRoot;
        List list3;
        Intrinsics.checkParameterIsNotNull((Object)$this$configureExplicitContentRoots, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        String string2 = arguments2.getJavaModulePath();
        if (string2 == null) {
            list3 = null;
        } else {
            char[] cArray = new char[]{File.pathSeparatorChar};
            list3 = StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }
        string2 = list3;
        boolean bl = false;
        Object object = string2;
        if (object == null) {
            object = CollectionsKt.emptyList();
        }
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            modularRoot = (String)iterator2.next();
            $this$configureExplicitContentRoots.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(new File(modularRoot)));
        }
        if (arguments2.getBuildFile() != null) {
            return;
        }
        modularRoot = arguments2.getClasspath();
        if (modularRoot == null) {
            list2 = null;
        } else {
            char[] cArray = new char[]{File.pathSeparatorChar};
            list2 = StringsKt.split$default((CharSequence)modularRoot, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }
        modularRoot = list2;
        boolean bl2 = false;
        Object object2 = modularRoot;
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            String path2 = (String)iterator2.next();
            $this$configureExplicitContentRoots.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(new File(path2)));
        }
    }

    public static final void configureStandardLibs(@NotNull CompilerConfiguration $this$configureStandardLibs, @Nullable KotlinPaths paths, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$configureStandardLibs, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        boolean isModularJava = JvmArgumentsKt.isModularJava($this$configureStandardLibs);
        if (!arguments2.getNoStdlib()) {
            JvmArgumentsKt.configureStandardLibs$addRoot($this$configureStandardLibs, isModularJava, paths, "kotlin.stdlib", "kotlin-stdlib.jar", (Function1<? super KotlinPaths, ? extends File>)((Function1)configureStandardLibs.1.INSTANCE), "'-no-stdlib'");
            JvmArgumentsKt.configureStandardLibs$addRoot($this$configureStandardLibs, isModularJava, paths, "kotlin.script.runtime", "kotlin-script-runtime.jar", (Function1<? super KotlinPaths, ? extends File>)((Function1)configureStandardLibs.2.INSTANCE), "'-no-stdlib'");
        }
        if (!arguments2.getNoReflect() && !arguments2.getNoStdlib()) {
            JvmArgumentsKt.configureStandardLibs$addRoot($this$configureStandardLibs, isModularJava, paths, "kotlin.reflect", "kotlin-reflect.jar", (Function1<? super KotlinPaths, ? extends File>)((Function1)configureStandardLibs.3.INSTANCE), "'-no-reflect' or '-no-stdlib'");
        }
    }

    public static final boolean isModularJava(@NotNull CompilerConfiguration $this$isModularJava) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$isModularJava, (String)"<this>");
        File file2 = $this$isModularJava.get(JVMConfigurationKeys.JDK_HOME);
        if (file2 == null) {
            bl = false;
        } else {
            boolean bl2;
            File file3 = file2;
            boolean bl3 = false;
            boolean bl4 = false;
            File it = file3;
            boolean bl5 = false;
            bl = bl2 = CoreJrtFileSystem.Companion.isModularJdk(it);
        }
        return bl;
    }

    public static final void addModularRootIfNotNull(@NotNull CompilerConfiguration $this$addModularRootIfNotNull, boolean isModularJava, @NotNull String moduleName, @Nullable File file2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$addModularRootIfNotNull, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        if (file2 != null) {
            if (isModularJava) {
                $this$addModularRootIfNotNull.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(file2));
                $this$addModularRootIfNotNull.add(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, moduleName);
            } else {
                $this$addModularRootIfNotNull.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(file2));
            }
        }
    }

    public static final boolean registerJavacIfNeeded(@NotNull KotlinCoreEnvironment $this$registerJavacIfNeeded, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$registerJavacIfNeeded, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        if (arguments2.getUseJavac()) {
            $this$registerJavacIfNeeded.getConfiguration().put(JVMConfigurationKeys.USE_JAVAC, true);
            if (arguments2.getCompileJava()) {
                $this$registerJavacIfNeeded.getConfiguration().put(JVMConfigurationKeys.COMPILE_JAVA, true);
            }
            return KotlinCoreEnvironment.registerJavac$default($this$registerJavacIfNeeded, null, null, arguments2.getJavacArguments(), null, null, 27, null);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final void configureAdvancedJvmOptions(@NotNull CompilerConfiguration $this$configureAdvancedJvmOptions, @NotNull K2JVMCompilerArguments arguments) {
        Intrinsics.checkParameterIsNotNull((Object)$this$configureAdvancedJvmOptions, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.PARAMETERS_METADATA, arguments.getJavaParameters());
        v0 = useOldBackend = arguments.getUseOldBackend() != false || arguments.getUseIR() == false && Intrinsics.areEqual((Object)$this$configureAdvancedJvmOptions.get(JVMConfigurationKeys.IR), (Object)false) != false;
        if (arguments.getUseFir()) ** GOTO lbl-1000
        v1 = CommonConfigurationKeysKt.getLanguageVersionSettings($this$configureAdvancedJvmOptions).supportsFeature(LanguageFeature.JvmIrEnabledByDefault) ? !useOldBackend : arguments.getUseIR() != false && useOldBackend == false;
        if (v1) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = useIR = false;
        }
        if (arguments.getUseIR() && arguments.getUseOldBackend()) {
            MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.STRONG_WARNING, "Both -Xuse-ir and -Xuse-old-backend are passed. This is an inconsistent configuration. The compiler will use the " + (useIR != false ? "JVM IR" : "old JVM") + " backend", null, 4, null);
        }
        MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.LOGGING, "Using " + (useIR != false ? "JVM IR" : "old JVM") + " backend", null, 4, null);
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.IR, useIR);
        abiStability = JvmAbiStability.Companion.fromStringOrNull(arguments.getAbiStability());
        if (arguments.getAbiStability() != null) {
            if (abiStability == null) {
                var5_5 = JvmAbiStability.values();
                var20_6 = new StringBuilder().append("Unknown ABI stability mode: ").append((Object)arguments.getAbiStability()).append(", supported modes: ");
                var19_7 = CompilerMessageSeverity.ERROR;
                var18_8 = JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions);
                $i$f$map = false;
                var7_11 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                $i$f$mapTo = false;
                for (Enum item$iv$iv : $this$mapTo$iv$iv) {
                    var14_30 = item$iv$iv;
                    var21_34 = destination$iv$iv;
                    $i$a$-map-JvmArgumentsKt$configureAdvancedJvmOptions$1 = false;
                    var22_35 = it.getDescription();
                    var21_34.add(var22_35);
                }
                var21_34 = (List)destination$iv$iv;
                MessageCollector.DefaultImpls.report$default(var18_8, var19_7, var20_6.append(var21_34).toString(), null, 4, null);
            } else if (!useIR && abiStability == JvmAbiStability.UNSTABLE) {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.ERROR, "-Xabi-stability=unstable is not supported in the old JVM backend", null, 4, null);
            } else {
                $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ABI_STABILITY, abiStability);
            }
        }
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DO_NOT_CLEAR_BINDING_CONTEXT, arguments.getDoNotClearBindingContext());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, arguments.getNoCallAssertions());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_RECEIVER_ASSERTIONS, arguments.getNoReceiverAssertions());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, arguments.getNoParamAssertions());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_EXCEPTION_ON_EXPLICIT_EQUALS_FOR_BOXED_NULL, arguments.getNoExceptionOnExplicitEqualsForBoxedNull());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, arguments.getNoOptimize());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.EMIT_JVM_TYPE_ANNOTATIONS, arguments.getEmitJvmTypeAnnotations());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_OPTIMIZED_CALLABLE_REFERENCES, arguments.getNoOptimizedCallableReferences());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_KOTLIN_NOTHING_VALUE_EXCEPTION, arguments.getNoKotlinNothingValueException());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_RESET_JAR_TIMESTAMPS, arguments.getNoResetJarTimestamps());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_UNIFIED_NULL_CHECKS, arguments.getNoUnifiedNullChecks());
        if (!JVMConstructorCallNormalizationMode.Companion.isSupportedValue(arguments.getConstructorCallNormalizationMode())) {
            $this$map$iv = JVMConstructorCallNormalizationMode.values();
            var20_6 = new StringBuilder().append("Unknown constructor call normalization mode: ").append((Object)arguments.getConstructorCallNormalizationMode()).append(", supported modes: ");
            var19_7 = CompilerMessageSeverity.ERROR;
            var18_8 = JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>($this$map$iv.length);
            $i$f$mapTo = false;
            var10_21 = $this$mapTo$iv$iv;
            var11_23 = var10_21.length;
            for (var12_25 = 0; var12_25 < var11_23; ++var12_25) {
                it = item$iv$iv = var10_21[var12_25];
                var21_34 = destination$iv$iv;
                $i$a$-map-JvmArgumentsKt$configureAdvancedJvmOptions$2 = false;
                var22_35 = it.getDescription();
                var21_34.add(var22_35);
            }
            var21_34 = (List)destination$iv$iv;
            MessageCollector.DefaultImpls.report$default(var18_8, var19_7, var20_6.append(var21_34).toString(), null, 4, null);
        }
        if ((constructorCallNormalizationMode = JVMConstructorCallNormalizationMode.Companion.fromStringOrNull(arguments.getConstructorCallNormalizationMode())) != null) {
            $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.CONSTRUCTOR_CALL_NORMALIZATION_MODE, constructorCallNormalizationMode);
        }
        if ((assertionsMode = JVMAssertionsMode.Companion.fromStringOrNull(arguments.getAssertionsMode())) == null) {
            $this$mapTo$iv$iv = JVMAssertionsMode.values();
            var20_6 = new StringBuilder().append("Unknown assertions mode: ").append((Object)arguments.getAssertionsMode()).append(", supported modes: ");
            var19_7 = CompilerMessageSeverity.ERROR;
            var18_8 = JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions);
            $i$f$map = false;
            $i$f$mapTo = $this$map$iv /* !! */ ;
            destination$iv$iv = new ArrayList<E>(((JVMAssertionsMode)$this$map$iv /* !! */ ).length);
            $i$f$mapTo = false;
            var12_26 = $this$mapTo$iv$iv;
            var13_29 = ((void)var12_26).length;
            for (var14_31 = 0; var14_31 < var13_29; ++var14_31) {
                var16_36 = item$iv$iv = var12_26[var14_31];
                var21_34 = destination$iv$iv;
                $i$a$-map-JvmArgumentsKt$configureAdvancedJvmOptions$3 = false;
                var22_35 = it.getDescription();
                var21_34.add(var22_35);
            }
            var21_34 = (List)destination$iv$iv;
            MessageCollector.DefaultImpls.report$default(var18_8, var19_7, var20_6.append(var21_34).toString(), null, 4, null);
        }
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ASSERTIONS_MODE, ($this$map$iv /* !! */  = assertionsMode) == null ? JVMAssertionsMode.DEFAULT : $this$map$iv /* !! */ );
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_TYPE_TABLE, arguments.getUseTypeTable());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.SKIP_RUNTIME_VERSION_CHECK, arguments.getSkipRuntimeVersionCheck());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_PSI_CLASS_FILES_READING, arguments.getUseOldClassFilesReading());
        if (arguments.getUseOldClassFilesReading()) {
            MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.INFO, "Using the old java class files reading implementation", null, 4, null);
        }
        $this$configureAdvancedJvmOptions.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments.getAllowKotlinPackage());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_SINGLE_MODULE, arguments.getSingleModule());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_OLD_SPILLED_VAR_TYPE_ANALYSIS, arguments.getUseOldSpilledVarTypeAnalysis());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_OLD_INLINE_CLASSES_MANGLING_SCHEME, arguments.getUseOldInlineClassesManglingScheme());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ENABLE_JVM_PREVIEW, arguments.getEnableJvmPreview());
        if (arguments.getEnableJvmPreview()) {
            MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.INFO, "Using preview Java language features", null, 4, null);
        }
        if (($this$map$iv /* !! */  = arguments.getDeclarationsOutputPath()) != null) {
            $i$f$map /* !! */  = $this$map$iv /* !! */ ;
            var9_20 = false;
            var10_22 = false;
            it /* !! */  = $i$f$map /* !! */ ;
            $i$a$-let-JvmArgumentsKt$configureAdvancedJvmOptions$4 = false;
            $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DECLARATIONS_JSON_PATH, it /* !! */ );
        }
        $i$f$map = StringsKt.toIntOrNull((String)arguments.getParallelBackendThreads());
        nThreadsRaw = $i$f$map == null ? 1 : $i$f$map;
        nThreads = nThreadsRaw == 0 ? Runtime.getRuntime().availableProcessors() : nThreadsRaw;
        $this$configureAdvancedJvmOptions.put(CommonConfigurationKeys.PARALLEL_BACKEND_THREADS, nThreads);
    }

    /*
     * WARNING - void declaration
     */
    public static final void configureKlibPaths(@NotNull CompilerConfiguration $this$configureKlibPaths, @NotNull K2JVMCompilerArguments arguments2) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$configureKlibPaths, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        String string2 = arguments2.getKlibLibraries();
        if (string2 == null) {
            return;
        }
        String libraries = string2;
        boolean bl = arguments2.getUseIR() && !arguments2.getUseOldBackend();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JvmArgumentsKt$configureKlibPaths$322 = false;
            String $i$a$-assert-JvmArgumentsKt$configureKlibPaths$322 = "Klib libraries can only be used with IR backend";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-JvmArgumentsKt$configureKlibPaths$322));
        }
        Object object = libraries;
        String string3 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"pathSeparator");
        int $i$a$-assert-JvmArgumentsKt$configureKlibPaths$322 = 0;
        string3 = new Regex(string3);
        $i$a$-assert-JvmArgumentsKt$configureKlibPaths$322 = 0;
        boolean bl3 = false;
        object = string3.split((CharSequence)object, $i$a$-assert-JvmArgumentsKt$configureKlibPaths$322);
        CompilerConfigurationKey<List<String>> compilerConfigurationKey = JVMConfigurationKeys.KLIB_PATHS;
        CompilerConfiguration compilerConfiguration = $this$configureKlibPaths;
        boolean $i$f$filterNot = false;
        void $i$a$-assert-JvmArgumentsKt$configureKlibPaths$322 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            CharSequence p0 = (CharSequence)element$iv$iv;
            boolean bl4 = false;
            CharSequence charSequence = p0;
            boolean bl5 = false;
            if (charSequence.length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        compilerConfiguration.put(compilerConfigurationKey, list2);
    }

    private static final MessageCollector getMessageCollector(CompilerConfiguration $this$messageCollector) {
        MessageCollector messageCollector = $this$messageCollector.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageCollector, (String)"getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY)");
        return messageCollector;
    }

    private static final void configureStandardLibs$addRoot(CompilerConfiguration $this_configureStandardLibs, boolean isModularJava, KotlinPaths $paths, String moduleName, String libraryName2, Function1<? super KotlinPaths, ? extends File> getLibrary, String noLibraryArgument) {
        JvmArgumentsKt.addModularRootIfNotNull($this_configureStandardLibs, isModularJava, moduleName, UtilsKt.getLibraryFromHome($paths, getLibrary, libraryName2, JvmArgumentsKt.getMessageCollector($this_configureStandardLibs), noLibraryArgument));
    }
}

