/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.js.backend.ast.AbstractNode;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.StaticContext;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010 \u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\fJ\u0014\u0010&\u001a\u00020'*\u00020\u001b2\u0006\u0010 \u001a\u00020\u0019H\u0002J\u0014\u0010(\u001a\u00020\u001e*\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/js/translate/context/DeclarationExporter;", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/StaticContext;", "(Lorg/jetbrains/kotlin/js/translate/context/StaticContext;)V", "getContext", "()Lorg/jetbrains/kotlin/js/translate/context/StaticContext;", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "localPackageNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "objectLikeKinds", "", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "statements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "getStatements", "()Ljava/util/List;", "assign", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "qualifier", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "export", "force", "", "exportObject", "declaration", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "exportProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getLocalPackageName", "packageName", "exportStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "shouldBeExported", "js.translator"})
public final class DeclarationExporter {
    @NotNull
    private final StaticContext context;
    @NotNull
    private final Set<ClassKind> objectLikeKinds;
    @NotNull
    private final Set<MemberDescriptor> exportedDeclarations;
    @NotNull
    private final Map<FqName, JsName> localPackageNames;

    public DeclarationExporter(@NotNull StaticContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        ClassKind[] classKindArray = new ClassKind[]{ClassKind.OBJECT, ClassKind.ENUM_ENTRY};
        this.objectLikeKinds = SetsKt.setOf((Object[])classKindArray);
        boolean bl = false;
        this.exportedDeclarations = new LinkedHashSet();
        bl = false;
        this.localPackageNames = new LinkedHashMap();
    }

    @NotNull
    public final StaticContext getContext() {
        return this.context;
    }

    private final List<JsStatement> getStatements() {
        List<JsStatement> list2 = this.context.getFragment().getExportBlock().getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"context.fragment.exportBlock.statements");
        return list2;
    }

    public final void export(@NotNull MemberDescriptor descriptor2, boolean force) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (this.exportedDeclarations.contains(descriptor2)) {
            return;
        }
        if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary()) {
            return;
        }
        if (AnnotationsUtils.isNativeObject(descriptor2) || AnnotationsUtils.isLibraryObject(descriptor2)) {
            return;
        }
        if (InlineOnlyKt.isEffectivelyInlineOnly(descriptor2)) {
            return;
        }
        NameSuggestion nameSuggestion = this.context.getNameSuggestion();
        DeclarationDescriptor declarationDescriptor = descriptor2;
        BindingContext bindingContext = this.context.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.bindingContext");
        SuggestedName suggestedName = nameSuggestion.suggest(declarationDescriptor, bindingContext);
        if (suggestedName == null) {
            return;
        }
        SuggestedName suggestedName2 = suggestedName;
        DeclarationDescriptor container2 = suggestedName2.getScope();
        if (!this.shouldBeExported(descriptor2, force)) {
            return;
        }
        this.exportedDeclarations.add(descriptor2);
        JsExpression jsExpression = container2 instanceof PackageFragmentDescriptor ? (JsExpression)this.getLocalPackageName(((PackageFragmentDescriptor)container2).getFqName()).makeRef() : (DescriptorUtils.isObject(container2) ? JsAstUtils.prototypeOf(this.context.getInnerNameForDescriptor(container2).makeRef()) : (JsExpression)this.context.getInnerNameForDescriptor(container2).makeRef());
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"when {\n            container is PackageFragmentDescriptor -> {\n                getLocalPackageName(container.fqName).makeRef()\n            }\n            DescriptorUtils.isObject(container) -> {\n                JsAstUtils.prototypeOf(context.getInnerNameForDescriptor(container).makeRef())\n            }\n            else -> {\n                context.getInnerNameForDescriptor(container).makeRef()\n            }\n        }");
        JsExpression qualifier = jsExpression;
        if (descriptor2 instanceof ClassDescriptor && this.objectLikeKinds.contains((Object)((ClassDescriptor)descriptor2).getKind())) {
            this.exportObject((ClassDescriptor)descriptor2, qualifier);
        } else if (descriptor2 instanceof PropertyDescriptor && container2 instanceof PackageFragmentDescriptor) {
            this.exportProperty((PropertyDescriptor)descriptor2, qualifier);
        } else {
            this.assign(descriptor2, qualifier);
        }
    }

    private final void assign(DeclarationDescriptor descriptor2, JsExpression qualifier) {
        JsName jsName = this.context.getInnerNameForDescriptor(descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"context.getInnerNameForDescriptor(descriptor)");
        JsName exportedName = jsName;
        JsNameRef jsNameRef = exportedName.makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"exportedName.makeRef()");
        JsNameRef expression2 = jsNameRef;
        Object object = this.context.getNameForDescriptor(descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.getNameForDescriptor(descriptor)");
        JsName propertyName = object;
        if (MetadataProperties.getStaticRef(propertyName) == null && !Intrinsics.areEqual((Object)exportedName, (Object)propertyName)) {
            MetadataProperties.setStaticRef(propertyName, expression2);
        }
        object = this;
        Collection collection = super.getStatements();
        AbstractNode abstractNode = JsAstUtils.assignment(new JsNameRef(propertyName, qualifier), expression2);
        Intrinsics.checkNotNullExpressionValue((Object)abstractNode, (String)"assignment(JsNameRef(propertyName, qualifier), expression)");
        abstractNode = this.exportStatement((JsExpression)abstractNode, descriptor2);
        boolean bl = false;
        collection.add(abstractNode);
    }

    private final void exportObject(ClassDescriptor declaration2, JsExpression qualifier) {
        JsName jsName = this.context.getNameForDescriptor(declaration2);
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"context.getNameForDescriptor(declaration)");
        JsName name = jsName;
        Object object = JsAstUtils.defineGetter(qualifier, name.getIdent(), this.context.getNameForObjectInstance(declaration2).makeRef());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"defineGetter(qualifier, name.ident,\n                                                 context.getNameForObjectInstance(declaration).makeRef())");
        JsExpression expression2 = object;
        object = this;
        Collection collection = super.getStatements();
        JsExpressionStatement jsExpressionStatement = this.exportStatement(expression2, declaration2);
        boolean bl = false;
        collection.add(jsExpressionStatement);
    }

    private final void exportProperty(PropertyDescriptor declaration2, JsExpression qualifier) {
        Object object;
        Collection<JsPropertyInitializer> collection;
        JsExpression jsExpression;
        SourceInfoAwareJsNode accessToField;
        Object object2;
        JsObjectLiteral propertyLiteral = new JsObjectLiteral(true);
        String string2 = this.context.getNameForDescriptor(declaration2).getIdent();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getNameForDescriptor(declaration).ident");
        String name = string2;
        boolean simpleProperty = JsDescriptorUtils.isSimpleFinalProperty(declaration2) && !TranslationUtils.shouldAccessViaFunctions((CallableDescriptor)declaration2);
        JsName exportedName = null;
        if (simpleProperty) {
            object2 = this.context.getInnerNameForDescriptor(declaration2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.getInnerNameForDescriptor(declaration)");
            exportedName = object2;
            accessToField = new JsReturn(exportedName.makeRef());
            jsExpression = new JsFunction(this.context.getFragment().getScope(), new JsBlock((JsStatement)((Object)accessToField)), declaration2 + " getter");
        } else {
            collection = declaration2.getGetter();
            Intrinsics.checkNotNull((Object)collection);
            object = this.context.getInnerNameForDescriptor((DeclarationDescriptor)((Object)collection));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.getInnerNameForDescriptor(declaration.getter!!)");
            exportedName = object;
            accessToField = exportedName.makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)accessToField, (String)"{\n            exportedName = context.getInnerNameForDescriptor(declaration.getter!!)\n            exportedName.makeRef()\n        }");
            jsExpression = (JsExpression)accessToField;
        }
        JsExpression getterBody = jsExpression;
        accessToField = propertyLiteral;
        object = ((JsObjectLiteral)accessToField).getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"propertyLiteral.propertyInitializers");
        object = (Collection)object;
        collection = new JsPropertyInitializer(new JsNameRef("get"), getterBody);
        boolean bl = false;
        object.add(collection);
        if (declaration2.isVar()) {
            JsExpression jsExpression2;
            if (simpleProperty) {
                boolean bl2 = false;
                List statements2 = new ArrayList();
                JsFunction function2 = new JsFunction(this.context.getFragment().getScope(), new JsBlock(statements2), declaration2 + " setter");
                SourceElement sourceElement = declaration2.getSource();
                Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"declaration.source");
                function2.setSource(KotlinSourceElementKt.getPsi(sourceElement));
                Object object3 = JsScope.declareTemporaryName("value");
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"declareTemporaryName(\"value\")");
                JsName valueName = object3;
                object3 = function2;
                Object object4 = ((JsFunction)object3).getParameters();
                Intrinsics.checkNotNullExpressionValue(object4, (String)"function.parameters");
                object4 = (Collection)object4;
                JsParameter jsParameter = new JsParameter(valueName);
                boolean bl3 = false;
                object4.add((JsParameter)jsParameter);
                object3 = statements2;
                object4 = JsAstUtils.assignment(this.context.getInnerNameForDescriptor(declaration2).makeRef(), valueName.makeRef()).makeStmt();
                boolean bl4 = false;
                object3.add(object4);
                jsExpression2 = function2;
            } else {
                collection = declaration2.getSetter();
                Intrinsics.checkNotNull((Object)collection);
                object = this.context.getInnerNameForDescriptor((DeclarationDescriptor)((Object)collection)).makeRef();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                context.getInnerNameForDescriptor(declaration.setter!!).makeRef()\n            }");
                jsExpression2 = (JsExpression)object;
            }
            JsExpression setterBody = jsExpression2;
            object = propertyLiteral;
            collection = ((JsObjectLiteral)object).getPropertyInitializers();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"propertyLiteral.propertyInitializers");
            collection = collection;
            JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(new JsNameRef("set"), setterBody);
            boolean bl5 = false;
            collection.add(jsPropertyInitializer);
        }
        object2 = this;
        object = super.getStatements();
        collection = JsAstUtils.defineProperty(qualifier, name, propertyLiteral);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"defineProperty(qualifier, name, propertyLiteral)");
        collection = this.exportStatement((JsExpression)((Object)collection), declaration2);
        bl = false;
        object.add(collection);
    }

    @NotNull
    public final JsName getLocalPackageName(@NotNull FqName packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (packageName.isRoot()) {
            JsName jsName = this.context.getFragment().getScope().declareName(Namer.getRootPackageName());
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"context.fragment.scope.declareName(Namer.getRootPackageName())");
            return jsName;
        }
        JsName name = this.localPackageNames.get(packageName);
        if (name == null) {
            name = JsScope.declareTemporaryName(Intrinsics.stringPlus((String)"package$", (Object)packageName.shortName().asString()));
            Object object = this.localPackageNames;
            boolean bl = false;
            object.put((FqName)packageName, (JsName)name);
            object = this;
            Collection collection = super.getStatements();
            Object object2 = packageName.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"packageName.shortName().asString()");
            String string2 = object2;
            object2 = packageName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"packageName.asString()");
            String string3 = object2;
            FqName fqName2 = packageName.parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"packageName.parent()");
            object2 = this.getLocalPackageName(fqName2).makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getLocalPackageName(packageName.parent()).makeRef()");
            object2 = UtilsKt.definePackageAlias(string2, name, string3, (JsExpression)object2);
            boolean bl2 = false;
            collection.add(object2);
        }
        return name;
    }

    private final JsExpressionStatement exportStatement(JsExpression $this$exportStatement, DeclarationDescriptor declaration2) {
        JsExpressionStatement jsExpressionStatement = new JsExpressionStatement($this$exportStatement);
        boolean bl = false;
        boolean bl2 = false;
        JsExpressionStatement it = jsExpressionStatement;
        boolean bl3 = false;
        MetadataProperties.setExportedTag(it, this.getContext().getTag(declaration2));
        return jsExpressionStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldBeExported(MemberDescriptor $this$shouldBeExported, boolean force) {
        if (force) return true;
        DeclarationDescriptor declarationDescriptor = $this$shouldBeExported;
        JsConfig jsConfig = this.context.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)jsConfig, (String)"context.config");
        if (!DescriptorUtilsKt.shouldBeExported(declarationDescriptor, jsConfig)) return false;
        return true;
    }
}

