/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.AnnotationsKt;
import org.jetbrains.kotlin.resolve.checkers.KotlinVersionStringAnnotationValueChecker;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/SinceKotlinAnnotationValueChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/KotlinVersionStringAnnotationValueChecker;", "()V", "extraCheck", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "version", "", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend"})
public final class SinceKotlinAnnotationValueChecker
extends KotlinVersionStringAnnotationValueChecker {
    @NotNull
    public static final SinceKotlinAnnotationValueChecker INSTANCE = new SinceKotlinAnnotationValueChecker();

    private SinceKotlinAnnotationValueChecker() {
        super(AnnotationsKt.getSINCE_KOTLIN_FQ_NAME());
    }

    @Override
    public void extraCheck(@NotNull KtDeclaration declaration2, @NotNull AnnotationDescriptor annotation2, @NotNull String version, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        ApiVersion apiVersion = ApiVersion.Companion.parse(version);
        ApiVersion specified = languageVersionSettings.getApiVersion();
        if (apiVersion != null && apiVersion.compareTo(specified) > 0) {
            PsiElement psiElement = KotlinSourceElementKt.getPsi(annotation2.getSource());
            diagnosticHolder.report(Errors.NEWER_VERSION_IN_SINCE_KOTLIN.on(psiElement == null ? (PsiElement)declaration2 : psiElement, specified.getVersionString()));
        }
    }
}

