/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.security.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.io.ExponentialBackoff;
import org.gradle.internal.io.IOQuery;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.security.internal.Fingerprint;
import org.gradle.security.internal.PublicKeyResultBuilder;
import org.gradle.security.internal.PublicKeyService;
import org.gradle.security.internal.SecuritySupport;

public class PublicKeyDownloadService
implements PublicKeyService {
    private static final Logger LOGGER = Logging.getLogger(PublicKeyDownloadService.class);
    private final List<URI> keyServers;
    private final ExternalResourceAccessor client;

    public PublicKeyDownloadService(List<URI> keyServers, ExternalResourceAccessor client) {
        this.keyServers = keyServers;
        this.client = client;
    }

    @Override
    public void findByLongId(long keyId, PublicKeyResultBuilder builder) {
        ArrayList<URI> servers = new ArrayList<URI>(this.keyServers);
        Collections.shuffle(servers);
        this.tryDownloadKeyFromServer(SecuritySupport.toLongIdHexString(keyId), servers, builder, keyring -> this.findMatchingKey(keyId, (PGPPublicKeyRing)keyring, builder));
    }

    @Override
    public void findByFingerprint(byte[] fingerprint, PublicKeyResultBuilder builder) {
        ArrayList<URI> servers = new ArrayList<URI>(this.keyServers);
        Collections.shuffle(servers);
        this.tryDownloadKeyFromServer(Fingerprint.wrap(fingerprint).toString(), servers, builder, keyring -> this.findMatchingKey(fingerprint, (PGPPublicKeyRing)keyring, builder));
    }

    private void tryDownloadKeyFromServer(String fingerprint, List<URI> baseUris, PublicKeyResultBuilder builder, Consumer<? super PGPPublicKeyRing> onKeyring) {
        ArrayDeque<URI> serversLeft = new ArrayDeque<URI>(baseUris);
        try {
            ExponentialBackoff backoff = ExponentialBackoff.of((int)5, (TimeUnit)TimeUnit.SECONDS, (int)50, (TimeUnit)TimeUnit.MILLISECONDS);
            backoff.retryUntil(() -> {
                URI baseUri = (URI)serversLeft.poll();
                if (baseUri == null) {
                    return IOQuery.Result.successful((Object)false);
                }
                try {
                    URI query = this.toQuery(baseUri, fingerprint);
                    ExternalResourceReadResponse response = this.client.openResource(query, false);
                    if (response != null) {
                        this.extractKeyRing(response, builder, onKeyring);
                        return IOQuery.Result.successful((Object)true);
                    }
                    PublicKeyDownloadService.logKeyDownloadAttempt(fingerprint, baseUri);
                }
                catch (Exception e) {
                    PublicKeyDownloadService.logKeyDownloadAttempt(fingerprint, baseUri);
                    serversLeft.add(baseUri);
                }
                return IOQuery.Result.notSuccessful((Object)false);
            });
        }
        catch (IOException | InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private void findMatchingKey(long id, PGPPublicKeyRing keyRing, PublicKeyResultBuilder builder) {
        for (PGPPublicKey publicKey : keyRing) {
            if (publicKey.getKeyID() != id) continue;
            builder.publicKey(publicKey);
            return;
        }
    }

    private void findMatchingKey(byte[] fingerprint, PGPPublicKeyRing keyRing, PublicKeyResultBuilder builder) {
        for (PGPPublicKey publicKey : keyRing) {
            if (!Arrays.equals(publicKey.getFingerprint(), fingerprint)) continue;
            builder.publicKey(publicKey);
            return;
        }
    }

    private void extractKeyRing(ExternalResourceReadResponse response, PublicKeyResultBuilder builder, Consumer<? super PGPPublicKeyRing> onKeyring) throws IOException {
        try (InputStream stream = response.openStream();
             InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)stream);){
            PGPObjectFactory objectFactory = new PGPObjectFactory(decoderStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            PGPPublicKeyRing keyring = (PGPPublicKeyRing)objectFactory.nextObject();
            onKeyring.accept((PGPPublicKeyRing)keyring);
            builder.keyRing(keyring);
        }
    }

    private static void logKeyDownloadAttempt(String fingerprint, URI baseUri) {
        LOGGER.debug("Cannot download public key " + fingerprint + " from " + baseUri.getHost());
    }

    private URI toQuery(URI baseUri, String fingerprint) throws URISyntaxException {
        String scheme = baseUri.getScheme();
        int port = baseUri.getPort();
        if ("hkp".equals(scheme)) {
            scheme = "http";
            port = 11371;
        }
        return new URI(scheme, null, baseUri.getHost(), port, "/pks/lookup", "op=get&options=mr&search=0x" + fingerprint, null);
    }

    @Override
    public void close() {
    }
}

