/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.graph;

import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.graph.InboundSemiGraph;

public final class CachingSemiGraph<Node>
implements InboundSemiGraph<Node> {
    private final Set<Node> myNodes;
    private final Map<Node, List<Node>> myIn;

    @NotNull
    public static <T> InboundSemiGraph<T> cache(@NotNull InboundSemiGraph<T> original) {
        if (original == null) {
            CachingSemiGraph.$$$reportNull$$$0(0);
        }
        return new CachingSemiGraph<T>(original);
    }

    private CachingSemiGraph(@NotNull InboundSemiGraph<Node> original) {
        if (original == null) {
            CachingSemiGraph.$$$reportNull$$$0(1);
        }
        this.myNodes = new LinkedHashSet<Node>(original.getNodes());
        this.myIn = new THashMap();
        for (Node node : this.myNodes) {
            Iterator<Node> inIterator = original.getIn(node);
            if (!inIterator.hasNext()) continue;
            ArrayList value2 = new ArrayList();
            ContainerUtil.addAll(value2, inIterator);
            this.myIn.put(node, value2);
        }
    }

    @Override
    @NotNull
    public Collection<Node> getNodes() {
        Set<Node> set = this.myNodes;
        if (set == null) {
            CachingSemiGraph.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public Iterator<Node> getIn(Node n) {
        List<Node> inNodes = this.myIn.get(n);
        Iterator<Object> iterator2 = inNodes != null ? inNodes.iterator() : Collections.emptyIterator();
        if (iterator2 == null) {
            CachingSemiGraph.$$$reportNull$$$0(3);
        }
        return iterator2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/graph/CachingSemiGraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/graph/CachingSemiGraph";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cache";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

