/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.configure;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Named;
import org.gradle.api.Transformer;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.model.ModelMap;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.internal.TargetedNativeComponentInternal;
import org.gradle.nativeplatform.internal.configure.NativeBinaries;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.platform.internal.NativePlatforms;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultBinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultPlatformRequirement;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.platform.base.internal.PlatformResolvers;
import org.gradle.util.internal.CollectionUtils;

public class NativeComponentRules {
    public static void createBinariesImpl(TargetedNativeComponentInternal nativeComponent, PlatformResolvers platforms, Set<? extends BuildType> buildTypes, Set<? extends Flavor> flavors, NativePlatforms nativePlatforms, NativeDependencyResolver nativeDependencyResolver, FileCollectionFactory fileCollectionFactory) {
        List<NativePlatform> resolvedPlatforms = NativeComponentRules.resolvePlatforms(nativeComponent, nativePlatforms, platforms);
        for (NativePlatform platform : resolvedPlatforms) {
            BinaryNamingScheme namingScheme = DefaultBinaryNamingScheme.component((String)nativeComponent.getName());
            namingScheme = namingScheme.withVariantDimension((Named)platform, resolvedPlatforms);
            NativeComponentRules.executeForEachBuildType(nativeComponent, (NativePlatformInternal)platform, namingScheme, buildTypes, flavors, nativeDependencyResolver, fileCollectionFactory);
        }
    }

    private static List<NativePlatform> resolvePlatforms(TargetedNativeComponentInternal targetedComponent, NativePlatforms nativePlatforms, final PlatformResolvers platforms) {
        List<PlatformRequirement> targetPlatforms = targetedComponent.getTargetPlatforms();
        if (targetPlatforms.isEmpty()) {
            PlatformRequirement requirement = DefaultPlatformRequirement.create((String)nativePlatforms.getDefaultPlatformName());
            targetPlatforms = Collections.singletonList(requirement);
        }
        return CollectionUtils.collect((Iterable)targetPlatforms, (Transformer)new Transformer<NativePlatform, PlatformRequirement>(){

            public NativePlatform transform(PlatformRequirement platformRequirement) {
                return (NativePlatform)platforms.resolve(NativePlatform.class, platformRequirement);
            }
        });
    }

    private static void executeForEachBuildType(TargetedNativeComponentInternal projectNativeComponent, NativePlatformInternal platform, BinaryNamingScheme namingScheme, Set<? extends BuildType> allBuildTypes, Set<? extends Flavor> allFlavors, NativeDependencyResolver nativeDependencyResolver, FileCollectionFactory fileCollectionFactory) {
        Set<BuildType> targetBuildTypes = projectNativeComponent.chooseBuildTypes(allBuildTypes);
        for (BuildType buildType : targetBuildTypes) {
            BinaryNamingScheme namingSchemeWithBuildType = namingScheme.withVariantDimension((Named)buildType, targetBuildTypes);
            NativeComponentRules.executeForEachFlavor(projectNativeComponent, platform, buildType, namingSchemeWithBuildType, allFlavors, nativeDependencyResolver, fileCollectionFactory);
        }
    }

    private static void executeForEachFlavor(TargetedNativeComponentInternal projectNativeComponent, NativePlatform platform, BuildType buildType, BinaryNamingScheme namingScheme, Set<? extends Flavor> allFlavors, NativeDependencyResolver nativeDependencyResolver, FileCollectionFactory fileCollectionFactory) {
        Set<Flavor> targetFlavors = projectNativeComponent.chooseFlavors(allFlavors);
        for (Flavor flavor : targetFlavors) {
            BinaryNamingScheme namingSchemeWithFlavor = namingScheme.withVariantDimension((Named)flavor, targetFlavors);
            NativeBinaries.createNativeBinaries(projectNativeComponent, (ModelMap<NativeBinarySpec>)projectNativeComponent.getBinaries().withType(NativeBinarySpec.class), nativeDependencyResolver, fileCollectionFactory, namingSchemeWithFlavor, platform, buildType, flavor);
        }
    }
}

