/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.core;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.core.trie.ArrayView;
import io.usethesource.capsule.core.trie.SetNode;
import io.usethesource.capsule.core.trie.SetNodeResult;
import io.usethesource.capsule.util.EqualityComparator;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PersistentTrieSet<K>
implements Set.Immutable<K>,
Serializable {
    private static final long serialVersionUID = 42L;
    private static final CompactSetNode EMPTY_NODE = new BitmapIndexedSetNode(null, 0, 0, new Object[0]);
    private static final PersistentTrieSet EMPTY_SET = new PersistentTrieSet(EMPTY_NODE, 0, 0);
    private static final boolean DEBUG = false;
    private final AbstractSetNode<K> rootNode;
    private final int cachedHashCode;
    private final int cachedSize;

    PersistentTrieSet(AbstractSetNode<K> rootNode, int cachedHashCode, int cachedSize) {
        this.rootNode = rootNode;
        this.cachedHashCode = cachedHashCode;
        this.cachedSize = cachedSize;
    }

    public static final <K> Set.Immutable<K> of() {
        return EMPTY_SET;
    }

    public static final <K> Set.Immutable<K> of(K key0) {
        int keyHash0 = key0.hashCode();
        int dataMap = CompactSetNode.bitpos(CompactSetNode.mask(keyHash0, 0));
        CompactSetNode<K> newRootNode = CompactSetNode.nodeOf(null, dataMap, key0, keyHash0);
        return new PersistentTrieSet<K>(newRootNode, keyHash0, 1);
    }

    public static final <K> Set.Immutable<K> of(K key0, K key1) {
        assert (!Objects.equals(key0, key1));
        int keyHash0 = key0.hashCode();
        int keyHash1 = key1.hashCode();
        CompactSetNode<K> newRootNode = CompactSetNode.mergeTwoKeyValPairs(key0, keyHash0, key1, keyHash1, 0);
        return new PersistentTrieSet<K>(newRootNode, keyHash0 + keyHash1, 2);
    }

    public static final <K> Set.Immutable<K> of(K ... keys) {
        Set.Immutable<K> result = EMPTY_SET;
        for (K key : keys) {
            result = result.__insert(key);
        }
        return result;
    }

    public static final <K> Set.Transient<K> transientOf() {
        return EMPTY_SET.asTransient();
    }

    public static final <K> Set.Transient<K> transientOf(K ... keys) {
        Set.Transient<K> result = EMPTY_SET.asTransient();
        for (K key : keys) {
            result.__insert(key);
        }
        return result;
    }

    private static <K> int hashCode(AbstractSetNode<K> rootNode) {
        int hash = 0;
        SetKeyIterator<K> it = new SetKeyIterator<K>(rootNode);
        while (it.hasNext()) {
            hash += it.next().hashCode();
        }
        return hash;
    }

    private static <K> int size(AbstractSetNode<K> rootNode) {
        int size = 0;
        SetKeyIterator<K> it = new SetKeyIterator<K>(rootNode);
        while (it.hasNext()) {
            ++size;
            it.next();
        }
        return size;
    }

    private boolean checkHashCodeAndSize(int targetHash, int targetSize) {
        int hash = 0;
        int size = 0;
        Iterator<K> it = this.keyIterator();
        while (it.hasNext()) {
            K key = it.next();
            hash += key.hashCode();
            ++size;
        }
        return hash == targetHash && size == targetSize;
    }

    public static final int transformHashCode(int hash) {
        return hash;
    }

    @Override
    public boolean contains(Object o) {
        return this.containsEquivalent(o, Object::equals);
    }

    @Override
    public boolean containsEquivalent(Object o, EqualityComparator<Object> cmp) {
        try {
            Object key = o;
            return this.rootNode.contains(key, PersistentTrieSet.transformHashCode(key.hashCode()), 0, cmp);
        }
        catch (ClassCastException unused) {
            return false;
        }
    }

    @Override
    public K get(Object o) {
        return this.getEquivalent(o, Object::equals);
    }

    @Override
    public K getEquivalent(Object o, EqualityComparator<Object> cmp) {
        try {
            Object key = o;
            Optional<Object> result = this.rootNode.findByKey(key, PersistentTrieSet.transformHashCode(key.hashCode()), 0, cmp);
            if (result.isPresent()) {
                return (K)result.get();
            }
            return null;
        }
        catch (ClassCastException unused) {
            return null;
        }
    }

    @Override
    public Set.Immutable<K> __insert(K key) {
        return this.__insertEquivalent(key, Object::equals);
    }

    @Override
    public Set.Immutable<K> __insertEquivalent(K key, EqualityComparator<Object> cmp) {
        int keyHash = key.hashCode();
        SetNodeResult details = SetNodeResult.unchanged();
        AbstractSetNode newRootNode = (AbstractSetNode)this.rootNode.updated(null, key, PersistentTrieSet.transformHashCode(keyHash), 0, details, cmp);
        if (details.isModified()) {
            return new PersistentTrieSet<K>(newRootNode, this.cachedHashCode + keyHash, this.cachedSize + 1);
        }
        return this;
    }

    @Override
    public Set.Immutable<K> __insertAll(Set<? extends K> set) {
        return this.__insertAllEquivalent(set, Object::equals);
    }

    @Override
    public Set.Immutable<K> __insertAllEquivalent(Set<? extends K> set, EqualityComparator<Object> cmp) {
        Set.Transient<? extends K> tmpTransient = this.asTransient();
        tmpTransient.__insertAllEquivalent(set, cmp);
        return tmpTransient.freeze();
    }

    @Override
    public Set.Immutable<K> __remove(K key) {
        return this.__removeEquivalent(key, Object::equals);
    }

    @Override
    public Set.Immutable<K> __removeEquivalent(K key, EqualityComparator<Object> cmp) {
        int keyHash = key.hashCode();
        SetNodeResult details = SetNodeResult.unchanged();
        AbstractSetNode newRootNode = (AbstractSetNode)this.rootNode.removed(null, key, PersistentTrieSet.transformHashCode(keyHash), 0, details, cmp);
        if (details.isModified()) {
            return new PersistentTrieSet<K>(newRootNode, this.cachedHashCode - keyHash, this.cachedSize - 1);
        }
        return this;
    }

    @Override
    public Set.Immutable<K> __removeAll(Set<? extends K> set) {
        return this.__removeAllEquivalent(set, Object::equals);
    }

    @Override
    public Set.Immutable<K> __removeAllEquivalent(Set<? extends K> set, EqualityComparator<Object> cmp) {
        Set.Transient<? extends K> tmpTransient = this.asTransient();
        tmpTransient.__removeAllEquivalent(set, cmp);
        return tmpTransient.freeze();
    }

    @Override
    public Set.Immutable<K> __retainAll(Set<? extends K> set) {
        Set.Transient<? extends K> tmpTransient = this.asTransient();
        tmpTransient.__retainAll(set);
        return tmpTransient.freeze();
    }

    @Override
    public Set.Immutable<K> __retainAllEquivalent(Set.Transient<? extends K> transientSet, EqualityComparator<Object> cmp) {
        Set.Transient<? extends K> tmpTransient = this.asTransient();
        tmpTransient.__retainAllEquivalent(transientSet, cmp);
        return tmpTransient.freeze();
    }

    @Override
    public boolean add(K key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.containsAllEquivalent(c, Object::equals);
    }

    @Override
    public boolean containsAllEquivalent(Collection<?> c, EqualityComparator<Object> cmp) {
        for (Object item : c) {
            if (this.containsEquivalent(item, cmp)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.cachedSize;
    }

    @Override
    public boolean isEmpty() {
        return this.cachedSize == 0;
    }

    @Override
    public Iterator<K> iterator() {
        return this.keyIterator();
    }

    @Override
    public Iterator<K> keyIterator() {
        return new SetKeyIterator<K>(this.rootNode);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.cachedSize];
        int idx = 0;
        for (K key : this) {
            array[idx++] = key;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList<K> list = new ArrayList<K>(this.cachedSize);
        for (K key : this) {
            list.add(key);
        }
        return list.toArray(a);
    }

    @Override
    public boolean equals(Object other) {
        return this.equivalent(other, Object::equals);
    }

    @Override
    public boolean equivalent(Object other, EqualityComparator<Object> cmp) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof PersistentTrieSet) {
            PersistentTrieSet that = (PersistentTrieSet)other;
            if (this.cachedSize != that.cachedSize) {
                return false;
            }
            if (this.cachedHashCode != that.cachedHashCode) {
                return false;
            }
            return this.rootNode.equivalent(that.rootNode, cmp);
        }
        if (other instanceof Set) {
            Set that = (Set)other;
            if (this.size() != that.size()) {
                return false;
            }
            return this.containsAllEquivalent(that, cmp);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.cachedHashCode;
    }

    public String toString() {
        String body = this.stream().map(k -> k.toString()).reduce((o1, o2) -> String.join((CharSequence)", ", o1, o2)).orElse("");
        return String.format("{%s}", body);
    }

    @Override
    public boolean isTransientSupported() {
        return true;
    }

    @Override
    public Set.Transient<K> asTransient() {
        return new TransientTrieSet(this);
    }

    protected AbstractSetNode<K> getRootNode() {
        return this.rootNode;
    }

    protected Iterator<AbstractSetNode<K>> nodeIterator() {
        return new TrieSetNodeIterator<K>(this.rootNode);
    }

    protected int getNodeCount() {
        Iterator<AbstractSetNode<K>> it = this.nodeIterator();
        int sumNodes = 0;
        while (it.hasNext()) {
            ++sumNodes;
            it.next();
        }
        return sumNodes;
    }

    protected int[][] arityCombinationsHistogram() {
        Iterator<AbstractSetNode<K>> it = this.nodeIterator();
        int[][] sumArityCombinations = new int[33][33];
        while (it.hasNext()) {
            AbstractSetNode<K> node = it.next();
            int[] nArray = sumArityCombinations[node.payloadArity()];
            int n = node.nodeArity();
            nArray[n] = nArray[n] + 1;
        }
        return sumArityCombinations;
    }

    protected int[] arityHistogram() {
        int[][] sumArityCombinations = this.arityCombinationsHistogram();
        int[] sumArity = new int[33];
        int maxArity = 32;
        for (int j = 0; j <= 32; ++j) {
            int maxRestArity = 32 - j;
            for (int k = 0; k <= maxRestArity - j; ++k) {
                int n = j + k;
                sumArity[n] = sumArity[n] + sumArityCombinations[j][k];
            }
        }
        return sumArity;
    }

    public void printStatistics() {
        int i;
        int[][] sumArityCombinations = this.arityCombinationsHistogram();
        int[] sumArity = this.arityHistogram();
        int sumNodes = this.getNodeCount();
        int[] cumsumArity = new int[33];
        int cumsum = 0;
        for (i = 0; i < 33; ++i) {
            cumsumArity[i] = cumsum += sumArity[i];
        }
        float threshhold = 0.01f;
        for (i = 0; i < 33; ++i) {
            float arityPercentage = (float)sumArity[i] / (float)sumNodes;
            float cumsumArityPercentage = (float)cumsumArity[i] / (float)sumNodes;
            if (arityPercentage == 0.0f || !(arityPercentage >= 0.01f)) continue;
            StringBuilder bldr = new StringBuilder();
            int max = i;
            for (int j = 0; j <= max; ++j) {
                for (int k = max - j; k <= max - j; ++k) {
                    float arityCombinationsPercentage = (float)sumArityCombinations[j][k] / (float)sumNodes;
                    if (arityCombinationsPercentage == 0.0f || !(arityCombinationsPercentage >= 0.01f)) continue;
                    bldr.append(String.format("%d/%d: %s, ", j, k, new DecimalFormat("0.00%").format(arityCombinationsPercentage)));
                }
            }
            String detailPercentages = bldr.toString();
            System.out.println(String.format("%2d: %s\t[cumsum = %s]\t%s", i, new DecimalFormat("0.00%").format(arityPercentage), new DecimalFormat("0.00%").format(cumsumArityPercentage), detailPercentages));
        }
    }

    static final class TransientTrieSet<K>
    extends AbstractTransientTrieSet<K> {
        private final AtomicReference<Thread> mutator = new AtomicReference<Thread>(Thread.currentThread());

        TransientTrieSet(PersistentTrieSet<K> trieSet) {
            super(trieSet);
        }

        @Override
        public boolean __insert(K key) {
            return this.__insertWithCapability(this.mutator, key);
        }

        @Override
        public boolean __insertEquivalent(K key, EqualityComparator<Object> cmp) {
            return this.__insertEquivalentWithCapability(this.mutator, key, cmp);
        }

        @Override
        public boolean __remove(K key) {
            return this.__removeWithCapability(this.mutator, key);
        }

        @Override
        public boolean __removeEquivalent(K key, EqualityComparator<Object> cmp) {
            return this.__removeEquivalentWithCapability(this.mutator, key, cmp);
        }

        @Override
        public Set.Immutable<K> freeze() {
            if (this.mutator.get() == null) {
                throw new IllegalStateException("Transient already frozen.");
            }
            this.mutator.set(null);
            return new PersistentTrieSet(this.rootNode, this.cachedHashCode, this.cachedSize);
        }
    }

    static abstract class AbstractTransientTrieSet<K>
    implements Set.Transient<K> {
        protected AbstractSetNode<K> rootNode;
        protected int cachedHashCode;
        protected int cachedSize;

        AbstractTransientTrieSet(PersistentTrieSet<K> trieSet) {
            this.rootNode = ((PersistentTrieSet)trieSet).rootNode;
            this.cachedHashCode = ((PersistentTrieSet)trieSet).cachedHashCode;
            this.cachedSize = ((PersistentTrieSet)trieSet).cachedSize;
        }

        private boolean checkHashCodeAndSize(int targetHash, int targetSize) {
            int hash = 0;
            int size = 0;
            Iterator<K> it = this.keyIterator();
            while (it.hasNext()) {
                K key = it.next();
                hash += key.hashCode();
                ++size;
            }
            return hash == targetHash && size == targetSize;
        }

        @Override
        public boolean add(K key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.containsEquivalent(o, Object::equals);
        }

        @Override
        public boolean containsEquivalent(Object o, EqualityComparator<Object> cmp) {
            try {
                Object key = o;
                return this.rootNode.contains(key, PersistentTrieSet.transformHashCode(key.hashCode()), 0, cmp);
            }
            catch (ClassCastException unused) {
                return false;
            }
        }

        @Override
        public K get(Object o) {
            return this.getEquivalent(o, Object::equals);
        }

        @Override
        public K getEquivalent(Object o, EqualityComparator<Object> cmp) {
            try {
                Object key = o;
                Optional<Object> result = this.rootNode.findByKey(key, PersistentTrieSet.transformHashCode(key.hashCode()), 0, cmp);
                if (result.isPresent()) {
                    return (K)result.get();
                }
                return null;
            }
            catch (ClassCastException unused) {
                return null;
            }
        }

        protected boolean __insertWithCapability(AtomicReference<Thread> mutator, K key) {
            return this.__insertEquivalentWithCapability(mutator, key, Object::equals);
        }

        protected boolean __insertEquivalentWithCapability(AtomicReference<Thread> mutator, K key, EqualityComparator<Object> cmp) {
            if (mutator.get() == null) {
                throw new IllegalStateException("Transient already frozen.");
            }
            int keyHash = key.hashCode();
            SetNodeResult details = SetNodeResult.unchanged();
            AbstractSetNode newRootNode = (AbstractSetNode)this.rootNode.updated(mutator, key, PersistentTrieSet.transformHashCode(keyHash), 0, details, cmp);
            if (details.isModified()) {
                this.rootNode = newRootNode;
                this.cachedHashCode += keyHash;
                ++this.cachedSize;
                return true;
            }
            return false;
        }

        @Override
        public boolean __insertAll(Set<? extends K> set) {
            return this.__insertAllEquivalent(set, Object::equals);
        }

        @Override
        public boolean __insertAllEquivalent(Set<? extends K> set, EqualityComparator<Object> cmp) {
            boolean modified = false;
            for (K key : set) {
                modified |= this.__insertEquivalent(key, cmp);
            }
            return modified;
        }

        protected boolean __removeWithCapability(AtomicReference<Thread> mutator, K key) {
            return this.__removeEquivalentWithCapability(mutator, key, Object::equals);
        }

        protected boolean __removeEquivalentWithCapability(AtomicReference<Thread> mutator, K key, EqualityComparator<Object> cmp) {
            if (mutator.get() == null) {
                throw new IllegalStateException("Transient already frozen.");
            }
            int keyHash = key.hashCode();
            SetNodeResult details = SetNodeResult.unchanged();
            AbstractSetNode newRootNode = (AbstractSetNode)this.rootNode.removed(mutator, key, PersistentTrieSet.transformHashCode(keyHash), 0, details, cmp);
            if (details.isModified()) {
                this.rootNode = newRootNode;
                this.cachedHashCode -= keyHash;
                --this.cachedSize;
                return true;
            }
            return false;
        }

        @Override
        public boolean __removeAll(Set<? extends K> set) {
            return this.__removeAllEquivalent(set, Object::equals);
        }

        @Override
        public boolean __removeAllEquivalent(Set<? extends K> set, EqualityComparator<Object> cmp) {
            boolean modified = false;
            for (K key : set) {
                modified |= this.__removeEquivalent(key, cmp);
            }
            return modified;
        }

        @Override
        public boolean __retainAll(Set<? extends K> set) {
            boolean modified = false;
            Iterator<K> thisIterator = this.iterator();
            while (thisIterator.hasNext()) {
                if (set.contains(thisIterator.next())) continue;
                thisIterator.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean __retainAllEquivalent(Set.Transient<? extends K> transientSet, EqualityComparator<Object> cmp) {
            boolean modified = false;
            Iterator<K> thisIterator = this.iterator();
            while (thisIterator.hasNext()) {
                if (transientSet.containsEquivalent(thisIterator.next(), cmp)) continue;
                thisIterator.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.containsAllEquivalent(c, Object::equals);
        }

        @Override
        public boolean containsAllEquivalent(Collection<?> c, EqualityComparator<Object> cmp) {
            for (Object item : c) {
                if (this.containsEquivalent(item, cmp)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int size() {
            return this.cachedSize;
        }

        @Override
        public boolean isEmpty() {
            return this.cachedSize == 0;
        }

        @Override
        public Iterator<K> iterator() {
            return this.keyIterator();
        }

        @Override
        public Iterator<K> keyIterator() {
            return new TransientSetKeyIterator(this);
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.cachedSize];
            int idx = 0;
            for (K key : this) {
                array[idx++] = key;
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList<K> list = new ArrayList<K>(this.cachedSize);
            for (K key : this) {
                list.add(key);
            }
            return list.toArray(a);
        }

        @Override
        public boolean equals(Object other) {
            return this.equivalent(other, Object::equals);
        }

        @Override
        public boolean equivalent(Object other, EqualityComparator<Object> cmp) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other instanceof AbstractTransientTrieSet) {
                AbstractTransientTrieSet that = (AbstractTransientTrieSet)other;
                if (this.cachedSize != that.cachedSize) {
                    return false;
                }
                if (this.cachedHashCode != that.cachedHashCode) {
                    return false;
                }
                return this.rootNode.equivalent(that.rootNode, cmp);
            }
            if (other instanceof Set) {
                Set that = (Set)other;
                if (this.size() != that.size()) {
                    return false;
                }
                return this.containsAllEquivalent(that, cmp);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.cachedHashCode;
        }

        public static class TransientSetKeyIterator<K>
        extends SetKeyIterator<K> {
            final AbstractTransientTrieSet<K> collection;
            K lastKey;

            public TransientSetKeyIterator(AbstractTransientTrieSet<K> collection) {
                super(collection.rootNode);
                this.collection = collection;
            }

            @Override
            public K next() {
                this.lastKey = super.next();
                return this.lastKey;
            }

            @Override
            public void remove() {
                this.collection.__remove(this.lastKey);
            }
        }
    }

    private static class TrieSetNodeIterator<K>
    implements Iterator<AbstractSetNode<K>> {
        final Deque<Iterator<? extends AbstractSetNode<K>>> nodeIteratorStack = new ArrayDeque<Iterator<? extends AbstractSetNode<K>>>();

        TrieSetNodeIterator(AbstractSetNode<K> rootNode) {
            this.nodeIteratorStack.push(Collections.singleton(rootNode).iterator());
        }

        @Override
        public boolean hasNext() {
            while (!this.nodeIteratorStack.isEmpty()) {
                if (this.nodeIteratorStack.peek().hasNext()) {
                    return true;
                }
                this.nodeIteratorStack.pop();
            }
            return false;
        }

        @Override
        public AbstractSetNode<K> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            AbstractSetNode<K> innerNode = this.nodeIteratorStack.peek().next();
            if (innerNode.hasNodes()) {
                this.nodeIteratorStack.push(innerNode.nodeIterator());
            }
            return innerNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class SetKeyIterator<K>
    extends AbstractSetIterator<K>
    implements Iterator<K> {
        SetKeyIterator(AbstractSetNode<K> rootNode) {
            super(rootNode);
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentValueNode.getKey(this.currentValueCursor++);
        }
    }

    private static abstract class AbstractSetIterator<K> {
        private static final int MAX_DEPTH = 7;
        protected int currentValueCursor;
        protected int currentValueLength;
        protected AbstractSetNode<K> currentValueNode;
        private int currentStackLevel = -1;
        private final int[] nodeCursorsAndLengths = new int[14];
        AbstractSetNode<K>[] nodes = new AbstractSetNode[7];

        AbstractSetIterator(AbstractSetNode<K> rootNode) {
            if (rootNode.hasNodes()) {
                this.currentStackLevel = 0;
                this.nodes[0] = rootNode;
                this.nodeCursorsAndLengths[0] = 0;
                this.nodeCursorsAndLengths[1] = rootNode.nodeArity();
            }
            if (rootNode.hasPayload()) {
                this.currentValueNode = rootNode;
                this.currentValueCursor = 0;
                this.currentValueLength = rootNode.payloadArity();
            }
        }

        private boolean searchNextValueNode() {
            while (this.currentStackLevel >= 0) {
                int currentCursorIndex = this.currentStackLevel * 2;
                int nodeCursor = this.nodeCursorsAndLengths[currentCursorIndex];
                int currentLengthIndex = currentCursorIndex + 1;
                int nodeLength = this.nodeCursorsAndLengths[currentLengthIndex];
                if (nodeCursor < nodeLength) {
                    AbstractSetNode<K> nextNode = this.nodes[this.currentStackLevel].getNode(nodeCursor);
                    int n = currentCursorIndex;
                    this.nodeCursorsAndLengths[n] = this.nodeCursorsAndLengths[n] + 1;
                    if (nextNode.hasNodes()) {
                        int nextStackLevel = ++this.currentStackLevel;
                        int nextCursorIndex = nextStackLevel * 2;
                        int nextLengthIndex = nextCursorIndex + 1;
                        this.nodes[nextStackLevel] = nextNode;
                        this.nodeCursorsAndLengths[nextCursorIndex] = 0;
                        this.nodeCursorsAndLengths[nextLengthIndex] = nextNode.nodeArity();
                    }
                    if (!nextNode.hasPayload()) continue;
                    this.currentValueNode = nextNode;
                    this.currentValueCursor = 0;
                    this.currentValueLength = nextNode.payloadArity();
                    return true;
                }
                --this.currentStackLevel;
            }
            return false;
        }

        public boolean hasNext() {
            if (this.currentValueCursor < this.currentValueLength) {
                return true;
            }
            return this.searchNextValueNode();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class HashCollisionSetNode<K>
    extends CompactSetNode<K> {
        private final K[] keys;
        private final int hash;

        HashCollisionSetNode(int hash, K[] keys) {
            this.keys = keys;
            this.hash = hash;
            assert (this.payloadArity() >= 2);
        }

        @Override
        public ArrayView<AbstractSetNode<K>> nodeArray() {
            return ArrayView.empty();
        }

        @Override
        public boolean contains(K key, int keyHash, int shift, EqualityComparator<Object> cmp) {
            if (this.hash == keyHash) {
                for (K k : this.keys) {
                    if (!cmp.equals(k, key)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Optional<K> findByKey(K key, int keyHash, int shift, EqualityComparator<Object> cmp) {
            for (int i = 0; i < this.keys.length; ++i) {
                K _key = this.keys[i];
                if (!cmp.equals(key, _key)) continue;
                return Optional.of(_key);
            }
            return Optional.empty();
        }

        @Override
        public AbstractSetNode<K> updated(AtomicReference<Thread> mutator, K key, int keyHash, int shift, SetNodeResult<K> details, EqualityComparator<Object> cmp) {
            assert (this.hash == keyHash);
            for (int idx = 0; idx < this.keys.length; ++idx) {
                if (!cmp.equals(this.keys[idx], key)) continue;
                return this;
            }
            Object[] keysNew = new Object[this.keys.length + 1];
            System.arraycopy(this.keys, 0, keysNew, 0, this.keys.length);
            keysNew[this.keys.length + 0] = key;
            System.arraycopy(this.keys, this.keys.length, keysNew, this.keys.length + 1, this.keys.length - this.keys.length);
            details.modified();
            details.updateDeltaSize(1);
            details.updateDeltaHashCode(keyHash);
            return new HashCollisionSetNode<Object>(keyHash, keysNew);
        }

        @Override
        public AbstractSetNode<K> removed(AtomicReference<Thread> mutator, K key, int keyHash, int shift, SetNodeResult<K> details, EqualityComparator<Object> cmp) {
            for (int idx = 0; idx < this.keys.length; ++idx) {
                if (!cmp.equals(this.keys[idx], key)) continue;
                details.modified();
                details.updateDeltaSize(-1);
                details.updateDeltaHashCode(-keyHash);
                if (this.arity() == 1) {
                    return HashCollisionSetNode.nodeOf(mutator);
                }
                if (this.arity() == 2) {
                    K theOtherKey = idx == 0 ? this.keys[1] : this.keys[0];
                    return CompactSetNode.nodeOf(mutator).updated((AtomicReference)mutator, (Object)theOtherKey, keyHash, 0, SetNodeResult.unchanged(), (EqualityComparator)cmp);
                }
                Object[] keysNew = new Object[this.keys.length - 1];
                System.arraycopy(this.keys, 0, keysNew, 0, idx);
                System.arraycopy(this.keys, idx + 1, keysNew, idx, this.keys.length - idx - 1);
                return new HashCollisionSetNode<Object>(keyHash, keysNew);
            }
            return this;
        }

        @Override
        public boolean hasPayload() {
            return true;
        }

        @Override
        public int payloadArity() {
            return this.keys.length;
        }

        @Override
        boolean hasNodes() {
            return false;
        }

        @Override
        int nodeArity() {
            return 0;
        }

        @Override
        int arity() {
            return this.payloadArity();
        }

        @Override
        public byte sizePredicate() {
            return 2;
        }

        @Override
        public K getKey(int index) {
            return this.keys[index];
        }

        @Override
        public int getKeyHash(int index) {
            return this.getKey(index).hashCode();
        }

        @Override
        public CompactSetNode<K> getNode(int index) {
            throw new IllegalStateException("Is leaf node.");
        }

        @Override
        Object getSlot(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean hasSlots() {
            throw new UnsupportedOperationException();
        }

        @Override
        int slotArity() {
            throw new UnsupportedOperationException();
        }

        @Override
        int localPayloadHashCode() {
            return this.hash * this.keys.length;
        }

        public int hashCode() {
            int prime = 31;
            int result = 0;
            result = 31 * result + this.hash;
            result = 31 * result + Arrays.hashCode(this.keys);
            return result;
        }

        public boolean equals(Object other) {
            return this.equivalent(other, Object::equals);
        }

        @Override
        public boolean equivalent(Object other, EqualityComparator<Object> cmp) {
            if (null == other) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            HashCollisionSetNode that = (HashCollisionSetNode)other;
            if (this.hash != that.hash) {
                return false;
            }
            if (this.arity() != that.arity()) {
                return false;
            }
            block0: for (int i = 0; i < that.payloadArity(); ++i) {
                K otherKey = that.getKey(i);
                for (int j = 0; j < this.keys.length; ++j) {
                    K key = this.keys[j];
                    if (cmp.equals(key, otherKey)) continue block0;
                }
                return false;
            }
            return true;
        }

        @Override
        CompactSetNode<K> copyAndInsertValue(AtomicReference<Thread> mutator, int bitpos, K key) {
            throw new UnsupportedOperationException();
        }

        @Override
        CompactSetNode<K> copyAndRemoveValue(AtomicReference<Thread> mutator, int bitpos) {
            throw new UnsupportedOperationException();
        }

        @Override
        CompactSetNode<K> copyAndSetNode(AtomicReference<Thread> mutator, int bitpos, AbstractSetNode<K> node) {
            throw new UnsupportedOperationException();
        }

        @Override
        CompactSetNode<K> copyAndMigrateFromInlineToNode(AtomicReference<Thread> mutator, int bitpos, AbstractSetNode<K> node) {
            throw new UnsupportedOperationException();
        }

        @Override
        CompactSetNode<K> copyAndMigrateFromNodeToInline(AtomicReference<Thread> mutator, int bitpos, AbstractSetNode<K> node) {
            throw new UnsupportedOperationException();
        }

        @Override
        final int nodeMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        final int dataMap() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class BitmapIndexedSetNode<K>
    extends CompactMixedSetNode<K> {
        final transient AtomicReference<Thread> mutator;
        final Object[] nodes;

        private BitmapIndexedSetNode(AtomicReference<Thread> mutator, int nodeMap, int dataMap, Object[] nodes) {
            super(mutator, nodeMap, dataMap);
            this.mutator = mutator;
            this.nodes = nodes;
        }

        @Override
        public ArrayView<AbstractSetNode<K>> nodeArray() {
            return new ArrayView<AbstractSetNode<K>>(){

                @Override
                public int size() {
                    return this.nodeArity();
                }

                @Override
                public AbstractSetNode<K> get(int index) {
                    return this.getNode(index);
                }

                @Override
                public void set(int index, AbstractSetNode<K> item) {
                    nodes[nodes.length - 1 - index] = item;
                }

                @Override
                public void set(int index, AbstractSetNode<K> item, AtomicReference<?> writeCapabilityToken) {
                    if (!AbstractSetNode.isAllowedToEdit(mutator, writeCapabilityToken)) {
                        throw new IllegalStateException();
                    }
                    nodes[nodes.length - 1 - index] = item;
                }
            };
        }

        @Override
        public K getKey(int index) {
            return (K)this.nodes[1 * index];
        }

        @Override
        public int getKeyHash(int index) {
            return this.getKey(index).hashCode();
        }

        @Override
        CompactSetNode<K> getNode(int index) {
            return (CompactSetNode)this.nodes[this.nodes.length - 1 - index];
        }

        @Override
        public boolean hasPayload() {
            return this.dataMap() != 0;
        }

        @Override
        public int payloadArity() {
            return Integer.bitCount(this.dataMap());
        }

        @Override
        boolean hasNodes() {
            return this.nodeMap() != 0;
        }

        @Override
        int nodeArity() {
            return Integer.bitCount(this.nodeMap());
        }

        @Override
        Object getSlot(int index) {
            return this.nodes[index];
        }

        @Override
        boolean hasSlots() {
            return this.nodes.length != 0;
        }

        @Override
        int slotArity() {
            return this.nodes.length;
        }

        @Override
        int localPayloadHashCode() {
            Stream<Object> keyStream = StreamSupport.stream(this.dataArray(0, 0).spliterator(), false);
            return keyStream.mapToInt(Object::hashCode).sum();
        }

        public int hashCode() {
            int prime = 31;
            int result = 0;
            result = 31 * result + this.nodeMap();
            result = 31 * result + this.dataMap();
            result = 31 * result + Arrays.hashCode(this.nodes);
            return result;
        }

        public boolean equals(Object other) {
            return this.equivalent(other, Object::equals);
        }

        @Override
        public boolean equivalent(Object other, EqualityComparator<Object> cmp) {
            if (null == other) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            BitmapIndexedSetNode that = (BitmapIndexedSetNode)other;
            if (this.nodeMap() != that.nodeMap()) {
                return false;
            }
            if (this.dataMap() != that.dataMap()) {
                return false;
            }
            return this.deepContentEquality(this.nodes, that.nodes, this.payloadArity(), this.slotArity(), cmp);
        }

        private final boolean deepContentEquality(Object[] a1, Object[] a2, int splitAt, int length, EqualityComparator<Object> cmp) {
            Object o2;
            Object o1;
            int i;
            if (a1 == a2) {
                return true;
            }
            for (i = 0; i < splitAt; ++i) {
                o1 = a1[i];
                o2 = a2[i];
                if (EqualityComparator.equals(o1, o2, cmp::equals)) continue;
                return false;
            }
            for (i = splitAt; i < length; ++i) {
                o1 = (AbstractSetNode)a1[i];
                o2 = (AbstractSetNode)a2[i];
                if (EqualityComparator.equals(o1, o2, (a, b) -> a.equivalent(b, cmp))) continue;
                return false;
            }
            return true;
        }

        @Override
        public byte sizePredicate() {
            if (this.nodeArity() == 0) {
                switch (this.payloadArity()) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                }
                return 2;
            }
            return 2;
        }

        @Override
        public final int size() {
            return super.size();
        }

        @Override
        public int recursivePayloadHashCode() {
            return super.recursivePayloadHashCode();
        }

        @Override
        CompactSetNode<K> copyAndSetNode(AtomicReference<Thread> mutator, int bitpos, AbstractSetNode<K> newNode) {
            int nodeIndex = this.nodeIndex(bitpos);
            AbstractSetNode node = this.getNode(nodeIndex);
            int idx = this.nodes.length - 1 - nodeIndex;
            if (BitmapIndexedSetNode.isAllowedToEdit(this.mutator, mutator)) {
                this.nodes[idx] = newNode;
                return this;
            }
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length];
            System.arraycopy(src, 0, dst, 0, src.length);
            dst[idx + 0] = newNode;
            return BitmapIndexedSetNode.nodeOf(mutator, this.nodeMap(), this.dataMap(), dst);
        }

        @Override
        CompactSetNode<K> copyAndInsertValue(AtomicReference<Thread> mutator, int bitpos, K key) {
            int idx = 1 * this.dataIndex(bitpos);
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length + 1];
            System.arraycopy(src, 0, dst, 0, idx);
            dst[idx + 0] = key;
            System.arraycopy(src, idx, dst, idx + 1, src.length - idx);
            return BitmapIndexedSetNode.nodeOf(mutator, this.nodeMap(), this.dataMap() | bitpos, dst);
        }

        @Override
        CompactSetNode<K> copyAndRemoveValue(AtomicReference<Thread> mutator, int bitpos) {
            int idx = 1 * this.dataIndex(bitpos);
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length - 1];
            System.arraycopy(src, 0, dst, 0, idx);
            System.arraycopy(src, idx + 1, dst, idx, src.length - idx - 1);
            return BitmapIndexedSetNode.nodeOf(mutator, this.nodeMap(), this.dataMap() ^ bitpos, dst);
        }

        @Override
        CompactSetNode<K> copyAndMigrateFromInlineToNode(AtomicReference<Thread> mutator, int bitpos, AbstractSetNode<K> node) {
            int idxOld = 1 * this.dataIndex(bitpos);
            int idxNew = this.nodes.length - 1 - this.nodeIndex(bitpos);
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length - 1 + 1];
            assert (idxOld <= idxNew);
            System.arraycopy(src, 0, dst, 0, idxOld);
            System.arraycopy(src, idxOld + 1, dst, idxOld, idxNew - idxOld);
            dst[idxNew + 0] = node;
            System.arraycopy(src, idxNew + 1, dst, idxNew + 1, src.length - idxNew - 1);
            return BitmapIndexedSetNode.nodeOf(mutator, this.nodeMap() | bitpos, this.dataMap() ^ bitpos, dst);
        }

        @Override
        CompactSetNode<K> copyAndMigrateFromNodeToInline(AtomicReference<Thread> mutator, int bitpos, AbstractSetNode<K> node) {
            int idxOld = this.nodes.length - 1 - this.nodeIndex(bitpos);
            int idxNew = 1 * this.dataIndex(bitpos);
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length - 1 + 1];
            assert (idxOld >= idxNew);
            System.arraycopy(src, 0, dst, 0, idxNew);
            dst[idxNew + 0] = node.getKey(0);
            System.arraycopy(src, idxNew, dst, idxNew + 1, idxOld - idxNew);
            System.arraycopy(src, idxOld + 1, dst, idxOld + 1, src.length - idxOld - 1);
            return BitmapIndexedSetNode.nodeOf(mutator, this.nodeMap() ^ bitpos, this.dataMap() | bitpos, dst);
        }
    }

    protected static abstract class CompactMixedSetNode<K>
    extends CompactSetNode<K> {
        private final int nodeMap;
        private final int dataMap;

        CompactMixedSetNode(AtomicReference<Thread> mutator, int nodeMap, int dataMap) {
            this.nodeMap = nodeMap;
            this.dataMap = dataMap;
        }

        @Override
        final int nodeMap() {
            return this.nodeMap;
        }

        @Override
        final int dataMap() {
            return this.dataMap;
        }
    }

    protected static abstract class CompactSetNode<K>
    extends AbstractSetNode<K> {
        static final int HASH_CODE_LENGTH = 32;
        static final int BIT_PARTITION_SIZE = 5;
        static final int BIT_PARTITION_MASK = 31;

        protected CompactSetNode() {
        }

        static final int mask(int keyHash, int shift) {
            return keyHash >>> shift & 0x1F;
        }

        static final int bitpos(int mask) {
            return 1 << mask;
        }

        abstract int nodeMap();

        abstract int dataMap();

        @Override
        abstract CompactSetNode<K> getNode(int var1);

        boolean nodeInvariant() {
            boolean inv3;
            boolean inv2;
            boolean inv1;
            boolean bl = inv1 = this.size() - this.payloadArity() >= 2 * (this.arity() - this.payloadArity());
            boolean bl2 = this.arity() == 0 ? this.sizePredicate() == 0 : (inv2 = true);
            boolean bl3 = this.arity() == 1 && this.payloadArity() == 1 ? this.sizePredicate() == 1 : (inv3 = true);
            boolean inv4 = this.arity() >= 2 ? this.sizePredicate() == 2 : true;
            boolean inv5 = this.nodeArity() >= 0 && this.payloadArity() >= 0 && this.payloadArity() + this.nodeArity() == this.arity();
            return inv1 && inv2 && inv3 && inv4 && inv5;
        }

        abstract CompactSetNode<K> copyAndInsertValue(AtomicReference<Thread> var1, int var2, K var3);

        abstract CompactSetNode<K> copyAndRemoveValue(AtomicReference<Thread> var1, int var2);

        abstract CompactSetNode<K> copyAndSetNode(AtomicReference<Thread> var1, int var2, AbstractSetNode<K> var3);

        abstract CompactSetNode<K> copyAndMigrateFromInlineToNode(AtomicReference<Thread> var1, int var2, AbstractSetNode<K> var3);

        abstract CompactSetNode<K> copyAndMigrateFromNodeToInline(AtomicReference<Thread> var1, int var2, AbstractSetNode<K> var3);

        static final <K> CompactSetNode<K> mergeTwoKeyValPairs(K key0, int keyHash0, K key1, int keyHash1, int shift) {
            int mask1;
            assert (!key0.equals(key1));
            if (shift >= 32) {
                return new HashCollisionSetNode<Object>(keyHash0, new Object[]{key0, key1});
            }
            int mask0 = CompactSetNode.mask(keyHash0, shift);
            if (mask0 != (mask1 = CompactSetNode.mask(keyHash1, shift))) {
                int dataMap = CompactSetNode.bitpos(mask0) | CompactSetNode.bitpos(mask1);
                if (mask0 < mask1) {
                    return CompactSetNode.nodeOf(null, dataMap, key0, keyHash0, key1, keyHash1);
                }
                return CompactSetNode.nodeOf(null, dataMap, key1, keyHash1, key0, keyHash0);
            }
            CompactSetNode<K> node = CompactSetNode.mergeTwoKeyValPairs(key0, keyHash0, key1, keyHash1, shift + 5);
            int nodeMap = CompactSetNode.bitpos(mask0);
            return CompactSetNode.nodeOf(null, nodeMap, node);
        }

        static final <K> CompactSetNode<K> nodeOf(AtomicReference<Thread> mutator, int nodeMap, int dataMap, Object[] nodes) {
            return new BitmapIndexedSetNode(mutator, nodeMap, dataMap, nodes);
        }

        static final <K> CompactSetNode<K> nodeOf(AtomicReference<Thread> mutator) {
            return EMPTY_NODE;
        }

        static final <K> CompactSetNode<K> nodeOf(AtomicReference<Thread> mutator, int dataMap, K key, int keyHash) {
            return CompactSetNode.nodeOf(mutator, 0, dataMap, new Object[]{key});
        }

        static final <K> CompactSetNode<K> nodeOf(AtomicReference<Thread> mutator, int dataMap, K key0, int keyHash0, K key1, int keyHash1) {
            return CompactSetNode.nodeOf(mutator, 0, dataMap, new Object[]{key0, key1});
        }

        static final <K> CompactSetNode<K> nodeOf(AtomicReference<Thread> mutator, int nodeMap, AbstractSetNode<K> node) {
            return CompactSetNode.nodeOf(mutator, nodeMap, 0, new Object[]{node});
        }

        static final int index(int bitmap, int bitpos) {
            return Integer.bitCount(bitmap & bitpos - 1);
        }

        static final int index(int bitmap, int mask, int bitpos) {
            return bitmap == -1 ? mask : CompactSetNode.index(bitmap, bitpos);
        }

        int dataIndex(int bitpos) {
            return Integer.bitCount(this.dataMap() & bitpos - 1);
        }

        int nodeIndex(int bitpos) {
            return Integer.bitCount(this.nodeMap() & bitpos - 1);
        }

        CompactSetNode<K> nodeAt(int bitpos) {
            return this.getNode(this.nodeIndex(bitpos));
        }

        @Override
        public boolean contains(K key, int keyHash, int shift, EqualityComparator<Object> cmp) {
            int mask = CompactSetNode.mask(keyHash, shift);
            int bitpos = CompactSetNode.bitpos(mask);
            int dataMap = this.dataMap();
            if ((dataMap & bitpos) != 0) {
                int index = CompactSetNode.index(dataMap, mask, bitpos);
                return cmp.equals(this.getKey(index), key);
            }
            int nodeMap = this.nodeMap();
            if ((nodeMap & bitpos) != 0) {
                int index = CompactSetNode.index(nodeMap, mask, bitpos);
                return ((CompactSetNode)this.getNode(index)).contains(key, keyHash, shift + 5, cmp);
            }
            return false;
        }

        @Override
        public Optional<K> findByKey(K key, int keyHash, int shift, EqualityComparator<Object> cmp) {
            int mask = CompactSetNode.mask(keyHash, shift);
            int bitpos = CompactSetNode.bitpos(mask);
            if ((this.dataMap() & bitpos) != 0) {
                int index = this.dataIndex(bitpos);
                if (cmp.equals(this.getKey(index), key)) {
                    return Optional.of(this.getKey(index));
                }
                return Optional.empty();
            }
            if ((this.nodeMap() & bitpos) != 0) {
                CompactSetNode<K> subNode = this.nodeAt(bitpos);
                return subNode.findByKey(key, keyHash, shift + 5, cmp);
            }
            return Optional.empty();
        }

        @Override
        public AbstractSetNode<K> updated(AtomicReference<Thread> mutator, K key, int keyHash, int shift, SetNodeResult<K> details, EqualityComparator<Object> cmp) {
            int mask = CompactSetNode.mask(keyHash, shift);
            int bitpos = CompactSetNode.bitpos(mask);
            if ((this.dataMap() & bitpos) != 0) {
                int dataIndex = this.dataIndex(bitpos);
                Object currentKey = this.getKey(dataIndex);
                if (cmp.equals(currentKey, key)) {
                    return this;
                }
                CompactSetNode subNodeNew = CompactSetNode.mergeTwoKeyValPairs(currentKey, PersistentTrieSet.transformHashCode(currentKey.hashCode()), key, keyHash, shift + 5);
                details.modified();
                details.updateDeltaSize(1);
                details.updateDeltaHashCode(keyHash);
                return this.copyAndMigrateFromInlineToNode(mutator, bitpos, subNodeNew);
            }
            if ((this.nodeMap() & bitpos) != 0) {
                CompactSetNode<K> subNode = this.nodeAt(bitpos);
                AbstractSetNode subNodeNew = (AbstractSetNode)subNode.updated(mutator, key, keyHash, shift + 5, details, cmp);
                if (details.isModified()) {
                    return this.copyAndSetNode(mutator, bitpos, subNodeNew);
                }
                return this;
            }
            details.modified();
            details.updateDeltaSize(1);
            details.updateDeltaHashCode(keyHash);
            return this.copyAndInsertValue(mutator, bitpos, key);
        }

        @Override
        public AbstractSetNode<K> removed(AtomicReference<Thread> mutator, K key, int keyHash, int shift, SetNodeResult<K> details, EqualityComparator<Object> cmp) {
            int mask = CompactSetNode.mask(keyHash, shift);
            int bitpos = CompactSetNode.bitpos(mask);
            if ((this.dataMap() & bitpos) != 0) {
                int dataIndex = this.dataIndex(bitpos);
                if (cmp.equals(this.getKey(dataIndex), key)) {
                    details.modified();
                    details.updateDeltaSize(-1);
                    details.updateDeltaHashCode(-keyHash);
                    if (this.payloadArity() == 2 && this.nodeArity() == 0) {
                        int newDataMap;
                        int n = newDataMap = shift == 0 ? this.dataMap() ^ bitpos : CompactSetNode.bitpos(CompactSetNode.mask(keyHash, 0));
                        if (dataIndex == 0) {
                            return CompactSetNode.nodeOf(mutator, newDataMap, this.getKey(1), this.getKeyHash(1));
                        }
                        return CompactSetNode.nodeOf(mutator, newDataMap, this.getKey(0), this.getKeyHash(0));
                    }
                    return this.copyAndRemoveValue(mutator, bitpos);
                }
                return this;
            }
            if ((this.nodeMap() & bitpos) != 0) {
                CompactSetNode<K> subNode = this.nodeAt(bitpos);
                AbstractSetNode subNodeNew = (AbstractSetNode)subNode.removed(mutator, key, keyHash, shift + 5, details, cmp);
                if (!details.isModified()) {
                    return this;
                }
                switch (subNodeNew.sizePredicate()) {
                    case 0: {
                        throw new IllegalStateException("Sub-node must have at least one element.");
                    }
                    case 1: {
                        if (this.payloadArity() == 0 && this.nodeArity() == 1) {
                            return subNodeNew;
                        }
                        return this.copyAndMigrateFromNodeToInline(mutator, bitpos, subNodeNew);
                    }
                }
                return this.copyAndSetNode(mutator, bitpos, subNodeNew);
            }
            return this;
        }

        static byte recoverMask(int map, byte i_th) {
            assert (1 <= i_th && i_th <= 32);
            byte cnt1 = 0;
            for (byte mask = 0; mask < 32; mask = (byte)((byte)(mask + 1))) {
                if ((map & 1) == 1 && (cnt1 = (byte)(cnt1 + 1)) == i_th) {
                    return mask;
                }
                map >>= 1;
            }
            assert (cnt1 != i_th);
            throw new RuntimeException("Called with invalid arguments.");
        }

        public String toString() {
            byte pos;
            int i;
            StringBuilder bldr = new StringBuilder();
            bldr.append('[');
            for (i = 0; i < this.payloadArity(); i = (int)((byte)(i + 1))) {
                pos = CompactSetNode.recoverMask(this.dataMap(), (byte)(i + 1));
                bldr.append(String.format("@%d<#%d>", pos, Objects.hashCode(this.getKey(i))));
                if (i + 1 == this.payloadArity()) continue;
                bldr.append(", ");
            }
            if (this.payloadArity() > 0 && this.nodeArity() > 0) {
                bldr.append(", ");
            }
            for (i = 0; i < this.nodeArity(); i = (int)((byte)(i + 1))) {
                pos = CompactSetNode.recoverMask(this.nodeMap(), (byte)(i + 1));
                bldr.append(String.format("@%d: %s", pos, this.getNode(i)));
                if (i + 1 == this.nodeArity()) continue;
                bldr.append(", ");
            }
            bldr.append(']');
            return bldr.toString();
        }
    }

    protected static abstract class AbstractSetNode<K>
    implements SetNode<K, AbstractSetNode<K>>,
    Iterable<K>,
    Serializable {
        private static final long serialVersionUID = 42L;
        static final int TUPLE_LENGTH = 1;

        protected AbstractSetNode() {
        }

        static final <T> boolean isAllowedToEdit(AtomicReference<?> x, AtomicReference<?> y) {
            return x != null && y != null && (x == y || x.get() == y.get());
        }

        @Override
        public <T> ArrayView<T> dataArray(int category, int component) {
            if (category == 0 && component == 0) {
                return this.categoryArrayView0();
            }
            throw new IllegalArgumentException("Category %i is not supported.");
        }

        private <T> ArrayView<T> categoryArrayView0() {
            return new ArrayView<T>(){

                @Override
                public int size() {
                    return this.payloadArity();
                }

                @Override
                public T get(int index) {
                    return this.getKey(index);
                }
            };
        }

        public abstract ArrayView<AbstractSetNode<K>> nodeArray();

        abstract boolean hasNodes();

        abstract int nodeArity();

        abstract AbstractSetNode<K> getNode(int var1);

        @Deprecated
        Iterator<? extends AbstractSetNode<K>> nodeIterator() {
            return new Iterator<AbstractSetNode<K>>(){
                int nextIndex = 0;
                final int nodeArity = this.nodeArity();

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public AbstractSetNode<K> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.getNode(this.nextIndex++);
                }

                @Override
                public boolean hasNext() {
                    return this.nextIndex < this.nodeArity;
                }
            };
        }

        @Deprecated
        abstract boolean hasSlots();

        abstract int slotArity();

        abstract Object getSlot(int var1);

        int arity() {
            return this.payloadArity() + this.nodeArity();
        }

        @Override
        public int size() {
            TrieSetNodeIterator it = new TrieSetNodeIterator(this);
            int size = 0;
            while (it.hasNext()) {
                AbstractSetNode node = (AbstractSetNode)it.next();
                size += node.payloadArity();
            }
            return size;
        }

        abstract int localPayloadHashCode();

        @Override
        public int recursivePayloadHashCode() {
            TrieSetNodeIterator it = new TrieSetNodeIterator(this);
            int hashCode = 0;
            while (it.hasNext()) {
                AbstractSetNode node = (AbstractSetNode)it.next();
                hashCode += node.localPayloadHashCode();
            }
            return hashCode;
        }

        @Override
        public Iterator<K> iterator() {
            return new SetKeyIterator(this);
        }

        @Override
        public Spliterator<K> spliterator() {
            return Spliterators.spliteratorUnknownSize(this.iterator(), 1);
        }

        public Stream<K> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }
    }
}

