/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestExecutionException;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.execution.TaskSelection;
import org.gradle.execution.TaskSelectionException;
import org.gradle.execution.TaskSelector;
import org.gradle.internal.build.event.types.DefaultTestDescriptor;
import org.gradle.process.JavaDebugOptions;
import org.gradle.process.internal.DefaultJavaDebugOptions;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.test.InternalDebugOptions;
import org.gradle.tooling.internal.protocol.test.InternalJvmTestRequest;
import org.gradle.tooling.internal.provider.action.TestExecutionRequestAction;
import org.gradle.util.internal.CollectionUtils;

class TestExecutionBuildConfigurationAction
implements BuildConfigurationAction {
    private final GradleInternal gradle;
    private final TestExecutionRequestAction testExecutionRequest;
    private final TaskSelector taskSelector;

    public TestExecutionBuildConfigurationAction(TestExecutionRequestAction testExecutionRequest, GradleInternal gradle) {
        this.testExecutionRequest = testExecutionRequest;
        this.gradle = gradle;
        this.taskSelector = (TaskSelector)gradle.getServices().get(TaskSelector.class);
    }

    public void configure(BuildExecutionContext context) {
        LinkedHashSet<Test> allTestTasksToRun = new LinkedHashSet<Test>();
        GradleInternal gradleInternal = context.getGradle();
        allTestTasksToRun.addAll(this.configureBuildForTestDescriptors(this.testExecutionRequest));
        allTestTasksToRun.addAll(this.configureBuildForInternalJvmTestRequest(gradleInternal, this.testExecutionRequest));
        allTestTasksToRun.addAll(this.configureBuildForTestTasks(this.testExecutionRequest));
        this.configureTestTasks(allTestTasksToRun);
        this.gradle.getTaskGraph().addEntryTasks(allTestTasksToRun);
    }

    private void configureTestTasks(Set<Test> allTestTasksToRun) {
        for (Test task : allTestTasksToRun) {
            task.setIgnoreFailures(true);
            task.getFilter().setFailOnNoMatchingTests(false);
            task.getOutputs().upToDateWhen(Specs.SATISFIES_NONE);
            final InternalDebugOptions debugOptions = this.testExecutionRequest.getDebugOptions();
            if (!debugOptions.isDebugMode()) continue;
            task.debugOptions((Action)new Action<JavaDebugOptions>(){

                public void execute(JavaDebugOptions javaDebugOptions) {
                    DefaultJavaDebugOptions options = (DefaultJavaDebugOptions)javaDebugOptions;
                    options.getEnabled().set((Object)true);
                    options.getPort().set((Object)debugOptions.getPort());
                    options.getServer().set((Object)false);
                    options.getSuspend().set((Object)false);
                }
            });
        }
    }

    private List<Test> configureBuildForTestDescriptors(TestExecutionRequestAction testExecutionRequest) {
        Map taskAndTests = testExecutionRequest.getTaskAndTests();
        ArrayList<Test> testTasksToRun = new ArrayList<Test>();
        for (Map.Entry entry : taskAndTests.entrySet()) {
            String testTaskPath = (String)entry.getKey();
            for (Test testTask : this.queryTestTasks(testTaskPath)) {
                for (InternalJvmTestRequest jvmTestRequest : (List)entry.getValue()) {
                    TestFilter filter = testTask.getFilter();
                    filter.includeTest(jvmTestRequest.getClassName(), jvmTestRequest.getMethodName());
                }
                testTasksToRun.add(testTask);
            }
        }
        return testTasksToRun;
    }

    private List<Test> configureBuildForTestTasks(TestExecutionRequestAction testExecutionRequest) {
        Set testDescriptors = testExecutionRequest.getTestExecutionDescriptors();
        List testTaskPaths = CollectionUtils.collect((Iterable)testDescriptors, (Transformer)new Transformer<String, InternalTestDescriptor>(){

            public String transform(InternalTestDescriptor testDescriptor) {
                return ((DefaultTestDescriptor)testDescriptor).getTaskPath();
            }
        });
        ArrayList<Test> testTasksToRun = new ArrayList<Test>();
        for (String testTaskPath : testTaskPaths) {
            for (Test testTask : this.queryTestTasks(testTaskPath)) {
                for (InternalTestDescriptor testDescriptor : testDescriptors) {
                    DefaultTestDescriptor defaultTestDescriptor = (DefaultTestDescriptor)testDescriptor;
                    if (!defaultTestDescriptor.getTaskPath().equals(testTaskPath)) continue;
                    String className = defaultTestDescriptor.getClassName();
                    String methodName = defaultTestDescriptor.getMethodName();
                    if (className == null && methodName == null) {
                        testTask.getFilter().includeTestsMatching("*");
                        continue;
                    }
                    testTask.getFilter().includeTest(className, methodName);
                }
                testTasksToRun.add(testTask);
            }
        }
        return testTasksToRun;
    }

    private Set<Test> queryTestTasks(String testTaskPath) {
        TaskSelection taskSelection;
        try {
            taskSelection = this.taskSelector.getSelection(testTaskPath);
        }
        catch (TaskSelectionException e) {
            throw new TestExecutionException(String.format("Requested test task with path '%s' cannot be found.", testTaskPath));
        }
        Set tasks = taskSelection.getTasks();
        if (tasks.isEmpty()) {
            throw new TestExecutionException(String.format("Requested test task with path '%s' cannot be found.", testTaskPath));
        }
        LinkedHashSet<Test> result = new LinkedHashSet<Test>();
        for (Task task : tasks) {
            if (!(task instanceof Test)) {
                throw new TestExecutionException(String.format("Task '%s' of type '%s' not supported for executing tests via TestLauncher API.", testTaskPath, task.getClass().getName()));
            }
            result.add((Test)task);
        }
        return result;
    }

    private List<Test> configureBuildForInternalJvmTestRequest(GradleInternal gradle, TestExecutionRequestAction testExecutionRequest) {
        Set internalJvmTestRequests = testExecutionRequest.getInternalJvmTestRequests();
        if (internalJvmTestRequests.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Test> tasksToExecute = new ArrayList<Test>();
        Set allprojects = gradle.getRootProject().getAllprojects();
        for (Project project : allprojects) {
            TaskCollection testTasks = project.getTasks().withType(Test.class);
            for (Test testTask : testTasks) {
                for (InternalJvmTestRequest jvmTestRequest : internalJvmTestRequests) {
                    TestFilter filter = testTask.getFilter();
                    filter.includeTest(jvmTestRequest.getClassName(), jvmTestRequest.getMethodName());
                }
            }
            tasksToExecute.addAll((Collection<Test>)testTasks);
        }
        return tasksToExecute;
    }
}

