/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.build.BuildProjectRegistry;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.model.CalculatedModelValue;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.resources.ProjectLeaseRegistry;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.Path;

public class DefaultProjectStateRegistry
implements ProjectStateRegistry {
    private final WorkerLeaseService workerLeaseService;
    private final Object lock = new Object();
    private final Map<Path, ProjectStateImpl> projectsByPath = Maps.newLinkedHashMap();
    private final Map<ProjectComponentIdentifier, ProjectStateImpl> projectsById = Maps.newHashMap();
    private final Map<BuildIdentifier, DefaultBuildProjectRegistry> projectsByBuild = Maps.newHashMap();
    private final AtomicReference<Thread> ownerOfAllProjects = new AtomicReference();

    public DefaultProjectStateRegistry(WorkerLeaseService workerLeaseService) {
        this.workerLeaseService = workerLeaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProjects(BuildState owner, ProjectRegistry<DefaultProjectDescriptor> projectRegistry) {
        Set<DefaultProjectDescriptor> allProjects = projectRegistry.getAllProjects();
        Object object = this.lock;
        synchronized (object) {
            DefaultBuildProjectRegistry buildProjectRegistry = this.getBuildProjectRegistry(owner);
            if (!buildProjectRegistry.projectsByPath.isEmpty()) {
                throw new IllegalStateException("Projects for " + owner.getDisplayName() + " have already been registered.");
            }
            for (DefaultProjectDescriptor descriptor : allProjects) {
                this.addProject(owner, buildProjectRegistry, descriptor);
            }
        }
    }

    private DefaultBuildProjectRegistry getBuildProjectRegistry(BuildState owner) {
        DefaultBuildProjectRegistry buildProjectRegistry = this.projectsByBuild.get(owner.getBuildIdentifier());
        if (buildProjectRegistry == null) {
            buildProjectRegistry = new DefaultBuildProjectRegistry(owner);
            this.projectsByBuild.put(owner.getBuildIdentifier(), buildProjectRegistry);
        }
        return buildProjectRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectState registerProject(BuildState owner, DefaultProjectDescriptor projectDescriptor) {
        Object object = this.lock;
        synchronized (object) {
            DefaultBuildProjectRegistry buildProjectRegistry = this.getBuildProjectRegistry(owner);
            return this.addProject(owner, buildProjectRegistry, projectDescriptor);
        }
    }

    private ProjectState addProject(BuildState owner, DefaultBuildProjectRegistry projectRegistry, DefaultProjectDescriptor descriptor) {
        Path projectPath = descriptor.path();
        Path identityPath = owner.calculateIdentityPathForProject(projectPath);
        String name = descriptor.getName();
        DefaultProjectComponentIdentifier projectIdentifier = new DefaultProjectComponentIdentifier(owner.getBuildIdentifier(), identityPath, projectPath, name);
        IProjectFactory projectFactory = (IProjectFactory)owner.getMutableModel().getServices().get(IProjectFactory.class);
        ProjectStateImpl projectState = new ProjectStateImpl(owner, identityPath, projectPath, descriptor.getName(), projectIdentifier, descriptor, projectFactory);
        this.projectsByPath.put(identityPath, projectState);
        this.projectsById.put(projectIdentifier, projectState);
        projectRegistry.add(projectPath, projectState);
        return projectState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ProjectStateImpl> getAllProjects() {
        Object object = this.lock;
        synchronized (object) {
            return this.projectsByPath.values();
        }
    }

    @Override
    public ProjectState stateFor(Project project) {
        return ((ProjectInternal)project).getOwner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectState stateFor(ProjectComponentIdentifier identifier) {
        Object object = this.lock;
        synchronized (object) {
            ProjectStateImpl projectState = this.projectsById.get(identifier);
            if (projectState == null) {
                throw new IllegalArgumentException(identifier.getDisplayName() + " not found.");
            }
            return projectState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildProjectRegistry projectsFor(BuildIdentifier buildIdentifier) throws IllegalArgumentException {
        Object object = this.lock;
        synchronized (object) {
            BuildProjectRegistry registry = this.projectsByBuild.get(buildIdentifier);
            if (registry == null) {
                throw new IllegalArgumentException("Projects for " + buildIdentifier + " have not been registered yet.");
            }
            return registry;
        }
    }

    @Override
    public void withMutableStateOfAllProjects(Runnable runnable) {
        this.withMutableStateOfAllProjects(Factories.toFactory((Runnable)runnable));
    }

    @Override
    public <T> T withMutableStateOfAllProjects(Factory<T> factory) {
        if (!this.ownerOfAllProjects.compareAndSet(null, Thread.currentThread())) {
            if (this.ownerOfAllProjects.get() == Thread.currentThread()) {
                return (T)factory.create();
            }
            throw new IllegalStateException(String.format("Another thread (%s) currently holds the state lock for all projects.", this.ownerOfAllProjects));
        }
        try {
            Object object = factory.create();
            return (T)object;
        }
        finally {
            this.ownerOfAllProjects.set(null);
        }
    }

    @Override
    public void blocking(Runnable runnable) {
        Thread owner = this.ownerOfAllProjects.get();
        if (owner == Thread.currentThread()) {
            this.ownerOfAllProjects.set(null);
            try {
                runnable.run();
            }
            finally {
                this.ownerOfAllProjects.set(owner);
            }
        } else {
            this.workerLeaseService.blocking(runnable);
        }
    }

    @Override
    public <T> T allowUncontrolledAccessToAnyProject(Factory<T> factory) {
        return (T)this.workerLeaseService.allowUncontrolledAccessToAnyProject(factory);
    }

    private static class CalculatedModelValueImpl<T>
    implements CalculatedModelValue<T> {
        private final ProjectLeaseRegistry projectLeaseRegistry;
        private final ModelContainer<?> owner;
        private final ReentrantLock lock = new ReentrantLock();
        private volatile T value;

        public CalculatedModelValueImpl(ProjectStateImpl owner, WorkerLeaseService projectLeaseRegistry, @Nullable T initialValue) {
            this.projectLeaseRegistry = projectLeaseRegistry;
            this.value = initialValue;
            this.owner = owner;
        }

        @Override
        public T get() throws IllegalStateException {
            T currentValue = this.getOrNull();
            if (currentValue == null) {
                throw new IllegalStateException("No calculated value is available for " + this.owner);
            }
            return currentValue;
        }

        @Override
        public T getOrNull() {
            return this.value;
        }

        @Override
        public void set(T newValue) {
            this.assertCanMutate();
            this.value = newValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T update(Function<T, T> updateFunction) {
            this.acquireUpdateLock();
            try {
                T newValue = updateFunction.apply(this.value);
                this.value = newValue;
                T t = newValue;
                return t;
            }
            finally {
                this.releaseUpdateLock();
            }
        }

        private void acquireUpdateLock() {
            this.assertCanMutate();
            if (this.lock.tryLock()) {
                return;
            }
            this.projectLeaseRegistry.withoutProjectLock(this.lock::lock);
        }

        private void assertCanMutate() {
            if (!this.owner.hasMutableState()) {
                throw new IllegalStateException("Current thread does not hold the state lock for " + this.owner);
            }
        }

        private void releaseUpdateLock() {
            this.lock.unlock();
        }
    }

    private class ProjectStateImpl
    implements ProjectState {
        private final Path projectPath;
        private final String projectName;
        private final ProjectComponentIdentifier identifier;
        private final DefaultProjectDescriptor descriptor;
        private final IProjectFactory projectFactory;
        private final BuildState owner;
        private final Path identityPath;
        private final ResourceLock projectLock;
        private final Set<Thread> canDoAnythingToThisProject = new CopyOnWriteArraySet<Thread>();
        private ProjectInternal project;

        ProjectStateImpl(BuildState owner, Path identityPath, Path projectPath, String projectName, ProjectComponentIdentifier identifier, DefaultProjectDescriptor descriptor, IProjectFactory projectFactory) {
            this.owner = owner;
            this.identityPath = identityPath;
            this.projectPath = projectPath;
            this.projectName = projectName;
            this.identifier = identifier;
            this.descriptor = descriptor;
            this.projectFactory = projectFactory;
            this.projectLock = DefaultProjectStateRegistry.this.workerLeaseService.getProjectLock(owner.getIdentityPath(), identityPath);
        }

        @Override
        public DisplayName getDisplayName() {
            if (this.projectPath.equals((Object)Path.ROOT)) {
                return Describables.quoted((Object)"root project", (Object)this.projectName);
            }
            return Describables.of((Object)this.identifier);
        }

        public String toString() {
            return this.getDisplayName().getDisplayName();
        }

        @Override
        public BuildState getOwner() {
            return this.owner;
        }

        @Override
        @Nullable
        public ProjectState getParent() {
            return this.identityPath.getParent() == null ? null : (ProjectState)DefaultProjectStateRegistry.this.projectsByPath.get(this.identityPath.getParent());
        }

        @Override
        public Set<ProjectState> getChildProjects() {
            TreeSet<ProjectState> children = new TreeSet<ProjectState>(Comparator.comparing(ProjectState::getIdentityPath));
            for (ProjectDescriptor child : this.descriptor.getChildren()) {
                children.add((ProjectState)DefaultProjectStateRegistry.this.projectsByPath.get(this.identityPath.child(child.getName())));
            }
            return children;
        }

        @Override
        public String getName() {
            return this.projectName;
        }

        @Override
        public Path getIdentityPath() {
            return this.identityPath;
        }

        @Override
        public Path getProjectPath() {
            return this.projectPath;
        }

        @Override
        public File getProjectDir() {
            return this.descriptor.getProjectDir();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void createMutableModel(ClassLoaderScope selfClassLoaderScope, ClassLoaderScope baseClassLoaderScope) {
            ProjectStateImpl projectStateImpl = this;
            synchronized (projectStateImpl) {
                ProjectInternal parent;
                if (this.project != null) {
                    throw new IllegalStateException(String.format("The project object for project %s has already been attached.", this.getIdentityPath()));
                }
                if (this.descriptor.getParent() != null) {
                    Path parentPath = this.owner.calculateIdentityPathForProject(this.descriptor.getParent().path());
                    ProjectStateImpl parentState = (ProjectStateImpl)DefaultProjectStateRegistry.this.projectsByPath.get(parentPath);
                    if (parentState == null) {
                        throw new IllegalStateException("Parent project " + parentPath + " is not registered for project " + this.identityPath);
                    }
                    parent = parentState.getMutableModel();
                } else {
                    parent = null;
                }
                this.project = this.projectFactory.createProject(this.owner.getMutableModel(), this.descriptor, this, parent, selfClassLoaderScope, baseClassLoaderScope);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProjectInternal getMutableModel() {
            ProjectStateImpl projectStateImpl = this;
            synchronized (projectStateImpl) {
                if (this.project == null) {
                    throw new IllegalStateException(String.format("The project object for project %s has not been attached yet.", this.getIdentityPath()));
                }
                return this.project;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ensureConfigured() {
            ProjectStateImpl projectStateImpl = this;
            synchronized (projectStateImpl) {
                this.getMutableModel().evaluate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ensureTasksDiscovered() {
            ProjectStateImpl projectStateImpl = this;
            synchronized (projectStateImpl) {
                ProjectInternal project = this.getMutableModel();
                project.evaluate();
                project.getTasks().discoverTasks();
                project.bindAllModelRules();
            }
        }

        @Override
        public ProjectComponentIdentifier getComponentIdentifier() {
            return this.identifier;
        }

        @Override
        public ResourceLock getAccessLock() {
            return this.projectLock;
        }

        @Override
        public void applyToMutableState(Consumer<? super ProjectInternal> action) {
            this.fromMutableState((Function)p -> {
                action.accept((ProjectInternal)p);
                return null;
            });
        }

        @Override
        public <S> S fromMutableState(Function<? super ProjectInternal, ? extends S> function) {
            Thread currentThread = Thread.currentThread();
            if (DefaultProjectStateRegistry.this.workerLeaseService.isAllowedUncontrolledAccessToAnyProject() || this.canDoAnythingToThisProject.contains(currentThread)) {
                return function.apply(this.getMutableModel());
            }
            Thread currentOwner = (Thread)DefaultProjectStateRegistry.this.ownerOfAllProjects.get();
            if (currentOwner != null) {
                if (currentOwner == currentThread) {
                    return function.apply(this.getMutableModel());
                }
                throw new IllegalStateException(String.format("Cannot acquire state lock for %s as another thread (%s) currently holds the state lock for all projects.", this.project, currentOwner));
            }
            Collection currentLocks = DefaultProjectStateRegistry.this.workerLeaseService.getCurrentProjectLocks();
            if (currentLocks.contains(this.projectLock)) {
                if (currentLocks.size() == 1) {
                    return function.apply(this.getMutableModel());
                }
                currentLocks = Lists.newArrayList((Iterable)currentLocks);
                currentLocks.remove(this.projectLock);
                return (S)DefaultProjectStateRegistry.this.workerLeaseService.withoutLocks((Iterable)currentLocks, () -> function.apply(this.getMutableModel()));
            }
            if (!currentLocks.isEmpty()) {
                return (S)DefaultProjectStateRegistry.this.workerLeaseService.withoutLocks((Iterable)currentLocks, () -> this.withProjectLock(this.projectLock, function));
            }
            return this.withProjectLock(this.projectLock, function);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <S> S forceAccessToMutableState(Function<? super ProjectInternal, ? extends S> factory) {
            Thread currentThread = Thread.currentThread();
            boolean added = this.canDoAnythingToThisProject.add(currentThread);
            try {
                S s = factory.apply(this.getMutableModel());
                return s;
            }
            finally {
                if (added) {
                    this.canDoAnythingToThisProject.remove(currentThread);
                }
            }
        }

        private <S> S withProjectLock(ResourceLock projectLock, Function<? super ProjectInternal, ? extends S> function) {
            return (S)DefaultProjectStateRegistry.this.workerLeaseService.withLocks(Collections.singleton(projectLock), () -> function.apply(this.getMutableModel()));
        }

        @Override
        public boolean hasMutableState() {
            Thread currentThread = Thread.currentThread();
            return this.canDoAnythingToThisProject.contains(currentThread) || DefaultProjectStateRegistry.this.workerLeaseService.isAllowedUncontrolledAccessToAnyProject() || DefaultProjectStateRegistry.this.ownerOfAllProjects.get() == currentThread || DefaultProjectStateRegistry.this.workerLeaseService.getCurrentProjectLocks().contains(this.projectLock);
        }

        @Override
        public <T> CalculatedModelValue<T> newCalculatedValue(@Nullable T initialValue) {
            return new CalculatedModelValueImpl<T>(this, DefaultProjectStateRegistry.this.workerLeaseService, initialValue);
        }
    }

    private static class DefaultBuildProjectRegistry
    implements BuildProjectRegistry {
        private final BuildState owner;
        private final Map<Path, ProjectStateImpl> projectsByPath = Maps.newLinkedHashMap();

        public DefaultBuildProjectRegistry(BuildState owner) {
            this.owner = owner;
        }

        public void add(Path projectPath, ProjectStateImpl projectState) {
            this.projectsByPath.put(projectPath, projectState);
        }

        @Override
        public ProjectState getRootProject() {
            return this.getProject(Path.ROOT);
        }

        @Override
        public ProjectState getProject(Path projectPath) {
            ProjectStateImpl projectState = this.projectsByPath.get(projectPath);
            if (projectState == null) {
                throw new IllegalArgumentException("Project with path '" + projectPath + "' not found in " + this.owner.getDisplayName() + ".");
            }
            return projectState;
        }

        @Override
        @Nullable
        public ProjectState findProject(Path projectPath) {
            return this.projectsByPath.get(projectPath);
        }

        @Override
        public Set<? extends ProjectState> getAllProjects() {
            TreeSet<ProjectState> projects = new TreeSet<ProjectState>(Comparator.comparing(ProjectState::getIdentityPath));
            projects.addAll(this.projectsByPath.values());
            return projects;
        }
    }
}

