/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import org.gradle.api.BuildCancelledException;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.initialization.BuildCancellationToken;

public class TaskPathProjectEvaluator
implements ProjectConfigurer {
    private final BuildCancellationToken cancellationToken;

    public TaskPathProjectEvaluator(BuildCancellationToken cancellationToken) {
        this.cancellationToken = cancellationToken;
    }

    @Override
    public void configure(ProjectInternal project) {
        if (this.cancellationToken.isCancellationRequested()) {
            throw new BuildCancelledException();
        }
        ProjectInternal parentProject = project.getParent();
        if (parentProject != null) {
            this.configure(parentProject);
        }
        project.getOwner().ensureConfigured();
    }

    @Override
    public void configureFully(ProjectInternal project) {
        this.configure(project);
        if (this.cancellationToken.isCancellationRequested()) {
            throw new BuildCancelledException();
        }
        project.getOwner().ensureTasksDiscovered();
    }

    @Override
    public void configureHierarchy(ProjectInternal project) {
        this.configure(project);
        for (Project sub : project.getSubprojects()) {
            this.configure((ProjectInternal)sub);
        }
    }

    @Override
    public void configureHierarchyFully(ProjectInternal project) {
        this.configureFully(project);
        for (Project sub : project.getSubprojects()) {
            this.configureFully((ProjectInternal)sub);
        }
    }
}

