/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.initialization.EvaluateSettingsBuildOperationType;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;

public class BuildOperationSettingsProcessor
implements SettingsProcessor {
    private static final EvaluateSettingsBuildOperationType.Result RESULT = new EvaluateSettingsBuildOperationType.Result(){};
    private final SettingsProcessor settingsProcessor;
    private final BuildOperationExecutor buildOperationExecutor;

    public BuildOperationSettingsProcessor(SettingsProcessor settingsProcessor, BuildOperationExecutor buildOperationExecutor) {
        this.settingsProcessor = settingsProcessor;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public SettingsInternal process(final GradleInternal gradle, final SettingsLocation settingsLocation, final ClassLoaderScope buildRootClassLoaderScope, final StartParameter startParameter) {
        return (SettingsInternal)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<SettingsInternal>(){

            public SettingsInternal call(BuildOperationContext context) {
                SettingsInternal settingsInternal = BuildOperationSettingsProcessor.this.settingsProcessor.process(gradle, settingsLocation, buildRootClassLoaderScope, startParameter);
                context.setResult((Object)RESULT);
                return settingsInternal;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)gradle.contextualize("Evaluate settings")).progressDisplayName("Evaluating settings").details((Object)new EvaluateSettingsBuildOperationType.Details(){

                    @Override
                    public String getBuildPath() {
                        return gradle.getIdentityPath().toString();
                    }

                    @Override
                    public String getSettingsDir() {
                        return settingsLocation.getSettingsDir().getAbsolutePath();
                    }

                    @Override
                    public String getSettingsFile() {
                        File settingsFile = settingsLocation.getSettingsFile();
                        return settingsFile != null ? settingsFile.getPath() : null;
                    }
                });
            }
        });
    }
}

