/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.internal.InternalBuildFinishedListener;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildModelController;
import org.gradle.internal.build.BuildWorkPreparer;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.StateTransitionController;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.execution.BuildOutputCleanupRegistry;
import org.gradle.internal.service.scopes.BuildScopeServices;

public class DefaultBuildLifecycleController
implements BuildLifecycleController {
    private final ExceptionAnalyser exceptionAnalyser;
    private final BuildListener buildListener;
    private final BuildCompletionListener buildCompletionListener;
    private final InternalBuildFinishedListener buildFinishedListener;
    private final BuildWorkPreparer workPreparer;
    private final BuildWorkExecutor workExecutor;
    private final BuildScopeServices buildServices;
    private final BuildModelController modelController;
    private final StateTransitionController<State> controller = new StateTransitionController<State>(State.Configure);
    private final GradleInternal gradle;
    private boolean hasTasks;

    public DefaultBuildLifecycleController(GradleInternal gradle, BuildModelController buildModelController, ExceptionAnalyser exceptionAnalyser, BuildListener buildListener, BuildCompletionListener buildCompletionListener, InternalBuildFinishedListener buildFinishedListener, BuildWorkPreparer workPreparer, BuildWorkExecutor workExecutor, BuildScopeServices buildServices) {
        this.gradle = gradle;
        this.modelController = buildModelController;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildListener = buildListener;
        this.workPreparer = workPreparer;
        this.workExecutor = workExecutor;
        this.buildCompletionListener = buildCompletionListener;
        this.buildFinishedListener = buildFinishedListener;
        this.buildServices = buildServices;
    }

    @Override
    public GradleInternal getGradle() {
        this.controller.assertNotInState(State.Finished);
        return this.gradle;
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        return this.controller.notInStateIgnoreOtherThreads(State.Finished, this.modelController::getLoadedSettings);
    }

    @Override
    public GradleInternal getConfiguredBuild() {
        return this.controller.notInStateIgnoreOtherThreads(State.Finished, this.modelController::getConfiguredModel);
    }

    @Override
    public void prepareToScheduleTasks() {
        this.controller.maybeTransition(State.Configure, State.TaskSchedule, () -> {
            this.hasTasks = true;
            this.modelController.prepareToScheduleTasks();
        });
    }

    @Override
    public void scheduleRequestedTasks() {
        this.populateWorkGraph(taskGraph -> this.modelController.scheduleRequestedTasks());
    }

    @Override
    public void populateWorkGraph(Consumer<? super TaskExecutionGraphInternal> action) {
        this.controller.inState(State.TaskSchedule, () -> this.workPreparer.populateWorkGraph(this.gradle, action));
    }

    @Override
    public void finalizeWorkGraph(boolean workScheduled) {
        if (workScheduled) {
            TaskExecutionGraphInternal taskGraph = this.gradle.getTaskGraph();
            taskGraph.populate();
        }
        this.finalizeGradleServices(this.gradle);
    }

    private void finalizeGradleServices(GradleInternal gradle) {
        BuildOutputCleanupRegistry buildOutputCleanupRegistry = (BuildOutputCleanupRegistry)gradle.getServices().get(BuildOutputCleanupRegistry.class);
        buildOutputCleanupRegistry.resolveOutputs();
    }

    @Override
    public ExecutionResult<Void> executeTasks() {
        return this.controller.tryTransition(State.TaskSchedule, State.Configure, () -> this.workExecutor.execute(this.gradle));
    }

    @Override
    public ExecutionResult<Void> finishBuild(@Nullable Throwable failure) {
        return this.controller.finish(State.Finished, stageFailures -> {
            ExecutionResult<Object> finishResult;
            Throwable reportableFailure = failure;
            if (reportableFailure == null && !stageFailures.getFailures().isEmpty()) {
                reportableFailure = this.exceptionAnalyser.transform(stageFailures.getFailures());
            }
            BuildResult buildResult = new BuildResult(this.hasTasks ? "Build" : "Configure", (Gradle)this.gradle, reportableFailure);
            try {
                this.buildListener.buildFinished(buildResult);
                this.buildFinishedListener.buildFinished((GradleInternal)buildResult.getGradle(), buildResult.getFailure() != null);
                finishResult = ExecutionResult.succeeded();
            }
            catch (Throwable t) {
                finishResult = ExecutionResult.failed(t);
            }
            return finishResult;
        });
    }

    @Override
    public void addListener(Object listener) {
        this.getGradle().addListener(listener);
    }

    public void stop() {
        try {
            CompositeStoppable.stoppable((Object[])new Object[]{this.buildServices}).stop();
        }
        finally {
            this.buildCompletionListener.completed();
        }
    }

    private static enum State implements StateTransitionController.State
    {
        Configure,
        TaskSchedule,
        Finished;

    }
}

