/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.ControlFlowBuilder;
import org.jetbrains.kotlin.cfg.ControlFlowProcessor;
import org.jetbrains.kotlin.cfg.GenerationTrigger;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.LoopInfo;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.pseudocode.ControlFlowInstructionsGenerator;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartFMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tower.TowerLevelsKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "builder", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;", "generate", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "subroutine", "Lorg/jetbrains/kotlin/psi/KtElement;", "eventOccurrencesRange", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "generateImplicitReturnValue", "", "bodyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "generatePseudocode", "processLocalDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "CFPVisitor", "CatchFinallyLabels", "cfg"})
public final class ControlFlowProcessor {
    @NotNull
    private final BindingTrace trace;
    @Nullable
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final ControlFlowBuilder builder;

    public ControlFlowProcessor(@NotNull BindingTrace trace, @Nullable LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        this.trace = trace;
        this.languageVersionSettings = languageVersionSettings;
        this.builder = new ControlFlowInstructionsGenerator();
    }

    @NotNull
    public final Pseudocode generatePseudocode(@NotNull KtElement subroutine) {
        Intrinsics.checkNotNullParameter((Object)subroutine, (String)"subroutine");
        Pseudocode pseudocode = this.generate(subroutine, null);
        ((PseudocodeImpl)pseudocode).postProcess();
        return pseudocode;
    }

    private final Pseudocode generate(KtElement subroutine, EventOccurrencesRange eventOccurrencesRange) {
        this.builder.enterSubroutine(subroutine, eventOccurrencesRange);
        CFPVisitor cfpVisitor = new CFPVisitor(this.builder);
        if (subroutine instanceof KtDeclarationWithBody && !(subroutine instanceof KtSecondaryConstructor)) {
            List<KtParameter> list2 = ((KtDeclarationWithBody)subroutine).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"subroutine.valueParameters");
            List<KtParameter> valueParameters2 = list2;
            for (KtParameter valueParameter2 : valueParameters2) {
                cfpVisitor.generateInstructions(valueParameter2);
            }
            KtExpression bodyExpression = ((KtDeclarationWithBody)subroutine).getBodyExpression();
            if (bodyExpression != null) {
                cfpVisitor.generateInstructions(bodyExpression);
                if (!((KtDeclarationWithBody)subroutine).hasBlockBody()) {
                    this.generateImplicitReturnValue(bodyExpression, subroutine);
                }
            }
        } else {
            cfpVisitor.generateInstructions(subroutine);
        }
        return this.builder.exitSubroutine(subroutine, eventOccurrencesRange);
    }

    private final void generateImplicitReturnValue(KtExpression bodyExpression, KtElement subroutine) {
        CallableDescriptor callableDescriptor = (CallableDescriptor)this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, subroutine);
        if (callableDescriptor == null) {
            return;
        }
        CallableDescriptor subroutineDescriptor = callableDescriptor;
        KotlinType returnType2 = subroutineDescriptor.getReturnType();
        if (returnType2 != null && KotlinBuiltIns.isUnit(returnType2) && subroutineDescriptor instanceof AnonymousFunctionDescriptor) {
            return;
        }
        PseudoValue pseudoValue = this.builder.getBoundValue(bodyExpression);
        if (pseudoValue == null) {
            return;
        }
        PseudoValue returnValue = pseudoValue;
        this.builder.returnValue(bodyExpression, returnValue, subroutine);
    }

    private final void processLocalDeclaration(KtDeclaration subroutine) {
        Label afterDeclaration = this.builder.createUnboundLabel("after local declaration");
        this.builder.nondeterministicJump(afterDeclaration, subroutine, null);
        this.generate(subroutine, null);
        this.builder.bindLabel(afterDeclaration);
    }

    public static final /* synthetic */ Pseudocode access$generate(ControlFlowProcessor $this, KtElement subroutine, EventOccurrencesRange eventOccurrencesRange) {
        return $this.generate(subroutine, eventOccurrencesRange);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CatchFinallyLabels;", "", "onException", "Lorg/jetbrains/kotlin/cfg/Label;", "toFinally", "tryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "(Lorg/jetbrains/kotlin/cfg/Label;Lorg/jetbrains/kotlin/cfg/Label;Lorg/jetbrains/kotlin/psi/KtTryExpression;)V", "getOnException", "()Lorg/jetbrains/kotlin/cfg/Label;", "getToFinally", "getTryExpression", "()Lorg/jetbrains/kotlin/psi/KtTryExpression;", "cfg"})
    private static final class CatchFinallyLabels {
        @Nullable
        private final Label onException;
        @Nullable
        private final Label toFinally;
        @Nullable
        private final KtTryExpression tryExpression;

        public CatchFinallyLabels(@Nullable Label onException, @Nullable Label toFinally, @Nullable KtTryExpression tryExpression) {
            this.onException = onException;
            this.toFinally = toFinally;
            this.tryExpression = tryExpression;
        }

        @Nullable
        public final Label getOnException() {
            return this.onException;
        }

        @Nullable
        public final Label getToFinally() {
            return this.toFinally;
        }

        @Nullable
        public final KtTryExpression getTryExpression() {
            return this.tryExpression;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c3\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\t\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0002\u00ef\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010\u001f\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010\u00162\u0006\u0010!\u001a\u00020\u0016H\u0002J(\u0010\"\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00162\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160#2\u0006\u0010$\u001a\u00020%H\u0002J5\u0010\"\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160&\"\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010'J1\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160&\"\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010'J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0002J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0#2\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160#H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010+\u001a\u00020/H\u0002J\u001e\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u0002022\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0002J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020/0#2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00104\u001a\u00020\u000e2\u0006\u00101\u001a\u000202H\u0002J(\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u0002022\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c082\u0006\u00109\u001a\u00020/H\u0002J\u0010\u0010:\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020;H\u0002J\u0010\u0010=\u001a\u00020\u00112\u0006\u0010>\u001a\u00020\u0016H\u0002J\u0014\u0010=\u001a\u00020?2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u0010\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020EH\u0002J\u0018\u0010G\u001a\u00020\u000e2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u001cH\u0002J\u0010\u0010K\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\b\u0010N\u001a\u00020\u000eH\u0002J,\u0010O\u001a\u00020\u000e2\b\u0010P\u001a\u0004\u0018\u00010/2\u0018\u0010Q\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u00020S0\u00130RH\u0002J\u0018\u0010T\u001a\u00020\u00112\u0006\u0010+\u001a\u00020/2\u0006\u0010U\u001a\u00020VH\u0002J\u0012\u0010W\u001a\u0004\u0018\u00010X2\u0006\u0010+\u001a\u00020YH\u0002J8\u0010Z\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\\0[2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\\2\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\\0[H\u0002J2\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\\0[2\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c082\f\u0010b\u001a\b\u0012\u0004\u0012\u00020S0\u0013H\u0002J\u0014\u0010c\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0012\u0010d\u001a\u0004\u0018\u00010e2\u0006\u0010+\u001a\u00020fH\u0002J\u0012\u0010g\u001a\u0004\u0018\u00010e2\u0006\u0010+\u001a\u00020/H\u0002J\u0010\u0010h\u001a\u00020i2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010j\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c082\b\u0010+\u001a\u0004\u0018\u00010/H\u0002J\u0012\u0010k\u001a\u0004\u0018\u00010e2\u0006\u0010+\u001a\u00020/H\u0002J:\u0010l\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020m0[2\u0006\u0010>\u001a\u00020\u00162\b\u0010n\u001a\u0004\u0018\u00010m2\u0012\u0010o\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020m0[H\u0002J \u0010l\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020m0p2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u0012\u0010q\u001a\u00020i2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u001a\u0010r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c082\b\u0010s\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010t\u001a\u00020\u00112\u0006\u0010+\u001a\u00020uH\u0002J\u0010\u0010v\u001a\u00020\u00112\u0006\u0010w\u001a\u00020xH\u0002J\u0018\u0010y\u001a\u00020\u00112\u0006\u0010z\u001a\u00020f2\u0006\u0010{\u001a\u00020|H\u0002J\u0018\u0010}\u001a\u00020\u00112\u0006\u0010z\u001a\u00020f2\u0006\u0010{\u001a\u00020eH\u0002J\u0010\u0010~\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u007f\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020/0#2\u0006\u0010!\u001a\u00020/H\u0002J\u0012\u0010\u0080\u0001\u001a\u00020\u000e2\u0007\u0010\u0081\u0001\u001a\u00020EH\u0002J\u0018\u0010\u0082\u0001\u001a\u00020\u000e2\r\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020\u001e0#H\u0002J\u0011\u0010\u0084\u0001\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u0085\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u0086\u0001H\u0016J\u0013\u0010\u0087\u0001\u001a\u00020\u000e2\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001H\u0016J\u0011\u0010\u008a\u0001\u001a\u00020\u000e2\u0006\u0010+\u001a\u000202H\u0016J+\u0010\u008b\u0001\u001a\u00020\u000e2\b\u00106\u001a\u0004\u0018\u00010/2\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c082\u0006\u00109\u001a\u00020/H\u0002J\u0011\u0010\u008c\u0001\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020;H\u0016J\u0012\u0010\u008d\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u008e\u0001H\u0016J\u0011\u0010\u008f\u0001\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020uH\u0016J\u0012\u0010\u0090\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u0091\u0001H\u0016J\u0012\u0010\u0092\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u0093\u0001H\u0016J\u0013\u0010\u0094\u0001\u001a\u00020\u000e2\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0016J\u0012\u0010\u0097\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u0098\u0001H\u0016J\u0012\u0010\u0099\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u009a\u0001H\u0016J\u0013\u0010\u009b\u0001\u001a\u00020\u000e2\b\u0010\u009c\u0001\u001a\u00030\u009d\u0001H\u0016J\u0012\u0010\u009e\u0001\u001a\u00020\u000e2\u0007\u0010H\u001a\u00030\u009f\u0001H\u0016J\u001b\u0010\u009e\u0001\u001a\u00020\u000e2\u0007\u0010H\u001a\u00030\u009f\u00012\u0007\u0010\u00a0\u0001\u001a\u00020\u0011H\u0002J\u0012\u0010\u00a1\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00a2\u0001H\u0016J\u0012\u0010\u00a3\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00a4\u0001H\u0016J\u0011\u0010\u00a5\u0001\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0016J!\u0010\u00a6\u0001\u001a\u00020\u000e2\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u00012\f\b\u0002\u0010\u00a9\u0001\u001a\u0005\u0018\u00010\u00aa\u0001H\u0002J\u0012\u0010\u00ab\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00ac\u0001H\u0016J\u0013\u0010\u00ad\u0001\u001a\u00020\u000e2\b\u0010\u00ae\u0001\u001a\u00030\u00af\u0001H\u0016J\u001d\u0010\u00b0\u0001\u001a\u00020\u000e2\b\u0010\u00b1\u0001\u001a\u00030\u00a8\u00012\b\u0010\u00a9\u0001\u001a\u00030\u00aa\u0001H\u0002J\u0012\u0010\u00b2\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00b3\u0001H\u0016J\u0011\u0010\u00b4\u0001\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0013\u0010\u00b5\u0001\u001a\u00020\u000e2\b\u0010\u00b6\u0001\u001a\u00030\u00b7\u0001H\u0016J\u0012\u0010\u00b8\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00b9\u0001H\u0016J\u0013\u0010\u00ba\u0001\u001a\u00020\u000e2\b\u0010\u00bb\u0001\u001a\u00030\u00bc\u0001H\u0016J\u0013\u0010\u00bd\u0001\u001a\u00020\u000e2\b\u0010\u00a7\u0001\u001a\u00030\u00be\u0001H\u0016J\u0013\u0010\u00bf\u0001\u001a\u00020\u000e2\b\u0010\u00c0\u0001\u001a\u00030\u00c1\u0001H\u0016J\u0012\u0010\u00c2\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00c3\u0001H\u0016J\u0011\u0010\u00c4\u0001\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u00c5\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00c6\u0001H\u0016J\u0013\u0010\u00c7\u0001\u001a\u00020\u000e2\b\u0010\u00c8\u0001\u001a\u00030\u00c9\u0001H\u0016J\u0013\u0010\u00ca\u0001\u001a\u00020\u000e2\b\u0010\u00cb\u0001\u001a\u00030\u00cc\u0001H\u0016J\u0012\u0010\u00cd\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00ce\u0001H\u0016J\u0011\u0010\u00cf\u0001\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u0019H\u0016J\u0013\u0010\u00d0\u0001\u001a\u00020\u000e2\b\u0010\u00d1\u0001\u001a\u00030\u00d2\u0001H\u0016J\u0013\u0010\u00d3\u0001\u001a\u00020\u000e2\b\u0010\u00d4\u0001\u001a\u00030\u00d5\u0001H\u0016J\u0012\u0010\u00d6\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00d7\u0001H\u0016J\u0012\u0010\u00d8\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00d9\u0001H\u0016J\u0012\u0010\u00da\u0001\u001a\u00020\u000e2\u0007\u0010A\u001a\u00030\u00db\u0001H\u0016J\u0013\u0010\u00dc\u0001\u001a\u00020\u000e2\b\u0010\u009c\u0001\u001a\u00030\u00dd\u0001H\u0016J\u0013\u0010\u00de\u0001\u001a\u00020\u000e2\b\u0010\u00ae\u0001\u001a\u00030\u00df\u0001H\u0016J\u0012\u0010\u00e0\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00e1\u0001H\u0016J\u0012\u0010\u00e2\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00e3\u0001H\u0016J\u0011\u0010\u00e4\u0001\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020YH\u0016J\u0013\u0010\u00e5\u0001\u001a\u00020\u000e2\b\u0010\u00e6\u0001\u001a\u00030\u00e7\u0001H\u0016J\u0012\u0010\u00e8\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00e9\u0001H\u0016J\u0012\u0010\u00ea\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00eb\u0001H\u0016J\u0012\u0010\u00ec\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00ed\u0001H\u0016J\u0011\u0010\u00ee\u0001\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR*\u0010\u000b\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000f0\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00f0\u0001"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "builder", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;", "(Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor;Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;)V", "catchFinallyStack", "Ljava/util/Stack;", "Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CatchFinallyLabels;", "conditionVisitor", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$conditionVisitor$1", "Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$conditionVisitor$1;", "deferredGeneratorsStack", "", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/cfg/DeferredGenerator;", "checkAndGenerateCall", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "checkNothingType", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "checkReturnLabelTarget", "returnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "labeledElement", "computePseudoValueForParameter", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "copyValue", "from", "to", "createNonSyntheticValue", "", "kind", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MagicKind;", "", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MagicKind;[Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "createSyntheticValue", "instructionElement", "declareLoopParameter", "expression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "elementsToValues", "generateAndGetReceiverIfAny", "Lorg/jetbrains/kotlin/psi/KtExpression;", "generateArrayAccess", "arrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "generateArrayAccessArguments", "generateArrayAccessWithoutCall", "generateArrayAssignment", "lhs", "rhsDeferredValue", "Lkotlin/Function0;", "parentExpression", "generateBooleanOperation", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "generateBothArgumentsAndMark", "generateCall", "callElement", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/InstructionWithValue;", "generateCallOrMarkUnresolved", "call", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "generateDeclarationForLocalClassOrObjectIfNeeded", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "generateHeaderDelegationSpecifiers", "generateInitializer", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "initValue", "generateInitializersForClassOrObject", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "generateInstructions", "generateJumpsToCatchAndFinally", "generateLoopConventionCall", "loopRange", "callSlice", "Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateQualifier", "qualifier", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "generateTryAndCatches", "Lorg/jetbrains/kotlin/cfg/Label;", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "generateValueArgument", "Lorg/jetbrains/kotlin/com/intellij/util/SmartFMap;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "parameterDescriptor", "parameterValuesArg", "getArraySetterArguments", "setResolvedCall", "getBoundOrUnreachableValue", "getCorrespondingLoop", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "getCorrespondingLoopWithoutLabel", "getDeclarationAccessTarget", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/AccessTarget;", "getDeferredValue", "getNearestLoopExpression", "getReceiverValues", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "receiver", "receiverValuesArg", "", "getResolvedCallAccessTarget", "getValueAsFunction", "value", "isBlockInDoWhile", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "isIncrementOrDecrement", "operationType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "jumpCrossesTryCatchBoundary", "jumpExpression", "jumpTarget", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "jumpDoesNotCrossFunctionBoundary", "mark", "mergeValues", "processEntryOrObject", "entryOrObject", "processParameters", "parameters", "returnCrossesTryCatchBoundary", "visitAnnotatedExpression", "Lorg/jetbrains/kotlin/psi/KtAnnotatedExpression;", "visitAnonymousInitializer", "classInitializer", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "visitArrayAccessExpression", "visitAssignment", "visitBinaryExpression", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitBlockExpression", "visitBreakExpression", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "visitContinueExpression", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "visitDelegatedSuperTypeEntry", "specifier", "Lorg/jetbrains/kotlin/psi/KtDelegatedSuperTypeEntry;", "visitDestructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "generateWriteForEntries", "visitDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "visitDoubleColonExpression", "Lorg/jetbrains/kotlin/psi/KtDoubleColonExpression;", "visitForExpression", "visitFunction", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "eventOccurrencesRange", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitInitializerList", "list", "Lorg/jetbrains/kotlin/psi/KtInitializerList;", "visitInlinedFunction", "lambdaFunctionLiteral", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitKtElement", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitObjectDeclaration", "objectDeclaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "visitObjectLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "visitParameter", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitPropertyAccessor", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "visitQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitReturnExpression", "visitScript", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "visitSecondaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitSuperTypeCallEntry", "Lorg/jetbrains/kotlin/psi/KtSuperTypeCallEntry;", "visitSuperTypeEntry", "Lorg/jetbrains/kotlin/psi/KtSuperTypeEntry;", "visitSuperTypeList", "Lorg/jetbrains/kotlin/psi/KtSuperTypeList;", "visitThisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "visitThrowExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "visitTryExpression", "visitTypeProjection", "typeProjection", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "writeLoopParameterAssignment", "FinallyBlockGenerator", "cfg"})
    private final class CFPVisitor
    extends KtVisitorVoid {
        @NotNull
        private final ControlFlowBuilder builder;
        @NotNull
        private final Stack<CatchFinallyLabels> catchFinallyStack;
        @NotNull
        private final Stack<List<Function1<ControlFlowBuilder, Unit>>> deferredGeneratorsStack;
        @NotNull
        private final conditionVisitor.1 conditionVisitor;

        public CFPVisitor(ControlFlowBuilder builder2) {
            Intrinsics.checkNotNullParameter((Object)ControlFlowProcessor.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            this.builder = builder2;
            this.catchFinallyStack = new Stack();
            this.deferredGeneratorsStack = new Stack();
            this.conditionVisitor = new KtVisitorVoid(this){
                final /* synthetic */ CFPVisitor this$0;
                {
                    this.this$0 = $receiver;
                }

                private final KtExpression getSubjectExpression(KtWhenCondition condition) {
                    PsiElement $this$getStrictParentOfType$iv = condition;
                    boolean $i$f$getStrictParentOfType = false;
                    KtWhenExpression ktWhenExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtWhenExpression.class, true);
                    return ktWhenExpression == null ? null : ktWhenExpression.getSubjectExpression();
                }

                public void visitWhenConditionInRange(@NotNull KtWhenConditionInRange condition) {
                    Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
                    KtOperationReferenceExpression ktOperationReferenceExpression = condition.getOperationReference();
                    Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"condition.operationReference");
                    if (!CFPVisitor.access$generateCall(this.this$0, ktOperationReferenceExpression)) {
                        KtExpression rangeExpression = condition.getRangeExpression();
                        this.this$0.generateInstructions(rangeExpression);
                        KtElement[] ktElementArray = new KtElement[]{rangeExpression};
                        CFPVisitor.access$createNonSyntheticValue(this.this$0, condition, MagicKind.UNRESOLVED_CALL, ktElementArray);
                    }
                }

                public void visitWhenConditionIsPattern(@NotNull KtWhenConditionIsPattern condition) {
                    Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
                    CFPVisitor.access$mark(this.this$0, condition);
                    KtElement[] ktElementArray = new KtElement[]{this.getSubjectExpression(condition)};
                    CFPVisitor.access$createNonSyntheticValue(this.this$0, condition, MagicKind.IS, ktElementArray);
                }

                public void visitWhenConditionWithExpression(@NotNull KtWhenConditionWithExpression condition) {
                    Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
                    CFPVisitor.access$mark(this.this$0, condition);
                    KtExpression expression2 = condition.getExpression();
                    this.this$0.generateInstructions(expression2);
                    KtExpression subjectExpression = this.getSubjectExpression(condition);
                    if (subjectExpression != null) {
                        KtElement[] ktElementArray = new KtElement[]{subjectExpression, expression2};
                        CFPVisitor.access$createNonSyntheticValue(this.this$0, condition, MagicKind.EQUALS_IN_WHEN_CONDITION, ktElementArray);
                    } else {
                        CFPVisitor.access$copyValue(this.this$0, expression2, condition);
                    }
                }

                public void visitKtElement(@NotNull KtElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"[ControlFlowProcessor] ", (Object)element));
                }
            };
        }

        private final void mark(KtElement element) {
            this.builder.mark(element);
        }

        public final void generateInstructions(@Nullable KtElement element) {
            if (element == null) {
                return;
            }
            element.accept(this);
            this.checkNothingType(element);
        }

        private final void checkNothingType(KtElement element) {
            if (!(element instanceof KtExpression)) {
                return;
            }
            KtExpression ktExpression = KtPsiUtil.deparenthesize((KtExpression)element);
            if (ktExpression == null) {
                return;
            }
            KtExpression ktExpression2 = ktExpression;
            KtExpression expression2 = ktExpression2;
            if (expression2 instanceof KtStatementExpression || expression2 instanceof KtTryExpression || expression2 instanceof KtIfExpression || expression2 instanceof KtWhenExpression) {
                return;
            }
            KotlinType type2 = ControlFlowProcessor.this.trace.getBindingContext().getType(expression2);
            if (type2 != null && KotlinBuiltIns.isNothing(type2)) {
                this.builder.jumpToError(expression2);
            }
        }

        private final PseudoValue createSyntheticValue(KtElement instructionElement, MagicKind kind, KtElement ... from) {
            return this.builder.magic(instructionElement, null, this.elementsToValues(ArraysKt.asList((Object[])from)), kind).getOutputValue();
        }

        private final PseudoValue createNonSyntheticValue(KtElement to, List<? extends KtElement> from, MagicKind kind) {
            return this.builder.magic(to, to, this.elementsToValues(from), kind).getOutputValue();
        }

        private final PseudoValue createNonSyntheticValue(KtElement to, MagicKind kind, KtElement ... from) {
            return this.createNonSyntheticValue(to, ArraysKt.asList((Object[])from), kind);
        }

        private final void mergeValues(List<? extends KtExpression> from, KtExpression to) {
            this.builder.merge(to, this.elementsToValues(from));
        }

        private final void copyValue(KtElement from, KtElement to) {
            PseudoValue pseudoValue = this.getBoundOrUnreachableValue(from);
            if (pseudoValue != null) {
                PseudoValue pseudoValue2 = pseudoValue;
                boolean bl = false;
                boolean bl2 = false;
                PseudoValue it = pseudoValue2;
                boolean bl3 = false;
                this.builder.bindValue(it, to);
            }
        }

        private final PseudoValue getBoundOrUnreachableValue(KtElement element) {
            if (element == null) {
                return null;
            }
            PseudoValue value2 = this.builder.getBoundValue(element);
            return value2 != null || element instanceof KtDeclaration ? value2 : this.builder.newValue(element);
        }

        /*
         * WARNING - void declaration
         */
        private final List<PseudoValue> elementsToValues(List<? extends KtElement> from) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = from;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PseudoValue pseudoValue;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtElement element = (KtElement)element$iv$iv;
                boolean bl2 = false;
                if (this.getBoundOrUnreachableValue(element) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                PseudoValue it$iv$iv = pseudoValue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final void generateInitializer(KtDeclaration declaration2, PseudoValue initValue) {
            this.builder.write(declaration2, declaration2, initValue, this.getDeclarationAccessTarget(declaration2), MapsKt.emptyMap());
        }

        private final AccessTarget getResolvedCallAccessTarget(KtElement element) {
            AccessTarget.Call call2;
            Object object = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(element, (BindingContext)object);
            if (resolvedCall2 == null) {
                call2 = null;
            } else {
                object = resolvedCall2;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                call2 = new AccessTarget.Call((ResolvedCall<?>)it);
            }
            AccessTarget.Call call3 = call2;
            return call3 == null ? (AccessTarget)AccessTarget.BlackBox.INSTANCE : (AccessTarget)call3;
        }

        private final AccessTarget getDeclarationAccessTarget(KtElement element) {
            DeclarationDescriptor descriptor2 = ControlFlowProcessor.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
            return descriptor2 instanceof VariableDescriptor ? (AccessTarget)new AccessTarget.Declaration((VariableDescriptor)descriptor2) : (AccessTarget)AccessTarget.BlackBox.INSTANCE;
        }

        @Override
        public void visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtExpression innerExpression = expression2.getExpression();
            if (innerExpression != null) {
                this.generateInstructions(innerExpression);
                this.copyValue(innerExpression, expression2);
            }
        }

        @Override
        public void visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtExpression baseExpression = expression2.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression);
                this.copyValue(baseExpression, expression2);
            }
        }

        @Override
        public void visitThisExpression(@NotNull KtThisExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtElement ktElement = expression2;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            if (resolvedCall2 == null) {
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, new KtElement[0]);
                return;
            }
            CallableDescriptor resultingDescriptor = resolvedCall2.getResultingDescriptor();
            if (resultingDescriptor instanceof ReceiverParameterDescriptor) {
                this.builder.readVariable(expression2, resolvedCall2, this.getReceiverValues(resolvedCall2));
            }
            KtElement ktElement2 = expression2;
            KtReferenceExpression ktReferenceExpression = expression2.getInstanceReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktReferenceExpression, (String)"expression.instanceReference");
            this.copyValue(ktElement2, ktReferenceExpression);
        }

        @Override
        public void visitConstantExpression(@NotNull KtConstantExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtExpression ktExpression = expression2;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            CompileTimeConstant<?> constant = ConstantExpressionEvaluator.Companion.getConstant(ktExpression, bindingContext);
            this.builder.loadConstant(expression2, constant);
        }

        @Override
        public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtElement ktElement = expression2;
            KtElement[] ktElementArray = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)ktElementArray, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, (BindingContext)ktElementArray);
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                this.generateCall(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall());
            } else {
                Qualifier qualifier;
                if (resolvedCall2 == null && (qualifier = (Qualifier)ControlFlowProcessor.this.trace.getBindingContext().get(BindingContext.QUALIFIER, expression2)) != null && this.generateQualifier(expression2, qualifier)) {
                    return;
                }
                if (!this.generateCall(expression2) && !(expression2.getParent() instanceof KtCallExpression)) {
                    ktElementArray = new KtElement[]{this.generateAndGetReceiverIfAny(expression2)};
                    this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, ktElementArray);
                }
            }
        }

        @Override
        public void visitLabeledExpression(@NotNull KtLabeledExpression expression2) {
            KtExpression deparenthesizedBaseExpression;
            KtSimpleNameExpression labelNameExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtExpression baseExpression = expression2.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression);
                this.copyValue(baseExpression, expression2);
            }
            if (!((labelNameExpression = expression2.getTargetLabel()) == null || (deparenthesizedBaseExpression = KtPsiUtil.deparenthesize(expression2)) instanceof KtLambdaExpression || deparenthesizedBaseExpression instanceof KtLoopExpression || deparenthesizedBaseExpression instanceof KtNamedFunction)) {
                ControlFlowProcessor.this.trace.report(Errors.REDUNDANT_LABEL_WARNING.on((KtElement)((PsiElement)labelNameExpression)));
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
            KtOperationReferenceExpression operationReference = ktOperationReferenceExpression;
            IElementType operationType = operationReference.getReferencedNameElementType();
            KtExpression left = expression2.getLeft();
            KtExpression right = expression2.getRight();
            if (operationType == KtTokens.ANDAND || operationType == KtTokens.OROR) {
                this.generateBooleanOperation(expression2);
            } else if (operationType == KtTokens.EQ) {
                this.visitAssignment(left, this.getDeferredValue(right), expression2);
            } else {
                Map<KtSingleValueToken, Name> map = OperatorConventions.ASSIGNMENT_OPERATIONS;
                Intrinsics.checkNotNullExpressionValue(map, (String)"ASSIGNMENT_OPERATIONS");
                map = map;
                boolean bl = false;
                if (map.containsKey(operationType)) {
                    KtElement ktElement = expression2;
                    BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
                    if (resolvedCall2 != null) {
                        PseudoValue rhsValue = this.generateCall(resolvedCall2).getOutputValue();
                        Name assignMethodName = OperatorConventions.getNameForOperationSymbol((KtToken)expression2.getOperationToken());
                        if (!Intrinsics.areEqual((Object)resolvedCall2.getResultingDescriptor().getName(), (Object)assignMethodName)) {
                            this.visitAssignment(left, this.getValueAsFunction(rhsValue), expression2);
                        }
                    } else {
                        this.generateBothArgumentsAndMark(expression2);
                    }
                } else if (operationType == KtTokens.ELVIS) {
                    this.generateInstructions(left);
                    this.mark(expression2);
                    Label afterElvis = this.builder.createUnboundLabel("after elvis operator");
                    this.builder.jumpOnTrue(afterElvis, expression2, this.builder.getBoundValue(left));
                    this.generateInstructions(right);
                    this.builder.bindLabel(afterElvis);
                    Object[] objectArray = new KtExpression[]{left, right};
                    this.mergeValues(CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])objectArray)), expression2);
                } else if (!this.generateCall(expression2)) {
                    this.generateBothArgumentsAndMark(expression2);
                }
            }
        }

        private final void generateBooleanOperation(KtBinaryExpression expression2) {
            IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
            KtExpression left = expression2.getLeft();
            KtExpression right = expression2.getRight();
            Label resultLabel = this.builder.createUnboundLabel("result of boolean operation");
            this.generateInstructions(left);
            if (operationType == KtTokens.ANDAND) {
                this.builder.jumpOnFalse(resultLabel, expression2, this.builder.getBoundValue(left));
            } else {
                this.builder.jumpOnTrue(resultLabel, expression2, this.builder.getBoundValue(left));
            }
            this.generateInstructions(right);
            this.builder.bindLabel(resultLabel);
            ControlFlowBuilder.PredefinedOperation operation = operationType == KtTokens.ANDAND ? ControlFlowBuilder.PredefinedOperation.AND : ControlFlowBuilder.PredefinedOperation.OR;
            Object[] objectArray = new KtExpression[]{left, right};
            this.builder.predefinedOperation(expression2, operation, this.elementsToValues(CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])objectArray))));
        }

        private final Function0<PseudoValue> getValueAsFunction(PseudoValue value2) {
            return (Function0)new Function0<PseudoValue>(value2){
                final /* synthetic */ PseudoValue $value;
                {
                    this.$value = $value;
                    super(0);
                }

                @Nullable
                public final PseudoValue invoke() {
                    return this.$value;
                }
            };
        }

        private final Function0<PseudoValue> getDeferredValue(KtExpression expression2) {
            return (Function0)new Function0<PseudoValue>(this, expression2){
                final /* synthetic */ CFPVisitor this$0;
                final /* synthetic */ KtExpression $expression;
                {
                    this.this$0 = $receiver;
                    this.$expression = $expression;
                    super(0);
                }

                @Nullable
                public final PseudoValue invoke() {
                    this.this$0.generateInstructions(this.$expression);
                    return CFPVisitor.access$getBoundOrUnreachableValue(this.this$0, this.$expression);
                }
            };
        }

        private final void generateBothArgumentsAndMark(KtBinaryExpression expression2) {
            KtExpression right;
            KtExpression left = KtPsiUtil.deparenthesize(expression2.getLeft());
            if (left != null) {
                this.generateInstructions(left);
            }
            if ((right = expression2.getRight()) != null) {
                this.generateInstructions(right);
            }
            this.mark(expression2);
            KtElement[] ktElementArray = new KtElement[]{left, right};
            this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, ktElementArray);
        }

        private final void visitAssignment(KtExpression lhs, Function0<? extends PseudoValue> rhsDeferredValue, KtExpression parentExpression) {
            PseudoValue rightValue;
            PseudoValue pseudoValue;
            KtExpression left = KtPsiUtil.deparenthesize(lhs);
            if (left == null) {
                List list2;
                PseudoValue pseudoValue2 = (PseudoValue)rhsDeferredValue.invoke();
                if (pseudoValue2 == null) {
                    list2 = null;
                } else {
                    PseudoValue pseudoValue3 = pseudoValue2;
                    boolean bl = false;
                    boolean bl2 = false;
                    PseudoValue it = pseudoValue3;
                    boolean bl3 = false;
                    list2 = CollectionsKt.listOf((Object)it);
                }
                List list3 = list2;
                List arguments2 = list3 == null ? CollectionsKt.emptyList() : list3;
                this.builder.magic(parentExpression, parentExpression, arguments2, MagicKind.UNSUPPORTED_ELEMENT);
                return;
            }
            if (left instanceof KtArrayAccessExpression) {
                this.generateArrayAssignment((KtArrayAccessExpression)left, rhsDeferredValue, parentExpression);
                return;
            }
            SmartFMap smartFMap = SmartFMap.emptyMap();
            Intrinsics.checkNotNullExpressionValue(smartFMap, (String)"emptyMap<PseudoValue, ReceiverValue>()");
            Map<PseudoValue, ReceiverValue> receiverValues = smartFMap;
            AccessTarget accessTarget = AccessTarget.BlackBox.INSTANCE;
            if (left instanceof KtSimpleNameExpression || left instanceof KtQualifiedExpression) {
                accessTarget = this.getResolvedCallAccessTarget(KtPsiUtilKt.getQualifiedElementSelector(left));
                if (accessTarget instanceof AccessTarget.Call) {
                    receiverValues = this.getReceiverValues(((AccessTarget.Call)accessTarget).getResolvedCall());
                }
            } else if (left instanceof KtProperty) {
                accessTarget = this.getDeclarationAccessTarget(left);
            }
            if (accessTarget == AccessTarget.BlackBox.INSTANCE && !(left instanceof KtProperty)) {
                this.generateInstructions(left);
                KtElement[] ktElementArray = new KtElement[]{left};
                this.createSyntheticValue(left, MagicKind.VALUE_CONSUMER, ktElementArray);
            }
            PseudoValue rValue = (pseudoValue = (rightValue = (PseudoValue)rhsDeferredValue.invoke())) == null ? this.createSyntheticValue(parentExpression, MagicKind.UNRECOGNIZED_WRITE_RHS, new KtElement[0]) : pseudoValue;
            this.builder.write(parentExpression, left, rValue, accessTarget, receiverValues);
        }

        private final void generateArrayAssignment(KtArrayAccessExpression lhs, Function0<? extends PseudoValue> rhsDeferredValue, KtExpression parentExpression) {
            ResolvedCall setResolvedCall = (ResolvedCall)ControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_SET, lhs);
            if (setResolvedCall == null) {
                this.generateArrayAccess(lhs, null);
                Object[] objectArray = new PseudoValue[]{this.getBoundOrUnreachableValue(lhs), (PseudoValue)rhsDeferredValue.invoke()};
                List arguments2 = CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])objectArray));
                this.builder.magic(parentExpression, parentExpression, arguments2, MagicKind.UNRESOLVED_CALL);
                return;
            }
            if (((KtOperationExpression)parentExpression).getOperationReference().getReferencedNameElementType() == KtTokens.EQ) {
                this.mark(lhs);
            }
            this.generateInstructions(lhs.getArrayExpression());
            Map<PseudoValue, ReceiverValue> receiverValues = this.getReceiverValues(setResolvedCall);
            SmartFMap<PseudoValue, ValueParameterDescriptor> argumentValues = this.getArraySetterArguments(rhsDeferredValue, setResolvedCall);
            this.builder.call(parentExpression, setResolvedCall, receiverValues, (Map<PseudoValue, ? extends ValueParameterDescriptor>)argumentValues);
        }

        /*
         * WARNING - void declaration
         */
        private final SmartFMap<PseudoValue, ValueParameterDescriptor> getArraySetterArguments(Function0<? extends PseudoValue> rhsDeferredValue, ResolvedCall<FunctionDescriptor> setResolvedCall) {
            void destination$iv;
            Object list$iv;
            Object object;
            void $this$flatMapTo$iv;
            Iterable<ValueParameterDescriptor> iterable = setResolvedCall.getResultingDescriptor().getValueParameters();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"setResolvedCall.resultin\u2026escriptor.valueParameters");
            iterable = iterable;
            Collection collection = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                ValueParameterDescriptor descriptor2 = (ValueParameterDescriptor)element$iv;
                boolean bl = false;
                object = setResolvedCall.getValueArguments().get(descriptor2);
                List<ValueArgument> list2 = object == null ? null : object.getArguments();
                list$iv = list2 == null ? CollectionsKt.emptyList() : list2;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            ArrayList valueArguments = (ArrayList)destination$iv;
            ValueArgument rhsArgument = (ValueArgument)CollectionsKt.lastOrNull((List)valueArguments);
            SmartFMap<PseudoValue, ValueParameterDescriptor> smartFMap = SmartFMap.emptyMap();
            Intrinsics.checkNotNullExpressionValue(smartFMap, (String)"emptyMap<PseudoValue, ValueParameterDescriptor>()");
            Object argumentValues = smartFMap;
            for (ValueArgument valueArgument : valueArguments) {
                ArgumentMapping bl = setResolvedCall.getArgumentMapping(valueArgument);
                Object object2 = list$iv = bl instanceof ArgumentMatch ? (ArgumentMatch)bl : null;
                if (list$iv == null) continue;
                Object argumentMapping = list$iv;
                ValueParameterDescriptor parameterDescriptor = argumentMapping.getValueParameter();
                if (valueArgument != rhsArgument) {
                    Intrinsics.checkNotNullExpressionValue((Object)valueArgument, (String)"valueArgument");
                    argumentValues = this.generateValueArgument(valueArgument, parameterDescriptor, (SmartFMap<PseudoValue, ValueParameterDescriptor>)argumentValues);
                    continue;
                }
                PseudoValue rhsValue = (PseudoValue)rhsDeferredValue.invoke();
                if (rhsValue == null) continue;
                object = ((SmartFMap)argumentValues).plus((PseudoValue)rhsValue, (ValueParameterDescriptor)parameterDescriptor);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"argumentValues.plus(rhsValue, parameterDescriptor)");
                argumentValues = object;
            }
            return argumentValues;
        }

        private final void generateArrayAccess(KtArrayAccessExpression arrayAccessExpression2, ResolvedCall<?> resolvedCall2) {
            if (this.builder.getBoundValue(arrayAccessExpression2) != null) {
                return;
            }
            this.mark(arrayAccessExpression2);
            if (!this.checkAndGenerateCall(resolvedCall2)) {
                this.generateArrayAccessWithoutCall(arrayAccessExpression2);
            }
        }

        private final void generateArrayAccessWithoutCall(KtArrayAccessExpression arrayAccessExpression2) {
            this.createNonSyntheticValue((KtElement)arrayAccessExpression2, this.generateArrayAccessArguments(arrayAccessExpression2), MagicKind.UNRESOLVED_CALL);
        }

        private final List<KtExpression> generateArrayAccessArguments(KtArrayAccessExpression arrayAccessExpression2) {
            ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
            KtExpression arrayExpression = arrayAccessExpression2.getArrayExpression();
            if (arrayExpression != null) {
                inputExpressions.add(arrayExpression);
            }
            this.generateInstructions(arrayExpression);
            for (KtExpression index2 : arrayAccessExpression2.getIndexExpressions()) {
                this.generateInstructions(index2);
                inputExpressions.add(index2);
            }
            return inputExpressions;
        }

        @Override
        public void visitUnaryExpression(@NotNull KtUnaryExpression expression2) {
            PseudoValue rhsValue;
            PseudoValue pseudoValue;
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtSimpleNameExpression ktSimpleNameExpression = expression2.getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expression.operationReference");
            KtSimpleNameExpression operationSign = ktSimpleNameExpression;
            IElementType operationType = operationSign.getReferencedNameElementType();
            KtExpression ktExpression2 = expression2.getBaseExpression();
            if (ktExpression2 == null) {
                return;
            }
            KtExpression baseExpression = ktExpression = ktExpression2;
            if (KtTokens.EXCLEXCL == operationType) {
                this.generateInstructions(baseExpression);
                this.builder.predefinedOperation(expression2, ControlFlowBuilder.PredefinedOperation.NOT_NULL_ASSERTION, this.elementsToValues(CollectionsKt.listOf((Object)baseExpression)));
                return;
            }
            boolean incrementOrDecrement = this.isIncrementOrDecrement(operationType);
            KtElement ktElement = expression2;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            if (resolvedCall2 != null) {
                pseudoValue = this.generateCall(resolvedCall2).getOutputValue();
            } else {
                this.generateInstructions(baseExpression);
                KtElement[] ktElementArray = new KtElement[]{baseExpression};
                pseudoValue = rhsValue = this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, ktElementArray);
            }
            if (incrementOrDecrement && resolvedCall2 != null) {
                this.visitAssignment(baseExpression, this.getValueAsFunction(rhsValue), expression2);
                if (expression2 instanceof KtPostfixExpression) {
                    this.copyValue(baseExpression, expression2);
                }
            }
        }

        private final boolean isIncrementOrDecrement(IElementType operationType) {
            return operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS;
        }

        @Override
        public void visitIfExpression(@NotNull KtIfExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark(expression2);
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>(2);
            KtExpression condition = expression2.getCondition();
            this.generateInstructions(condition);
            Label elseLabel = this.builder.createUnboundLabel("else branch");
            this.builder.jumpOnFalse(elseLabel, expression2, this.builder.getBoundValue(condition));
            KtExpression thenBranch = expression2.getThen();
            if (thenBranch != null) {
                branches.add(thenBranch);
                this.generateInstructions(thenBranch);
            } else {
                this.builder.loadUnit(expression2);
            }
            Label resultLabel = this.builder.createUnboundLabel("'if' expression result");
            this.builder.jump(resultLabel, expression2);
            this.builder.bindLabel(elseLabel);
            KtExpression elseBranch = expression2.getElse();
            if (elseBranch != null) {
                branches.add(elseBranch);
                this.generateInstructions(elseBranch);
            } else {
                this.builder.loadUnit(expression2);
            }
            this.builder.bindLabel(resultLabel);
            this.mergeValues((List<? extends KtExpression>)branches, expression2);
        }

        @Override
        public void visitTryExpression(@NotNull KtTryExpression expression2) {
            boolean hasFinally;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtFinallySection finallyBlock = expression2.getFinallyBlock();
            FinallyBlockGenerator finallyBlockGenerator = new FinallyBlockGenerator(finallyBlock);
            boolean bl = hasFinally = finallyBlock != null;
            if (hasFinally) {
                this.builder.enterTryFinally(new GenerationTrigger(finallyBlockGenerator){
                    private boolean working;
                    final /* synthetic */ FinallyBlockGenerator $finallyBlockGenerator;
                    {
                        this.$finallyBlockGenerator = $finallyBlockGenerator;
                    }

                    public void generate() {
                        if (this.working) {
                            return;
                        }
                        this.working = true;
                        this.$finallyBlockGenerator.generate();
                        this.working = false;
                    }
                });
            }
            Label onExceptionToFinallyBlock = this.generateTryAndCatches(expression2);
            if (hasFinally) {
                boolean bl2 = onExceptionToFinallyBlock != null;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean $i$a$-assert-ControlFlowProcessor$CFPVisitor$visitTryExpression$32 = false;
                    String $i$a$-assert-ControlFlowProcessor$CFPVisitor$visitTryExpression$32 = Intrinsics.stringPlus((String)"No finally label generated: ", (Object)expression2.getText());
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ControlFlowProcessor$CFPVisitor$visitTryExpression$32));
                }
                this.builder.exitTryFinally();
                Label skipFinallyToErrorBlock = this.builder.createUnboundLabel("skipFinallyToErrorBlock");
                this.builder.jump(skipFinallyToErrorBlock, expression2);
                Label label = onExceptionToFinallyBlock;
                Intrinsics.checkNotNull((Object)label);
                this.builder.bindLabel(label);
                finallyBlockGenerator.generate();
                this.builder.jumpToError(expression2);
                this.builder.bindLabel(skipFinallyToErrorBlock);
                finallyBlockGenerator.generate();
            }
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>();
            branches.add(expression2.getTryBlock());
            for (KtCatchClause catchClause : expression2.getCatchClauses()) {
                KtExpression ktExpression = catchClause.getCatchBody();
                if (ktExpression == null) continue;
                KtExpression ktExpression2 = ktExpression;
                boolean bl4 = false;
                boolean bl5 = false;
                KtExpression it = ktExpression2;
                boolean bl6 = false;
                branches.add(it);
            }
            this.mergeValues((List<? extends KtExpression>)branches, expression2);
        }

        private final Label generateTryAndCatches(KtTryExpression expression2) {
            List<KtCatchClause> list2 = expression2.getCatchClauses();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"expression.catchClauses");
            List<KtCatchClause> catchClauses = list2;
            boolean hasCatches = !catchClauses.isEmpty();
            Label onException = null;
            if (hasCatches) {
                onException = this.builder.createUnboundLabel("onException");
                this.builder.nondeterministicJump(onException, expression2, null);
            }
            Label onExceptionToFinallyBlock = null;
            if (expression2.getFinallyBlock() != null) {
                onExceptionToFinallyBlock = this.builder.createUnboundLabel("onExceptionToFinallyBlock");
                this.builder.nondeterministicJump(onExceptionToFinallyBlock, expression2, null);
            }
            KtBlockExpression ktBlockExpression = expression2.getTryBlock();
            Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"expression.tryBlock");
            KtBlockExpression tryBlock = ktBlockExpression;
            this.catchFinallyStack.push(new CatchFinallyLabels(onException, onExceptionToFinallyBlock, expression2));
            this.generateInstructions(tryBlock);
            this.generateJumpsToCatchAndFinally();
            this.catchFinallyStack.pop();
            if (hasCatches && onException != null) {
                Label afterCatches = this.builder.createUnboundLabel("afterCatches");
                this.builder.jump(afterCatches, expression2);
                this.builder.bindLabel(onException);
                LinkedList<Label> catchLabels = new LinkedList<Label>();
                int catchClausesSize = catchClauses.size();
                int n = 0;
                int n2 = catchClausesSize - 1;
                if (n < n2) {
                    do {
                        int i = n++;
                        catchLabels.add(this.builder.createUnboundLabel(Intrinsics.stringPlus((String)"catch ", (Object)i)));
                    } while (n < n2);
                }
                if (!catchLabels.isEmpty()) {
                    this.builder.nondeterministicJump((List<? extends Label>)catchLabels, expression2);
                }
                boolean isFirst = true;
                for (KtCatchClause catchClause : catchClauses) {
                    Intrinsics.checkNotNullExpressionValue((Object)catchClause, (String)"catchClause");
                    this.builder.enterBlockScope(catchClause);
                    if (!isFirst) {
                        Object e = catchLabels.remove();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"catchLabels.remove()");
                        this.builder.bindLabel((Label)e);
                    } else {
                        isFirst = false;
                    }
                    KtParameter catchParameter = catchClause.getCatchParameter();
                    if (catchParameter != null) {
                        this.builder.declareParameter(catchParameter);
                        this.generateInitializer(catchParameter, this.createSyntheticValue(catchParameter, MagicKind.FAKE_INITIALIZER, new KtElement[0]));
                    }
                    this.generateInstructions(catchClause.getCatchBody());
                    this.builder.jump(afterCatches, expression2);
                    this.builder.exitBlockScope(catchClause);
                }
                this.builder.bindLabel(afterCatches);
            }
            return onExceptionToFinallyBlock;
        }

        @Override
        public void visitWhileExpression(@NotNull KtWhileExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            LoopInfo loopInfo = this.builder.enterLoop(expression2);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            KtExpression condition = expression2.getCondition();
            this.generateInstructions(condition);
            this.mark(expression2);
            if (!CompileTimeConstantUtils.canBeReducedToBooleanConstant(condition, ControlFlowProcessor.this.trace.getBindingContext(), true)) {
                this.builder.jumpOnFalse(loopInfo.getExitPoint(), expression2, this.builder.getBoundValue(condition));
            } else {
                boolean bl = condition != null;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = Intrinsics.stringPlus((String)"Invalid while condition: ", (Object)expression2.getText());
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                KtExpression ktExpression = condition;
                Intrinsics.checkNotNull((Object)ktExpression);
                KtElement[] ktElementArray = new KtElement[]{condition};
                this.createSyntheticValue(ktExpression, MagicKind.VALUE_CONSUMER, ktElementArray);
            }
            this.builder.enterLoopBody(expression2);
            this.generateInstructions(expression2.getBody());
            this.builder.jump(loopInfo.getEntryPoint(), expression2);
            this.builder.exitLoopBody(expression2);
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression2);
        }

        @Override
        public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.builder.enterBlockScope(expression2);
            this.mark(expression2);
            LoopInfo loopInfo = this.builder.enterLoop(expression2);
            this.builder.enterLoopBody(expression2);
            this.generateInstructions(expression2.getBody());
            this.builder.exitLoopBody(expression2);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            KtExpression condition = expression2.getCondition();
            this.generateInstructions(condition);
            this.builder.exitBlockScope(expression2);
            if (!CompileTimeConstantUtils.canBeReducedToBooleanConstant(condition, ControlFlowProcessor.this.trace.getBindingContext(), true)) {
                this.builder.jumpOnTrue(loopInfo.getEntryPoint(), expression2, this.builder.getBoundValue(expression2.getCondition()));
            } else {
                boolean bl = condition != null;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = Intrinsics.stringPlus((String)"Invalid do / while condition: ", (Object)expression2.getText());
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                KtExpression ktExpression = condition;
                Intrinsics.checkNotNull((Object)ktExpression);
                KtElement[] ktElementArray = new KtElement[]{condition};
                this.createSyntheticValue(ktExpression, MagicKind.VALUE_CONSUMER, ktElementArray);
                this.builder.jump(loopInfo.getEntryPoint(), expression2);
            }
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression2);
        }

        @Override
        public void visitForExpression(@NotNull KtForExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.builder.enterBlockScope(expression2);
            KtExpression loopRange = expression2.getLoopRange();
            this.generateInstructions(loopRange);
            WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL;
            Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"LOOP_RANGE_ITERATOR_RESOLVED_CALL");
            this.generateLoopConventionCall(loopRange, (ReadOnlySlice<KtExpression, ResolvedCall<FunctionDescriptor>>)writableSlice);
            this.declareLoopParameter(expression2);
            LoopInfo loopInfo = this.builder.enterLoop(expression2);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice2 = BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL;
            Intrinsics.checkNotNullExpressionValue(writableSlice2, (String)"LOOP_RANGE_HAS_NEXT_RESOLVED_CALL");
            this.generateLoopConventionCall(loopRange, (ReadOnlySlice<KtExpression, ResolvedCall<FunctionDescriptor>>)writableSlice2);
            this.builder.nondeterministicJump(loopInfo.getExitPoint(), expression2, null);
            writableSlice2 = BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL;
            Intrinsics.checkNotNullExpressionValue(writableSlice2, (String)"LOOP_RANGE_NEXT_RESOLVED_CALL");
            this.generateLoopConventionCall(loopRange, (ReadOnlySlice<KtExpression, ResolvedCall<FunctionDescriptor>>)writableSlice2);
            this.writeLoopParameterAssignment(expression2);
            this.mark(expression2);
            this.builder.enterLoopBody(expression2);
            this.generateInstructions(expression2.getBody());
            this.builder.jump(loopInfo.getEntryPoint(), expression2);
            this.builder.exitLoopBody(expression2);
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression2);
            this.builder.exitBlockScope(expression2);
        }

        private final void generateLoopConventionCall(KtExpression loopRange, ReadOnlySlice<KtExpression, ResolvedCall<FunctionDescriptor>> callSlice) {
            ResolvedCall<FunctionDescriptor> resolvedCall2;
            if (loopRange == null) {
                return;
            }
            ResolvedCall<FunctionDescriptor> resolvedCall3 = ControlFlowProcessor.this.trace.getBindingContext().get(callSlice, loopRange);
            if (resolvedCall3 == null) {
                return;
            }
            ResolvedCall<FunctionDescriptor> resolvedCall4 = resolvedCall2 = resolvedCall3;
            this.generateCall(resolvedCall4);
        }

        private final void declareLoopParameter(KtForExpression expression2) {
            KtParameter loopParameter = expression2.getLoopParameter();
            if (loopParameter != null) {
                KtDestructuringDeclaration destructuringDeclaration = loopParameter.getDestructuringDeclaration();
                if (destructuringDeclaration != null) {
                    this.visitDestructuringDeclaration(destructuringDeclaration, false);
                } else {
                    this.builder.declareParameter(loopParameter);
                }
            }
        }

        private final void writeLoopParameterAssignment(KtForExpression expression2) {
            KtParameter loopParameter = expression2.getLoopParameter();
            KtExpression loopRange = expression2.getLoopRange();
            Object object = loopRange;
            KtElement ktElement = (KtElement)(object == null ? (KtExpression)expression2 : object);
            object = ContainerUtil.createMaybeSingletonList(this.builder.getBoundValue(loopRange));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createMaybeSingletonList\u2026getBoundValue(loopRange))");
            PseudoValue value2 = this.builder.magic(ktElement, null, (List<? extends PseudoValue>)object, MagicKind.LOOP_RANGE_ITERATION).getOutputValue();
            if (loopParameter != null) {
                KtDestructuringDeclaration destructuringDeclaration = loopParameter.getDestructuringDeclaration();
                if (destructuringDeclaration != null) {
                    for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                        Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
                        this.generateInitializer(entry, value2);
                    }
                } else {
                    this.generateInitializer(loopParameter, value2);
                }
            }
        }

        @Override
        public void visitBreakExpression(@NotNull KtBreakExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtLoopExpression loop2 = this.getCorrespondingLoop(expression2);
            if (loop2 != null) {
                Label label;
                if (this.jumpCrossesTryCatchBoundary(expression2, loop2)) {
                    this.generateJumpsToCatchAndFinally();
                }
                if (this.jumpDoesNotCrossFunctionBoundary(expression2, loop2) && (label = this.builder.getLoopExitPoint(loop2)) != null) {
                    Label label2 = label;
                    boolean bl = false;
                    boolean bl2 = false;
                    Label it = label2;
                    boolean bl3 = false;
                    this.builder.jump(it, expression2);
                }
            }
        }

        @Override
        public void visitContinueExpression(@NotNull KtContinueExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtLoopExpression loop2 = this.getCorrespondingLoop(expression2);
            if (loop2 != null) {
                Label label;
                if (this.jumpCrossesTryCatchBoundary(expression2, loop2)) {
                    this.generateJumpsToCatchAndFinally();
                }
                if (this.jumpDoesNotCrossFunctionBoundary(expression2, loop2) && (label = this.builder.getLoopConditionEntryPoint(loop2)) != null) {
                    Label label2 = label;
                    boolean bl = false;
                    boolean bl2 = false;
                    Label it = label2;
                    boolean bl3 = false;
                    this.builder.jump(it, expression2);
                }
            }
        }

        private final KtLoopExpression getNearestLoopExpression(KtExpression expression2) {
            PsiElement $this$getStrictParentOfType$iv = expression2;
            boolean $i$f$getStrictParentOfType = false;
            return PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtLoopExpression.class, true);
        }

        private final KtLoopExpression getCorrespondingLoopWithoutLabel(KtExpression expression2) {
            KtLoopExpression ktLoopExpression = this.getNearestLoopExpression(expression2);
            if (ktLoopExpression == null) {
                return null;
            }
            KtLoopExpression parentLoop = ktLoopExpression;
            KtExpression parentBody = parentLoop.getBody();
            return parentBody != null && parentBody.getTextRange().contains(expression2.getTextRange()) ? parentLoop : this.getNearestLoopExpression(parentLoop);
        }

        private final KtLoopExpression getCorrespondingLoop(KtExpressionWithLabel expression2) {
            Object object;
            Object targetLabel;
            String labelName = expression2.getLabelName();
            KtLoopExpression loop2 = null;
            if (labelName != null) {
                KtLoopExpression ktLoopExpression;
                KtSimpleNameExpression ktSimpleNameExpression = expression2.getTargetLabel();
                Intrinsics.checkNotNull((Object)ktSimpleNameExpression);
                targetLabel = ktSimpleNameExpression;
                PsiElement labeledElement = (PsiElement)ControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, targetLabel);
                if (labeledElement instanceof KtLoopExpression) {
                    ktLoopExpression = (KtLoopExpression)labeledElement;
                } else {
                    ControlFlowProcessor.this.trace.report(Errors.NOT_A_LOOP_LABEL.on((KtExpressionWithLabel)((PsiElement)expression2), targetLabel.getText()));
                    ktLoopExpression = null;
                }
                loop2 = ktLoopExpression;
            } else {
                loop2 = this.getCorrespondingLoopWithoutLabel(expression2);
                if (loop2 == null) {
                    ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on((KtExpressionWithLabel)((PsiElement)expression2)));
                } else {
                    KtWhenExpression whenExpression;
                    targetLabel = ControlFlowProcessor.this.languageVersionSettings;
                    if (!(targetLabel == null ? false : true == targetLabel.supportsFeature(LanguageFeature.AllowBreakAndContinueInsideWhen)) && (whenExpression = PsiTreeUtil.getParentOfType((PsiElement)expression2, KtWhenExpression.class, true, object = new Class[]{KtLoopExpression.class})) != null) {
                        ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_IN_WHEN.on((KtExpressionWithLabel)((PsiElement)expression2)));
                    }
                }
            }
            KtLoopExpression ktLoopExpression = loop2;
            if (ktLoopExpression != null && (object = ktLoopExpression.getBody()) != null) {
                Object object2 = object;
                ControlFlowProcessor controlFlowProcessor = ControlFlowProcessor.this;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                if (!it.getTextRange().contains(expression2.getTextRange())) {
                    controlFlowProcessor.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on((KtExpressionWithLabel)((PsiElement)expression2)));
                    return null;
                }
            }
            return loop2;
        }

        private final boolean returnCrossesTryCatchBoundary(KtReturnExpression returnExpression) {
            PsiElement psiElement;
            KtSimpleNameExpression ktSimpleNameExpression = returnExpression.getTargetLabel();
            if (ktSimpleNameExpression == null) {
                return true;
            }
            KtSimpleNameExpression targetLabel = ktSimpleNameExpression;
            PsiElement psiElement2 = (PsiElement)ControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement2 == null) {
                return true;
            }
            PsiElement labeledElement = psiElement = psiElement2;
            return this.jumpCrossesTryCatchBoundary(returnExpression, labeledElement);
        }

        private final boolean jumpCrossesTryCatchBoundary(KtExpressionWithLabel jumpExpression, PsiElement jumpTarget) {
            PsiElement current = jumpExpression.getParent();
            PsiElement psiElement;
            while (!Intrinsics.areEqual((Object)(psiElement = current), (Object)jumpTarget)) {
                if (psiElement instanceof KtTryExpression) {
                    return true;
                }
                current = current.getParent();
            }
            return false;
        }

        private final boolean jumpDoesNotCrossFunctionBoundary(KtExpressionWithLabel jumpExpression, KtLoopExpression jumpTarget) {
            boolean bl;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            BindingContext bindingContext2 = bindingContext;
            FunctionDescriptor labelExprEnclosingFunc = BindingContextUtilsKt.getEnclosingFunctionDescriptor(bindingContext2, jumpExpression);
            FunctionDescriptor labelTargetEnclosingFunc = BindingContextUtilsKt.getEnclosingFunctionDescriptor(bindingContext2, jumpTarget);
            if (labelExprEnclosingFunc != labelTargetEnclosingFunc) {
                if (this.builder.getLoopExitPoint(jumpTarget) != null || labelExprEnclosingFunc instanceof ConstructorDescriptor && !((ConstructorDescriptor)labelExprEnclosingFunc).isPrimary()) {
                    ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_JUMPS_ACROSS_FUNCTION_BOUNDARY.on((KtExpressionWithLabel)((PsiElement)jumpExpression)));
                }
                bl = false;
            } else {
                bl = true;
            }
            return bl;
        }

        @Override
        public void visitReturnExpression(@NotNull KtReturnExpression expression2) {
            KtElement ktElement;
            KtElement[] ktElementArray;
            KtExpression returnedExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (this.returnCrossesTryCatchBoundary(expression2)) {
                this.generateJumpsToCatchAndFinally();
            }
            if ((returnedExpression = expression2.getReturnedExpression()) != null) {
                this.generateInstructions(returnedExpression);
            }
            KtSimpleNameExpression labelElement = expression2.getTargetLabel();
            KtElement subroutine = null;
            String labelName = expression2.getLabelName();
            if (labelElement != null && labelName != null) {
                ktElementArray = (KtElement[])ControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, labelElement);
                if (ktElementArray == null) {
                    ktElement = null;
                } else {
                    KtElement[] ktElementArray2 = ktElementArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtElement[] labeledElement = ktElementArray2;
                    boolean bl3 = false;
                    KtElement labeledKtElement = (KtElement)labeledElement;
                    this.checkReturnLabelTarget(expression2, labeledKtElement);
                    ktElement = labeledKtElement;
                }
            } else {
                ktElement = subroutine = this.builder.getReturnSubroutine();
            }
            if (subroutine instanceof KtFunction || subroutine instanceof KtPropertyAccessor) {
                PseudoValue returnValue;
                PseudoValue pseudoValue = returnValue = returnedExpression != null ? this.builder.getBoundValue(returnedExpression) : null;
                if (returnValue == null) {
                    this.builder.returnNoValue(expression2, subroutine);
                } else {
                    this.builder.returnValue(expression2, returnValue, subroutine);
                }
            } else {
                ktElementArray = new KtElement[]{returnedExpression};
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, ktElementArray);
            }
        }

        private final void checkReturnLabelTarget(KtReturnExpression returnExpression, KtElement labeledElement) {
            if (ControlFlowProcessor.this.languageVersionSettings == null) {
                return;
            }
            if (!(labeledElement instanceof KtFunctionLiteral) && !(labeledElement instanceof KtNamedFunction)) {
                if (ControlFlowProcessor.this.languageVersionSettings.supportsFeature(LanguageFeature.RestrictReturnStatementTarget)) {
                    ControlFlowProcessor.this.trace.report(Errors.NOT_A_FUNCTION_LABEL.on((KtExpressionWithLabel)((PsiElement)returnExpression)));
                } else {
                    ControlFlowProcessor.this.trace.report(Errors.NOT_A_FUNCTION_LABEL_WARNING.on((KtExpressionWithLabel)((PsiElement)returnExpression)));
                }
            }
        }

        @Override
        public void visitParameter(@NotNull KtParameter parameter) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            this.builder.declareParameter(parameter);
            KtExpression defaultValue2 = parameter.getDefaultValue();
            if (defaultValue2 != null) {
                object = parameter.getName();
                Label skipDefaultValue = this.builder.createUnboundLabel(Intrinsics.stringPlus((String)"after default value for parameter ", (Object)(object == null ? "<anonymous>" : object)));
                this.builder.nondeterministicJump(skipDefaultValue, defaultValue2, null);
                this.generateInstructions(defaultValue2);
                this.builder.bindLabel(skipDefaultValue);
            }
            this.generateInitializer(parameter, this.computePseudoValueForParameter(parameter));
            KtDestructuringDeclaration ktDestructuringDeclaration = parameter.getDestructuringDeclaration();
            if (ktDestructuringDeclaration != null) {
                object = ktDestructuringDeclaration;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                this.visitDestructuringDeclaration((KtDestructuringDeclaration)it, true);
            }
        }

        private final PseudoValue computePseudoValueForParameter(KtParameter parameter) {
            PseudoValue syntheticValue = this.createSyntheticValue(parameter, MagicKind.FAKE_INITIALIZER, new KtElement[0]);
            Object[] objectArray = this.builder.getBoundValue(parameter.getDefaultValue());
            if (objectArray == null) {
                return syntheticValue;
            }
            Object[] defaultValue2 = objectArray;
            objectArray = new PseudoValue[]{defaultValue2, syntheticValue};
            return this.builder.merge(parameter, CollectionsKt.arrayListOf((Object[])objectArray)).getOutputValue();
        }

        @Override
        public void visitBlockExpression(@NotNull KtBlockExpression expression2) {
            boolean declareBlockScope;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            boolean bl = declareBlockScope = !this.isBlockInDoWhile(expression2);
            if (declareBlockScope) {
                this.builder.enterBlockScope(expression2);
            }
            this.mark(expression2);
            List<KtExpression> list2 = expression2.getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"expression.statements");
            List<KtExpression> statements2 = list2;
            for (KtExpression statement2 : statements2) {
                Label label;
                KtClassOrObject ktClassOrObject;
                KtClassOrObject ktClassOrObject2 = ktClassOrObject = statement2 instanceof KtClassOrObject ? (KtClassOrObject)statement2 : null;
                if (ktClassOrObject == null) {
                    label = null;
                } else {
                    KtClassOrObject ktClassOrObject3 = ktClassOrObject;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    KtClassOrObject it = ktClassOrObject3;
                    boolean bl4 = false;
                    label = this.builder.createUnboundLabel("after local class");
                }
                Label afterClassLabel = label;
                if (afterClassLabel != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)statement2, (String)"statement");
                    this.builder.nondeterministicJump(afterClassLabel, statement2, null);
                }
                this.generateInstructions(statement2);
                if (afterClassLabel == null) continue;
                this.builder.bindLabel(afterClassLabel);
            }
            if (statements2.isEmpty()) {
                this.builder.loadUnit(expression2);
            } else {
                this.copyValue((KtElement)CollectionsKt.lastOrNull(statements2), expression2);
            }
            if (declareBlockScope) {
                this.builder.exitBlockScope(expression2);
            }
        }

        private final boolean isBlockInDoWhile(KtBlockExpression expression2) {
            PsiElement parent2 = expression2.getParent();
            return parent2.getParent() instanceof KtDoWhileExpression;
        }

        private final void visitFunction(KtFunction function2, EventOccurrencesRange eventOccurrencesRange) {
            boolean isAnonymousFunction;
            if (eventOccurrencesRange == null) {
                ControlFlowProcessor.this.processLocalDeclaration(function2);
            } else {
                this.visitInlinedFunction(function2, eventOccurrencesRange);
            }
            boolean bl = isAnonymousFunction = function2 instanceof KtFunctionLiteral || function2.getName() == null;
            if (isAnonymousFunction || function2.isLocal() && !(function2.getParent() instanceof KtBlockExpression)) {
                this.builder.createLambda(function2);
            }
        }

        static /* synthetic */ void visitFunction$default(CFPVisitor cFPVisitor, KtFunction ktFunction, EventOccurrencesRange eventOccurrencesRange, int n, Object object) {
            if ((n & 2) != 0) {
                eventOccurrencesRange = null;
            }
            cFPVisitor.visitFunction(ktFunction, eventOccurrencesRange);
        }

        private final void visitInlinedFunction(KtFunction lambdaFunctionLiteral, EventOccurrencesRange eventOccurrencesRange) {
            this.deferredGeneratorsStack.peek().add(new Function1<ControlFlowBuilder, Unit>(eventOccurrencesRange, lambdaFunctionLiteral, ControlFlowProcessor.this){
                final /* synthetic */ EventOccurrencesRange $eventOccurrencesRange;
                final /* synthetic */ KtFunction $lambdaFunctionLiteral;
                final /* synthetic */ ControlFlowProcessor this$0;
                {
                    this.$eventOccurrencesRange = $eventOccurrencesRange;
                    this.$lambdaFunctionLiteral = $lambdaFunctionLiteral;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ControlFlowBuilder builder2) {
                    Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                    Label beforeDeclaration = builder2.createUnboundLabel("before inlined declaration");
                    Label afterDeclaration = builder2.createUnboundLabel("after inlined declaration");
                    builder2.bindLabel(beforeDeclaration);
                    if (!EventOccurrencesRangeKt.isDefinitelyVisited(this.$eventOccurrencesRange)) {
                        builder2.nondeterministicJump(afterDeclaration, this.$lambdaFunctionLiteral, null);
                    }
                    ControlFlowProcessor.access$generate(this.this$0, this.$lambdaFunctionLiteral, this.$eventOccurrencesRange);
                    if (EventOccurrencesRangeKt.canBeRevisited(this.$eventOccurrencesRange)) {
                        builder2.nondeterministicJump(beforeDeclaration, this.$lambdaFunctionLiteral, null);
                    }
                    builder2.bindLabel(afterDeclaration);
                }
            });
        }

        @Override
        public void visitNamedFunction(@NotNull KtNamedFunction function2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            CFPVisitor.visitFunction$default(this, function2, null, 2, null);
        }

        @Override
        public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
            Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
            this.mark(lambdaExpression);
            KtFunctionLiteral ktFunctionLiteral = lambdaExpression.getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"lambdaExpression.functionLiteral");
            KtFunctionLiteral functionLiteral = ktFunctionLiteral;
            this.visitFunction(functionLiteral, (EventOccurrencesRange)((Object)ControlFlowProcessor.this.trace.get(BindingContext.LAMBDA_INVOCATIONS, lambdaExpression)));
            this.copyValue(functionLiteral, lambdaExpression);
        }

        @Override
        public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtExpression selectorExpression = expression2.getSelectorExpression();
            KtExpression receiverExpression = expression2.getReceiverExpression();
            boolean safe = expression2 instanceof KtSafeQualifiedExpression;
            if (selectorExpression instanceof KtCallExpression || selectorExpression instanceof KtSimpleNameExpression) {
                if (!safe) {
                    this.generateInstructions(selectorExpression);
                } else {
                    Label resultLabel = this.builder.createUnboundLabel("result of call");
                    this.builder.jumpOnFalse(resultLabel, expression2, null);
                    this.generateInstructions(selectorExpression);
                    this.builder.bindLabel(resultLabel);
                }
                this.copyValue(selectorExpression, expression2);
            } else {
                this.generateInstructions(receiverExpression);
                KtElement[] ktElementArray = new KtElement[]{receiverExpression};
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, ktElementArray);
            }
        }

        @Override
        public void visitCallExpression(@NotNull KtCallExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (!this.generateCall(expression2)) {
                ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
                for (KtValueArgument argument2 : expression2.getValueArguments()) {
                    KtExpression argumentExpression = argument2.getArgumentExpression();
                    if (argumentExpression == null) continue;
                    this.generateInstructions(argumentExpression);
                    inputExpressions.add(argumentExpression);
                }
                KtExpression calleeExpression = expression2.getCalleeExpression();
                this.generateInstructions(calleeExpression);
                if (calleeExpression != null) {
                    inputExpressions.add(calleeExpression);
                    KtExpression ktExpression = this.generateAndGetReceiverIfAny(expression2);
                    if (ktExpression != null) {
                        KtExpression ktExpression2 = ktExpression;
                        boolean bl = false;
                        boolean bl2 = false;
                        KtExpression it = ktExpression2;
                        boolean bl3 = false;
                        inputExpressions.add(it);
                    }
                }
                this.mark(expression2);
                this.createNonSyntheticValue((KtElement)expression2, (List<? extends KtElement>)inputExpressions, MagicKind.UNRESOLVED_CALL);
            }
        }

        private final KtExpression generateAndGetReceiverIfAny(KtExpression expression2) {
            KtQualifiedExpression ktQualifiedExpression;
            PsiElement psiElement = expression2.getParent();
            KtQualifiedExpression ktQualifiedExpression2 = ktQualifiedExpression = psiElement instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement : null;
            if (ktQualifiedExpression == null) {
                return null;
            }
            KtQualifiedExpression parent2 = ktQualifiedExpression;
            if (parent2.getSelectorExpression() != expression2) {
                return null;
            }
            KtExpression receiverExpression = parent2.getReceiverExpression();
            this.generateInstructions(receiverExpression);
            return receiverExpression;
        }

        @Override
        public void visitProperty(@NotNull KtProperty property2) {
            KtExpression delegate2;
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            this.builder.declareVariable(property2);
            KtExpression initializer2 = property2.getInitializer();
            if (initializer2 != null) {
                this.visitAssignment(property2, this.getDeferredValue(initializer2), property2);
            }
            if ((delegate2 = property2.getDelegateExpression()) != null) {
                this.visitAssignment(property2, this.getDeferredValue(null), property2);
                this.generateInstructions(delegate2);
                if (property2.isLocal()) {
                    this.generateInitializer(property2, this.createSyntheticValue(property2, MagicKind.FAKE_INITIALIZER, new KtElement[0]));
                }
                if (this.builder.getBoundValue(delegate2) != null) {
                    KtElement[] ktElementArray = new KtElement[]{delegate2};
                    this.createSyntheticValue(property2, MagicKind.VALUE_CONSUMER, ktElementArray);
                }
            }
            if (KtPsiUtil.isLocal(property2)) {
                for (KtPropertyAccessor accessor : property2.getAccessors()) {
                    this.generateInstructions(accessor);
                }
            }
        }

        @Override
        public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration declaration2) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            this.visitDestructuringDeclaration(declaration2, true);
        }

        @Override
        private final void visitDestructuringDeclaration(KtDestructuringDeclaration declaration2, boolean generateWriteForEntries) {
            KtExpression initializer2 = declaration2.getInitializer();
            this.generateInstructions(initializer2);
            for (KtDestructuringDeclarationEntry entry : declaration2.getEntries()) {
                Object object;
                PseudoValue pseudoValue;
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
                this.builder.declareVariable(entry);
                ResolvedCall resolvedCall2 = (ResolvedCall)ControlFlowProcessor.this.trace.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                PseudoValue writtenValue = null;
                if (resolvedCall2 != null) {
                    pseudoValue = this.builder.call(entry, resolvedCall2, this.getReceiverValues(resolvedCall2), MapsKt.emptyMap()).getOutputValue();
                } else {
                    object = initializer2;
                    if (object == null) {
                        pseudoValue = null;
                    } else {
                        KtExpression ktExpression = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        KtExpression it = ktExpression;
                        boolean bl3 = false;
                        KtElement[] ktElementArray = new KtElement[]{it};
                        pseudoValue = this.createSyntheticValue(entry, MagicKind.UNRESOLVED_CALL, ktElementArray);
                    }
                }
                writtenValue = pseudoValue;
                if (!generateWriteForEntries) continue;
                object = writtenValue;
                this.generateInitializer(entry, (PseudoValue)(object == null ? this.createSyntheticValue(entry, MagicKind.FAKE_INITIALIZER, new KtElement[0]) : object));
            }
        }

        @Override
        public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
            Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
            ControlFlowProcessor.this.processLocalDeclaration(accessor);
        }

        @Override
        public void visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark(expression2);
            IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
            KtElement[] ktElementArray = expression2.getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)ktElementArray, (String)"expression.left");
            KtElement[] left = ktElementArray;
            if (operationType == KtTokens.AS_KEYWORD || operationType == KtTokens.AS_SAFE) {
                this.generateInstructions((KtElement)left);
                if (this.getBoundOrUnreachableValue((KtElement)left) != null) {
                    ktElementArray = new KtElement[]{(KtElement)left};
                    this.createNonSyntheticValue((KtElement)expression2, MagicKind.CAST, ktElementArray);
                }
            } else {
                this.visitKtElement(expression2);
                ktElementArray = new KtElement[]{(KtElement)left};
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, ktElementArray);
            }
        }

        private final void generateJumpsToCatchAndFinally() {
            Object object = this.catchFinallyStack;
            boolean bl = false;
            if (!object.isEmpty()) {
                object = this.catchFinallyStack.peek();
                bl = false;
                boolean bl2 = false;
                CatchFinallyLabels $this$generateJumpsToCatchAndFinally_u24lambda_u2d19 = (CatchFinallyLabels)object;
                boolean bl3 = false;
                if ($this$generateJumpsToCatchAndFinally_u24lambda_u2d19.getTryExpression() != null) {
                    Label it;
                    boolean bl4;
                    boolean bl5;
                    Label label;
                    Label label2 = $this$generateJumpsToCatchAndFinally_u24lambda_u2d19.getOnException();
                    if (label2 != null) {
                        label = label2;
                        bl5 = false;
                        bl4 = false;
                        it = label;
                        boolean bl6 = false;
                        this.builder.nondeterministicJump(it, $this$generateJumpsToCatchAndFinally_u24lambda_u2d19.getTryExpression(), null);
                    }
                    label2 = $this$generateJumpsToCatchAndFinally_u24lambda_u2d19.getToFinally();
                    if (label2 != null) {
                        label = label2;
                        bl5 = false;
                        bl4 = false;
                        it = label;
                        boolean bl7 = false;
                        this.builder.nondeterministicJump(it, $this$generateJumpsToCatchAndFinally_u24lambda_u2d19.getTryExpression(), null);
                    }
                }
            }
        }

        @Override
        public void visitThrowExpression(@NotNull KtThrowExpression expression2) {
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark(expression2);
            this.generateJumpsToCatchAndFinally();
            Object object = expression2.getThrownExpression();
            if (object == null) {
                return;
            }
            KtExpression thrownExpression = ktExpression = object;
            this.generateInstructions(thrownExpression);
            object = this.builder.getBoundValue(thrownExpression);
            if (object == null) {
                return;
            }
            Object thrownValue = object;
            this.builder.throwException(expression2, (PseudoValue)thrownValue);
        }

        @Override
        public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.generateArrayAccess(expression2, (ResolvedCall)ControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_GET, expression2));
        }

        @Override
        public void visitIsExpression(@NotNull KtIsExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtElement[] ktElementArray = expression2.getLeftHandSide();
            Intrinsics.checkNotNullExpressionValue((Object)ktElementArray, (String)"expression.leftHandSide");
            KtElement[] left = ktElementArray;
            this.generateInstructions((KtElement)left);
            ktElementArray = new KtElement[]{(KtElement)left};
            this.createNonSyntheticValue((KtElement)expression2, MagicKind.IS, ktElementArray);
        }

        @Override
        public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtExpression subjectExpression = expression2.getSubjectExpression();
            if (subjectExpression != null) {
                this.generateInstructions(subjectExpression);
            }
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>();
            Label doneLabel = this.builder.createUnboundLabel("after 'when' expression");
            Label nextLabel = null;
            Iterator<KtWhenEntry> iterator2 = expression2.getEntries().iterator();
            while (iterator2.hasNext()) {
                KtWhenEntry whenEntry = iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)whenEntry, (String)"whenEntry");
                this.mark(whenEntry);
                boolean isElse = whenEntry.isElse();
                if (isElse && iterator2.hasNext()) {
                    ControlFlowProcessor.this.trace.report(Errors.ELSE_MISPLACED_IN_WHEN.on((KtWhenEntry)((PsiElement)whenEntry)));
                }
                Label bodyLabel = this.builder.createUnboundLabel("'when' entry body");
                Object[] objectArray = whenEntry.getConditions();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"whenEntry.conditions");
                Object[] conditions2 = objectArray;
                int n = 0;
                int n2 = conditions2.length + -1;
                if (n <= n2) {
                    do {
                        int i = n++;
                        KtWhenCondition condition = conditions2[i];
                        condition.accept(this.conditionVisitor);
                        if (i + 1 >= conditions2.length) continue;
                        this.builder.nondeterministicJump(bodyLabel, expression2, this.builder.getBoundValue(condition));
                    } while (n <= n2);
                }
                if (!isElse) {
                    nextLabel = this.builder.createUnboundLabel("next 'when' entry");
                    KtWhenCondition lastCondition = (KtWhenCondition)ArraysKt.lastOrNull((Object[])conditions2);
                    this.builder.nondeterministicJump(nextLabel, expression2, this.builder.getBoundValue(lastCondition));
                }
                this.builder.bindLabel(bodyLabel);
                KtExpression whenEntryExpression = whenEntry.getExpression();
                if (whenEntryExpression != null) {
                    this.generateInstructions(whenEntryExpression);
                    branches.add(whenEntryExpression);
                }
                this.builder.jump(doneLabel, expression2);
                if (isElse || nextLabel == null) continue;
                this.builder.bindLabel(nextLabel);
                if (iterator2.hasNext() || !WhenChecker.isWhenExhaustive(expression2, ControlFlowProcessor.this.trace)) continue;
                this.builder.magic(expression2, null, CollectionsKt.emptyList(), MagicKind.EXHAUSTIVE_WHEN_ELSE);
            }
            this.builder.bindLabel(doneLabel);
            this.mergeValues((List<? extends KtExpression>)branches, expression2);
            WhenChecker.INSTANCE.checkDuplicatedLabels(expression2, ControlFlowProcessor.this.trace);
        }

        @Override
        public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtObjectDeclaration ktObjectDeclaration = expression2.getObjectDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"expression.objectDeclaration");
            KtObjectDeclaration declaration2 = ktObjectDeclaration;
            this.generateInstructions(declaration2);
            this.builder.createAnonymousObject(expression2);
        }

        @Override
        public void visitObjectDeclaration(@NotNull KtObjectDeclaration objectDeclaration) {
            Intrinsics.checkNotNullParameter((Object)objectDeclaration, (String)"objectDeclaration");
            this.generateHeaderDelegationSpecifiers(objectDeclaration);
            this.generateInitializersForClassOrObject(objectDeclaration);
            this.generateDeclarationForLocalClassOrObjectIfNeeded(objectDeclaration);
        }

        @Override
        public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark(expression2);
            ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
            KtStringTemplateEntry[] ktStringTemplateEntryArray = expression2.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"expression.entries");
            for (KtStringTemplateEntry entry : ktStringTemplateEntryArray) {
                if (!(entry instanceof KtStringTemplateEntryWithExpression)) continue;
                KtExpression entryExpression = entry.getExpression();
                this.generateInstructions(entryExpression);
                if (entryExpression == null) continue;
                inputExpressions.add(entryExpression);
            }
            this.builder.loadStringTemplate(expression2, this.elementsToValues((List<? extends KtElement>)inputExpressions));
        }

        @Override
        public void visitTypeProjection(@NotNull KtTypeProjection typeProjection) {
            Intrinsics.checkNotNullParameter((Object)typeProjection, (String)"typeProjection");
        }

        @Override
        public void visitAnonymousInitializer(@NotNull KtAnonymousInitializer classInitializer) {
            Intrinsics.checkNotNullParameter((Object)classInitializer, (String)"classInitializer");
            this.generateInstructions(classInitializer.getBody());
        }

        private final void generateHeaderDelegationSpecifiers(KtClassOrObject classOrObject) {
            for (KtSuperTypeListEntry specifier : classOrObject.getSuperTypeListEntries()) {
                this.generateInstructions(specifier);
            }
        }

        private final void generateInitializersForClassOrObject(KtDeclarationContainer classOrObject) {
            for (KtDeclaration declaration2 : classOrObject.getDeclarations()) {
                if (!(declaration2 instanceof KtProperty) && !(declaration2 instanceof KtAnonymousInitializer)) continue;
                this.generateInstructions(declaration2);
            }
        }

        private final void processEntryOrObject(KtClassOrObject entryOrObject) {
            DeclarationDescriptor classDescriptor = ControlFlowProcessor.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, entryOrObject);
            if (classDescriptor instanceof ClassDescriptor) {
                this.builder.declareEntryOrObject(entryOrObject);
                this.builder.write(entryOrObject, entryOrObject, this.createSyntheticValue(entryOrObject, MagicKind.FAKE_INITIALIZER, new KtElement[0]), new AccessTarget.Declaration(new FakeCallableDescriptorForObject((ClassDescriptor)classDescriptor)), MapsKt.emptyMap());
                this.generateInstructions(entryOrObject);
            }
        }

        @Override
        public void visitClass(@NotNull KtClass klass) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            if (klass.hasPrimaryConstructor()) {
                this.processParameters(klass.getPrimaryConstructorParameters());
                this.generateHeaderDelegationSpecifiers(klass);
                this.generateInitializersForClassOrObject(klass);
            }
            this.generateDeclarationForLocalClassOrObjectIfNeeded(klass);
            if (klass.isEnum()) {
                Iterable $this$forEach$iv = klass.getDeclarations();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtDeclaration it = (KtDeclaration)element$iv;
                    boolean bl = false;
                    KtDeclaration ktDeclaration = it;
                    if (ktDeclaration instanceof KtEnumEntry) {
                        this.processEntryOrObject((KtClassOrObject)it);
                        continue;
                    }
                    if (!(ktDeclaration instanceof KtObjectDeclaration) || !((KtObjectDeclaration)it).isCompanion()) continue;
                    this.processEntryOrObject((KtClassOrObject)it);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitScript(@NotNull KtScript script) {
            KotlinType kotlinType;
            KtExpression resultExpression;
            KtExpression ktExpression;
            Object[] lastInitializer;
            Object object;
            Object object2;
            Object[] $this$getChildOfType$iv;
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            PsiElement psiElement = script;
            boolean $i$f$getChildOfType2 = false;
            KtBlockExpression ktBlockExpression = PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtBlockExpression.class);
            if (ktBlockExpression == null) {
                object2 = null;
            } else {
                void $this$getChildrenOfType$iv;
                PsiElement $i$f$getChildOfType2 = ktBlockExpression;
                boolean $i$f$getChildrenOfType = false;
                object = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtScriptInitializer.class);
                $this$getChildOfType$iv = (KtScriptInitializer[])(object == null ? (PsiElement[])new KtScriptInitializer[0] : object);
                object2 = (KtScriptInitializer)ArraysKt.lastOrNull((Object[])$this$getChildOfType$iv);
            }
            $this$getChildOfType$iv = lastInitializer = object2;
            if ($this$getChildOfType$iv == null) {
                ktExpression = null;
            } else {
                PsiElement $this$getChildOfType$iv2 = (PsiElement)$this$getChildOfType$iv;
                boolean $i$f$getChildOfType3 = false;
                ktExpression = PsiTreeUtil.getChildOfType($this$getChildOfType$iv2, KtExpression.class);
            }
            KtExpression $this$getChildOfType$iv2 = resultExpression = ktExpression;
            if ($this$getChildOfType$iv2 == null) {
                kotlinType = null;
            } else {
                KtExpression ktExpression2 = $this$getChildOfType$iv2;
                object = ControlFlowProcessor.this;
                boolean bl = false;
                boolean bl2 = false;
                KtExpression it = ktExpression2;
                boolean bl3 = false;
                kotlinType = ((ControlFlowProcessor)object).trace.getBindingContext().getType(it);
            }
            KotlinType resultType = kotlinType;
            boolean hasResultField = resultType != null && !TypeUtilsKt.isUnit(resultType) && !TypeUtilsKt.isNothing(resultType);
            for (KtDeclaration declaration2 : script.getDeclarations()) {
                if (declaration2 instanceof KtAnonymousInitializer) {
                    this.generateInstructions(declaration2);
                    if (!hasResultField || !Intrinsics.areEqual((Object)declaration2, (Object)lastInitializer)) continue;
                    ControlFlowProcessor.this.trace.record(BindingContext.USED_AS_EXPRESSION, resultExpression, true);
                    continue;
                }
                if (!(declaration2 instanceof KtProperty) && !(declaration2 instanceof KtDestructuringDeclaration)) continue;
                this.generateInstructions(declaration2);
            }
        }

        private final void generateDeclarationForLocalClassOrObjectIfNeeded(KtClassOrObject classOrObject) {
            if (classOrObject.isLocal()) {
                for (KtDeclaration declaration2 : classOrObject.getDeclarations()) {
                    if (declaration2 instanceof KtSecondaryConstructor || declaration2 instanceof KtProperty || declaration2 instanceof KtAnonymousInitializer) continue;
                    this.generateInstructions(declaration2);
                }
            }
        }

        private final void processParameters(List<? extends KtParameter> parameters2) {
            for (KtParameter ktParameter : parameters2) {
                this.generateInstructions(ktParameter);
            }
        }

        @Override
        public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor2) {
            KtClassOrObject ktClassOrObject;
            Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
            KtClassOrObject ktClassOrObject2 = PsiTreeUtil.getParentOfType((PsiElement)constructor2, KtClassOrObject.class);
            if (ktClassOrObject2 == null) {
                String string2 = "Guaranteed by parsing contract";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            KtClassOrObject classOrObject = ktClassOrObject = ktClassOrObject2;
            this.processParameters(constructor2.getValueParameters());
            this.generateCallOrMarkUnresolved(constructor2.getDelegationCall());
            if (!constructor2.getDelegationCall().isCallToThis()) {
                this.generateInitializersForClassOrObject(classOrObject);
            }
            this.generateInstructions(constructor2.getBodyExpression());
        }

        @Override
        public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call2) {
            Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
            this.generateCallOrMarkUnresolved(call2);
        }

        @Override
        public void visitInitializerList(@NotNull KtInitializerList list2) {
            Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
            list2.acceptChildren(this);
        }

        /*
         * WARNING - void declaration
         */
        private final void generateCallOrMarkUnresolved(KtCallElement call2) {
            if (!this.generateCall(call2)) {
                void $this$mapNotNullTo$iv$iv;
                List<? extends ValueArgument> list2 = call2.getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"call.valueArguments");
                Iterable $this$mapNotNull$iv = list2;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    KtExpression ktExpression;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    ValueArgument p0 = (ValueArgument)element$iv$iv;
                    boolean bl2 = false;
                    if (p0.getArgumentExpression() == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    KtExpression it$iv$iv = ktExpression;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List arguments2 = (List)destination$iv$iv;
                for (KtExpression argument2 : arguments2) {
                    this.generateInstructions(argument2);
                }
                this.createNonSyntheticValue((KtElement)call2, arguments2, MagicKind.UNRESOLVED_CALL);
            }
        }

        @Override
        public void visitDelegatedSuperTypeEntry(@NotNull KtDelegatedSuperTypeEntry specifier) {
            Intrinsics.checkNotNullParameter((Object)specifier, (String)"specifier");
            KtExpression delegateExpression2 = specifier.getDelegateExpression();
            this.generateInstructions(delegateExpression2);
            if (delegateExpression2 != null) {
                KtElement[] ktElementArray = new KtElement[]{delegateExpression2};
                this.createSyntheticValue(specifier, MagicKind.VALUE_CONSUMER, ktElementArray);
            }
        }

        @Override
        public void visitSuperTypeEntry(@NotNull KtSuperTypeEntry specifier) {
            Intrinsics.checkNotNullParameter((Object)specifier, (String)"specifier");
        }

        @Override
        public void visitSuperTypeList(@NotNull KtSuperTypeList list2) {
            Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
            list2.acceptChildren(this);
        }

        @Override
        public void visitKtFile(@NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            for (KtDeclaration declaration2 : file2.getDeclarations()) {
                if (!(declaration2 instanceof KtProperty)) continue;
                this.generateInstructions(declaration2);
            }
        }

        @Override
        public void visitDoubleColonExpression(@NotNull KtDoubleColonExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark(expression2);
            KtExpression receiverExpression = expression2.getReceiverExpression();
            if (receiverExpression != null && ControlFlowProcessor.this.trace.getBindingContext().get(BindingContext.DOUBLE_COLON_LHS, receiverExpression) instanceof DoubleColonLHS.Expression) {
                this.generateInstructions(receiverExpression);
                KtElement[] ktElementArray = new KtElement[]{receiverExpression};
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.BOUND_CALLABLE_REFERENCE, ktElementArray);
            } else {
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNBOUND_CALLABLE_REFERENCE, new KtElement[0]);
            }
        }

        @Override
        public void visitKtElement(@NotNull KtElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.createNonSyntheticValue(element, MagicKind.UNSUPPORTED_ELEMENT, new KtElement[0]);
        }

        private final boolean generateQualifier(KtExpression expression2, Qualifier qualifier) {
            FakeCallableDescriptorForObject fakeCallableDescriptorForObject;
            DeclarationDescriptor qualifierDescriptor = qualifier.getDescriptor();
            if (qualifierDescriptor instanceof ClassDescriptor && (fakeCallableDescriptorForObject = TowerLevelsKt.getFakeDescriptorForObject((ClassifierDescriptor)qualifierDescriptor)) != null) {
                FakeCallableDescriptorForObject fakeCallableDescriptorForObject2 = fakeCallableDescriptorForObject;
                boolean bl = false;
                boolean bl2 = false;
                FakeCallableDescriptorForObject it = fakeCallableDescriptorForObject2;
                boolean bl3 = false;
                this.mark(expression2);
                this.builder.read(expression2, new AccessTarget.Declaration(it), MapsKt.emptyMap());
                return true;
            }
            return false;
        }

        private final boolean generateCall(KtElement callElement) {
            Call call2;
            KtElement ktElement;
            ResolvedCall<? extends CallableDescriptor> resolvedCall2;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2 = CallUtilKt.getResolvedCall(callElement, bindingContext);
            KtElement ktElement2 = resolvedCall3 == null ? null : (ktElement = (call2 = resolvedCall3.getCall()) == null ? null : call2.getCallElement());
            if (ktElement == null) {
                return false;
            }
            KtElement ktElement3 = ktElement;
            KtElement callElementFromResolvedCall = ktElement3;
            if (PsiUtilsKt.isAncestor(callElement, callElementFromResolvedCall, true)) {
                return false;
            }
            return this.checkAndGenerateCall(resolvedCall2);
        }

        private final boolean checkAndGenerateCall(ResolvedCall<?> resolvedCall2) {
            if (resolvedCall2 == null) {
                return false;
            }
            this.generateCall(resolvedCall2);
            return true;
        }

        private final InstructionWithValue generateCall(ResolvedCall<?> resolvedCall2) {
            Instruction instruction;
            Object argumentMapping232;
            Object object;
            KtElement ktElement = resolvedCall2.getCall().getCallElement();
            Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"resolvedCall.call.callElement");
            KtElement callElement = ktElement;
            Map<PseudoValue, ReceiverValue> receivers = this.getReceiverValues(resolvedCall2);
            boolean bl = false;
            this.deferredGeneratorsStack.push(new ArrayList());
            SmartFMap<PseudoValue, ValueParameterDescriptor> smartFMap = SmartFMap.emptyMap();
            Intrinsics.checkNotNullExpressionValue(smartFMap, (String)"emptyMap<PseudoValue, ValueParameterDescriptor>()");
            SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues = smartFMap;
            for (ValueArgument valueArgument : resolvedCall2.getCall().getValueArguments()) {
                object = resolvedCall2.getArgumentMapping(valueArgument);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resolvedCall.getArgumentMapping(argument)");
                argumentMapping232 = object;
                KtExpression argumentExpression = valueArgument.getArgumentExpression();
                if (argumentMapping232 instanceof ArgumentMatch) {
                    Intrinsics.checkNotNullExpressionValue((Object)valueArgument, (String)"argument");
                    parameterValues = this.generateValueArgument(valueArgument, ((ArgumentMatch)argumentMapping232).getValueParameter(), parameterValues);
                    continue;
                }
                if (argumentExpression == null) continue;
                this.generateInstructions(argumentExpression);
                KtElement[] ktElementArray = new KtElement[]{argumentExpression};
                this.createSyntheticValue(argumentExpression, MagicKind.VALUE_CONSUMER, ktElementArray);
            }
            if (resolvedCall2.getResultingDescriptor() instanceof VariableDescriptor) {
                Object object2 = argumentMapping232 = callElement instanceof KtExpression ? (KtExpression)callElement : null;
                if (argumentMapping232 == null) {
                    object = Intrinsics.stringPlus((String)"Variable-based call without callee expression: ", (Object)callElement.getText());
                    boolean bl2 = false;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
                KtExpression ktExpression = argumentMapping232;
                boolean argumentMapping232 = parameterValues.isEmpty();
                boolean bl3 = false;
                if (_Assertions.ENABLED && !argumentMapping232) {
                    boolean $i$a$-assert-ControlFlowProcessor$CFPVisitor$generateCall$callInstruction$232 = false;
                    String $i$a$-assert-ControlFlowProcessor$CFPVisitor$generateCall$callInstruction$232 = Intrinsics.stringPlus((String)"Variable-based call with non-empty argument list: ", (Object)((KtExpression)callElement).getText());
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ControlFlowProcessor$CFPVisitor$generateCall$callInstruction$232));
                }
                instruction = this.builder.readVariable(ktExpression, resolvedCall2, receivers);
            } else {
                KtElement ktElement2 = resolvedCall2.getCall().getCallElement();
                Intrinsics.checkNotNullExpressionValue((Object)ktElement2, (String)"resolvedCall.call.callElement");
                this.mark(ktElement2);
                instruction = this.builder.call(callElement, resolvedCall2, receivers, (Map<PseudoValue, ? extends ValueParameterDescriptor>)parameterValues);
            }
            Instruction callInstruction = instruction;
            List<Function1<ControlFlowBuilder, Unit>> list2 = this.deferredGeneratorsStack.pop();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"deferredGeneratorsStack.pop()");
            Iterable iterable = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : iterable) {
                Function1 it = (Function1)element$iv;
                boolean bl4 = false;
                it.invoke((Object)this.builder);
            }
            return (InstructionWithValue)callInstruction;
        }

        private final Map<PseudoValue, ReceiverValue> getReceiverValues(ResolvedCall<?> resolvedCall2) {
            Object object;
            PseudoValue varCallResult = null;
            ReceiverValue explicitReceiver = null;
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                varCallResult = this.generateCall(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall()).getOutputValue();
                object = resolvedCall2.getExplicitReceiverKind();
                Intrinsics.checkNotNullExpressionValue(object, (String)"resolvedCall.explicitReceiverKind");
                Object kind = object;
                object = kind;
                int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
                switch (n) {
                    case 1: {
                        explicitReceiver = resolvedCall2.getDispatchReceiver();
                        break;
                    }
                    case 2: 
                    case 3: {
                        explicitReceiver = resolvedCall2.getExtensionReceiver();
                    }
                }
            }
            object = SmartFMap.emptyMap();
            Intrinsics.checkNotNullExpressionValue(object, (String)"emptyMap<PseudoValue, ReceiverValue>()");
            SmartFMap<PseudoValue, ReceiverValue> receiverValues = object;
            if (explicitReceiver != null && varCallResult != null) {
                object = receiverValues.plus(varCallResult, explicitReceiver);
                Intrinsics.checkNotNullExpressionValue(object, (String)"receiverValues.plus(varC\u2026Result, explicitReceiver)");
                receiverValues = object;
            }
            KtElement ktElement = resolvedCall2.getCall().getCallElement();
            Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"resolvedCall.call.callElement");
            KtElement callElement = ktElement;
            receiverValues = this.getReceiverValues(callElement, resolvedCall2.getDispatchReceiver(), receiverValues);
            receiverValues = this.getReceiverValues(callElement, resolvedCall2.getExtensionReceiver(), receiverValues);
            return receiverValues;
        }

        private final SmartFMap<PseudoValue, ReceiverValue> getReceiverValues(KtElement callElement, ReceiverValue receiver, SmartFMap<PseudoValue, ReceiverValue> receiverValuesArg) {
            SmartFMap<PseudoValue, ReceiverValue> receiverValues = receiverValuesArg;
            if (receiver == null || receiverValues.containsValue(receiver)) {
                return receiverValues;
            }
            ReceiverValue receiverValue = receiver;
            if (receiverValue instanceof ImplicitReceiver) {
                Object declaration2;
                if (callElement instanceof KtCallExpression && (declaration2 = ((ImplicitReceiver)receiver).getDeclarationDescriptor()) instanceof ClassDescriptor) {
                    FakeCallableDescriptorForObject fakeDescriptor = TowerLevelsKt.getFakeDescriptorForObject((ClassifierDescriptor)declaration2);
                    KtExpression calleeExpression = ((KtCallExpression)callElement).getCalleeExpression();
                    if (fakeDescriptor != null && calleeExpression != null) {
                        this.builder.read(calleeExpression, new AccessTarget.Declaration(fakeDescriptor), MapsKt.emptyMap());
                    }
                }
                declaration2 = receiverValues.plus(this.createSyntheticValue(callElement, MagicKind.IMPLICIT_RECEIVER, new KtElement[0]), receiver);
                Intrinsics.checkNotNullExpressionValue((Object)declaration2, (String)"receiverValues.plus(crea\u2026ICIT_RECEIVER), receiver)");
                receiverValues = declaration2;
            } else if (receiverValue instanceof ExpressionReceiver) {
                PseudoValue receiverPseudoValue;
                KtExpression expression2 = ((ExpressionReceiver)receiver).getExpression();
                if (this.builder.getBoundValue(expression2) == null) {
                    this.generateInstructions(expression2);
                }
                if ((receiverPseudoValue = this.getBoundOrUnreachableValue(expression2)) != null) {
                    SmartFMap<PseudoValue, ReceiverValue> smartFMap = receiverValues.plus(receiverPseudoValue, receiver);
                    Intrinsics.checkNotNullExpressionValue(smartFMap, (String)"receiverValues.plus(receiverPseudoValue, receiver)");
                    receiverValues = smartFMap;
                }
            } else if (!(receiverValue instanceof TransientReceiver)) {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unknown receiver kind: ", (Object)receiver));
            }
            return receiverValues;
        }

        private final SmartFMap<PseudoValue, ValueParameterDescriptor> generateValueArgument(ValueArgument valueArgument, ValueParameterDescriptor parameterDescriptor, SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValuesArg) {
            SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues = parameterValuesArg;
            KtExpression expression2 = valueArgument.getArgumentExpression();
            if (expression2 != null) {
                PseudoValue argValue;
                if (!valueArgument.isExternal()) {
                    this.generateInstructions(expression2);
                }
                if ((argValue = this.getBoundOrUnreachableValue(expression2)) != null) {
                    SmartFMap<PseudoValue, ValueParameterDescriptor> smartFMap = parameterValues.plus(argValue, parameterDescriptor);
                    Intrinsics.checkNotNullExpressionValue(smartFMap, (String)"parameterValues.plus(arg\u2026lue, parameterDescriptor)");
                    parameterValues = smartFMap;
                }
            }
            return parameterValues;
        }

        public static final /* synthetic */ PseudoValue access$getBoundOrUnreachableValue(CFPVisitor $this, KtElement element) {
            return $this.getBoundOrUnreachableValue(element);
        }

        public static final /* synthetic */ boolean access$generateCall(CFPVisitor $this, KtElement callElement) {
            return $this.generateCall(callElement);
        }

        public static final /* synthetic */ PseudoValue access$createNonSyntheticValue(CFPVisitor $this, KtElement to, MagicKind kind, KtElement ... from) {
            return $this.createNonSyntheticValue(to, kind, from);
        }

        public static final /* synthetic */ void access$mark(CFPVisitor $this, KtElement element) {
            $this.mark(element);
        }

        public static final /* synthetic */ void access$copyValue(CFPVisitor $this, KtElement from, KtElement to) {
            $this.copyValue(from, to);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$FinallyBlockGenerator;", "", "finallyBlock", "Lorg/jetbrains/kotlin/psi/KtFinallySection;", "(Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor;Lorg/jetbrains/kotlin/psi/KtFinallySection;)V", "finishFinally", "Lorg/jetbrains/kotlin/cfg/Label;", "startFinally", "generate", "", "cfg"})
        private final class FinallyBlockGenerator {
            @Nullable
            private final KtFinallySection finallyBlock;
            @Nullable
            private Label startFinally;
            @Nullable
            private Label finishFinally;

            public FinallyBlockGenerator(KtFinallySection finallyBlock) {
                Intrinsics.checkNotNullParameter((Object)CFPVisitor.this, (String)"this$0");
                this.finallyBlock = finallyBlock;
            }

            public final void generate() {
                Object object;
                Object object2 = this.finallyBlock;
                Object object3 = object = object2 == null ? null : ((KtFinallySection)object2).getFinalExpression();
                if (object == null) {
                    return;
                }
                KtBlockExpression finalExpression = object;
                CFPVisitor.this.catchFinallyStack.push(new CatchFinallyLabels(null, null, null));
                object = this.startFinally;
                if (object != null) {
                    object2 = object;
                    CFPVisitor cFPVisitor = CFPVisitor.this;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    boolean bl4 = this.finishFinally != null;
                    boolean bl5 = false;
                    if (_Assertions.ENABLED && !bl4) {
                        boolean bl6 = false;
                        String string2 = "startFinally label is set to " + this.startFinally + " but finishFinally label is not set";
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    ControlFlowBuilder controlFlowBuilder = cFPVisitor.builder;
                    Label label = this.finishFinally;
                    Intrinsics.checkNotNull((Object)label);
                    controlFlowBuilder.repeatPseudocode((Label)it, label);
                    cFPVisitor.catchFinallyStack.pop();
                    return;
                }
                object = CFPVisitor.this.builder.createUnboundLabel("start finally");
                object2 = CFPVisitor.this;
                boolean bl = false;
                boolean bl7 = false;
                Object it = object;
                boolean bl8 = false;
                this.startFinally = it;
                ((CFPVisitor)object2).builder.bindLabel((Label)it);
                CFPVisitor.this.generateInstructions(finalExpression);
                object = CFPVisitor.this.builder.createUnboundLabel("finish finally");
                object2 = CFPVisitor.this;
                bl = false;
                bl7 = false;
                it = object;
                boolean bl9 = false;
                this.finishFinally = it;
                ((CFPVisitor)object2).builder.bindLabel((Label)it);
                CFPVisitor.this.catchFinallyStack.pop();
            }
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ExplicitReceiverKind.values().length];
                nArray[ExplicitReceiverKind.DISPATCH_RECEIVER.ordinal()] = 1;
                nArray[ExplicitReceiverKind.EXTENSION_RECEIVER.ordinal()] = 2;
                nArray[ExplicitReceiverKind.BOTH_RECEIVERS.ordinal()] = 3;
                nArray[ExplicitReceiverKind.NO_EXPLICIT_RECEIVER.ordinal()] = 4;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

