/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002J\u001c\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0002J*\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u000fJ\f\u0010\u001c\u001a\u00020\r*\u00020\u000fH\u0002J\f\u0010\u001c\u001a\u00020\r*\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\r*\u00020\u001dH\u0002J\u0014\u0010\u001f\u001a\u00020\r*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020 H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeReplacedWithOperatorAssignmentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVariableAssignmentChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "isCommutativeOperator", "", "operator", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "isHierarchicallyTrue", "currentOperation", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "nextOperation", "isLightNodesHierarchicallyTrue", "first", "second", "lightTreeMatcher", "variable", "source", "Lorg/jetbrains/kotlin/fir/FirLightSourceElement;", "prevOperator", "canBeAugmented", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isCommutative", "matcher", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "checkers"})
public final class CanBeReplacedWithOperatorAssignmentChecker
extends FirExpressionChecker<FirVariableAssignment> {
    @NotNull
    public static final CanBeReplacedWithOperatorAssignmentChecker INSTANCE = new CanBeReplacedWithOperatorAssignmentChecker();

    private CanBeReplacedWithOperatorAssignmentChecker() {
    }

    @Override
    public void check(@NotNull FirVariableAssignment expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        ConeKotlinType coneKotlinType;
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirReference lValue = expression2.getLValue();
        if (!(lValue instanceof FirResolvedNamedReference)) {
            return;
        }
        FirSourceElement firSourceElement = expression2.getSource();
        if ((firSourceElement == null ? null : firSourceElement.getKind()) instanceof FirFakeSourceElementKind) {
            return;
        }
        FirCallableSymbol<?> firCallableSymbol = expression2.getRValue();
        Object object2 = object = firCallableSymbol instanceof FirFunctionCall ? (FirFunctionCall)((Object)firCallableSymbol) : null;
        if (object == null) {
            return;
        }
        Object rValue = object;
        if (((object = ((FirFunctionCall)rValue).getSource()) == null ? null : ((FirSourceElement)object).getKind()) instanceof FirFakeSourceElementKind) {
            return;
        }
        object = ((FirFunctionCall)rValue).getExplicitReceiver();
        if (!(object == null ? false : ((firCallableSymbol = ((FirExpression)object).getTypeRef()) == null ? false : ((coneKotlinType = FirTypeUtilsKt.getConeType((FirTypeRef)((Object)firCallableSymbol))) == null ? false : ConeTypeUtilsKt.isPrimitive(coneKotlinType))))) {
            return;
        }
        firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol((FirExpression)rValue);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol<?> rValueResolvedSymbol = firCallableSymbol;
        if (!((firCallableSymbol = ClassMembersKt.dispatchReceiverTypeOrNull(rValueResolvedSymbol)) == null ? false : ConeTypeUtilsKt.isPrimitive((ConeKotlinType)((Object)firCallableSymbol)))) {
            return;
        }
        boolean needToReport = false;
        FirSourceElement assignmentSource = expression2.getSource();
        if (assignmentSource instanceof FirPsiSourceElement) {
            KtNameReferenceExpression ktNameReferenceExpression;
            PsiElement psiElement = FirSourceElementKt.getPsi(lValue);
            KtNameReferenceExpression ktNameReferenceExpression2 = ktNameReferenceExpression = psiElement instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)psiElement : null;
            if (ktNameReferenceExpression == null) {
                return;
            }
            KtNameReferenceExpression lValuePsi = ktNameReferenceExpression;
            PsiElement psiElement2 = FirSourceElementKt.getPsi((FirElement)rValue);
            PsiElement psiElement3 = psiElement = psiElement2 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement2 : null;
            if (psiElement == null) {
                return;
            }
            PsiElement rValuePsi = psiElement;
            if (this.matcher((KtBinaryExpression)rValuePsi, lValuePsi)) {
                needToReport = true;
            }
        } else if (assignmentSource instanceof FirLightSourceElement) {
            FirSourceElement firSourceElement2 = lValue.getSource();
            Intrinsics.checkNotNull((Object)firSourceElement2);
            LighterASTNode lValueLightTree = firSourceElement2.getLighterASTNode();
            FirSourceElement firSourceElement3 = ((FirFunctionCall)rValue).getSource();
            Intrinsics.checkNotNull((Object)firSourceElement3);
            LighterASTNode rValueLightTree = firSourceElement3.getLighterASTNode();
            if (CanBeReplacedWithOperatorAssignmentChecker.lightTreeMatcher$default(this, lValueLightTree, rValueLightTree, (FirLightSourceElement)assignmentSource, null, 8, null)) {
                needToReport = true;
            }
        }
        if (needToReport) {
            DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getCAN_BE_REPLACED_WITH_OPERATOR_ASSIGNMENT(), context2, null, 8, null);
        }
    }

    public final boolean lightTreeMatcher(@NotNull LighterASTNode variable2, @NotNull LighterASTNode expression2, @NotNull FirLightSourceElement source, @Nullable LighterASTNode prevOperator) {
        Object v0;
        Object $this$firstOrNull$iv;
        List children2;
        block6: {
            Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            FlyweightCapableTreeStructure<LighterASTNode> tree = source.getTreeStructure();
            children2 = CollectionsKt.filterNotNull((Iterable)SourceHelpersKt.getChildren(expression2, tree));
            $this$firstOrNull$iv = children2;
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                LighterASTNode it = (LighterASTNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.OPERATION_REFERENCE)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        LighterASTNode operator = v0;
        if (prevOperator != null && !this.isLightNodesHierarchicallyTrue(prevOperator, operator)) {
            return false;
        }
        $this$firstOrNull$iv = operator;
        if ($this$firstOrNull$iv == null ? false : !this.canBeAugmented((LighterASTNode)$this$firstOrNull$iv)) {
            return false;
        }
        boolean commutative = operator != null && this.isCommutativeOperator(operator);
        boolean afterOperatorNode = false;
        Iterable $this$forEach$iv = children2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LighterASTNode it = (LighterASTNode)element$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.REFERENCE_EXPRESSION)) {
                if (!commutative && afterOperatorNode || !Intrinsics.areEqual((Object)it.toString(), (Object)variable2.toString())) continue;
                return true;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BINARY_EXPRESSION)) {
                return INSTANCE.lightTreeMatcher(variable2, it, source, operator);
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OPERATION_REFERENCE)) continue;
            afterOperatorNode = true;
        }
        return false;
    }

    public static /* synthetic */ boolean lightTreeMatcher$default(CanBeReplacedWithOperatorAssignmentChecker canBeReplacedWithOperatorAssignmentChecker, LighterASTNode lighterASTNode2, LighterASTNode lighterASTNode3, FirLightSourceElement firLightSourceElement, LighterASTNode lighterASTNode4, int n, Object object) {
        if ((n & 8) != 0) {
            lighterASTNode4 = null;
        }
        return canBeReplacedWithOperatorAssignmentChecker.lightTreeMatcher(lighterASTNode2, lighterASTNode3, firLightSourceElement, lighterASTNode4);
    }

    private final boolean matcher(KtBinaryExpression $this$matcher, KtNameReferenceExpression variable2) {
        boolean bl;
        KtBinaryExpression leftExpression;
        if (!this.canBeAugmented($this$matcher)) {
            return false;
        }
        Object object = $this$matcher.getLeft();
        KtNameReferenceExpression ktNameReferenceExpression = object instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)object : null;
        if (Intrinsics.areEqual((Object)(ktNameReferenceExpression == null ? null : ktNameReferenceExpression.getReferencedName()), (Object)variable2.getReferencedName())) {
            return true;
        }
        object = $this$matcher.getRight();
        ktNameReferenceExpression = object instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)object : null;
        if (Intrinsics.areEqual((Object)(ktNameReferenceExpression == null ? null : ktNameReferenceExpression.getReferencedName()), (Object)variable2.getReferencedName()) && this.isCommutative($this$matcher)) {
            return true;
        }
        if (this.isCommutative($this$matcher)) {
            boolean isRightMatch;
            boolean isLeftMatch;
            object = $this$matcher.getLeft();
            leftExpression = object instanceof KtBinaryExpression ? (KtBinaryExpression)object : null;
            KtExpression ktExpression = $this$matcher.getRight();
            KtBinaryExpression rightExpression = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
            Object object2 = $this$matcher.getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"operationToken");
            IElementType iElementType = object2;
            object2 = leftExpression;
            boolean bl2 = this.isHierarchicallyTrue(iElementType, object2 == null ? null : ((KtBinaryExpression)object2).getOperationToken()) && ((object2 = leftExpression) == null ? false : this.matcher((KtBinaryExpression)object2, variable2)) ? true : (isLeftMatch = false);
            if (isLeftMatch) {
                return true;
            }
            Object object3 = $this$matcher.getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"operationToken");
            IElementType iElementType2 = object3;
            object3 = rightExpression;
            boolean bl3 = this.isHierarchicallyTrue(iElementType2, object3 == null ? null : ((KtBinaryExpression)object3).getOperationToken()) && ((object3 = rightExpression) == null ? false : this.matcher((KtBinaryExpression)object3, variable2)) ? true : (isRightMatch = false);
            if (isRightMatch) {
                return true;
            }
            bl = false;
        } else {
            object = $this$matcher.getLeft();
            leftExpression = object instanceof KtBinaryExpression ? (KtBinaryExpression)object : null;
            object = $this$matcher.getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"operationToken");
            Object object4 = object;
            object = leftExpression;
            bl = this.isHierarchicallyTrue((IElementType)object4, object == null ? null : ((KtBinaryExpression)object).getOperationToken()) && ((object = leftExpression) == null ? false : this.matcher((KtBinaryExpression)object, variable2));
        }
        return bl;
    }

    private final boolean isCommutative(KtBinaryExpression $this$isCommutative) {
        return Intrinsics.areEqual((Object)$this$isCommutative.getOperationToken(), (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)$this$isCommutative.getOperationToken(), (Object)KtTokens.MUL);
    }

    private final boolean canBeAugmented(KtBinaryExpression $this$canBeAugmented) {
        return Intrinsics.areEqual((Object)$this$canBeAugmented.getOperationToken(), (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)$this$canBeAugmented.getOperationToken(), (Object)KtTokens.MUL) || Intrinsics.areEqual((Object)$this$canBeAugmented.getOperationToken(), (Object)KtTokens.MINUS) || Intrinsics.areEqual((Object)$this$canBeAugmented.getOperationToken(), (Object)KtTokens.DIV) || Intrinsics.areEqual((Object)$this$canBeAugmented.getOperationToken(), (Object)KtTokens.PERC);
    }

    private final boolean isHierarchicallyTrue(IElementType currentOperation, IElementType nextOperation) {
        return Intrinsics.areEqual((Object)currentOperation, (Object)nextOperation);
    }

    private final boolean isCommutativeOperator(LighterASTNode operator) {
        String string2 = operator.toString();
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        return Intrinsics.areEqual((Object)it, (Object)"+") || Intrinsics.areEqual((Object)it, (Object)"*");
    }

    private final boolean isLightNodesHierarchicallyTrue(LighterASTNode first, LighterASTNode second) {
        return Intrinsics.areEqual((Object)String.valueOf(first), (Object)String.valueOf(second));
    }

    private final boolean canBeAugmented(LighterASTNode $this$canBeAugmented) {
        String string2 = $this$canBeAugmented.toString();
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        return Intrinsics.areEqual((Object)it, (Object)"+") || Intrinsics.areEqual((Object)it, (Object)"*") || Intrinsics.areEqual((Object)it, (Object)"-") || Intrinsics.areEqual((Object)it, (Object)"/") || Intrinsics.areEqual((Object)it, (Object)"%");
    }
}

