/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010 \u001a\u00020\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R&\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR&\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001c\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "", "environment", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;)V", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "(Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;)V", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "(Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;)V", "getCallStack", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "irExceptions", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getIrExceptions", "()Ljava/util/List;", "mapOfEnums", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "getMapOfEnums", "()Ljava/util/Map;", "setMapOfEnums", "(Ljava/util/Map;)V", "mapOfObjects", "getMapOfObjects", "setMapOfObjects", "copyWithNewCallStack", "Companion", "ir.interpreter"})
public final class IrInterpreterEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final CallStack callStack;
    @NotNull
    private final List<IrClass> irExceptions;
    @NotNull
    private Map<IrSymbol, Complex> mapOfEnums;
    @NotNull
    private Map<IrSymbol, Complex> mapOfObjects;
    public static final int MAX_STACK = 10000;
    public static final int MAX_COMMANDS = 1000000;

    public IrInterpreterEnvironment(@NotNull IrBuiltIns irBuiltIns, @NotNull CallStack callStack) {
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter((Object)callStack, (String)"callStack");
        this.irBuiltIns = irBuiltIns;
        this.callStack = callStack;
        boolean bl = false;
        this.irExceptions = new ArrayList();
        bl = false;
        this.mapOfEnums = new LinkedHashMap();
        bl = false;
        this.mapOfObjects = new LinkedHashMap();
        Map<IrSymbol, Complex> map = this.mapOfObjects;
        IrClassSymbol irClassSymbol = this.irBuiltIns.getUnitClass();
        Common common = new Common((IrClass)this.irBuiltIns.getUnitClass().getOwner());
        boolean bl2 = false;
        map.put(irClassSymbol, common);
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @NotNull
    public final CallStack getCallStack() {
        return this.callStack;
    }

    @NotNull
    public final List<IrClass> getIrExceptions() {
        return this.irExceptions;
    }

    @NotNull
    public final Map<IrSymbol, Complex> getMapOfEnums() {
        return this.mapOfEnums;
    }

    public final void setMapOfEnums(@NotNull Map<IrSymbol, Complex> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.mapOfEnums = map;
    }

    @NotNull
    public final Map<IrSymbol, Complex> getMapOfObjects() {
        return this.mapOfObjects;
    }

    public final void setMapOfObjects(@NotNull Map<IrSymbol, Complex> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.mapOfObjects = map;
    }

    private IrInterpreterEnvironment(IrInterpreterEnvironment environment) {
        this(environment.irBuiltIns, new CallStack());
        this.irExceptions.addAll((Collection<IrClass>)environment.irExceptions);
        this.mapOfEnums = environment.mapOfEnums;
        this.mapOfObjects = environment.mapOfObjects;
    }

    /*
     * WARNING - void declaration
     */
    public IrInterpreterEnvironment(@NotNull IrModuleFragment irModule) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        IrElementBase it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        this(irModule.getIrBuiltins(), new CallStack());
        Iterable iterable = irModule.getFiles();
        List<IrClass> list2 = this.irExceptions;
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrFile)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getDeclarations();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        $this$flatMap$iv = list3;
        boolean $i$f$filterIsInstance = false;
        $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrClass)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list3 = (List)destination$iv$iv;
        $this$filterIsInstance$iv = list3;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrClass)element$iv$iv;
            boolean bl = false;
            if (!IrUtilsKt.isSubclassOf((IrClass)it, (IrClass)this.getIrBuiltIns().getThrowableClass().getOwner())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list3 = (List)destination$iv$iv;
        list2.addAll(list3);
    }

    @NotNull
    public final IrInterpreterEnvironment copyWithNewCallStack() {
        return new IrInterpreterEnvironment(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment$Companion;", "", "()V", "MAX_COMMANDS", "", "MAX_STACK", "ir.interpreter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

