/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.internal.precompiled;

import com.google.common.base.CaseFormat;
import java.io.File;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.configuration.ScriptTarget;
import org.gradle.groovy.scripts.DelegatingScriptSource;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.TextResourceScriptSource;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.resource.TextFileResourceLoader;
import org.gradle.plugin.devel.PluginDeclaration;
import org.gradle.plugin.devel.internal.precompiled.PrecompiledScriptTarget;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.DefaultPluginId;

class PrecompiledGroovyScript {
    private static final String SCRIPT_PLUGIN_EXTENSION = ".gradle";
    private final ScriptSource firstPassSource;
    private final ScriptSource scriptSource;
    private final Type type;
    private final PluginId pluginId;
    private final ScriptTarget scriptTarget;
    private final String precompiledScriptClassName;

    PrecompiledGroovyScript(File scriptFile, TextFileResourceLoader resourceLoader) {
        String fileName = scriptFile.getName();
        this.type = Type.getType(fileName);
        this.pluginId = this.type.toPluginId(fileName);
        this.precompiledScriptClassName = PrecompiledGroovyScript.toJavaIdentifier(PrecompiledGroovyScript.kebabCaseToPascalCase(this.pluginId.getId().replace('.', '-')));
        this.firstPassSource = new PrecompiledScriptPluginFirstPassSource(scriptFile, this.precompiledScriptClassName, resourceLoader);
        this.scriptSource = new PrecompiledScriptPluginSource(scriptFile, this.precompiledScriptClassName, resourceLoader);
        this.scriptTarget = new PrecompiledScriptTarget(this.type != Type.INIT, this.type == Type.SETTINGS);
    }

    static void filterPluginFiles(PatternFilterable patternFilterable) {
        patternFilterable.include(new String[]{"**/*.gradle"});
    }

    void declarePlugin(PluginDeclaration pluginDeclaration) {
        pluginDeclaration.setImplementationClass(this.getPluginAdapterClassName());
        pluginDeclaration.setId(this.pluginId.getId());
    }

    String getId() {
        return this.pluginId.getId();
    }

    String getPluginAdapterClassName() {
        return this.precompiledScriptClassName + "Plugin";
    }

    String getFirstPassClassName() {
        return this.firstPassSource.getClassName();
    }

    String getBodyClassName() {
        return this.scriptSource.getClassName();
    }

    HashCode getContentHash() {
        return this.scriptSource.getResource().getContentHash();
    }

    ScriptSource getFirstPassSource() {
        return this.firstPassSource;
    }

    ScriptSource getBodySource() {
        return this.scriptSource;
    }

    ScriptTarget getScriptTarget() {
        return this.scriptTarget;
    }

    String getTargetClassName() {
        return this.type.targetClass.getName();
    }

    private static String kebabCaseToPascalCase(String s) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, s);
    }

    private static String toJavaIdentifier(String s) {
        StringBuilder sb = new StringBuilder();
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            sb.append("_");
        }
        for (char c : s.toCharArray()) {
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            sb.append("_");
        }
        return sb.toString();
    }

    private static class PrecompiledScriptPluginFirstPassSource
    extends PrecompiledScriptPluginSource {
        public PrecompiledScriptPluginFirstPassSource(File scriptFile, String className, TextFileResourceLoader resourceLoader) {
            super(scriptFile, className, resourceLoader);
        }

        @Override
        public String getClassName() {
            return "cp_" + super.getClassName();
        }
    }

    private static class PrecompiledScriptPluginSource
    extends DelegatingScriptSource {
        private final File scriptFile;
        private final String className;

        public PrecompiledScriptPluginSource(File scriptFile, String className, TextFileResourceLoader resourceLoader) {
            super((ScriptSource)new TextResourceScriptSource(resourceLoader.loadFile("script", scriptFile)));
            this.scriptFile = scriptFile;
            this.className = "precompiled_" + className;
        }

        public String getClassName() {
            return this.className;
        }

        public String getFileName() {
            return this.scriptFile.getPath();
        }
    }

    private static enum Type {
        PROJECT(ProjectInternal.class, ".gradle"),
        SETTINGS(SettingsInternal.class, ".settings.gradle"),
        INIT(GradleInternal.class, ".init.gradle");

        private final Class<?> targetClass;
        private final String fileExtension;

        private Type(Class<?> targetClass, String fileExtension) {
            this.targetClass = targetClass;
            this.fileExtension = fileExtension;
        }

        static Type getType(String fileName) {
            if (fileName.endsWith(Type.SETTINGS.fileExtension)) {
                return SETTINGS;
            }
            if (fileName.endsWith(Type.INIT.fileExtension)) {
                return INIT;
            }
            return PROJECT;
        }

        PluginId toPluginId(String fileName) {
            return DefaultPluginId.of((String)fileName.substring(0, fileName.lastIndexOf(this.fileExtension)));
        }
    }
}

