/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.SortedMap;
import org.gradle.api.Describable;
import org.gradle.internal.Cast;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.history.changes.CachingChangeContainer;
import org.gradle.internal.execution.history.changes.Change;
import org.gradle.internal.execution.history.changes.ChangeContainer;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.ErrorHandlingChangeContainer;
import org.gradle.internal.execution.history.changes.ExecutionStateChangeDetector;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.ImplementationChanges;
import org.gradle.internal.execution.history.changes.IncrementalInputProperties;
import org.gradle.internal.execution.history.changes.InputFileChanges;
import org.gradle.internal.execution.history.changes.InputValueChanges;
import org.gradle.internal.execution.history.changes.OutputFileChanges;
import org.gradle.internal.execution.history.changes.PreviousSuccessChanges;
import org.gradle.internal.execution.history.changes.PropertyChanges;
import org.gradle.internal.execution.history.changes.SummarizingChangeContainer;
import org.gradle.internal.execution.history.impl.OutputSnapshotUtil;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.impl.KnownImplementationSnapshot;

public class DefaultExecutionStateChangeDetector
implements ExecutionStateChangeDetector {
    @Override
    public ExecutionStateChanges detectChanges(Describable executable, PreviousExecutionState lastExecution, BeforeExecutionState thisExecution, IncrementalInputProperties incrementalInputProperties) {
        PreviousSuccessChanges previousSuccessState = new PreviousSuccessChanges(lastExecution.isSuccessful());
        KnownImplementationSnapshot currentImplementation = (KnownImplementationSnapshot)Cast.uncheckedNonnullCast((Object)thisExecution.getImplementation());
        ImmutableList currentAdditionalImplementations = (ImmutableList)Cast.uncheckedNonnullCast(thisExecution.getAdditionalImplementations());
        ImplementationChanges implementationChanges = new ImplementationChanges(lastExecution.getImplementation(), lastExecution.getAdditionalImplementations(), currentImplementation, (ImmutableList<KnownImplementationSnapshot>)currentAdditionalImplementations, executable);
        PropertyChanges inputPropertyChanges = new PropertyChanges((ImmutableSortedSet<String>)lastExecution.getInputProperties().keySet(), (ImmutableSortedSet<String>)thisExecution.getInputProperties().keySet(), "Input", executable);
        InputValueChanges inputPropertyValueChanges = new InputValueChanges(lastExecution.getInputProperties(), thisExecution.getInputProperties(), executable);
        PropertyChanges inputFilePropertyChanges = new PropertyChanges((ImmutableSortedSet<String>)lastExecution.getInputFileProperties().keySet(), (ImmutableSortedSet<String>)thisExecution.getInputFileProperties().keySet(), "Input file", executable);
        InputFileChanges nonIncrementalInputFileChanges = incrementalInputProperties.nonIncrementalChanges(lastExecution.getInputFileProperties(), thisExecution.getInputFileProperties());
        PropertyChanges outputFilePropertyChanges = new PropertyChanges((ImmutableSortedSet<String>)lastExecution.getOutputFilesProducedByWork().keySet(), (ImmutableSortedSet<String>)thisExecution.getOutputFileLocationSnapshots().keySet(), "Output", executable);
        ImmutableSortedMap<String, FileSystemSnapshot> remainingPreviouslyProducedOutputs = thisExecution.getDetectedOverlappingOutputs().isPresent() ? OutputSnapshotUtil.findOutputsStillPresentSincePreviousExecution(lastExecution.getOutputFilesProducedByWork(), thisExecution.getOutputFileLocationSnapshots()) : thisExecution.getOutputFileLocationSnapshots();
        OutputFileChanges outputFileChanges = new OutputFileChanges((SortedMap<String, FileSystemSnapshot>)lastExecution.getOutputFilesProducedByWork(), (SortedMap<String, FileSystemSnapshot>)remainingPreviouslyProducedOutputs);
        ChangeContainer rebuildTriggeringChanges = DefaultExecutionStateChangeDetector.errorHandling(executable, new SummarizingChangeContainer(previousSuccessState, implementationChanges, inputPropertyChanges, inputPropertyValueChanges, outputFilePropertyChanges, outputFileChanges, inputFilePropertyChanges, nonIncrementalInputFileChanges));
        ImmutableList<String> rebuildReasons = DefaultExecutionStateChangeDetector.collectChanges(rebuildTriggeringChanges);
        if (!rebuildReasons.isEmpty()) {
            return ExecutionStateChanges.nonIncremental(rebuildReasons, thisExecution, incrementalInputProperties);
        }
        InputFileChanges directIncrementalInputFileChanges = incrementalInputProperties.incrementalChanges(lastExecution.getInputFileProperties(), thisExecution.getInputFileProperties());
        InputFileChanges incrementalInputFileChanges = DefaultExecutionStateChangeDetector.errorHandling(executable, DefaultExecutionStateChangeDetector.caching(directIncrementalInputFileChanges));
        ImmutableList<String> incrementalInputFileChangeMessages = DefaultExecutionStateChangeDetector.collectChanges(incrementalInputFileChanges);
        return ExecutionStateChanges.incremental(incrementalInputFileChangeMessages, thisExecution, incrementalInputFileChanges, incrementalInputProperties);
    }

    private static ImmutableList<String> collectChanges(ChangeContainer changes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        MessageCollectingChangeVisitor visitor = new MessageCollectingChangeVisitor((ImmutableCollection.Builder<String>)builder, 3);
        changes.accept(visitor);
        return builder.build();
    }

    private static InputFileChanges caching(InputFileChanges wrapped) {
        CachingChangeContainer cachingChangeContainer = new CachingChangeContainer(3, wrapped);
        return new InputFileChangesWrapper(wrapped, cachingChangeContainer);
    }

    private static ChangeContainer errorHandling(Describable executable, ChangeContainer wrapped) {
        return new ErrorHandlingChangeContainer(executable, wrapped);
    }

    private static InputFileChanges errorHandling(Describable executable, InputFileChanges wrapped) {
        ErrorHandlingChangeContainer errorHandlingChangeContainer = new ErrorHandlingChangeContainer(executable, wrapped);
        return new InputFileChangesWrapper(wrapped, errorHandlingChangeContainer);
    }

    private static class MessageCollectingChangeVisitor
    implements ChangeVisitor {
        private final ImmutableCollection.Builder<String> messages;
        private final int max;
        private int count;

        public MessageCollectingChangeVisitor(ImmutableCollection.Builder<String> messages, int max) {
            this.messages = messages;
            this.max = max;
        }

        @Override
        public boolean visitChange(Change change) {
            this.messages.add((Object)change.getMessage());
            return ++this.count < this.max;
        }
    }

    private static class InputFileChangesWrapper
    implements InputFileChanges {
        private final InputFileChanges inputFileChangesDelegate;
        private final ChangeContainer changeContainerDelegate;

        public InputFileChangesWrapper(InputFileChanges inputFileChangesDelegate, ChangeContainer changeContainerDelegate) {
            this.inputFileChangesDelegate = inputFileChangesDelegate;
            this.changeContainerDelegate = changeContainerDelegate;
        }

        @Override
        public boolean accept(String propertyName, ChangeVisitor visitor) {
            return this.inputFileChangesDelegate.accept(propertyName, visitor);
        }

        @Override
        public boolean accept(ChangeVisitor visitor) {
            return this.changeContainerDelegate.accept(visitor);
        }
    }
}

