/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/SelfCallInNestedObjectConstructorChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "Visitor", "frontend"})
public final class SelfCallInNestedObjectConstructorChecker
implements CallChecker {
    @NotNull
    public static final SelfCallInNestedObjectConstructorChecker INSTANCE = new SelfCallInNestedObjectConstructorChecker();

    private SelfCallInNestedObjectConstructorChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object candidateDescriptor = resolvedCall2.getCandidateDescriptor();
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"resolvedCall.call");
        Call call3 = call2;
        if (!(candidateDescriptor instanceof ConstructorDescriptor) || !CallResolverUtilKt.isSuperOrDelegatingConstructorCall(call3)) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = context2.getResolutionContext().scope.getOwnerDescriptor().getContainingDeclaration();
        ClassDescriptor classDescriptor2 = classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor constructedObject = classDescriptor;
        if (constructedObject.getKind() != ClassKind.OBJECT) {
            return;
        }
        DeclarationDescriptor declarationDescriptor2 = constructedObject.getContainingDeclaration();
        DeclarationDescriptor declarationDescriptor3 = declarationDescriptor = declarationDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor2 : null;
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor containingClass = declarationDescriptor;
        if (Intrinsics.areEqual((Object)((ConstructorDescriptor)candidateDescriptor).getConstructedClass(), (Object)containingClass)) {
            boolean reportError2 = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitSelfCallsInNestedObjects);
            Visitor visitor2 = new Visitor((ClassDescriptor)containingClass, context2.getTrace(), reportError2);
            KtValueArgumentList ktValueArgumentList = resolvedCall2.getCall().getValueArgumentList();
            if (ktValueArgumentList != null) {
                ktValueArgumentList.accept(visitor2);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/SelfCallInNestedObjectConstructorChecker$Visitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "containingClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "reportError", "", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/resolve/BindingTrace;Z)V", "getContainingClass", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getReportError", "()Z", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkArgument", "", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkReceiver", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "argument", "visitExpression", "expression", "visitKtElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "frontend"})
    private static final class Visitor
    extends KtVisitorVoid {
        @NotNull
        private final ClassDescriptor containingClass;
        @NotNull
        private final BindingTrace trace;
        private final boolean reportError;

        public Visitor(@NotNull ClassDescriptor containingClass, @NotNull BindingTrace trace, boolean reportError2) {
            Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            this.containingClass = containingClass;
            this.trace = trace;
            this.reportError = reportError2;
        }

        @NotNull
        public final ClassDescriptor getContainingClass() {
            return this.containingClass;
        }

        @NotNull
        public final BindingTrace getTrace() {
            return this.trace;
        }

        public final boolean getReportError() {
            return this.reportError;
        }

        @Override
        public void visitKtElement(@NotNull KtElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren(this, null);
        }

        @Override
        public void visitExpression(@NotNull KtExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.checkArgument(expression2);
            expression2.acceptChildren(this, null);
        }

        private final void checkArgument(KtExpression argumentExpression) {
            KtElement ktElement = argumentExpression;
            Object object = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"trace.bindingContext");
            Call call2 = CallUtilKt.getCall(ktElement, (BindingContext)object);
            if (call2 == null) {
                return;
            }
            Call call3 = call2;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            object = CallUtilKt.getResolvedCall(call3, bindingContext);
            if (object == null) {
                return;
            }
            Object resolvedCall2 = object;
            this.checkReceiver(resolvedCall2.getDispatchReceiver(), argumentExpression);
        }

        private final void checkReceiver(ReceiverValue receiver, KtExpression argument2) {
            Annotated annotated;
            Object object = receiver;
            KotlinType kotlinType = annotated = object == null ? null : object.getType();
            if (annotated == null) {
                return;
            }
            KotlinType kotlinType2 = annotated;
            KotlinType receiverType = kotlinType2;
            object = receiverType.getConstructor().getDeclarationDescriptor();
            Annotated annotated2 = annotated = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
            if (annotated == null) {
                return;
            }
            Annotated receiverClass = annotated;
            if (DescriptorUtils.isSubclass((ClassDescriptor)receiverClass, this.containingClass)) {
                DiagnosticFactory0<KtExpression> factory2 = this.reportError ? Errors.SELF_CALL_IN_NESTED_OBJECT_CONSTRUCTOR : Errors.SELF_CALL_IN_NESTED_OBJECT_CONSTRUCTOR_WARNING;
                this.trace.report(factory2.on((KtExpression)((PsiElement)argument2)));
            }
        }
    }
}

