/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.kotlin.dsl.support.ScriptCompilationError;
import org.gradle.kotlin.dsl.support.ScriptCompilationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0080\b\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\u0019\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0005H\u0002J\t\u0010#\u001a\u00020\u000eH\u00d6\u0001J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u0004H\u0002J\u0010\u0010%\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\bH\u0002J\t\u0010(\u001a\u00020\bH\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\n\u00a8\u0006)"}, d2={"Lorg/gradle/kotlin/dsl/support/ScriptCompilationException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "errors", "", "Lorg/gradle/kotlin/dsl/support/ScriptCompilationError;", "(Ljava/util/List;)V", "errorPlural", "", "getErrorPlural", "()Ljava/lang/String;", "getErrors", "()Ljava/util/List;", "firstErrorLine", "", "getFirstErrorLine", "()Ljava/lang/Integer;", "maxLineNumberStringLength", "getMaxLineNumberStringLength", "()I", "maxLineNumberStringLength$delegate", "Lkotlin/Lazy;", "message", "getMessage", "component1", "copy", "equals", "", "other", "", "errorAt", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "errorMessage", "error", "hashCode", "indentedErrorMessages", "lineNumber", "prependIndent", "it", "toString", "kotlin-dsl"})
public final class ScriptCompilationException
extends RuntimeException {
    @NotNull
    private final List<ScriptCompilationError> errors;
    @NotNull
    private final Lazy maxLineNumberStringLength$delegate;

    public ScriptCompilationException(@NotNull List<ScriptCompilationError> errors) {
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        this.errors = errors;
        if (!(!((Collection)this.errors).isEmpty())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.maxLineNumberStringLength$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ ScriptCompilationException this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Integer invoke() {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = this.this$0.getErrors();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Integer it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    ScriptCompilationError it = (ScriptCompilationError)element$iv$iv;
                    boolean bl2 = false;
                    CompilerMessageSourceLocation compilerMessageSourceLocation = it.getLocation();
                    if ((compilerMessageSourceLocation != null ? Integer.valueOf(compilerMessageSourceLocation.getLine()) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Object object = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
                return object != null && (object = ((Integer)object).toString()) != null ? ((String)object).length() : 0;
            }
        }));
    }

    @NotNull
    public final List<ScriptCompilationError> getErrors() {
        return this.errors;
    }

    @Nullable
    public final Integer getFirstErrorLine() {
        return (Integer)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.errors), (Function1)firstErrorLine.1.INSTANCE));
    }

    @Override
    @NotNull
    public String getMessage() {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)("Script compilation " + this.getErrorPlural() + ':')), (Iterable)this.indentedErrorMessages()), (Object)("" + this.errors.size() + ' ' + this.getErrorPlural())), (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final List<String> indentedErrorMessages() {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.errors), (Function1)((Function1)new Function1<ScriptCompilationError, String>((Object)this){

            @NotNull
            public final String invoke(@NotNull ScriptCompilationError p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ScriptCompilationException.access$errorMessage((ScriptCompilationException)this.receiver, p0);
            }
        })), (Function1)((Function1)new Function1<String, String>((Object)this){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ScriptCompilationException.access$prependIndent((ScriptCompilationException)this.receiver, p0);
            }
        })));
    }

    private final String errorMessage(ScriptCompilationError error) {
        Object object;
        block3: {
            block2: {
                object = error.getLocation();
                if (object == null) break block2;
                CompilerMessageSourceLocation location = object;
                boolean bl = false;
                String string2 = this.errorAt(location, error.getMessage());
                object = string2;
                if (string2 != null) break block3;
            }
            object = error.getMessage();
        }
        return object;
    }

    private final String errorAt(CompilerMessageSourceLocation location, String message) {
        String columnIndent = StringsKt.repeat((CharSequence)" ", (int)(5 + this.getMaxLineNumberStringLength() + 1 + location.getColumn()));
        List list2 = StringsKt.lines((CharSequence)("^ " + message));
        String string2 = '\n' + columnIndent + "    ";
        return "Line " + this.lineNumber(location) + ": " + location.getLineContent() + '\n' + CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)string2, (CharSequence)columnIndent, null, (int)0, null, null, (int)60, null);
    }

    private final String lineNumber(CompilerMessageSourceLocation location) {
        return StringsKt.padStart((String)String.valueOf(location.getLine()), (int)this.getMaxLineNumberStringLength(), (char)'0');
    }

    private final String prependIndent(String it) {
        return StringsKt.prependIndent((String)it, (String)"  ");
    }

    private final String getErrorPlural() {
        return this.errors.size() > 1 ? "errors" : "error";
    }

    private final int getMaxLineNumberStringLength() {
        Lazy lazy = this.maxLineNumberStringLength$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public final List<ScriptCompilationError> component1() {
        return this.errors;
    }

    @NotNull
    public final ScriptCompilationException copy(@NotNull List<ScriptCompilationError> errors) {
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        return new ScriptCompilationException(errors);
    }

    public static /* synthetic */ ScriptCompilationException copy$default(ScriptCompilationException scriptCompilationException, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = scriptCompilationException.errors;
        }
        return scriptCompilationException.copy(list2);
    }

    @Override
    @NotNull
    public String toString() {
        return "ScriptCompilationException(errors=" + this.errors + ')';
    }

    public int hashCode() {
        return ((Object)this.errors).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScriptCompilationException)) {
            return false;
        }
        ScriptCompilationException scriptCompilationException = (ScriptCompilationException)other;
        return Intrinsics.areEqual(this.errors, scriptCompilationException.errors);
    }

    public static final /* synthetic */ String access$errorMessage(ScriptCompilationException $this, ScriptCompilationError error) {
        return $this.errorMessage(error);
    }

    public static final /* synthetic */ String access$prependIndent(ScriptCompilationException $this, String it) {
        return $this.prependIndent(it);
    }
}

