/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u000e\u001a\u00020\r*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirThrowableSubclassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "hasGenericOuterDeclaration", "", "hasThrowableSupertype", "checkers"})
public final class FirThrowableSubclassChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirThrowableSubclassChecker INSTANCE = new FirThrowableSubclassChecker();

    private FirThrowableSubclassChecker() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block11: {
            block8: {
                block10: {
                    block9: {
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                        if (!this.hasThrowableSupertype(declaration, context)) {
                            return;
                        }
                        if (!(((Collection)declaration.getTypeParameters()).isEmpty() == false)) break block8;
                        v0 = (FirTypeParameterRef)CollectionsKt.firstOrNull(declaration.getTypeParameters());
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(v0 != null ? v0.getSource() : null), FirErrors.INSTANCE.getGENERIC_THROWABLE_SUBCLASS(), (DiagnosticContext)context, null, 8, null);
                        v1 = declaration instanceof FirRegularClass != false ? (FirRegularClass)declaration : null;
                        if (v1 == null) break block9;
                        it = v1;
                        $i$a$-let-FirThrowableSubclassChecker$check$source$1 = false;
                        $this$isInner$iv = it;
                        $i$f$isInner = false;
                        if ($this$isInner$iv.getStatus().isInner()) ** GOTO lbl-1000
                        $this$isLocal$iv = it;
                        $i$f$isLocal = false;
                        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) lbl-1000:
                        // 2 sources

                        {
                            v2 = true;
                        } else {
                            v2 = false;
                        }
                        v3 = v2;
                        break block10;
                    }
                    v3 = false;
                }
                if (v3) {
                    v4 = declaration.getSource();
                } else if (declaration instanceof FirAnonymousObject) {
                    v5 = (FirDeclaration)CollectionsKt.firstOrNull(declaration.getDeclarations());
                    v4 = v5 != null ? v5.getSource() : null;
                } else {
                    v4 = null;
                }
                source = v4;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINNER_CLASS_OF_GENERIC_THROWABLE_SUBCLASS(), (DiagnosticContext)context, null, 8, null);
                break block11;
            }
            if (this.hasGenericOuterDeclaration(declaration, context)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getINNER_CLASS_OF_GENERIC_THROWABLE_SUBCLASS(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    private final boolean hasThrowableSupertype(FirClass $this$hasThrowableSupertype, CheckerContext context) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = FirDeclarationUtilKt.getSuperConeTypes($this$hasThrowableSupertype);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType it = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    if (!(!(it instanceof ConeErrorType) && FirHelpersKt.isSubtypeOfThrowable(it, context.getSession()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasGenericOuterDeclaration(FirClass $this$hasGenericOuterDeclaration, CheckerContext context) {
        if (!FirDeclarationUtilKt.getClassId($this$hasGenericOuterDeclaration).isLocal()) {
            return false;
        }
        for (FirDeclaration containingDeclaration : CollectionsKt.asReversed(context.getContainingDeclarations())) {
            if (containingDeclaration instanceof FirTypeParameterRefsOwner && !((Collection)((FirTypeParameterRefsOwner)((Object)containingDeclaration)).getTypeParameters()).isEmpty()) {
                return true;
            }
            if (!(containingDeclaration instanceof FirRegularClass)) continue;
            FirClassLikeDeclaration $this$isLocal$iv = (FirClassLikeDeclaration)containingDeclaration;
            boolean $i$f$isLocal = false;
            if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) continue;
            FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)containingDeclaration;
            boolean $i$f$isInner = false;
            if ($this$isInner$iv.getStatus().isInner()) continue;
            return false;
        }
        return false;
    }
}

