/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.initialization;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.provider.ConfigurationTimeBarrier;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.configurationcache.InputTrackingState;
import org.gradle.configurationcache.initialization.ConfigurationCacheProblemsListener;
import org.gradle.configurationcache.problems.DocumentationSection;
import org.gradle.configurationcache.problems.ProblemsListener;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.configurationcache.problems.PropertyProblemKt;
import org.gradle.configurationcache.problems.PropertyTrace;
import org.gradle.configurationcache.problems.StructuredMessage;
import org.gradle.internal.DisplayName;
import org.gradle.internal.buildoption.FeatureFlag;
import org.gradle.internal.buildoption.FeatureFlags;
import org.gradle.internal.execution.TaskExecutionTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u001c2\b\u0010$\u001a\u0004\u0018\u00010\u001cH\u0016J\u0018\u0010%\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010)\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010,\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/gradle/configurationcache/initialization/DefaultConfigurationCacheProblemsListener;", "Lorg/gradle/configurationcache/initialization/ConfigurationCacheProblemsListener;", "problems", "Lorg/gradle/configurationcache/problems/ProblemsListener;", "userCodeApplicationContext", "Lorg/gradle/configuration/internal/UserCodeApplicationContext;", "configurationTimeBarrier", "Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;", "taskExecutionTracker", "Lorg/gradle/internal/execution/TaskExecutionTracker;", "featureFlags", "Lorg/gradle/internal/buildoption/FeatureFlags;", "inputTrackingState", "Lorg/gradle/configurationcache/InputTrackingState;", "(Lorg/gradle/configurationcache/problems/ProblemsListener;Lorg/gradle/configuration/internal/UserCodeApplicationContext;Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;Lorg/gradle/internal/execution/TaskExecutionTracker;Lorg/gradle/internal/buildoption/FeatureFlags;Lorg/gradle/configurationcache/InputTrackingState;)V", "atConfigurationTime", "", "isBuildSrcBuild", "invocationSource", "", "isExecutingTask", "isInputTrackingDisabled", "isStableConfigurationCacheEnabled", "listenerRegistrationProblem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "trace", "Lorg/gradle/configurationcache/problems/PropertyTrace;", "invocationDescription", "", "exception", "Lorg/gradle/api/InvalidUserCodeException;", "onBuildScopeListenerRegistration", "", "listener", "onExternalProcessStarted", "command", "consumer", "onProjectAccess", "task", "Lorg/gradle/api/internal/TaskInternal;", "onTaskDependenciesAccess", "onTaskExecutionAccessProblem", "onUnsafeCredentials", "locationSpecificReason", "problemsListenerFor", "propertyTraceForTask", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nConfigurationCacheProblemsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationCacheProblemsListener.kt\norg/gradle/configurationcache/initialization/DefaultConfigurationCacheProblemsListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class DefaultConfigurationCacheProblemsListener
implements ConfigurationCacheProblemsListener {
    @NotNull
    private final ProblemsListener problems;
    @NotNull
    private final UserCodeApplicationContext userCodeApplicationContext;
    @NotNull
    private final ConfigurationTimeBarrier configurationTimeBarrier;
    @NotNull
    private final TaskExecutionTracker taskExecutionTracker;
    @NotNull
    private final FeatureFlags featureFlags;
    @NotNull
    private final InputTrackingState inputTrackingState;

    public DefaultConfigurationCacheProblemsListener(@NotNull ProblemsListener problems, @NotNull UserCodeApplicationContext userCodeApplicationContext, @NotNull ConfigurationTimeBarrier configurationTimeBarrier, @NotNull TaskExecutionTracker taskExecutionTracker, @NotNull FeatureFlags featureFlags, @NotNull InputTrackingState inputTrackingState) {
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)userCodeApplicationContext, (String)"userCodeApplicationContext");
        Intrinsics.checkNotNullParameter((Object)configurationTimeBarrier, (String)"configurationTimeBarrier");
        Intrinsics.checkNotNullParameter((Object)taskExecutionTracker, (String)"taskExecutionTracker");
        Intrinsics.checkNotNullParameter((Object)featureFlags, (String)"featureFlags");
        Intrinsics.checkNotNullParameter((Object)inputTrackingState, (String)"inputTrackingState");
        this.problems = problems;
        this.userCodeApplicationContext = userCodeApplicationContext;
        this.configurationTimeBarrier = configurationTimeBarrier;
        this.taskExecutionTracker = taskExecutionTracker;
        this.featureFlags = featureFlags;
        this.inputTrackingState = inputTrackingState;
    }

    public void onProjectAccess(@NotNull String invocationDescription, @NotNull TaskInternal task) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.atConfigurationTime()) {
            return;
        }
        this.onTaskExecutionAccessProblem(invocationDescription, task);
    }

    public void onTaskDependenciesAccess(@NotNull String invocationDescription, @NotNull TaskInternal task) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.atConfigurationTime()) {
            return;
        }
        this.onTaskExecutionAccessProblem(invocationDescription, task);
    }

    public void onExternalProcessStarted(@NotNull String command, @Nullable String consumer) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (!this.isStableConfigurationCacheEnabled() || !this.atConfigurationTime() || this.isExecutingTask() || this.isInputTrackingDisabled()) {
            return;
        }
        this.problems.onProblem(new PropertyProblem(PropertyProblemKt.location(this.userCodeApplicationContext, consumer), StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(command){
            final /* synthetic */ String $command;
            {
                this.$command = $command;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                $this$build.text("external process started ");
                $this$build.reference(this.$command);
            }
        })), (Throwable)new InvalidUserCodeException("Starting an external process '" + command + "' during configuration time is unsupported."), DocumentationSection.RequirementsExternalProcess));
    }

    private final void onTaskExecutionAccessProblem(String invocationDescription, TaskInternal task) {
        this.problemsListenerFor(task).onProblem(new PropertyProblem(this.propertyTraceForTask(task), StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(invocationDescription){
            final /* synthetic */ String $invocationDescription;
            {
                this.$invocationDescription = $invocationDescription;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                $this$build.text("invocation of ");
                $this$build.reference(this.$invocationDescription);
                $this$build.text(" at execution time is unsupported.");
            }
        })), (Throwable)new InvalidUserCodeException("Invocation of '" + invocationDescription + "' by " + task + " at execution time is unsupported."), DocumentationSection.RequirementsUseProjectDuringExecution));
    }

    private final ProblemsListener problemsListenerFor(TaskInternal task) {
        ProblemsListener problemsListener;
        if (task.isCompatibleWithConfigurationCache()) {
            problemsListener = this.problems;
        } else {
            String string2 = task.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.path");
            problemsListener = this.problems.forIncompatibleTask(string2);
        }
        return problemsListener;
    }

    private final PropertyTrace propertyTraceForTask(TaskInternal task) {
        PropertyTrace propertyTrace;
        DisplayName displayName;
        UserCodeApplicationContext.Application application = this.userCodeApplicationContext.current();
        if (application != null && (displayName = application.getDisplayName()) != null) {
            DisplayName p0 = displayName;
            boolean bl = false;
            propertyTrace = new PropertyTrace.BuildLogic(p0);
        } else {
            Class clazz = GeneratedSubclasses.unpackType((Object)task);
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"unpackType(task)");
            String string2 = task.getIdentityPath().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.identityPath.path");
            propertyTrace = new PropertyTrace.Task(clazz, string2);
        }
        return propertyTrace;
    }

    public void onBuildScopeListenerRegistration(@NotNull Object listener2, @NotNull String invocationDescription, @NotNull Object invocationSource) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)invocationSource, (String)"invocationSource");
        if (this.isBuildSrcBuild(invocationSource)) {
            return;
        }
        this.problems.onProblem(this.listenerRegistrationProblem(PropertyProblemKt.location(this.userCodeApplicationContext, null), invocationDescription, new InvalidUserCodeException("Listener registration '" + invocationDescription + "' by " + invocationSource + " is unsupported.")));
    }

    public void onUnsafeCredentials(@NotNull String locationSpecificReason, @NotNull TaskInternal task) {
        Intrinsics.checkNotNullParameter((Object)locationSpecificReason, (String)"locationSpecificReason");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        StructuredMessage message2 = StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(locationSpecificReason){
            final /* synthetic */ String $locationSpecificReason;
            {
                this.$locationSpecificReason = $locationSpecificReason;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                $this$build.text("Credential values found in configuration for: ");
                $this$build.text(this.$locationSpecificReason);
            }
        }));
        this.problems.onProblem(new PropertyProblem(this.propertyTraceForTask(task), message2, (Throwable)new InvalidUserCodeException(message2.toString()), DocumentationSection.RequirementsSafeCredentials));
    }

    private final PropertyProblem listenerRegistrationProblem(PropertyTrace trace, String invocationDescription, InvalidUserCodeException exception) {
        return new PropertyProblem(trace, StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(invocationDescription){
            final /* synthetic */ String $invocationDescription;
            {
                this.$invocationDescription = $invocationDescription;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                $this$build.text("registration of listener on ");
                $this$build.reference(this.$invocationDescription);
                $this$build.text(" is unsupported");
            }
        })), (Throwable)exception, DocumentationSection.RequirementsBuildListeners);
    }

    private final boolean isBuildSrcBuild(Object invocationSource) {
        boolean bl;
        GradleInternal gradleInternal = invocationSource instanceof GradleInternal ? (GradleInternal)invocationSource : null;
        if (gradleInternal != null) {
            GradleInternal $this$isBuildSrcBuild_u24lambda_u240 = gradleInternal;
            boolean bl2 = false;
            bl = !$this$isBuildSrcBuild_u24lambda_u240.isRootBuild() && Intrinsics.areEqual((Object)$this$isBuildSrcBuild_u24lambda_u240.getIdentityPath().getName(), (Object)"buildSrc");
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean atConfigurationTime() {
        return this.configurationTimeBarrier.isAtConfigurationTime();
    }

    private final boolean isInputTrackingDisabled() {
        return !this.inputTrackingState.isEnabledForCurrentThread();
    }

    private final boolean isStableConfigurationCacheEnabled() {
        return this.featureFlags.isEnabled((FeatureFlag)FeaturePreviews.Feature.STABLE_CONFIGURATION_CACHE);
    }

    private final boolean isExecutingTask() {
        return this.taskExecutionTracker.getCurrentTask().isPresent();
    }
}

