/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.util.Arrays;
import java.util.List;
import org.testng.CommandLineArgs;
import org.testng.IInvokedMethodListener;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestRunnerFactory;
import org.testng.TestNG;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.remote.RemoteArgs;
import org.testng.remote.strprotocol.BaseMessageSender;
import org.testng.remote.strprotocol.GenericMessage;
import org.testng.remote.strprotocol.MessageHub;
import org.testng.remote.strprotocol.RemoteTestListener;
import org.testng.remote.strprotocol.SerializedMessageSender;
import org.testng.remote.strprotocol.StringMessageSender;
import org.testng.remote.strprotocol.SuiteMessage;
import org.testng.reporters.JUnitXMLReporter;
import org.testng.reporters.TestHTMLReporter;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteTestNG
extends TestNG {
    private static final String LOCALHOST = "localhost";
    public static final String DEBUG_PORT = "12345";
    public static final String DEBUG_SUITE_FILE = "testng-customsuite.xml";
    public static final String DEBUG_SUITE_DIRECTORY = System.getProperty("java.io.tmpdir");
    public static final String PROPERTY_DEBUG = "testng.eclipse.debug";
    public static final String PROPERTY_VERBOSE = "testng.eclipse.verbose";
    private ITestRunnerFactory m_customTestRunnerFactory;
    private String m_host;
    private Integer m_port = null;
    private static Integer m_serPort = null;
    private static boolean m_debug;
    private static boolean m_dontExit;
    private static boolean m_ack;

    public void setHost(String host) {
        this.m_host = Utils.defaultIfStringEmpty(host, LOCALHOST);
    }

    private void calculateAllSuites(List<XmlSuite> suites, List<XmlSuite> outSuites) {
        for (XmlSuite s : suites) {
            outSuites.add(s);
            this.calculateAllSuites(s.getChildSuites(), outSuites);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        BaseMessageSender baseMessageSender = m_serPort != null ? new SerializedMessageSender(this.m_host, m_serPort, m_ack) : new StringMessageSender(this.m_host, this.m_port);
        MessageHub msh = new MessageHub(baseMessageSender);
        msh.setDebug(RemoteTestNG.isDebug());
        try {
            try {
                msh.connect();
                this.initializeSuitesAndJarFile();
                List<XmlSuite> suites = Lists.newArrayList();
                this.calculateAllSuites(this.m_suites, suites);
                if (suites.size() > 0) {
                    int testCount = 0;
                    for (int i = 0; i < suites.size(); testCount += suites.get(i).getTests().size(), ++i) {
                    }
                    GenericMessage gm = new GenericMessage(1);
                    gm.setSuiteCount(suites.size());
                    gm.setTestCount(testCount);
                    msh.sendMessage(gm);
                    this.addListener(new RemoteSuiteListener(msh));
                    this.setTestRunnerFactory(new DelegatingTestRunnerFactory(this.buildTestRunnerFactory(), msh));
                    super.run();
                }
                System.err.println("No test suite found. Nothing to run");
            }
            catch (Throwable cause) {
                cause.printStackTrace(System.err);
                Object var7_9 = null;
                msh.shutDown();
                if (m_debug) return;
                if (m_dontExit) return;
                System.exit(0);
                return;
            }
            Object var7_8 = null;
            msh.shutDown();
            if (m_debug) return;
            if (m_dontExit) return;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            msh.shutDown();
            if (m_debug) throw throwable;
            if (m_dontExit) throw throwable;
            System.exit(0);
            throw throwable;
        }
        System.exit(0);
    }

    protected ITestRunnerFactory buildTestRunnerFactory() {
        if (null == this.m_customTestRunnerFactory) {
            this.m_customTestRunnerFactory = new ITestRunnerFactory(){

                @Override
                public TestRunner newTestRunner(ISuite suite, XmlTest xmlTest, List<IInvokedMethodListener> listeners) {
                    TestRunner runner = new TestRunner(RemoteTestNG.this.getConfiguration(), suite, xmlTest, false, listeners);
                    if (RemoteTestNG.this.m_useDefaultListeners) {
                        runner.addListener(new TestHTMLReporter());
                        runner.addListener(new JUnitXMLReporter());
                    }
                    return runner;
                }
            };
        }
        return this.m_customTestRunnerFactory;
    }

    public static void main(String[] args) throws ParameterException {
        CommandLineArgs cla = new CommandLineArgs();
        RemoteArgs ra = new RemoteArgs();
        new JCommander(Arrays.asList(cla, ra), args);
        m_dontExit = ra.dontExit;
        if (cla.port != null && ra.serPort != null) {
            throw new TestNGException("Can only specify one of -port and -serport");
        }
        m_debug = cla.debug;
        m_ack = ra.ack;
        if (m_debug) {
            RemoteTestNG.initAndRun(args, cla, ra);
        } else {
            RemoteTestNG.initAndRun(args, cla, ra);
        }
    }

    private static void initAndRun(String[] args, CommandLineArgs cla, RemoteArgs ra) {
        RemoteTestNG remoteTestNg = new RemoteTestNG();
        if (m_debug) {
            ra.serPort = cla.port = Integer.valueOf(Integer.parseInt(DEBUG_PORT));
            cla.suiteFiles = Arrays.asList(DEBUG_SUITE_DIRECTORY + DEBUG_SUITE_FILE);
        }
        remoteTestNg.configure(cla);
        remoteTestNg.setHost(cla.host);
        m_serPort = ra.serPort;
        remoteTestNg.m_port = cla.port;
        if (RemoteTestNG.isVerbose()) {
            StringBuilder sb = new StringBuilder("Invoked with ");
            for (String s : args) {
                sb.append(s).append(" ");
            }
            RemoteTestNG.p(sb.toString());
        }
        RemoteTestNG.validateCommandLineParameters(cla);
        remoteTestNg.run();
    }

    private static void p(String s) {
        if (RemoteTestNG.isVerbose()) {
            System.out.println("[RemoteTestNG] " + s);
        }
    }

    public static boolean isVerbose() {
        boolean result = System.getProperty(PROPERTY_VERBOSE) != null || RemoteTestNG.isDebug();
        return result;
    }

    public static boolean isDebug() {
        return m_debug || System.getProperty(PROPERTY_DEBUG) != null;
    }

    private String getHost() {
        return this.m_host;
    }

    private int getPort() {
        return this.m_port;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatingTestRunnerFactory
    implements ITestRunnerFactory {
        private final ITestRunnerFactory m_delegateFactory;
        private final MessageHub m_messageSender;

        DelegatingTestRunnerFactory(ITestRunnerFactory trf, MessageHub smsh) {
            this.m_delegateFactory = trf;
            this.m_messageSender = smsh;
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, List<IInvokedMethodListener> listeners) {
            TestRunner tr = this.m_delegateFactory.newTestRunner(suite, test, listeners);
            tr.addListener(new RemoteTestListener(suite, test, this.m_messageSender));
            return tr;
        }
    }

    private static class RemoteSuiteListener
    implements ISuiteListener {
        private final MessageHub m_messageSender;

        RemoteSuiteListener(MessageHub smsh) {
            this.m_messageSender = smsh;
        }

        public void onFinish(ISuite suite) {
            this.m_messageSender.sendMessage(new SuiteMessage(suite, false));
        }

        public void onStart(ISuite suite) {
            this.m_messageSender.sendMessage(new SuiteMessage(suite, true));
        }
    }
}

