/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.EndCollection;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.DefaultTransformationDependency;
import org.gradle.api.internal.artifacts.transform.ExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.TransformException;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformationNode;
import org.gradle.api.internal.artifacts.transform.TransformationNodeFactory;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.artifacts.transform.VariantDefinition;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Try;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public class TransformedProjectArtifactSet
implements ResolvedArtifactSet,
FileCollectionInternal.Source,
ResolvedArtifactSet.Artifacts {
    private final ComponentIdentifier componentIdentifier;
    private final ImmutableAttributes targetAttributes;
    private final List<? extends Capability> capabilities;
    private final Collection<TransformationNode> transformedArtifacts;

    public TransformedProjectArtifactSet(ComponentIdentifier componentIdentifier, ResolvedArtifactSet delegate, VariantDefinition variantDefinition, List<? extends Capability> capabilities, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolverFactory, TransformationNodeFactory transformationNodeFactory) {
        this.componentIdentifier = componentIdentifier;
        this.targetAttributes = variantDefinition.getTargetAttributes();
        this.capabilities = capabilities;
        TransformUpstreamDependenciesResolver dependenciesResolver = dependenciesResolverFactory.create(componentIdentifier, variantDefinition.getTransformation());
        this.transformedArtifacts = transformationNodeFactory.create(delegate, variantDefinition.getTransformationStep(), dependenciesResolver);
    }

    public TransformedProjectArtifactSet(ComponentIdentifier componentIdentifier, ImmutableAttributes targetAttributes, List<? extends Capability> capabilities, Collection<TransformationNode> transformedArtifacts) {
        this.componentIdentifier = componentIdentifier;
        this.targetAttributes = targetAttributes;
        this.capabilities = capabilities;
        this.transformedArtifacts = transformedArtifacts;
    }

    public ComponentIdentifier getOwnerId() {
        return this.componentIdentifier;
    }

    public ImmutableAttributes getTargetAttributes() {
        return this.targetAttributes;
    }

    public List<? extends Capability> getCapabilities() {
        return this.capabilities;
    }

    public Collection<TransformationNode> getTransformedArtifacts() {
        return this.transformedArtifacts;
    }

    @Override
    public void visit(ResolvedArtifactSet.Visitor visitor) {
        FileCollectionStructureVisitor.VisitType visitType = visitor.prepareForVisit(this);
        if (visitType == FileCollectionStructureVisitor.VisitType.NoContents) {
            visitor.visitArtifacts(new EndCollection(this));
        } else {
            visitor.visitArtifacts(this);
        }
    }

    @Override
    public void startFinalization(BuildOperationQueue<RunnableBuildOperation> actions, boolean requireFiles) {
    }

    @Override
    public void visit(ArtifactVisitor visitor) {
        DisplayName displayName = Describables.of((Object)this.componentIdentifier);
        for (TransformationNode node : this.transformedArtifacts) {
            node.executeIfNotAlready();
            Try<TransformationSubject> transformedSubject = node.getTransformedSubject();
            if (transformedSubject.isSuccessful()) {
                for (File file : ((TransformationSubject)transformedSubject.get()).getFiles()) {
                    visitor.visitArtifact(displayName, (AttributeContainer)this.targetAttributes, this.capabilities, node.getInputArtifact().transformedTo(file));
                }
                continue;
            }
            Throwable failure = (Throwable)transformedSubject.getFailure().get();
            visitor.visitFailure((Throwable)((Object)new TransformException(String.format("Failed to transform %s to match attributes %s.", node.getInputArtifact().getId().getDisplayName(), this.targetAttributes), failure)));
        }
        visitor.endVisitCollection(this);
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        if (!this.transformedArtifacts.isEmpty()) {
            context.add((Object)new DefaultTransformationDependency(this.transformedArtifacts));
        }
    }

    @Override
    public void visitTransformSources(ResolvedArtifactSet.TransformSourceVisitor visitor) {
        for (TransformationNode transformationNode : this.transformedArtifacts) {
            visitor.visitTransform(transformationNode);
        }
    }

    @Override
    public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
        throw new UnsupportedOperationException("Should not be called.");
    }
}

