/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import java.util.Collection;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.VariantSelectionException;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public class NoMatchingVariantSelectionException
extends VariantSelectionException {
    public NoMatchingVariantSelectionException(String producerDisplayName, AttributeContainerInternal consumer, Collection<? extends ResolvedVariant> candidates, AttributeMatcher matcher, AttributeDescriber describer) {
        super(NoMatchingVariantSelectionException.format(producerDisplayName, consumer, candidates, matcher, describer));
    }

    private static String format(String producerDisplayName, AttributeContainerInternal consumer, Collection<? extends ResolvedVariant> candidates, AttributeMatcher matcher, AttributeDescriber describer) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("No variants of " + NoMatchingVariantSelectionException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)producerDisplayName) + " match the consumer attributes");
        formatter.startChildren();
        for (ResolvedVariant resolvedVariant : candidates) {
            formatter.node(resolvedVariant.asDescribable().getCapitalizedDisplayName());
            AmbiguousConfigurationSelectionException.formatAttributeMatchesForIncompatibility(formatter, consumer.asImmutable(), matcher, resolvedVariant.getAttributes().asImmutable(), describer);
        }
        formatter.endChildren();
        return formatter.toString();
    }
}

